/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import net.minecraft.block.BlockTorch;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenEndPodium
extends WorldGenerator {
    public static final BlockPos END_PODIUM_LOCATION = BlockPos.ORIGIN;
    public static final BlockPos END_PODIUM_CHUNK_POS = new BlockPos(END_PODIUM_LOCATION.getX() - 4 & 0xFFFFFFF0, 0, END_PODIUM_LOCATION.getZ() - 4 & 0xFFFFFFF0);
    private final boolean activePortal;

    public WorldGenEndPodium(boolean p_i46666_1_) {
        this.activePortal = p_i46666_1_;
    }

    @Override
    public boolean generate(World p_generate_1_, Random p_generate_2_, BlockPos p_generate_3_) {
        for (BlockPos.MutableBlockPos lvt_5_1_ : BlockPos.getAllInBoxMutable(new BlockPos(p_generate_3_.getX() - 4, p_generate_3_.getY() - 1, p_generate_3_.getZ() - 4), new BlockPos(p_generate_3_.getX() + 4, p_generate_3_.getY() + 32, p_generate_3_.getZ() + 4))) {
            double lvt_6_1_ = lvt_5_1_.getDistance(p_generate_3_.getX(), lvt_5_1_.getY(), p_generate_3_.getZ());
            if (!(lvt_6_1_ <= 3.5)) continue;
            if (lvt_5_1_.getY() < p_generate_3_.getY()) {
                if (lvt_6_1_ <= 2.5) {
                    this.setBlockAndNotifyAdequately(p_generate_1_, lvt_5_1_, Blocks.BEDROCK.getDefaultState());
                    continue;
                }
                if (lvt_5_1_.getY() >= p_generate_3_.getY()) continue;
                this.setBlockAndNotifyAdequately(p_generate_1_, lvt_5_1_, Blocks.END_STONE.getDefaultState());
                continue;
            }
            if (lvt_5_1_.getY() > p_generate_3_.getY()) {
                this.setBlockAndNotifyAdequately(p_generate_1_, lvt_5_1_, Blocks.AIR.getDefaultState());
                continue;
            }
            if (lvt_6_1_ > 2.5) {
                this.setBlockAndNotifyAdequately(p_generate_1_, lvt_5_1_, Blocks.BEDROCK.getDefaultState());
                continue;
            }
            if (this.activePortal) {
                this.setBlockAndNotifyAdequately(p_generate_1_, new BlockPos(lvt_5_1_), Blocks.END_PORTAL.getDefaultState());
                continue;
            }
            this.setBlockAndNotifyAdequately(p_generate_1_, new BlockPos(lvt_5_1_), Blocks.AIR.getDefaultState());
        }
        for (int lvt_4_1_ = 0; lvt_4_1_ < 4; ++lvt_4_1_) {
            this.setBlockAndNotifyAdequately(p_generate_1_, p_generate_3_.up(lvt_4_1_), Blocks.BEDROCK.getDefaultState());
        }
        BlockPos lvt_4_2_ = p_generate_3_.up(2);
        for (EnumFacing lvt_6_2_ : EnumFacing.Plane.HORIZONTAL) {
            this.setBlockAndNotifyAdequately(p_generate_1_, lvt_4_2_.offset(lvt_6_2_), Blocks.TORCH.getDefaultState().withProperty(BlockTorch.FACING, lvt_6_2_));
        }
        return true;
    }
}

