/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class WorldGenFossils
extends WorldGenerator {
    private static final ResourceLocation STRUCTURE_SPINE_01 = new ResourceLocation("fossils/fossil_spine_01");
    private static final ResourceLocation STRUCTURE_SPINE_02 = new ResourceLocation("fossils/fossil_spine_02");
    private static final ResourceLocation STRUCTURE_SPINE_03 = new ResourceLocation("fossils/fossil_spine_03");
    private static final ResourceLocation STRUCTURE_SPINE_04 = new ResourceLocation("fossils/fossil_spine_04");
    private static final ResourceLocation STRUCTURE_SPINE_01_COAL = new ResourceLocation("fossils/fossil_spine_01_coal");
    private static final ResourceLocation STRUCTURE_SPINE_02_COAL = new ResourceLocation("fossils/fossil_spine_02_coal");
    private static final ResourceLocation STRUCTURE_SPINE_03_COAL = new ResourceLocation("fossils/fossil_spine_03_coal");
    private static final ResourceLocation STRUCTURE_SPINE_04_COAL = new ResourceLocation("fossils/fossil_spine_04_coal");
    private static final ResourceLocation STRUCTURE_SKULL_01 = new ResourceLocation("fossils/fossil_skull_01");
    private static final ResourceLocation STRUCTURE_SKULL_02 = new ResourceLocation("fossils/fossil_skull_02");
    private static final ResourceLocation STRUCTURE_SKULL_03 = new ResourceLocation("fossils/fossil_skull_03");
    private static final ResourceLocation STRUCTURE_SKULL_04 = new ResourceLocation("fossils/fossil_skull_04");
    private static final ResourceLocation STRUCTURE_SKULL_01_COAL = new ResourceLocation("fossils/fossil_skull_01_coal");
    private static final ResourceLocation STRUCTURE_SKULL_02_COAL = new ResourceLocation("fossils/fossil_skull_02_coal");
    private static final ResourceLocation STRUCTURE_SKULL_03_COAL = new ResourceLocation("fossils/fossil_skull_03_coal");
    private static final ResourceLocation STRUCTURE_SKULL_04_COAL = new ResourceLocation("fossils/fossil_skull_04_coal");
    private static final ResourceLocation[] FOSSILS = new ResourceLocation[]{STRUCTURE_SPINE_01, STRUCTURE_SPINE_02, STRUCTURE_SPINE_03, STRUCTURE_SPINE_04, STRUCTURE_SKULL_01, STRUCTURE_SKULL_02, STRUCTURE_SKULL_03, STRUCTURE_SKULL_04};
    private static final ResourceLocation[] FOSSILS_COAL = new ResourceLocation[]{STRUCTURE_SPINE_01_COAL, STRUCTURE_SPINE_02_COAL, STRUCTURE_SPINE_03_COAL, STRUCTURE_SPINE_04_COAL, STRUCTURE_SKULL_01_COAL, STRUCTURE_SKULL_02_COAL, STRUCTURE_SKULL_03_COAL, STRUCTURE_SKULL_04_COAL};

    @Override
    public boolean generate(World p_generate_1_, Random p_generate_2_, BlockPos p_generate_3_) {
        Random lvt_4_1_ = p_generate_1_.getChunkFromBlockCoords(p_generate_3_).getRandomWithSeed(987234911L);
        MinecraftServer lvt_5_1_ = p_generate_1_.getMinecraftServer();
        Rotation[] lvt_6_1_ = Rotation.values();
        Rotation lvt_7_1_ = lvt_6_1_[lvt_4_1_.nextInt(lvt_6_1_.length)];
        int lvt_8_1_ = lvt_4_1_.nextInt(FOSSILS.length);
        TemplateManager lvt_9_1_ = p_generate_1_.getSaveHandler().getStructureTemplateManager();
        Template lvt_10_1_ = lvt_9_1_.getTemplate(lvt_5_1_, FOSSILS[lvt_8_1_]);
        Template lvt_11_1_ = lvt_9_1_.getTemplate(lvt_5_1_, FOSSILS_COAL[lvt_8_1_]);
        ChunkPos lvt_12_1_ = new ChunkPos(p_generate_3_);
        StructureBoundingBox lvt_13_1_ = new StructureBoundingBox(lvt_12_1_.getXStart(), 0, lvt_12_1_.getZStart(), lvt_12_1_.getXEnd(), 256, lvt_12_1_.getZEnd());
        PlacementSettings lvt_14_1_ = new PlacementSettings().setRotation(lvt_7_1_).setBoundingBox(lvt_13_1_).setRandom(lvt_4_1_);
        BlockPos lvt_15_1_ = lvt_10_1_.transformedSize(lvt_7_1_);
        int lvt_16_1_ = lvt_4_1_.nextInt(16 - lvt_15_1_.getX());
        int lvt_17_1_ = lvt_4_1_.nextInt(16 - lvt_15_1_.getZ());
        int lvt_18_1_ = 256;
        for (int lvt_19_1_ = 0; lvt_19_1_ < lvt_15_1_.getX(); ++lvt_19_1_) {
            for (int lvt_20_1_ = 0; lvt_20_1_ < lvt_15_1_.getX(); ++lvt_20_1_) {
                lvt_18_1_ = Math.min(lvt_18_1_, p_generate_1_.getHeight(p_generate_3_.getX() + lvt_19_1_ + lvt_16_1_, p_generate_3_.getZ() + lvt_20_1_ + lvt_17_1_));
            }
        }
        int lvt_19_2_ = Math.max(lvt_18_1_ - 15 - lvt_4_1_.nextInt(10), 10);
        BlockPos lvt_20_2_ = lvt_10_1_.getZeroPositionWithTransform(p_generate_3_.add(lvt_16_1_, lvt_19_2_, lvt_17_1_), Mirror.NONE, lvt_7_1_);
        lvt_14_1_.setIntegrity(0.9f);
        lvt_10_1_.addBlocksToWorld(p_generate_1_, lvt_20_2_, lvt_14_1_, 20);
        lvt_14_1_.setIntegrity(0.1f);
        lvt_11_1_.addBlocksToWorld(p_generate_1_, lvt_20_2_, lvt_14_1_, 20);
        return true;
    }
}

