/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenHellLava
extends WorldGenerator {
    private final Block block;
    private final boolean insideRock;

    public WorldGenHellLava(Block p_i45453_1_, boolean p_i45453_2_) {
        this.block = p_i45453_1_;
        this.insideRock = p_i45453_2_;
    }

    @Override
    public boolean generate(World p_generate_1_, Random p_generate_2_, BlockPos p_generate_3_) {
        if (p_generate_1_.getBlockState(p_generate_3_.up()).getBlock() != Blocks.NETHERRACK) {
            return false;
        }
        if (!p_generate_1_.isAirBlock(p_generate_3_) && p_generate_1_.getBlockState(p_generate_3_).getBlock() != Blocks.NETHERRACK) {
            return false;
        }
        int i = 0;
        if (p_generate_1_.getBlockState(p_generate_3_.west()).getBlock() == Blocks.NETHERRACK) {
            ++i;
        }
        if (p_generate_1_.getBlockState(p_generate_3_.east()).getBlock() == Blocks.NETHERRACK) {
            ++i;
        }
        if (p_generate_1_.getBlockState(p_generate_3_.north()).getBlock() == Blocks.NETHERRACK) {
            ++i;
        }
        if (p_generate_1_.getBlockState(p_generate_3_.south()).getBlock() == Blocks.NETHERRACK) {
            ++i;
        }
        if (p_generate_1_.getBlockState(p_generate_3_.down()).getBlock() == Blocks.NETHERRACK) {
            ++i;
        }
        int j = 0;
        if (p_generate_1_.isAirBlock(p_generate_3_.west())) {
            ++j;
        }
        if (p_generate_1_.isAirBlock(p_generate_3_.east())) {
            ++j;
        }
        if (p_generate_1_.isAirBlock(p_generate_3_.north())) {
            ++j;
        }
        if (p_generate_1_.isAirBlock(p_generate_3_.south())) {
            ++j;
        }
        if (p_generate_1_.isAirBlock(p_generate_3_.down())) {
            ++j;
        }
        if (!this.insideRock && i == 4 && j == 1 || i == 5) {
            IBlockState iblockstate = this.block.getDefaultState();
            p_generate_1_.setBlockState(p_generate_3_, iblockstate, 2);
            p_generate_1_.immediateBlockTick(p_generate_3_, iblockstate, p_generate_2_);
        }
        return true;
    }
}

