/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public abstract class WorldGenHugeTrees
extends WorldGenAbstractTree {
    protected final int baseHeight;
    protected final IBlockState woodMetadata;
    protected final IBlockState leavesMetadata;
    protected int extraRandomHeight;

    public WorldGenHugeTrees(boolean p_i46447_1_, int p_i46447_2_, int p_i46447_3_, IBlockState p_i46447_4_, IBlockState p_i46447_5_) {
        super(p_i46447_1_);
        this.baseHeight = p_i46447_2_;
        this.extraRandomHeight = p_i46447_3_;
        this.woodMetadata = p_i46447_4_;
        this.leavesMetadata = p_i46447_5_;
    }

    protected int getHeight(Random p_getHeight_1_) {
        int i = p_getHeight_1_.nextInt(3) + this.baseHeight;
        if (this.extraRandomHeight > 1) {
            i += p_getHeight_1_.nextInt(this.extraRandomHeight);
        }
        return i;
    }

    private boolean isSpaceAt(World p_isSpaceAt_1_, BlockPos p_isSpaceAt_2_, int p_isSpaceAt_3_) {
        boolean flag = true;
        if (p_isSpaceAt_2_.getY() >= 1 && p_isSpaceAt_2_.getY() + p_isSpaceAt_3_ + 1 <= 256) {
            for (int i = 0; i <= 1 + p_isSpaceAt_3_; ++i) {
                int j = 2;
                if (i == 0) {
                    j = 1;
                } else if (i >= 1 + p_isSpaceAt_3_ - 2) {
                    j = 2;
                }
                for (int k = -j; k <= j && flag; ++k) {
                    for (int l = -j; l <= j && flag; ++l) {
                        if (p_isSpaceAt_2_.getY() + i >= 0 && p_isSpaceAt_2_.getY() + i < 256 && this.isReplaceable(p_isSpaceAt_1_, p_isSpaceAt_2_.add(k, i, l))) continue;
                        flag = false;
                    }
                }
            }
            return flag;
        }
        return false;
    }

    private boolean ensureDirtsUnderneath(BlockPos p_ensureDirtsUnderneath_1_, World p_ensureDirtsUnderneath_2_) {
        BlockPos blockpos = p_ensureDirtsUnderneath_1_.down();
        IBlockState state = p_ensureDirtsUnderneath_2_.getBlockState(blockpos);
        boolean isSoil = state.getBlock().canSustainPlant(state, p_ensureDirtsUnderneath_2_, blockpos, EnumFacing.UP, (BlockSapling)Blocks.SAPLING);
        if (isSoil && p_ensureDirtsUnderneath_1_.getY() >= 2) {
            this.onPlantGrow(p_ensureDirtsUnderneath_2_, blockpos, p_ensureDirtsUnderneath_1_);
            this.onPlantGrow(p_ensureDirtsUnderneath_2_, blockpos.east(), p_ensureDirtsUnderneath_1_);
            this.onPlantGrow(p_ensureDirtsUnderneath_2_, blockpos.south(), p_ensureDirtsUnderneath_1_);
            this.onPlantGrow(p_ensureDirtsUnderneath_2_, blockpos.south().east(), p_ensureDirtsUnderneath_1_);
            return true;
        }
        return false;
    }

    protected boolean ensureGrowable(World p_ensureGrowable_1_, Random p_ensureGrowable_2_, BlockPos p_ensureGrowable_3_, int p_ensureGrowable_4_) {
        return this.isSpaceAt(p_ensureGrowable_1_, p_ensureGrowable_3_, p_ensureGrowable_4_) && this.ensureDirtsUnderneath(p_ensureGrowable_3_, p_ensureGrowable_1_);
    }

    protected void growLeavesLayerStrict(World p_growLeavesLayerStrict_1_, BlockPos p_growLeavesLayerStrict_2_, int p_growLeavesLayerStrict_3_) {
        int i = p_growLeavesLayerStrict_3_ * p_growLeavesLayerStrict_3_;
        for (int j = -p_growLeavesLayerStrict_3_; j <= p_growLeavesLayerStrict_3_ + 1; ++j) {
            for (int k = -p_growLeavesLayerStrict_3_; k <= p_growLeavesLayerStrict_3_ + 1; ++k) {
                BlockPos blockpos;
                IBlockState state;
                int l = j - 1;
                int i1 = k - 1;
                if (j * j + k * k > i && l * l + i1 * i1 > i && j * j + i1 * i1 > i && l * l + k * k > i || !(state = p_growLeavesLayerStrict_1_.getBlockState(blockpos = p_growLeavesLayerStrict_2_.add(j, 0, k))).getBlock().isAir(state, p_growLeavesLayerStrict_1_, blockpos) && !state.getBlock().isLeaves(state, p_growLeavesLayerStrict_1_, blockpos)) continue;
                this.setBlockAndNotifyAdequately(p_growLeavesLayerStrict_1_, blockpos, this.leavesMetadata);
            }
        }
    }

    protected void growLeavesLayer(World p_growLeavesLayer_1_, BlockPos p_growLeavesLayer_2_, int p_growLeavesLayer_3_) {
        int i = p_growLeavesLayer_3_ * p_growLeavesLayer_3_;
        for (int j = -p_growLeavesLayer_3_; j <= p_growLeavesLayer_3_; ++j) {
            for (int k = -p_growLeavesLayer_3_; k <= p_growLeavesLayer_3_; ++k) {
                BlockPos blockpos;
                IBlockState state;
                if (j * j + k * k > i || !(state = p_growLeavesLayer_1_.getBlockState(blockpos = p_growLeavesLayer_2_.add(j, 0, k))).getBlock().isAir(state, p_growLeavesLayer_1_, blockpos) && !state.getBlock().isLeaves(state, p_growLeavesLayer_1_, blockpos)) continue;
                this.setBlockAndNotifyAdequately(p_growLeavesLayer_1_, blockpos, this.leavesMetadata);
            }
        }
    }

    private void onPlantGrow(World p_onPlantGrow_1_, BlockPos p_onPlantGrow_2_, BlockPos p_onPlantGrow_3_) {
        IBlockState state = p_onPlantGrow_1_.getBlockState(p_onPlantGrow_2_);
        state.getBlock().onPlantGrow(state, p_onPlantGrow_1_, p_onPlantGrow_2_, p_onPlantGrow_3_);
    }
}

