/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenHugeTrees;

public class WorldGenMegaJungle
extends WorldGenHugeTrees {
    public WorldGenMegaJungle(boolean p_i46448_1_, int p_i46448_2_, int p_i46448_3_, IBlockState p_i46448_4_, IBlockState p_i46448_5_) {
        super(p_i46448_1_, p_i46448_2_, p_i46448_3_, p_i46448_4_, p_i46448_5_);
    }

    @Override
    public boolean generate(World p_generate_1_, Random p_generate_2_, BlockPos p_generate_3_) {
        int i = this.getHeight(p_generate_2_);
        if (!this.ensureGrowable(p_generate_1_, p_generate_2_, p_generate_3_, i)) {
            return false;
        }
        this.createCrown(p_generate_1_, p_generate_3_.up(i), 2);
        for (int j = p_generate_3_.getY() + i - 2 - p_generate_2_.nextInt(4); j > p_generate_3_.getY() + i / 2; j -= 2 + p_generate_2_.nextInt(4)) {
            float f = p_generate_2_.nextFloat() * ((float)Math.PI * 2);
            int k = p_generate_3_.getX() + (int)(0.5f + MathHelper.cos(f) * 4.0f);
            int l = p_generate_3_.getZ() + (int)(0.5f + MathHelper.sin(f) * 4.0f);
            for (int i1 = 0; i1 < 5; ++i1) {
                k = p_generate_3_.getX() + (int)(1.5f + MathHelper.cos(f) * (float)i1);
                l = p_generate_3_.getZ() + (int)(1.5f + MathHelper.sin(f) * (float)i1);
                this.setBlockAndNotifyAdequately(p_generate_1_, new BlockPos(k, j - 3 + i1 / 2, l), this.woodMetadata);
            }
            int j2 = 1 + p_generate_2_.nextInt(2);
            int j1 = j;
            for (int k1 = j - j2; k1 <= j1; ++k1) {
                int l1 = k1 - j1;
                this.growLeavesLayer(p_generate_1_, new BlockPos(k, k1, l), 1 - l1);
            }
        }
        for (int i2 = 0; i2 < i; ++i2) {
            BlockPos blockpos3;
            BlockPos blockpos2;
            BlockPos blockpos = p_generate_3_.up(i2);
            if (this.isAirLeaves(p_generate_1_, blockpos)) {
                this.setBlockAndNotifyAdequately(p_generate_1_, blockpos, this.woodMetadata);
                if (i2 > 0) {
                    this.placeVine(p_generate_1_, p_generate_2_, blockpos.west(), BlockVine.EAST);
                    this.placeVine(p_generate_1_, p_generate_2_, blockpos.north(), BlockVine.SOUTH);
                }
            }
            if (i2 >= i - 1) continue;
            BlockPos blockpos1 = blockpos.east();
            if (this.isAirLeaves(p_generate_1_, blockpos1)) {
                this.setBlockAndNotifyAdequately(p_generate_1_, blockpos1, this.woodMetadata);
                if (i2 > 0) {
                    this.placeVine(p_generate_1_, p_generate_2_, blockpos1.east(), BlockVine.WEST);
                    this.placeVine(p_generate_1_, p_generate_2_, blockpos1.north(), BlockVine.SOUTH);
                }
            }
            if (this.isAirLeaves(p_generate_1_, blockpos2 = blockpos.south().east())) {
                this.setBlockAndNotifyAdequately(p_generate_1_, blockpos2, this.woodMetadata);
                if (i2 > 0) {
                    this.placeVine(p_generate_1_, p_generate_2_, blockpos2.east(), BlockVine.WEST);
                    this.placeVine(p_generate_1_, p_generate_2_, blockpos2.south(), BlockVine.NORTH);
                }
            }
            if (!this.isAirLeaves(p_generate_1_, blockpos3 = blockpos.south())) continue;
            this.setBlockAndNotifyAdequately(p_generate_1_, blockpos3, this.woodMetadata);
            if (i2 <= 0) continue;
            this.placeVine(p_generate_1_, p_generate_2_, blockpos3.west(), BlockVine.EAST);
            this.placeVine(p_generate_1_, p_generate_2_, blockpos3.south(), BlockVine.NORTH);
        }
        return true;
    }

    private void placeVine(World p_placeVine_1_, Random p_placeVine_2_, BlockPos p_placeVine_3_, PropertyBool p_placeVine_4_) {
        if (p_placeVine_2_.nextInt(3) > 0 && p_placeVine_1_.isAirBlock(p_placeVine_3_)) {
            this.setBlockAndNotifyAdequately(p_placeVine_1_, p_placeVine_3_, Blocks.VINE.getDefaultState().withProperty(p_placeVine_4_, true));
        }
    }

    private void createCrown(World p_createCrown_1_, BlockPos p_createCrown_2_, int p_createCrown_3_) {
        int i = 2;
        for (int j = -2; j <= 0; ++j) {
            this.growLeavesLayerStrict(p_createCrown_1_, p_createCrown_2_.up(j), p_createCrown_3_ + 1 - j);
        }
    }

    private boolean isAirLeaves(World p_isAirLeaves_1_, BlockPos p_isAirLeaves_2_) {
        IBlockState state = p_isAirLeaves_1_.getBlockState(p_isAirLeaves_2_);
        return state.getBlock().isAir(state, p_isAirLeaves_1_, p_isAirLeaves_2_) || state.getBlock().isLeaves(state, p_isAirLeaves_1_, p_isAirLeaves_2_);
    }
}

