/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenHugeTrees;

public class WorldGenMegaPineTree
extends WorldGenHugeTrees {
    private static final IBlockState TRUNK = Blocks.LOG.getDefaultState().withProperty(BlockOldLog.VARIANT, BlockPlanks.EnumType.SPRUCE);
    private static final IBlockState LEAF = Blocks.LEAVES.getDefaultState().withProperty(BlockOldLeaf.VARIANT, BlockPlanks.EnumType.SPRUCE).withProperty(BlockLeaves.CHECK_DECAY, false);
    private static final IBlockState PODZOL = Blocks.DIRT.getDefaultState().withProperty(BlockDirt.VARIANT, BlockDirt.DirtType.PODZOL);
    private final boolean useBaseHeight;

    public WorldGenMegaPineTree(boolean p_i45457_1_, boolean p_i45457_2_) {
        super(p_i45457_1_, 13, 15, TRUNK, LEAF);
        this.useBaseHeight = p_i45457_2_;
    }

    @Override
    public boolean generate(World p_generate_1_, Random p_generate_2_, BlockPos p_generate_3_) {
        int i = this.getHeight(p_generate_2_);
        if (!this.ensureGrowable(p_generate_1_, p_generate_2_, p_generate_3_, i)) {
            return false;
        }
        this.createCrown(p_generate_1_, p_generate_3_.getX(), p_generate_3_.getZ(), p_generate_3_.getY() + i, 0, p_generate_2_);
        for (int j = 0; j < i; ++j) {
            if (this.isAirLeaves(p_generate_1_, p_generate_3_.up(j))) {
                this.setBlockAndNotifyAdequately(p_generate_1_, p_generate_3_.up(j), this.woodMetadata);
            }
            if (j >= i - 1) continue;
            if (this.isAirLeaves(p_generate_1_, p_generate_3_.add(1, j, 0))) {
                this.setBlockAndNotifyAdequately(p_generate_1_, p_generate_3_.add(1, j, 0), this.woodMetadata);
            }
            if (this.isAirLeaves(p_generate_1_, p_generate_3_.add(1, j, 1))) {
                this.setBlockAndNotifyAdequately(p_generate_1_, p_generate_3_.add(1, j, 1), this.woodMetadata);
            }
            if (!this.isAirLeaves(p_generate_1_, p_generate_3_.add(0, j, 1))) continue;
            this.setBlockAndNotifyAdequately(p_generate_1_, p_generate_3_.add(0, j, 1), this.woodMetadata);
        }
        return true;
    }

    private void createCrown(World p_createCrown_1_, int p_createCrown_2_, int p_createCrown_3_, int p_createCrown_4_, int p_createCrown_5_, Random p_createCrown_6_) {
        int i = p_createCrown_6_.nextInt(5) + (this.useBaseHeight ? this.baseHeight : 3);
        int j = 0;
        for (int k = p_createCrown_4_ - i; k <= p_createCrown_4_; ++k) {
            int l = p_createCrown_4_ - k;
            int i1 = p_createCrown_5_ + MathHelper.floor((float)l / (float)i * 3.5f);
            this.growLeavesLayerStrict(p_createCrown_1_, new BlockPos(p_createCrown_2_, k, p_createCrown_3_), i1 + (l > 0 && i1 == j && (k & 1) == 0 ? 1 : 0));
            j = i1;
        }
    }

    @Override
    public void generateSaplings(World p_generateSaplings_1_, Random p_generateSaplings_2_, BlockPos p_generateSaplings_3_) {
        this.placePodzolCircle(p_generateSaplings_1_, p_generateSaplings_3_.west().north());
        this.placePodzolCircle(p_generateSaplings_1_, p_generateSaplings_3_.east(2).north());
        this.placePodzolCircle(p_generateSaplings_1_, p_generateSaplings_3_.west().south(2));
        this.placePodzolCircle(p_generateSaplings_1_, p_generateSaplings_3_.east(2).south(2));
        for (int i = 0; i < 5; ++i) {
            int j = p_generateSaplings_2_.nextInt(64);
            int k = j % 8;
            int l = j / 8;
            if (k != 0 && k != 7 && l != 0 && l != 7) continue;
            this.placePodzolCircle(p_generateSaplings_1_, p_generateSaplings_3_.add(-3 + k, 0, -3 + l));
        }
    }

    private void placePodzolCircle(World p_placePodzolCircle_1_, BlockPos p_placePodzolCircle_2_) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                this.placePodzolAt(p_placePodzolCircle_1_, p_placePodzolCircle_2_.add(i, 0, j));
            }
        }
    }

    private void placePodzolAt(World p_placePodzolAt_1_, BlockPos p_placePodzolAt_2_) {
        for (int i = 2; i >= -3; --i) {
            BlockPos blockpos = p_placePodzolAt_2_.up(i);
            IBlockState iblockstate = p_placePodzolAt_1_.getBlockState(blockpos);
            Block block = iblockstate.getBlock();
            if (block.canSustainPlant(iblockstate, p_placePodzolAt_1_, blockpos, EnumFacing.UP, (BlockSapling)Blocks.SAPLING)) {
                this.setBlockAndNotifyAdequately(p_placePodzolAt_1_, blockpos, PODZOL);
                break;
            }
            if (iblockstate.getMaterial() != Material.AIR && i < 0) break;
        }
    }

    private boolean isAirLeaves(World p_isAirLeaves_1_, BlockPos p_isAirLeaves_2_) {
        IBlockState state = p_isAirLeaves_1_.getBlockState(p_isAirLeaves_2_);
        return state.getBlock().isAir(state, p_isAirLeaves_1_, p_isAirLeaves_2_) || state.getBlock().isLeaves(state, p_isAirLeaves_1_, p_isAirLeaves_2_);
    }
}

