/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenSavannaTree
extends WorldGenAbstractTree {
    private static final IBlockState TRUNK = Blocks.LOG2.getDefaultState().withProperty(BlockNewLog.VARIANT, BlockPlanks.EnumType.ACACIA);
    private static final IBlockState LEAF = Blocks.LEAVES2.getDefaultState().withProperty(BlockNewLeaf.VARIANT, BlockPlanks.EnumType.ACACIA).withProperty(BlockLeaves.CHECK_DECAY, false);

    public WorldGenSavannaTree(boolean p_i45463_1_) {
        super(p_i45463_1_);
    }

    @Override
    public boolean generate(World p_generate_1_, Random p_generate_2_, BlockPos p_generate_3_) {
        int i = p_generate_2_.nextInt(3) + p_generate_2_.nextInt(3) + 5;
        boolean flag = true;
        if (p_generate_3_.getY() >= 1 && p_generate_3_.getY() + i + 1 <= 256) {
            for (int j = p_generate_3_.getY(); j <= p_generate_3_.getY() + 1 + i; ++j) {
                int k = 1;
                if (j == p_generate_3_.getY()) {
                    k = 0;
                }
                if (j >= p_generate_3_.getY() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = p_generate_3_.getX() - k; l <= p_generate_3_.getX() + k && flag; ++l) {
                    for (int i1 = p_generate_3_.getZ() - k; i1 <= p_generate_3_.getZ() + k && flag; ++i1) {
                        if (j >= 0 && j < 256) {
                            if (this.isReplaceable(p_generate_1_, blockpos$mutableblockpos.setPos(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = p_generate_3_.down();
            IBlockState state = p_generate_1_.getBlockState(down);
            boolean isSoil = state.getBlock().canSustainPlant(state, p_generate_1_, down, EnumFacing.UP, (BlockSapling)Blocks.SAPLING);
            if (isSoil && p_generate_3_.getY() < p_generate_1_.getHeight() - i - 1) {
                state.getBlock().onPlantGrow(state, p_generate_1_, down, p_generate_3_);
                EnumFacing enumfacing = EnumFacing.Plane.HORIZONTAL.random(p_generate_2_);
                int k2 = i - p_generate_2_.nextInt(4) - 1;
                int l2 = 3 - p_generate_2_.nextInt(3);
                int i3 = p_generate_3_.getX();
                int j1 = p_generate_3_.getZ();
                int k1 = 0;
                for (int l1 = 0; l1 < i; ++l1) {
                    BlockPos blockpos;
                    int i2 = p_generate_3_.getY() + l1;
                    if (l1 >= k2 && l2 > 0) {
                        i3 += enumfacing.getFrontOffsetX();
                        j1 += enumfacing.getFrontOffsetZ();
                        --l2;
                    }
                    if (!(state = p_generate_1_.getBlockState(blockpos = new BlockPos(i3, i2, j1))).getBlock().isAir(state, p_generate_1_, blockpos) && !state.getBlock().isLeaves(state, p_generate_1_, blockpos)) continue;
                    this.placeLogAt(p_generate_1_, blockpos);
                    k1 = i2;
                }
                BlockPos blockpos2 = new BlockPos(i3, k1, j1);
                for (int j3 = -3; j3 <= 3; ++j3) {
                    for (int i4 = -3; i4 <= 3; ++i4) {
                        if (Math.abs(j3) == 3 && Math.abs(i4) == 3) continue;
                        this.placeLeafAt(p_generate_1_, blockpos2.add(j3, 0, i4));
                    }
                }
                blockpos2 = blockpos2.up();
                for (int k3 = -1; k3 <= 1; ++k3) {
                    for (int j4 = -1; j4 <= 1; ++j4) {
                        this.placeLeafAt(p_generate_1_, blockpos2.add(k3, 0, j4));
                    }
                }
                this.placeLeafAt(p_generate_1_, blockpos2.east(2));
                this.placeLeafAt(p_generate_1_, blockpos2.west(2));
                this.placeLeafAt(p_generate_1_, blockpos2.south(2));
                this.placeLeafAt(p_generate_1_, blockpos2.north(2));
                i3 = p_generate_3_.getX();
                j1 = p_generate_3_.getZ();
                EnumFacing enumfacing1 = EnumFacing.Plane.HORIZONTAL.random(p_generate_2_);
                if (enumfacing1 != enumfacing) {
                    int l3 = k2 - p_generate_2_.nextInt(2) - 1;
                    int k4 = 1 + p_generate_2_.nextInt(3);
                    k1 = 0;
                    for (int l4 = l3; l4 < i && k4 > 0; ++l4, --k4) {
                        if (l4 < 1) continue;
                        int j2 = p_generate_3_.getY() + l4;
                        BlockPos blockpos1 = new BlockPos(i3 += enumfacing1.getFrontOffsetX(), j2, j1 += enumfacing1.getFrontOffsetZ());
                        state = p_generate_1_.getBlockState(blockpos1);
                        if (!state.getBlock().isAir(state, p_generate_1_, blockpos1) && !state.getBlock().isLeaves(state, p_generate_1_, blockpos1)) continue;
                        this.placeLogAt(p_generate_1_, blockpos1);
                        k1 = j2;
                    }
                    if (k1 > 0) {
                        BlockPos blockpos3 = new BlockPos(i3, k1, j1);
                        for (int i5 = -2; i5 <= 2; ++i5) {
                            for (int k5 = -2; k5 <= 2; ++k5) {
                                if (Math.abs(i5) == 2 && Math.abs(k5) == 2) continue;
                                this.placeLeafAt(p_generate_1_, blockpos3.add(i5, 0, k5));
                            }
                        }
                        blockpos3 = blockpos3.up();
                        for (int j5 = -1; j5 <= 1; ++j5) {
                            for (int l5 = -1; l5 <= 1; ++l5) {
                                this.placeLeafAt(p_generate_1_, blockpos3.add(j5, 0, l5));
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeLogAt(World p_placeLogAt_1_, BlockPos p_placeLogAt_2_) {
        this.setBlockAndNotifyAdequately(p_placeLogAt_1_, p_placeLogAt_2_, TRUNK);
    }

    private void placeLeafAt(World p_placeLeafAt_1_, BlockPos p_placeLeafAt_2_) {
        IBlockState state = p_placeLeafAt_1_.getBlockState(p_placeLeafAt_2_);
        if (state.getBlock().isAir(state, p_placeLeafAt_1_, p_placeLeafAt_2_) || state.getBlock().isLeaves(state, p_placeLeafAt_1_, p_placeLeafAt_2_)) {
            this.setBlockAndNotifyAdequately(p_placeLeafAt_1_, p_placeLeafAt_2_, LEAF);
        }
    }
}

