/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenTrees;

public class WorldGenShrub
extends WorldGenTrees {
    private final IBlockState leavesMetadata;
    private final IBlockState woodMetadata;

    public WorldGenShrub(IBlockState p_i46450_1_, IBlockState p_i46450_2_) {
        super(false);
        this.woodMetadata = p_i46450_1_;
        this.leavesMetadata = p_i46450_2_;
    }

    @Override
    public boolean generate(World p_generate_1_, Random p_generate_2_, BlockPos p_generate_3_) {
        IBlockState iblockstate = p_generate_1_.getBlockState(p_generate_3_);
        while ((iblockstate.getBlock().isAir(iblockstate, p_generate_1_, p_generate_3_) || iblockstate.getBlock().isLeaves(iblockstate, p_generate_1_, p_generate_3_)) && p_generate_3_.getY() > 0) {
            p_generate_3_ = p_generate_3_.down();
            iblockstate = p_generate_1_.getBlockState(p_generate_3_);
        }
        IBlockState state = p_generate_1_.getBlockState(p_generate_3_);
        if (state.getBlock().canSustainPlant(state, p_generate_1_, p_generate_3_, EnumFacing.UP, (BlockSapling)Blocks.SAPLING)) {
            p_generate_3_ = p_generate_3_.up();
            this.setBlockAndNotifyAdequately(p_generate_1_, p_generate_3_, this.woodMetadata);
            for (int i = p_generate_3_.getY(); i <= p_generate_3_.getY() + 2; ++i) {
                int j = i - p_generate_3_.getY();
                int k = 2 - j;
                for (int l = p_generate_3_.getX() - k; l <= p_generate_3_.getX() + k; ++l) {
                    int i1 = l - p_generate_3_.getX();
                    for (int j1 = p_generate_3_.getZ() - k; j1 <= p_generate_3_.getZ() + k; ++j1) {
                        BlockPos blockpos;
                        int k1 = j1 - p_generate_3_.getZ();
                        if (Math.abs(i1) == k && Math.abs(k1) == k && p_generate_2_.nextInt(2) == 0 || !(state = p_generate_1_.getBlockState(blockpos = new BlockPos(l, i, j1))).getBlock().canBeReplacedByLeaves(state, p_generate_1_, blockpos)) continue;
                        this.setBlockAndNotifyAdequately(p_generate_1_, blockpos, this.leavesMetadata);
                    }
                }
            }
        }
        return true;
    }
}

