/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenSpikes
extends WorldGenerator {
    private boolean crystalInvulnerable;
    private EndSpike spike;
    private BlockPos beamTarget;

    public void setSpike(EndSpike p_setSpike_1_) {
        this.spike = p_setSpike_1_;
    }

    public void setCrystalInvulnerable(boolean p_setCrystalInvulnerable_1_) {
        this.crystalInvulnerable = p_setCrystalInvulnerable_1_;
    }

    @Override
    public boolean generate(World p_generate_1_, Random p_generate_2_, BlockPos p_generate_3_) {
        if (this.spike == null) {
            throw new IllegalStateException("Decoration requires priming with a spike");
        }
        int lvt_4_1_ = this.spike.getRadius();
        for (BlockPos.MutableBlockPos lvt_6_1_ : BlockPos.getAllInBoxMutable(new BlockPos(p_generate_3_.getX() - lvt_4_1_, 0, p_generate_3_.getZ() - lvt_4_1_), new BlockPos(p_generate_3_.getX() + lvt_4_1_, this.spike.getHeight() + 10, p_generate_3_.getZ() + lvt_4_1_))) {
            if (lvt_6_1_.distanceSq(p_generate_3_.getX(), lvt_6_1_.getY(), p_generate_3_.getZ()) <= (double)(lvt_4_1_ * lvt_4_1_ + 1) && lvt_6_1_.getY() < this.spike.getHeight()) {
                this.setBlockAndNotifyAdequately(p_generate_1_, lvt_6_1_, Blocks.OBSIDIAN.getDefaultState());
                continue;
            }
            if (lvt_6_1_.getY() <= 65) continue;
            this.setBlockAndNotifyAdequately(p_generate_1_, lvt_6_1_, Blocks.AIR.getDefaultState());
        }
        if (this.spike.isGuarded()) {
            for (int lvt_5_1_ = -2; lvt_5_1_ <= 2; ++lvt_5_1_) {
                for (int lvt_6_2_ = -2; lvt_6_2_ <= 2; ++lvt_6_2_) {
                    if (MathHelper.abs(lvt_5_1_) == 2 || MathHelper.abs(lvt_6_2_) == 2) {
                        this.setBlockAndNotifyAdequately(p_generate_1_, new BlockPos(p_generate_3_.getX() + lvt_5_1_, this.spike.getHeight(), p_generate_3_.getZ() + lvt_6_2_), Blocks.IRON_BARS.getDefaultState());
                        this.setBlockAndNotifyAdequately(p_generate_1_, new BlockPos(p_generate_3_.getX() + lvt_5_1_, this.spike.getHeight() + 1, p_generate_3_.getZ() + lvt_6_2_), Blocks.IRON_BARS.getDefaultState());
                        this.setBlockAndNotifyAdequately(p_generate_1_, new BlockPos(p_generate_3_.getX() + lvt_5_1_, this.spike.getHeight() + 2, p_generate_3_.getZ() + lvt_6_2_), Blocks.IRON_BARS.getDefaultState());
                    }
                    this.setBlockAndNotifyAdequately(p_generate_1_, new BlockPos(p_generate_3_.getX() + lvt_5_1_, this.spike.getHeight() + 3, p_generate_3_.getZ() + lvt_6_2_), Blocks.IRON_BARS.getDefaultState());
                }
            }
        }
        EntityEnderCrystal lvt_5_2_ = new EntityEnderCrystal(p_generate_1_);
        lvt_5_2_.setBeamTarget(this.beamTarget);
        lvt_5_2_.setEntityInvulnerable(this.crystalInvulnerable);
        lvt_5_2_.setLocationAndAngles((float)p_generate_3_.getX() + 0.5f, this.spike.getHeight() + 1, (float)p_generate_3_.getZ() + 0.5f, p_generate_2_.nextFloat() * 360.0f, 0.0f);
        p_generate_1_.spawnEntity(lvt_5_2_);
        this.setBlockAndNotifyAdequately(p_generate_1_, new BlockPos(p_generate_3_.getX(), this.spike.getHeight(), p_generate_3_.getZ()), Blocks.BEDROCK.getDefaultState());
        return true;
    }

    public void setBeamTarget(BlockPos p_setBeamTarget_1_) {
        this.beamTarget = p_setBeamTarget_1_;
    }

    public static class EndSpike {
        private final int centerX;
        private final int centerZ;
        private final int radius;
        private final int height;
        private final boolean guarded;
        private final AxisAlignedBB topBoundingBox;

        public EndSpike(int p_i47020_1_, int p_i47020_2_, int p_i47020_3_, int p_i47020_4_, boolean p_i47020_5_) {
            this.centerX = p_i47020_1_;
            this.centerZ = p_i47020_2_;
            this.radius = p_i47020_3_;
            this.height = p_i47020_4_;
            this.guarded = p_i47020_5_;
            this.topBoundingBox = new AxisAlignedBB(p_i47020_1_ - p_i47020_3_, 0.0, p_i47020_2_ - p_i47020_3_, p_i47020_1_ + p_i47020_3_, 256.0, p_i47020_2_ + p_i47020_3_);
        }

        public boolean doesStartInChunk(BlockPos p_doesStartInChunk_1_) {
            int lvt_2_1_ = this.centerX - this.radius;
            int lvt_3_1_ = this.centerZ - this.radius;
            return p_doesStartInChunk_1_.getX() == (lvt_2_1_ & 0xFFFFFFF0) && p_doesStartInChunk_1_.getZ() == (lvt_3_1_ & 0xFFFFFFF0);
        }

        public int getCenterX() {
            return this.centerX;
        }

        public int getCenterZ() {
            return this.centerZ;
        }

        public int getRadius() {
            return this.radius;
        }

        public int getHeight() {
            return this.height;
        }

        public boolean isGuarded() {
            return this.guarded;
        }

        public AxisAlignedBB getTopBoundingBox() {
            return this.topBoundingBox;
        }
    }
}

