/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenSwamp
extends WorldGenAbstractTree {
    private static final IBlockState TRUNK = Blocks.LOG.getDefaultState().withProperty(BlockOldLog.VARIANT, BlockPlanks.EnumType.OAK);
    private static final IBlockState LEAF = Blocks.LEAVES.getDefaultState().withProperty(BlockOldLeaf.VARIANT, BlockPlanks.EnumType.OAK).withProperty(BlockOldLeaf.CHECK_DECAY, false);

    public WorldGenSwamp() {
        super(false);
    }

    @Override
    public boolean generate(World p_generate_1_, Random p_generate_2_, BlockPos p_generate_3_) {
        int i = p_generate_2_.nextInt(4) + 5;
        while (p_generate_1_.getBlockState(p_generate_3_.down()).getMaterial() == Material.WATER) {
            p_generate_3_ = p_generate_3_.down();
        }
        boolean flag = true;
        if (p_generate_3_.getY() >= 1 && p_generate_3_.getY() + i + 1 <= 256) {
            for (int j = p_generate_3_.getY(); j <= p_generate_3_.getY() + 1 + i; ++j) {
                int k = 1;
                if (j == p_generate_3_.getY()) {
                    k = 0;
                }
                if (j >= p_generate_3_.getY() + 1 + i - 2) {
                    k = 3;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = p_generate_3_.getX() - k; l <= p_generate_3_.getX() + k && flag; ++l) {
                    for (int i1 = p_generate_3_.getZ() - k; i1 <= p_generate_3_.getZ() + k && flag; ++i1) {
                        if (j >= 0 && j < 256) {
                            IBlockState iblockstate = p_generate_1_.getBlockState(blockpos$mutableblockpos.setPos(l, j, i1));
                            Block block = iblockstate.getBlock();
                            if (iblockstate.getBlock().isAir(iblockstate, p_generate_1_, blockpos$mutableblockpos.setPos(l, j, i1)) || iblockstate.getBlock().isLeaves(iblockstate, p_generate_1_, blockpos$mutableblockpos.setPos(l, j, i1))) continue;
                            if (block != Blocks.WATER && block != Blocks.FLOWING_WATER) {
                                flag = false;
                                continue;
                            }
                            if (j <= p_generate_3_.getY()) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = p_generate_3_.down();
            IBlockState state = p_generate_1_.getBlockState(down);
            boolean isSoil = state.getBlock().canSustainPlant(state, p_generate_1_, down, EnumFacing.UP, (BlockSapling)Blocks.SAPLING);
            if (isSoil && p_generate_3_.getY() < p_generate_1_.getHeight() - i - 1) {
                state.getBlock().onPlantGrow(state, p_generate_1_, p_generate_3_.down(), p_generate_3_);
                for (int k1 = p_generate_3_.getY() - 3 + i; k1 <= p_generate_3_.getY() + i; ++k1) {
                    int j2 = k1 - (p_generate_3_.getY() + i);
                    int l2 = 2 - j2 / 2;
                    for (int j3 = p_generate_3_.getX() - l2; j3 <= p_generate_3_.getX() + l2; ++j3) {
                        int k3 = j3 - p_generate_3_.getX();
                        for (int i4 = p_generate_3_.getZ() - l2; i4 <= p_generate_3_.getZ() + l2; ++i4) {
                            BlockPos blockpos;
                            int j1 = i4 - p_generate_3_.getZ();
                            if (Math.abs(k3) == l2 && Math.abs(j1) == l2 && (p_generate_2_.nextInt(2) == 0 || j2 == 0) || !(state = p_generate_1_.getBlockState(blockpos = new BlockPos(j3, k1, i4))).getBlock().canBeReplacedByLeaves(state, p_generate_1_, blockpos)) continue;
                            this.setBlockAndNotifyAdequately(p_generate_1_, blockpos, LEAF);
                        }
                    }
                }
                for (int l1 = 0; l1 < i; ++l1) {
                    BlockPos upN = p_generate_3_.up(l1);
                    IBlockState iblockstate1 = p_generate_1_.getBlockState(upN);
                    Block block2 = iblockstate1.getBlock();
                    if (!block2.isAir(iblockstate1, p_generate_1_, upN) && !block2.isLeaves(iblockstate1, p_generate_1_, upN) && block2 != Blocks.FLOWING_WATER && block2 != Blocks.WATER) continue;
                    this.setBlockAndNotifyAdequately(p_generate_1_, p_generate_3_.up(l1), TRUNK);
                }
                for (int i2 = p_generate_3_.getY() - 3 + i; i2 <= p_generate_3_.getY() + i; ++i2) {
                    int k2 = i2 - (p_generate_3_.getY() + i);
                    int i3 = 2 - k2 / 2;
                    BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
                    for (int l3 = p_generate_3_.getX() - i3; l3 <= p_generate_3_.getX() + i3; ++l3) {
                        for (int j4 = p_generate_3_.getZ() - i3; j4 <= p_generate_3_.getZ() + i3; ++j4) {
                            blockpos$mutableblockpos1.setPos(l3, i2, j4);
                            if (p_generate_1_.getBlockState(blockpos$mutableblockpos1).getMaterial() != Material.LEAVES) continue;
                            BlockPos blockpos3 = blockpos$mutableblockpos1.west();
                            BlockPos blockpos4 = blockpos$mutableblockpos1.east();
                            BlockPos blockpos1 = blockpos$mutableblockpos1.north();
                            BlockPos blockpos2 = blockpos$mutableblockpos1.south();
                            if (p_generate_2_.nextInt(4) == 0 && this.isAir(p_generate_1_, blockpos3)) {
                                this.addVine(p_generate_1_, blockpos3, BlockVine.EAST);
                            }
                            if (p_generate_2_.nextInt(4) == 0 && this.isAir(p_generate_1_, blockpos4)) {
                                this.addVine(p_generate_1_, blockpos4, BlockVine.WEST);
                            }
                            if (p_generate_2_.nextInt(4) == 0 && this.isAir(p_generate_1_, blockpos1)) {
                                this.addVine(p_generate_1_, blockpos1, BlockVine.SOUTH);
                            }
                            if (p_generate_2_.nextInt(4) != 0 || !this.isAir(p_generate_1_, blockpos2)) continue;
                            this.addVine(p_generate_1_, blockpos2, BlockVine.NORTH);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void addVine(World p_addVine_1_, BlockPos p_addVine_2_, PropertyBool p_addVine_3_) {
        IBlockState iblockstate = Blocks.VINE.getDefaultState().withProperty(p_addVine_3_, true);
        this.setBlockAndNotifyAdequately(p_addVine_1_, p_addVine_2_, iblockstate);
        p_addVine_2_ = p_addVine_2_.down();
        for (int i = 4; this.isAir(p_addVine_1_, p_addVine_2_) && i > 0; --i) {
            this.setBlockAndNotifyAdequately(p_addVine_1_, p_addVine_2_, iblockstate);
            p_addVine_2_ = p_addVine_2_.down();
        }
    }

    private boolean isAir(World p_isAir_1_, BlockPos p_isAir_2_) {
        IBlockState state = p_isAir_1_.getBlockState(p_isAir_2_);
        return state.getBlock().isAir(state, p_isAir_1_, p_isAir_2_);
    }
}

