/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenTaiga1
extends WorldGenAbstractTree {
    private static final IBlockState TRUNK = Blocks.LOG.getDefaultState().withProperty(BlockOldLog.VARIANT, BlockPlanks.EnumType.SPRUCE);
    private static final IBlockState LEAF = Blocks.LEAVES.getDefaultState().withProperty(BlockOldLeaf.VARIANT, BlockPlanks.EnumType.SPRUCE).withProperty(BlockLeaves.CHECK_DECAY, false);

    public WorldGenTaiga1() {
        super(false);
    }

    @Override
    public boolean generate(World p_generate_1_, Random p_generate_2_, BlockPos p_generate_3_) {
        int i = p_generate_2_.nextInt(5) + 7;
        int j = i - p_generate_2_.nextInt(2) - 3;
        int k = i - j;
        int l = 1 + p_generate_2_.nextInt(k + 1);
        if (p_generate_3_.getY() >= 1 && p_generate_3_.getY() + i + 1 <= 256) {
            boolean flag = true;
            for (int i1 = p_generate_3_.getY(); i1 <= p_generate_3_.getY() + 1 + i && flag; ++i1) {
                int j1 = 1;
                j1 = i1 - p_generate_3_.getY() < j ? 0 : l;
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int k1 = p_generate_3_.getX() - j1; k1 <= p_generate_3_.getX() + j1 && flag; ++k1) {
                    for (int l1 = p_generate_3_.getZ() - j1; l1 <= p_generate_3_.getZ() + j1 && flag; ++l1) {
                        if (i1 >= 0 && i1 < 256) {
                            if (this.isReplaceable(p_generate_1_, blockpos$mutableblockpos.setPos(k1, i1, l1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = p_generate_3_.down();
            IBlockState state = p_generate_1_.getBlockState(down);
            boolean isSoil = state.getBlock().canSustainPlant(state, p_generate_1_, down, EnumFacing.UP, (BlockSapling)Blocks.SAPLING);
            if (isSoil && p_generate_3_.getY() < 256 - i - 1) {
                state.getBlock().onPlantGrow(state, p_generate_1_, down, p_generate_3_);
                int k2 = 0;
                for (int l2 = p_generate_3_.getY() + i; l2 >= p_generate_3_.getY() + j; --l2) {
                    for (int j3 = p_generate_3_.getX() - k2; j3 <= p_generate_3_.getX() + k2; ++j3) {
                        int k3 = j3 - p_generate_3_.getX();
                        for (int i2 = p_generate_3_.getZ() - k2; i2 <= p_generate_3_.getZ() + k2; ++i2) {
                            BlockPos blockpos;
                            int j2 = i2 - p_generate_3_.getZ();
                            if (Math.abs(k3) == k2 && Math.abs(j2) == k2 && k2 > 0 || !(state = p_generate_1_.getBlockState(blockpos = new BlockPos(j3, l2, i2))).getBlock().canBeReplacedByLeaves(state, p_generate_1_, blockpos)) continue;
                            this.setBlockAndNotifyAdequately(p_generate_1_, blockpos, LEAF);
                        }
                    }
                    if (k2 >= 1 && l2 == p_generate_3_.getY() + j + 1) {
                        --k2;
                        continue;
                    }
                    if (k2 >= l) continue;
                    ++k2;
                }
                for (int i3 = 0; i3 < i - 1; ++i3) {
                    BlockPos upN = p_generate_3_.up(i3);
                    state = p_generate_1_.getBlockState(upN);
                    if (!state.getBlock().isAir(state, p_generate_1_, upN) && !state.getBlock().isLeaves(state, p_generate_1_, upN)) continue;
                    this.setBlockAndNotifyAdequately(p_generate_1_, p_generate_3_.up(i3), TRUNK);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

