/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenTallGrass
extends WorldGenerator {
    private final IBlockState tallGrassState;

    public WorldGenTallGrass(BlockTallGrass.EnumType p_i45629_1_) {
        this.tallGrassState = Blocks.TALLGRASS.getDefaultState().withProperty(BlockTallGrass.TYPE, p_i45629_1_);
    }

    @Override
    public boolean generate(World p_generate_1_, Random p_generate_2_, BlockPos p_generate_3_) {
        IBlockState iblockstate = p_generate_1_.getBlockState(p_generate_3_);
        while ((iblockstate.getBlock().isAir(iblockstate, p_generate_1_, p_generate_3_) || iblockstate.getBlock().isLeaves(iblockstate, p_generate_1_, p_generate_3_)) && p_generate_3_.getY() > 0) {
            p_generate_3_ = p_generate_3_.down();
            iblockstate = p_generate_1_.getBlockState(p_generate_3_);
        }
        for (int i = 0; i < 128; ++i) {
            BlockPos blockpos = p_generate_3_.add(p_generate_2_.nextInt(8) - p_generate_2_.nextInt(8), p_generate_2_.nextInt(4) - p_generate_2_.nextInt(4), p_generate_2_.nextInt(8) - p_generate_2_.nextInt(8));
            if (!p_generate_1_.isAirBlock(blockpos) || !Blocks.TALLGRASS.canBlockStay(p_generate_1_, blockpos, this.tallGrassState)) continue;
            p_generate_1_.setBlockState(blockpos, this.tallGrassState, 2);
        }
        return true;
    }
}

