/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenTrees
extends WorldGenAbstractTree {
    private static final IBlockState DEFAULT_TRUNK = Blocks.LOG.getDefaultState().withProperty(BlockOldLog.VARIANT, BlockPlanks.EnumType.OAK);
    private static final IBlockState DEFAULT_LEAF = Blocks.LEAVES.getDefaultState().withProperty(BlockOldLeaf.VARIANT, BlockPlanks.EnumType.OAK).withProperty(BlockLeaves.CHECK_DECAY, false);
    private final int minTreeHeight;
    private final boolean vinesGrow;
    private final IBlockState metaWood;
    private final IBlockState metaLeaves;

    public WorldGenTrees(boolean p_i2027_1_) {
        this(p_i2027_1_, 4, DEFAULT_TRUNK, DEFAULT_LEAF, false);
    }

    public WorldGenTrees(boolean p_i46446_1_, int p_i46446_2_, IBlockState p_i46446_3_, IBlockState p_i46446_4_, boolean p_i46446_5_) {
        super(p_i46446_1_);
        this.minTreeHeight = p_i46446_2_;
        this.metaWood = p_i46446_3_;
        this.metaLeaves = p_i46446_4_;
        this.vinesGrow = p_i46446_5_;
    }

    @Override
    public boolean generate(World p_generate_1_, Random p_generate_2_, BlockPos p_generate_3_) {
        int i = p_generate_2_.nextInt(3) + this.minTreeHeight;
        boolean flag = true;
        if (p_generate_3_.getY() >= 1 && p_generate_3_.getY() + i + 1 <= p_generate_1_.getHeight()) {
            for (int j = p_generate_3_.getY(); j <= p_generate_3_.getY() + 1 + i; ++j) {
                int k = 1;
                if (j == p_generate_3_.getY()) {
                    k = 0;
                }
                if (j >= p_generate_3_.getY() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = p_generate_3_.getX() - k; l <= p_generate_3_.getX() + k && flag; ++l) {
                    for (int i1 = p_generate_3_.getZ() - k; i1 <= p_generate_3_.getZ() + k && flag; ++i1) {
                        if (j >= 0 && j < p_generate_1_.getHeight()) {
                            if (this.isReplaceable(p_generate_1_, blockpos$mutableblockpos.setPos(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            IBlockState state = p_generate_1_.getBlockState(p_generate_3_.down());
            if (state.getBlock().canSustainPlant(state, p_generate_1_, p_generate_3_.down(), EnumFacing.UP, (BlockSapling)Blocks.SAPLING) && p_generate_3_.getY() < p_generate_1_.getHeight() - i - 1) {
                state.getBlock().onPlantGrow(state, p_generate_1_, p_generate_3_.down(), p_generate_3_);
                int k2 = 3;
                boolean l2 = false;
                for (int i3 = p_generate_3_.getY() - 3 + i; i3 <= p_generate_3_.getY() + i; ++i3) {
                    int i4 = i3 - (p_generate_3_.getY() + i);
                    int j1 = 1 - i4 / 2;
                    for (int k1 = p_generate_3_.getX() - j1; k1 <= p_generate_3_.getX() + j1; ++k1) {
                        int l1 = k1 - p_generate_3_.getX();
                        for (int i2 = p_generate_3_.getZ() - j1; i2 <= p_generate_3_.getZ() + j1; ++i2) {
                            BlockPos blockpos;
                            int j2 = i2 - p_generate_3_.getZ();
                            if (Math.abs(l1) == j1 && Math.abs(j2) == j1 && (p_generate_2_.nextInt(2) == 0 || i4 == 0) || !(state = p_generate_1_.getBlockState(blockpos = new BlockPos(k1, i3, i2))).getBlock().isAir(state, p_generate_1_, blockpos) && !state.getBlock().isLeaves(state, p_generate_1_, blockpos) && state.getMaterial() != Material.VINE) continue;
                            this.setBlockAndNotifyAdequately(p_generate_1_, blockpos, this.metaLeaves);
                        }
                    }
                }
                for (int j3 = 0; j3 < i; ++j3) {
                    BlockPos upN = p_generate_3_.up(j3);
                    state = p_generate_1_.getBlockState(upN);
                    if (!state.getBlock().isAir(state, p_generate_1_, upN) && !state.getBlock().isLeaves(state, p_generate_1_, upN) && state.getMaterial() != Material.VINE) continue;
                    this.setBlockAndNotifyAdequately(p_generate_1_, p_generate_3_.up(j3), this.metaWood);
                    if (!this.vinesGrow || j3 <= 0) continue;
                    if (p_generate_2_.nextInt(3) > 0 && p_generate_1_.isAirBlock(p_generate_3_.add(-1, j3, 0))) {
                        this.addVine(p_generate_1_, p_generate_3_.add(-1, j3, 0), BlockVine.EAST);
                    }
                    if (p_generate_2_.nextInt(3) > 0 && p_generate_1_.isAirBlock(p_generate_3_.add(1, j3, 0))) {
                        this.addVine(p_generate_1_, p_generate_3_.add(1, j3, 0), BlockVine.WEST);
                    }
                    if (p_generate_2_.nextInt(3) > 0 && p_generate_1_.isAirBlock(p_generate_3_.add(0, j3, -1))) {
                        this.addVine(p_generate_1_, p_generate_3_.add(0, j3, -1), BlockVine.SOUTH);
                    }
                    if (p_generate_2_.nextInt(3) <= 0 || !p_generate_1_.isAirBlock(p_generate_3_.add(0, j3, 1))) continue;
                    this.addVine(p_generate_1_, p_generate_3_.add(0, j3, 1), BlockVine.NORTH);
                }
                if (this.vinesGrow) {
                    for (int k3 = p_generate_3_.getY() - 3 + i; k3 <= p_generate_3_.getY() + i; ++k3) {
                        int j4 = k3 - (p_generate_3_.getY() + i);
                        int k4 = 2 - j4 / 2;
                        BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
                        for (int l4 = p_generate_3_.getX() - k4; l4 <= p_generate_3_.getX() + k4; ++l4) {
                            for (int i5 = p_generate_3_.getZ() - k4; i5 <= p_generate_3_.getZ() + k4; ++i5) {
                                blockpos$mutableblockpos1.setPos(l4, k3, i5);
                                state = p_generate_1_.getBlockState(blockpos$mutableblockpos1);
                                if (!state.getBlock().isLeaves(state, p_generate_1_, blockpos$mutableblockpos1)) continue;
                                BlockPos blockpos2 = blockpos$mutableblockpos1.west();
                                BlockPos blockpos3 = blockpos$mutableblockpos1.east();
                                BlockPos blockpos4 = blockpos$mutableblockpos1.north();
                                BlockPos blockpos1 = blockpos$mutableblockpos1.south();
                                if (p_generate_2_.nextInt(4) == 0 && p_generate_1_.isAirBlock(blockpos2)) {
                                    this.addHangingVine(p_generate_1_, blockpos2, BlockVine.EAST);
                                }
                                if (p_generate_2_.nextInt(4) == 0 && p_generate_1_.isAirBlock(blockpos3)) {
                                    this.addHangingVine(p_generate_1_, blockpos3, BlockVine.WEST);
                                }
                                if (p_generate_2_.nextInt(4) == 0 && p_generate_1_.isAirBlock(blockpos4)) {
                                    this.addHangingVine(p_generate_1_, blockpos4, BlockVine.SOUTH);
                                }
                                if (p_generate_2_.nextInt(4) != 0 || !p_generate_1_.isAirBlock(blockpos1)) continue;
                                this.addHangingVine(p_generate_1_, blockpos1, BlockVine.NORTH);
                            }
                        }
                    }
                    if (p_generate_2_.nextInt(5) == 0 && i > 5) {
                        for (int l3 = 0; l3 < 2; ++l3) {
                            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                                if (p_generate_2_.nextInt(4 - l3) != 0) continue;
                                EnumFacing enumfacing1 = enumfacing.getOpposite();
                                this.placeCocoa(p_generate_1_, p_generate_2_.nextInt(3), p_generate_3_.add(enumfacing1.getFrontOffsetX(), i - 5 + l3, enumfacing1.getFrontOffsetZ()), enumfacing);
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeCocoa(World p_placeCocoa_1_, int p_placeCocoa_2_, BlockPos p_placeCocoa_3_, EnumFacing p_placeCocoa_4_) {
        this.setBlockAndNotifyAdequately(p_placeCocoa_1_, p_placeCocoa_3_, Blocks.COCOA.getDefaultState().withProperty(BlockCocoa.AGE, p_placeCocoa_2_).withProperty(BlockCocoa.FACING, p_placeCocoa_4_));
    }

    private void addVine(World p_addVine_1_, BlockPos p_addVine_2_, PropertyBool p_addVine_3_) {
        this.setBlockAndNotifyAdequately(p_addVine_1_, p_addVine_2_, Blocks.VINE.getDefaultState().withProperty(p_addVine_3_, true));
    }

    private void addHangingVine(World p_addHangingVine_1_, BlockPos p_addHangingVine_2_, PropertyBool p_addHangingVine_3_) {
        this.addVine(p_addHangingVine_1_, p_addHangingVine_2_, p_addHangingVine_3_);
        p_addHangingVine_2_ = p_addHangingVine_2_.down();
        for (int i = 4; p_addHangingVine_1_.isAirBlock(p_addHangingVine_2_) && i > 0; --i) {
            this.addVine(p_addHangingVine_1_, p_addHangingVine_2_, p_addHangingVine_3_);
            p_addHangingVine_2_ = p_addHangingVine_2_.down();
        }
    }
}

