/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.loot.LootTableList;

public class WorldGeneratorBonusChest
extends WorldGenerator {
    @Override
    public boolean generate(World p_generate_1_, Random p_generate_2_, BlockPos p_generate_3_) {
        IBlockState iblockstate = p_generate_1_.getBlockState(p_generate_3_);
        while ((iblockstate.getBlock().isAir(iblockstate, p_generate_1_, p_generate_3_) || iblockstate.getBlock().isLeaves(iblockstate, p_generate_1_, p_generate_3_)) && p_generate_3_.getY() > 1) {
            p_generate_3_ = p_generate_3_.down();
            iblockstate = p_generate_1_.getBlockState(p_generate_3_);
        }
        if (p_generate_3_.getY() < 1) {
            return false;
        }
        p_generate_3_ = p_generate_3_.up();
        for (int i = 0; i < 4; ++i) {
            BlockPos blockpos = p_generate_3_.add(p_generate_2_.nextInt(4) - p_generate_2_.nextInt(4), p_generate_2_.nextInt(3) - p_generate_2_.nextInt(3), p_generate_2_.nextInt(4) - p_generate_2_.nextInt(4));
            if (!p_generate_1_.isAirBlock(blockpos) || !p_generate_1_.getBlockState(blockpos.down()).isSideSolid(p_generate_1_, blockpos.down(), EnumFacing.UP)) continue;
            p_generate_1_.setBlockState(blockpos, Blocks.CHEST.getDefaultState(), 2);
            TileEntity tileentity = p_generate_1_.getTileEntity(blockpos);
            if (tileentity instanceof TileEntityChest) {
                ((TileEntityChest)tileentity).setLootTable(LootTableList.CHESTS_SPAWN_BONUS_CHEST, p_generate_2_.nextLong());
            }
            BlockPos blockpos1 = blockpos.east();
            BlockPos blockpos2 = blockpos.west();
            BlockPos blockpos3 = blockpos.north();
            BlockPos blockpos4 = blockpos.south();
            if (p_generate_1_.isAirBlock(blockpos2) && p_generate_1_.getBlockState(blockpos2.down()).isSideSolid(p_generate_1_, blockpos2.down(), EnumFacing.UP)) {
                p_generate_1_.setBlockState(blockpos2, Blocks.TORCH.getDefaultState(), 2);
            }
            if (p_generate_1_.isAirBlock(blockpos1) && p_generate_1_.getBlockState(blockpos1.down()).isSideSolid(p_generate_1_, blockpos1.down(), EnumFacing.UP)) {
                p_generate_1_.setBlockState(blockpos1, Blocks.TORCH.getDefaultState(), 2);
            }
            if (p_generate_1_.isAirBlock(blockpos3) && p_generate_1_.getBlockState(blockpos3.down()).isSideSolid(p_generate_1_, blockpos3.down(), EnumFacing.UP)) {
                p_generate_1_.setBlockState(blockpos3, Blocks.TORCH.getDefaultState(), 2);
            }
            if (p_generate_1_.isAirBlock(blockpos4) && p_generate_1_.getBlockState(blockpos4.down()).isSideSolid(p_generate_1_, blockpos4.down(), EnumFacing.UP)) {
                p_generate_1_.setBlockState(blockpos4, Blocks.TORCH.getDefaultState(), 2);
            }
            return true;
        }
        return false;
    }
}

