/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.layer;

import net.minecraft.init.Biomes;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkProviderSettings;
import net.minecraft.world.gen.layer.GenLayerAddIsland;
import net.minecraft.world.gen.layer.GenLayerAddMushroomIsland;
import net.minecraft.world.gen.layer.GenLayerAddSnow;
import net.minecraft.world.gen.layer.GenLayerDeepOcean;
import net.minecraft.world.gen.layer.GenLayerEdge;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerHills;
import net.minecraft.world.gen.layer.GenLayerIsland;
import net.minecraft.world.gen.layer.GenLayerRareBiome;
import net.minecraft.world.gen.layer.GenLayerRemoveTooMuchOcean;
import net.minecraft.world.gen.layer.GenLayerRiver;
import net.minecraft.world.gen.layer.GenLayerRiverInit;
import net.minecraft.world.gen.layer.GenLayerRiverMix;
import net.minecraft.world.gen.layer.GenLayerShore;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;

public abstract class GenLayer {
    private long worldGenSeed;
    protected GenLayer parent;
    private long chunkSeed;
    protected long baseSeed;

    public static GenLayer[] initializeAllBiomeGenerators(long p_initializeAllBiomeGenerators_0_, WorldType p_initializeAllBiomeGenerators_2_, ChunkProviderSettings p_initializeAllBiomeGenerators_3_) {
        int i;
        GenLayer genlayer = new GenLayerIsland(1L);
        genlayer = new GenLayerFuzzyZoom(2000L, genlayer);
        GenLayerAddIsland genlayeraddisland = new GenLayerAddIsland(1L, genlayer);
        GenLayerZoom genlayerzoom = new GenLayerZoom(2001L, genlayeraddisland);
        GenLayerAddIsland genlayeraddisland1 = new GenLayerAddIsland(2L, genlayerzoom);
        genlayeraddisland1 = new GenLayerAddIsland(50L, genlayeraddisland1);
        genlayeraddisland1 = new GenLayerAddIsland(70L, genlayeraddisland1);
        GenLayerRemoveTooMuchOcean genlayerremovetoomuchocean = new GenLayerRemoveTooMuchOcean(2L, genlayeraddisland1);
        GenLayerAddSnow genlayeraddsnow = new GenLayerAddSnow(2L, genlayerremovetoomuchocean);
        GenLayerAddIsland genlayeraddisland2 = new GenLayerAddIsland(3L, genlayeraddsnow);
        GenLayerEdge genlayeredge = new GenLayerEdge(2L, genlayeraddisland2, GenLayerEdge.Mode.COOL_WARM);
        genlayeredge = new GenLayerEdge(2L, genlayeredge, GenLayerEdge.Mode.HEAT_ICE);
        genlayeredge = new GenLayerEdge(3L, genlayeredge, GenLayerEdge.Mode.SPECIAL);
        GenLayerZoom genlayerzoom1 = new GenLayerZoom(2002L, genlayeredge);
        genlayerzoom1 = new GenLayerZoom(2003L, genlayerzoom1);
        GenLayerAddIsland genlayeraddisland3 = new GenLayerAddIsland(4L, genlayerzoom1);
        GenLayerAddMushroomIsland genlayeraddmushroomisland = new GenLayerAddMushroomIsland(5L, genlayeraddisland3);
        GenLayerDeepOcean genlayerdeepocean = new GenLayerDeepOcean(4L, genlayeraddmushroomisland);
        GenLayer genlayer4 = GenLayerZoom.magnify(1000L, genlayerdeepocean, 0);
        int j = i = 4;
        if (p_initializeAllBiomeGenerators_3_ != null) {
            i = p_initializeAllBiomeGenerators_3_.biomeSize;
            j = p_initializeAllBiomeGenerators_3_.riverSize;
        }
        if (p_initializeAllBiomeGenerators_2_ == WorldType.LARGE_BIOMES) {
            i = 6;
        }
        i = GenLayer.getModdedBiomeSize(p_initializeAllBiomeGenerators_2_, i);
        GenLayer lvt_7_1_ = GenLayerZoom.magnify(1000L, genlayer4, 0);
        GenLayerRiverInit genlayerriverinit = new GenLayerRiverInit(100L, lvt_7_1_);
        GenLayer lvt_9_1_ = GenLayerZoom.magnify(1000L, genlayerriverinit, 2);
        GenLayer genlayerbiomeedge = p_initializeAllBiomeGenerators_2_.getBiomeLayer(p_initializeAllBiomeGenerators_0_, genlayer4, p_initializeAllBiomeGenerators_3_);
        GenLayer genlayerhills = new GenLayerHills(1000L, genlayerbiomeedge, lvt_9_1_);
        GenLayer genlayer5 = GenLayerZoom.magnify(1000L, genlayerriverinit, 2);
        genlayer5 = GenLayerZoom.magnify(1000L, genlayer5, j);
        GenLayerRiver genlayerriver = new GenLayerRiver(1L, genlayer5);
        GenLayerSmooth genlayersmooth = new GenLayerSmooth(1000L, genlayerriver);
        genlayerhills = new GenLayerRareBiome(1001L, genlayerhills);
        for (int k = 0; k < i; ++k) {
            genlayerhills = new GenLayerZoom(1000 + k, genlayerhills);
            if (k == 0) {
                genlayerhills = new GenLayerAddIsland(3L, genlayerhills);
            }
            if (k != 1 && i != 1) continue;
            genlayerhills = new GenLayerShore(1000L, genlayerhills);
        }
        GenLayerSmooth genlayersmooth1 = new GenLayerSmooth(1000L, genlayerhills);
        GenLayerRiverMix genlayerrivermix = new GenLayerRiverMix(100L, genlayersmooth1, genlayersmooth);
        GenLayerVoronoiZoom genlayer3 = new GenLayerVoronoiZoom(10L, genlayerrivermix);
        genlayerrivermix.initWorldGenSeed(p_initializeAllBiomeGenerators_0_);
        genlayer3.initWorldGenSeed(p_initializeAllBiomeGenerators_0_);
        return new GenLayer[]{genlayerrivermix, genlayer3, genlayerrivermix};
    }

    public GenLayer(long p_i2125_1_) {
        this.baseSeed = p_i2125_1_;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += p_i2125_1_;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += p_i2125_1_;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += p_i2125_1_;
    }

    public void initWorldGenSeed(long p_initWorldGenSeed_1_) {
        this.worldGenSeed = p_initWorldGenSeed_1_;
        if (this.parent != null) {
            this.parent.initWorldGenSeed(p_initWorldGenSeed_1_);
        }
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
    }

    public void initChunkSeed(long p_initChunkSeed_1_, long p_initChunkSeed_3_) {
        this.chunkSeed = this.worldGenSeed;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += p_initChunkSeed_1_;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += p_initChunkSeed_3_;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += p_initChunkSeed_1_;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += p_initChunkSeed_3_;
    }

    protected int nextInt(int p_nextInt_1_) {
        int i = (int)((this.chunkSeed >> 24) % (long)p_nextInt_1_);
        if (i < 0) {
            i += p_nextInt_1_;
        }
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += this.worldGenSeed;
        return i;
    }

    public abstract int[] getInts(int var1, int var2, int var3, int var4);

    protected static boolean biomesEqualOrMesaPlateau(int p_biomesEqualOrMesaPlateau_0_, int p_biomesEqualOrMesaPlateau_1_) {
        if (p_biomesEqualOrMesaPlateau_0_ == p_biomesEqualOrMesaPlateau_1_) {
            return true;
        }
        Biome biome = Biome.getBiome(p_biomesEqualOrMesaPlateau_0_);
        Biome biome1 = Biome.getBiome(p_biomesEqualOrMesaPlateau_1_);
        return biome != null && biome1 != null ? (biome != Biomes.MESA_ROCK && biome != Biomes.MESA_CLEAR_ROCK ? biome == biome1 || biome.getBiomeClass() == biome1.getBiomeClass() : biome1 == Biomes.MESA_ROCK || biome1 == Biomes.MESA_CLEAR_ROCK) : false;
    }

    protected static boolean isBiomeOceanic(int p_isBiomeOceanic_0_) {
        return BiomeManager.oceanBiomes.contains(Biome.getBiome(p_isBiomeOceanic_0_));
    }

    protected int selectRandom(int ... p_selectRandom_1_) {
        return p_selectRandom_1_[this.nextInt(p_selectRandom_1_.length)];
    }

    protected int selectModeOrRandom(int p_selectModeOrRandom_1_, int p_selectModeOrRandom_2_, int p_selectModeOrRandom_3_, int p_selectModeOrRandom_4_) {
        return p_selectModeOrRandom_2_ == p_selectModeOrRandom_3_ && p_selectModeOrRandom_3_ == p_selectModeOrRandom_4_ ? p_selectModeOrRandom_2_ : (p_selectModeOrRandom_1_ == p_selectModeOrRandom_2_ && p_selectModeOrRandom_1_ == p_selectModeOrRandom_3_ ? p_selectModeOrRandom_1_ : (p_selectModeOrRandom_1_ == p_selectModeOrRandom_2_ && p_selectModeOrRandom_1_ == p_selectModeOrRandom_4_ ? p_selectModeOrRandom_1_ : (p_selectModeOrRandom_1_ == p_selectModeOrRandom_3_ && p_selectModeOrRandom_1_ == p_selectModeOrRandom_4_ ? p_selectModeOrRandom_1_ : (p_selectModeOrRandom_1_ == p_selectModeOrRandom_2_ && p_selectModeOrRandom_3_ != p_selectModeOrRandom_4_ ? p_selectModeOrRandom_1_ : (p_selectModeOrRandom_1_ == p_selectModeOrRandom_3_ && p_selectModeOrRandom_2_ != p_selectModeOrRandom_4_ ? p_selectModeOrRandom_1_ : (p_selectModeOrRandom_1_ == p_selectModeOrRandom_4_ && p_selectModeOrRandom_2_ != p_selectModeOrRandom_3_ ? p_selectModeOrRandom_1_ : (p_selectModeOrRandom_2_ == p_selectModeOrRandom_3_ && p_selectModeOrRandom_1_ != p_selectModeOrRandom_4_ ? p_selectModeOrRandom_2_ : (p_selectModeOrRandom_2_ == p_selectModeOrRandom_4_ && p_selectModeOrRandom_1_ != p_selectModeOrRandom_3_ ? p_selectModeOrRandom_2_ : (p_selectModeOrRandom_3_ == p_selectModeOrRandom_4_ && p_selectModeOrRandom_1_ != p_selectModeOrRandom_2_ ? p_selectModeOrRandom_3_ : this.selectRandom(p_selectModeOrRandom_1_, p_selectModeOrRandom_2_, p_selectModeOrRandom_3_, p_selectModeOrRandom_4_))))))))));
    }

    protected long nextLong(long p_nextLong_1_) {
        long j = (this.chunkSeed >> 24) % p_nextLong_1_;
        if (j < 0L) {
            j += p_nextLong_1_;
        }
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += this.worldGenSeed;
        return j;
    }

    public static int getModdedBiomeSize(WorldType p_getModdedBiomeSize_0_, int p_getModdedBiomeSize_1_) {
        WorldTypeEvent.BiomeSize event = new WorldTypeEvent.BiomeSize(p_getModdedBiomeSize_0_, p_getModdedBiomeSize_1_);
        MinecraftForge.TERRAIN_GEN_BUS.post(event);
        return event.getNewSize();
    }
}

