/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.layer;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.init.Biomes;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkProviderSettings;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.BiomeManager;

public class GenLayerBiome
extends GenLayer {
    private List<BiomeManager.BiomeEntry>[] biomes = new ArrayList[BiomeManager.BiomeType.values().length];
    private final ChunkProviderSettings settings;

    public GenLayerBiome(long p_i45560_1_, GenLayer p_i45560_3_, WorldType p_i45560_4_, ChunkProviderSettings p_i45560_5_) {
        super(p_i45560_1_);
        this.parent = p_i45560_3_;
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            ImmutableList<BiomeManager.BiomeEntry> biomesToAdd = BiomeManager.getBiomes(type);
            int idx = type.ordinal();
            if (this.biomes[idx] == null) {
                this.biomes[idx] = new ArrayList<BiomeManager.BiomeEntry>();
            }
            if (biomesToAdd == null) continue;
            this.biomes[idx].addAll((Collection<BiomeManager.BiomeEntry>)biomesToAdd);
        }
        int desertIdx = BiomeManager.BiomeType.DESERT.ordinal();
        this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.DESERT, 30));
        this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.SAVANNA, 20));
        this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.PLAINS, 10));
        if (p_i45560_4_ == WorldType.DEFAULT_1_1) {
            this.biomes[desertIdx].clear();
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.DESERT, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.FOREST, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.EXTREME_HILLS, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.SWAMPLAND, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.PLAINS, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.TAIGA, 10));
            this.settings = null;
        } else {
            this.settings = p_i45560_5_;
        }
    }

    @Override
    public int[] getInts(int p_getInts_1_, int p_getInts_2_, int p_getInts_3_, int p_getInts_4_) {
        int[] aint = this.parent.getInts(p_getInts_1_, p_getInts_2_, p_getInts_3_, p_getInts_4_);
        int[] aint1 = IntCache.getIntCache(p_getInts_3_ * p_getInts_4_);
        for (int i = 0; i < p_getInts_4_; ++i) {
            for (int j = 0; j < p_getInts_3_; ++j) {
                this.initChunkSeed(j + p_getInts_1_, i + p_getInts_2_);
                int k = aint[j + i * p_getInts_3_];
                int l = (k & 0xF00) >> 8;
                k &= 0xFFFFF0FF;
                if (this.settings != null && this.settings.fixedBiome >= 0) {
                    aint1[j + i * p_getInts_3_] = this.settings.fixedBiome;
                    continue;
                }
                if (GenLayerBiome.isBiomeOceanic(k)) {
                    aint1[j + i * p_getInts_3_] = k;
                    continue;
                }
                if (k == Biome.getIdForBiome(Biomes.MUSHROOM_ISLAND)) {
                    aint1[j + i * p_getInts_3_] = k;
                    continue;
                }
                if (k == 1) {
                    if (l > 0) {
                        if (this.nextInt(3) == 0) {
                            aint1[j + i * p_getInts_3_] = Biome.getIdForBiome(Biomes.MESA_CLEAR_ROCK);
                            continue;
                        }
                        aint1[j + i * p_getInts_3_] = Biome.getIdForBiome(Biomes.MESA_ROCK);
                        continue;
                    }
                    aint1[j + i * p_getInts_3_] = Biome.getIdForBiome(this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT).biome);
                    continue;
                }
                if (k == 2) {
                    if (l > 0) {
                        aint1[j + i * p_getInts_3_] = Biome.getIdForBiome(Biomes.JUNGLE);
                        continue;
                    }
                    aint1[j + i * p_getInts_3_] = Biome.getIdForBiome(this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM).biome);
                    continue;
                }
                if (k == 3) {
                    if (l > 0) {
                        aint1[j + i * p_getInts_3_] = Biome.getIdForBiome(Biomes.REDWOOD_TAIGA);
                        continue;
                    }
                    aint1[j + i * p_getInts_3_] = Biome.getIdForBiome(this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL).biome);
                    continue;
                }
                aint1[j + i * p_getInts_3_] = k == 4 ? Biome.getIdForBiome(this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY).biome) : Biome.getIdForBiome(Biomes.MUSHROOM_ISLAND);
            }
        }
        return aint1;
    }

    protected BiomeManager.BiomeEntry getWeightedBiomeEntry(BiomeManager.BiomeType p_getWeightedBiomeEntry_1_) {
        List<BiomeManager.BiomeEntry> biomeList = this.biomes[p_getWeightedBiomeEntry_1_.ordinal()];
        int totalWeight = WeightedRandom.getTotalWeight(biomeList);
        int weight = BiomeManager.isTypeListModded(p_getWeightedBiomeEntry_1_) ? this.nextInt(totalWeight) : this.nextInt(totalWeight / 10) * 10;
        return WeightedRandom.getRandomItem(biomeList, weight);
    }
}

