/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.layer;

import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class GenLayerRiverMix
extends GenLayer {
    private final GenLayer biomePatternGeneratorChain;
    private final GenLayer riverPatternGeneratorChain;

    public GenLayerRiverMix(long p_i2129_1_, GenLayer p_i2129_3_, GenLayer p_i2129_4_) {
        super(p_i2129_1_);
        this.biomePatternGeneratorChain = p_i2129_3_;
        this.riverPatternGeneratorChain = p_i2129_4_;
    }

    @Override
    public void initWorldGenSeed(long p_initWorldGenSeed_1_) {
        this.biomePatternGeneratorChain.initWorldGenSeed(p_initWorldGenSeed_1_);
        this.riverPatternGeneratorChain.initWorldGenSeed(p_initWorldGenSeed_1_);
        super.initWorldGenSeed(p_initWorldGenSeed_1_);
    }

    @Override
    public int[] getInts(int p_getInts_1_, int p_getInts_2_, int p_getInts_3_, int p_getInts_4_) {
        int[] lvt_5_1_ = this.biomePatternGeneratorChain.getInts(p_getInts_1_, p_getInts_2_, p_getInts_3_, p_getInts_4_);
        int[] lvt_6_1_ = this.riverPatternGeneratorChain.getInts(p_getInts_1_, p_getInts_2_, p_getInts_3_, p_getInts_4_);
        int[] lvt_7_1_ = IntCache.getIntCache(p_getInts_3_ * p_getInts_4_);
        for (int lvt_8_1_ = 0; lvt_8_1_ < p_getInts_3_ * p_getInts_4_; ++lvt_8_1_) {
            if (lvt_5_1_[lvt_8_1_] == Biome.getIdForBiome(Biomes.OCEAN) || lvt_5_1_[lvt_8_1_] == Biome.getIdForBiome(Biomes.DEEP_OCEAN)) {
                lvt_7_1_[lvt_8_1_] = lvt_5_1_[lvt_8_1_];
                continue;
            }
            if (lvt_6_1_[lvt_8_1_] == Biome.getIdForBiome(Biomes.RIVER)) {
                if (lvt_5_1_[lvt_8_1_] == Biome.getIdForBiome(Biomes.ICE_PLAINS)) {
                    lvt_7_1_[lvt_8_1_] = Biome.getIdForBiome(Biomes.FROZEN_RIVER);
                    continue;
                }
                if (lvt_5_1_[lvt_8_1_] == Biome.getIdForBiome(Biomes.MUSHROOM_ISLAND) || lvt_5_1_[lvt_8_1_] == Biome.getIdForBiome(Biomes.MUSHROOM_ISLAND_SHORE)) {
                    lvt_7_1_[lvt_8_1_] = Biome.getIdForBiome(Biomes.MUSHROOM_ISLAND_SHORE);
                    continue;
                }
                lvt_7_1_[lvt_8_1_] = lvt_6_1_[lvt_8_1_] & 0xFF;
                continue;
            }
            lvt_7_1_[lvt_8_1_] = lvt_5_1_[lvt_8_1_];
        }
        return lvt_7_1_;
    }
}

