/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.layer;

import com.google.common.collect.Lists;
import java.util.List;

public class IntCache {
    private static int intCacheSize = 256;
    private static final List<int[]> freeSmallArrays = Lists.newArrayList();
    private static final List<int[]> inUseSmallArrays = Lists.newArrayList();
    private static final List<int[]> freeLargeArrays = Lists.newArrayList();
    private static final List<int[]> inUseLargeArrays = Lists.newArrayList();

    public static synchronized int[] getIntCache(int p_getIntCache_0_) {
        if (p_getIntCache_0_ <= 256) {
            if (freeSmallArrays.isEmpty()) {
                int[] lvt_1_1_ = new int[256];
                inUseSmallArrays.add(lvt_1_1_);
                return lvt_1_1_;
            }
            int[] lvt_1_2_ = freeSmallArrays.remove(freeSmallArrays.size() - 1);
            inUseSmallArrays.add(lvt_1_2_);
            return lvt_1_2_;
        }
        if (p_getIntCache_0_ > intCacheSize) {
            intCacheSize = p_getIntCache_0_;
            freeLargeArrays.clear();
            inUseLargeArrays.clear();
            int[] lvt_1_3_ = new int[intCacheSize];
            inUseLargeArrays.add(lvt_1_3_);
            return lvt_1_3_;
        }
        if (freeLargeArrays.isEmpty()) {
            int[] lvt_1_4_ = new int[intCacheSize];
            inUseLargeArrays.add(lvt_1_4_);
            return lvt_1_4_;
        }
        int[] lvt_1_5_ = freeLargeArrays.remove(freeLargeArrays.size() - 1);
        inUseLargeArrays.add(lvt_1_5_);
        return lvt_1_5_;
    }

    public static synchronized void resetIntCache() {
        if (!freeLargeArrays.isEmpty()) {
            freeLargeArrays.remove(freeLargeArrays.size() - 1);
        }
        if (!freeSmallArrays.isEmpty()) {
            freeSmallArrays.remove(freeSmallArrays.size() - 1);
        }
        freeLargeArrays.addAll(inUseLargeArrays);
        freeSmallArrays.addAll(inUseSmallArrays);
        inUseLargeArrays.clear();
        inUseSmallArrays.clear();
    }

    public static synchronized String getCacheSizes() {
        return "cache: " + freeLargeArrays.size() + ", tcache: " + freeSmallArrays.size() + ", allocated: " + inUseLargeArrays.size() + ", tallocated: " + inUseSmallArrays.size();
    }
}

