/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockTripWire;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.BlockVine;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class ComponentScatteredFeaturePieces {
    public static void registerScatteredFeaturePieces() {
        MapGenStructureIO.registerStructureComponent(DesertPyramid.class, "TeDP");
        MapGenStructureIO.registerStructureComponent(JunglePyramid.class, "TeJP");
        MapGenStructureIO.registerStructureComponent(SwampHut.class, "TeSH");
        MapGenStructureIO.registerStructureComponent(Igloo.class, "Iglu");
    }

    public static class Igloo
    extends Feature {
        private static final ResourceLocation IGLOO_TOP_ID = new ResourceLocation("igloo/igloo_top");
        private static final ResourceLocation IGLOO_MIDDLE_ID = new ResourceLocation("igloo/igloo_middle");
        private static final ResourceLocation IGLOO_BOTTOM_ID = new ResourceLocation("igloo/igloo_bottom");

        public Igloo() {
        }

        public Igloo(Random p_i47036_1_, int p_i47036_2_, int p_i47036_3_) {
            super(p_i47036_1_, p_i47036_2_, 64, p_i47036_3_, 7, 5, 8);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (!this.offsetToAverageGroundLevel(p_addComponentParts_1_, p_addComponentParts_3_, -1)) {
                return false;
            }
            StructureBoundingBox lvt_4_1_ = this.getBoundingBox();
            BlockPos lvt_5_1_ = new BlockPos(lvt_4_1_.minX, lvt_4_1_.minY, lvt_4_1_.minZ);
            Rotation[] lvt_6_1_ = Rotation.values();
            MinecraftServer lvt_7_1_ = p_addComponentParts_1_.getMinecraftServer();
            TemplateManager lvt_8_1_ = p_addComponentParts_1_.getSaveHandler().getStructureTemplateManager();
            PlacementSettings lvt_9_1_ = new PlacementSettings().setRotation(lvt_6_1_[p_addComponentParts_2_.nextInt(lvt_6_1_.length)]).setReplacedBlock(Blocks.STRUCTURE_VOID).setBoundingBox(lvt_4_1_);
            Template lvt_10_1_ = lvt_8_1_.getTemplate(lvt_7_1_, IGLOO_TOP_ID);
            lvt_10_1_.addBlocksToWorldChunk(p_addComponentParts_1_, lvt_5_1_, lvt_9_1_);
            if (p_addComponentParts_2_.nextDouble() < 0.5) {
                Template lvt_11_1_ = lvt_8_1_.getTemplate(lvt_7_1_, IGLOO_MIDDLE_ID);
                Template lvt_12_1_ = lvt_8_1_.getTemplate(lvt_7_1_, IGLOO_BOTTOM_ID);
                int lvt_13_1_ = p_addComponentParts_2_.nextInt(8) + 4;
                for (int lvt_14_1_ = 0; lvt_14_1_ < lvt_13_1_; ++lvt_14_1_) {
                    BlockPos lvt_15_1_ = lvt_10_1_.calculateConnectedPos(lvt_9_1_, new BlockPos(3, -1 - lvt_14_1_ * 3, 5), lvt_9_1_, new BlockPos(1, 2, 1));
                    lvt_11_1_.addBlocksToWorldChunk(p_addComponentParts_1_, lvt_5_1_.add(lvt_15_1_), lvt_9_1_);
                }
                BlockPos lvt_14_2_ = lvt_5_1_.add(lvt_10_1_.calculateConnectedPos(lvt_9_1_, new BlockPos(3, -1 - lvt_13_1_ * 3, 5), lvt_9_1_, new BlockPos(3, 5, 7)));
                lvt_12_1_.addBlocksToWorldChunk(p_addComponentParts_1_, lvt_14_2_, lvt_9_1_);
                Map<BlockPos, String> lvt_15_2_ = lvt_12_1_.getDataBlocks(lvt_14_2_, lvt_9_1_);
                for (Map.Entry<BlockPos, String> lvt_17_1_ : lvt_15_2_.entrySet()) {
                    if (!"chest".equals(lvt_17_1_.getValue())) continue;
                    BlockPos lvt_18_1_ = lvt_17_1_.getKey();
                    p_addComponentParts_1_.setBlockState(lvt_18_1_, Blocks.AIR.getDefaultState(), 3);
                    TileEntity lvt_19_1_ = p_addComponentParts_1_.getTileEntity(lvt_18_1_.down());
                    if (!(lvt_19_1_ instanceof TileEntityChest)) continue;
                    ((TileEntityChest)lvt_19_1_).setLootTable(LootTableList.CHESTS_IGLOO_CHEST, p_addComponentParts_2_.nextLong());
                }
            } else {
                BlockPos lvt_11_2_ = Template.transformedBlockPos(lvt_9_1_, new BlockPos(3, 0, 5));
                p_addComponentParts_1_.setBlockState(lvt_5_1_.add(lvt_11_2_), Blocks.SNOW.getDefaultState(), 3);
            }
            return true;
        }
    }

    public static class SwampHut
    extends Feature {
        private boolean hasWitch;

        public SwampHut() {
        }

        public SwampHut(Random p_i2066_1_, int p_i2066_2_, int p_i2066_3_) {
            super(p_i2066_1_, p_i2066_2_, 64, p_i2066_3_, 7, 7, 9);
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setBoolean("Witch", this.hasWitch);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.hasWitch = p_readStructureFromNBT_1_.getBoolean("Witch");
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            int lvt_10_1_;
            int lvt_9_2_;
            int lvt_8_2_;
            if (!this.offsetToAverageGroundLevel(p_addComponentParts_1_, p_addComponentParts_3_, 0)) {
                return false;
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 1, 5, 1, 7, Blocks.PLANKS.getStateFromMeta(BlockPlanks.EnumType.SPRUCE.getMetadata()), Blocks.PLANKS.getStateFromMeta(BlockPlanks.EnumType.SPRUCE.getMetadata()), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 4, 2, 5, 4, 7, Blocks.PLANKS.getStateFromMeta(BlockPlanks.EnumType.SPRUCE.getMetadata()), Blocks.PLANKS.getStateFromMeta(BlockPlanks.EnumType.SPRUCE.getMetadata()), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 1, 0, 4, 1, 0, Blocks.PLANKS.getStateFromMeta(BlockPlanks.EnumType.SPRUCE.getMetadata()), Blocks.PLANKS.getStateFromMeta(BlockPlanks.EnumType.SPRUCE.getMetadata()), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 2, 2, 3, 3, 2, Blocks.PLANKS.getStateFromMeta(BlockPlanks.EnumType.SPRUCE.getMetadata()), Blocks.PLANKS.getStateFromMeta(BlockPlanks.EnumType.SPRUCE.getMetadata()), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 3, 1, 3, 6, Blocks.PLANKS.getStateFromMeta(BlockPlanks.EnumType.SPRUCE.getMetadata()), Blocks.PLANKS.getStateFromMeta(BlockPlanks.EnumType.SPRUCE.getMetadata()), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 2, 3, 5, 3, 6, Blocks.PLANKS.getStateFromMeta(BlockPlanks.EnumType.SPRUCE.getMetadata()), Blocks.PLANKS.getStateFromMeta(BlockPlanks.EnumType.SPRUCE.getMetadata()), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 2, 7, 4, 3, 7, Blocks.PLANKS.getStateFromMeta(BlockPlanks.EnumType.SPRUCE.getMetadata()), Blocks.PLANKS.getStateFromMeta(BlockPlanks.EnumType.SPRUCE.getMetadata()), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, 2, 1, 3, 2, Blocks.LOG.getDefaultState(), Blocks.LOG.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 0, 2, 5, 3, 2, Blocks.LOG.getDefaultState(), Blocks.LOG.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, 7, 1, 3, 7, Blocks.LOG.getDefaultState(), Blocks.LOG.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 0, 7, 5, 3, 7, Blocks.LOG.getDefaultState(), Blocks.LOG.getDefaultState(), false);
            this.setBlockState(p_addComponentParts_1_, Blocks.OAK_FENCE.getDefaultState(), 2, 3, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.OAK_FENCE.getDefaultState(), 3, 3, 7, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 1, 3, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 5, 3, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 5, 3, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.FLOWER_POT.getDefaultState().withProperty(BlockFlowerPot.CONTENTS, BlockFlowerPot.EnumFlowerType.MUSHROOM_RED), 1, 3, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.CRAFTING_TABLE.getDefaultState(), 3, 2, 6, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.CAULDRON.getDefaultState(), 4, 2, 6, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.OAK_FENCE.getDefaultState(), 1, 2, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.OAK_FENCE.getDefaultState(), 5, 2, 1, p_addComponentParts_3_);
            IBlockState lvt_4_1_ = Blocks.SPRUCE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.NORTH);
            IBlockState lvt_5_1_ = Blocks.SPRUCE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.EAST);
            IBlockState lvt_6_1_ = Blocks.SPRUCE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.WEST);
            IBlockState lvt_7_1_ = Blocks.SPRUCE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.SOUTH);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 4, 1, 6, 4, 1, lvt_4_1_, lvt_4_1_, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 4, 2, 0, 4, 7, lvt_5_1_, lvt_5_1_, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 4, 2, 6, 4, 7, lvt_6_1_, lvt_6_1_, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 4, 8, 6, 4, 8, lvt_7_1_, lvt_7_1_, false);
            for (int lvt_8_1_ = 2; lvt_8_1_ <= 7; lvt_8_1_ += 5) {
                for (int lvt_9_1_ = 1; lvt_9_1_ <= 5; lvt_9_1_ += 4) {
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.LOG.getDefaultState(), lvt_9_1_, -1, lvt_8_1_, p_addComponentParts_3_);
                }
            }
            if (!this.hasWitch && p_addComponentParts_3_.isVecInside(new BlockPos(lvt_8_2_ = this.getXWithOffset(2, 5), lvt_9_2_ = this.getYWithOffset(2), lvt_10_1_ = this.getZWithOffset(2, 5)))) {
                this.hasWitch = true;
                EntityWitch lvt_11_1_ = new EntityWitch(p_addComponentParts_1_);
                lvt_11_1_.enablePersistence();
                lvt_11_1_.setLocationAndAngles((double)lvt_8_2_ + 0.5, lvt_9_2_, (double)lvt_10_1_ + 0.5, 0.0f, 0.0f);
                lvt_11_1_.onInitialSpawn(p_addComponentParts_1_.getDifficultyForLocation(new BlockPos(lvt_8_2_, lvt_9_2_, lvt_10_1_)), null);
                p_addComponentParts_1_.spawnEntity(lvt_11_1_);
            }
            return true;
        }
    }

    public static class JunglePyramid
    extends Feature {
        private boolean placedMainChest;
        private boolean placedHiddenChest;
        private boolean placedTrap1;
        private boolean placedTrap2;
        private static final Stones junglePyramidsRandomScatteredStones = new Stones();

        public JunglePyramid() {
        }

        public JunglePyramid(Random p_i2064_1_, int p_i2064_2_, int p_i2064_3_) {
            super(p_i2064_1_, p_i2064_2_, 64, p_i2064_3_, 12, 10, 15);
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setBoolean("placedMainChest", this.placedMainChest);
            p_writeStructureToNBT_1_.setBoolean("placedHiddenChest", this.placedHiddenChest);
            p_writeStructureToNBT_1_.setBoolean("placedTrap1", this.placedTrap1);
            p_writeStructureToNBT_1_.setBoolean("placedTrap2", this.placedTrap2);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.placedMainChest = p_readStructureFromNBT_1_.getBoolean("placedMainChest");
            this.placedHiddenChest = p_readStructureFromNBT_1_.getBoolean("placedHiddenChest");
            this.placedTrap1 = p_readStructureFromNBT_1_.getBoolean("placedTrap1");
            this.placedTrap2 = p_readStructureFromNBT_1_.getBoolean("placedTrap2");
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (!this.offsetToAverageGroundLevel(p_addComponentParts_1_, p_addComponentParts_3_, 0)) {
                return false;
            }
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, -4, 0, this.scatteredFeatureSizeX - 1, 0, this.scatteredFeatureSizeZ - 1, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 1, 2, 9, 2, 2, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 1, 12, 9, 2, 12, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 1, 3, 2, 2, 11, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 1, 3, 9, 2, 11, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 1, 10, 6, 1, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 13, 10, 6, 13, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 2, 1, 6, 12, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 10, 3, 2, 10, 6, 12, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 3, 2, 9, 3, 12, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 6, 2, 9, 6, 12, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 7, 3, 8, 7, 11, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 8, 4, 7, 8, 10, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithAir(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 3, 8, 2, 11);
            this.fillWithAir(p_addComponentParts_1_, p_addComponentParts_3_, 4, 3, 6, 7, 3, 9);
            this.fillWithAir(p_addComponentParts_1_, p_addComponentParts_3_, 2, 4, 2, 9, 5, 12);
            this.fillWithAir(p_addComponentParts_1_, p_addComponentParts_3_, 4, 6, 5, 7, 6, 9);
            this.fillWithAir(p_addComponentParts_1_, p_addComponentParts_3_, 5, 7, 6, 6, 7, 8);
            this.fillWithAir(p_addComponentParts_1_, p_addComponentParts_3_, 5, 1, 2, 6, 2, 2);
            this.fillWithAir(p_addComponentParts_1_, p_addComponentParts_3_, 5, 2, 12, 6, 2, 12);
            this.fillWithAir(p_addComponentParts_1_, p_addComponentParts_3_, 5, 5, 1, 6, 5, 1);
            this.fillWithAir(p_addComponentParts_1_, p_addComponentParts_3_, 5, 5, 13, 6, 5, 13);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 1, 5, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 10, 5, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 1, 5, 9, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 10, 5, 9, p_addComponentParts_3_);
            for (int lvt_4_1_ = 0; lvt_4_1_ <= 14; lvt_4_1_ += 14) {
                this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 4, lvt_4_1_, 2, 5, lvt_4_1_, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
                this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 4, lvt_4_1_, 4, 5, lvt_4_1_, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
                this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 4, lvt_4_1_, 7, 5, lvt_4_1_, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
                this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 4, lvt_4_1_, 9, 5, lvt_4_1_, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            }
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 6, 0, 6, 6, 0, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            for (int lvt_4_2_ = 0; lvt_4_2_ <= 11; lvt_4_2_ += 11) {
                for (int lvt_5_1_ = 2; lvt_5_1_ <= 12; lvt_5_1_ += 2) {
                    this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_4_2_, 4, lvt_5_1_, lvt_4_2_, 5, lvt_5_1_, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
                }
                this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_4_2_, 6, 5, lvt_4_2_, 6, 5, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
                this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_4_2_, 6, 9, lvt_4_2_, 6, 9, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            }
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 7, 2, 2, 9, 2, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 7, 2, 9, 9, 2, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 7, 12, 2, 9, 12, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 7, 12, 9, 9, 12, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 9, 4, 4, 9, 4, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 9, 4, 7, 9, 4, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 9, 10, 4, 9, 10, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 9, 10, 7, 9, 10, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 9, 7, 6, 9, 7, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            IBlockState lvt_4_3_ = Blocks.STONE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.EAST);
            IBlockState lvt_5_2_ = Blocks.STONE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.WEST);
            IBlockState lvt_6_1_ = Blocks.STONE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.SOUTH);
            IBlockState lvt_7_1_ = Blocks.STONE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.NORTH);
            this.setBlockState(p_addComponentParts_1_, lvt_7_1_, 5, 9, 6, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_7_1_, 6, 9, 6, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_6_1_, 5, 9, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_6_1_, 6, 9, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_7_1_, 4, 0, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_7_1_, 5, 0, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_7_1_, 6, 0, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_7_1_, 7, 0, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_7_1_, 4, 1, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_7_1_, 4, 2, 9, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_7_1_, 4, 3, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_7_1_, 7, 1, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_7_1_, 7, 2, 9, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_7_1_, 7, 3, 10, p_addComponentParts_3_);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 9, 4, 1, 9, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 1, 9, 7, 1, 9, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 10, 7, 2, 10, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 4, 5, 6, 4, 5, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.setBlockState(p_addComponentParts_1_, lvt_4_3_, 4, 4, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_5_2_, 7, 4, 5, p_addComponentParts_3_);
            for (int lvt_8_1_ = 0; lvt_8_1_ < 4; ++lvt_8_1_) {
                this.setBlockState(p_addComponentParts_1_, lvt_6_1_, 5, 0 - lvt_8_1_, 6 + lvt_8_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_6_1_, 6, 0 - lvt_8_1_, 6 + lvt_8_1_, p_addComponentParts_3_);
                this.fillWithAir(p_addComponentParts_1_, p_addComponentParts_3_, 5, 0 - lvt_8_1_, 7 + lvt_8_1_, 6, 0 - lvt_8_1_, 9 + lvt_8_1_);
            }
            this.fillWithAir(p_addComponentParts_1_, p_addComponentParts_3_, 1, -3, 12, 10, -1, 13);
            this.fillWithAir(p_addComponentParts_1_, p_addComponentParts_3_, 1, -3, 1, 3, -1, 13);
            this.fillWithAir(p_addComponentParts_1_, p_addComponentParts_3_, 1, -3, 1, 9, -1, 5);
            for (int lvt_8_2_ = 1; lvt_8_2_ <= 13; lvt_8_2_ += 2) {
                this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, -3, lvt_8_2_, 1, -2, lvt_8_2_, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            }
            for (int lvt_8_3_ = 2; lvt_8_3_ <= 12; lvt_8_3_ += 2) {
                this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, -1, lvt_8_3_, 3, -1, lvt_8_3_, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            }
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, -2, 1, 5, -2, 1, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, -2, 1, 9, -2, 1, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, -3, 1, 6, -3, 1, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, -1, 1, 6, -1, 1, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.setBlockState(p_addComponentParts_1_, Blocks.TRIPWIRE_HOOK.getDefaultState().withProperty(BlockTripWireHook.FACING, EnumFacing.EAST).withProperty(BlockTripWireHook.ATTACHED, true), 1, -3, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.TRIPWIRE_HOOK.getDefaultState().withProperty(BlockTripWireHook.FACING, EnumFacing.WEST).withProperty(BlockTripWireHook.ATTACHED, true), 4, -3, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.TRIPWIRE.getDefaultState().withProperty(BlockTripWire.ATTACHED, true), 2, -3, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.TRIPWIRE.getDefaultState().withProperty(BlockTripWire.ATTACHED, true), 3, -3, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.REDSTONE_WIRE.getDefaultState(), 5, -3, 7, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.REDSTONE_WIRE.getDefaultState(), 5, -3, 6, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.REDSTONE_WIRE.getDefaultState(), 5, -3, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.REDSTONE_WIRE.getDefaultState(), 5, -3, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.REDSTONE_WIRE.getDefaultState(), 5, -3, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.REDSTONE_WIRE.getDefaultState(), 5, -3, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.REDSTONE_WIRE.getDefaultState(), 5, -3, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.REDSTONE_WIRE.getDefaultState(), 4, -3, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.MOSSY_COBBLESTONE.getDefaultState(), 3, -3, 1, p_addComponentParts_3_);
            if (!this.placedTrap1) {
                this.placedTrap1 = this.createDispenser(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 3, -2, 1, EnumFacing.NORTH, LootTableList.CHESTS_JUNGLE_TEMPLE_DISPENSER);
            }
            this.setBlockState(p_addComponentParts_1_, Blocks.VINE.getDefaultState().withProperty(BlockVine.SOUTH, true), 3, -2, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.TRIPWIRE_HOOK.getDefaultState().withProperty(BlockTripWireHook.FACING, EnumFacing.NORTH).withProperty(BlockTripWireHook.ATTACHED, true), 7, -3, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.TRIPWIRE_HOOK.getDefaultState().withProperty(BlockTripWireHook.FACING, EnumFacing.SOUTH).withProperty(BlockTripWireHook.ATTACHED, true), 7, -3, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.TRIPWIRE.getDefaultState().withProperty(BlockTripWire.ATTACHED, true), 7, -3, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.TRIPWIRE.getDefaultState().withProperty(BlockTripWire.ATTACHED, true), 7, -3, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.TRIPWIRE.getDefaultState().withProperty(BlockTripWire.ATTACHED, true), 7, -3, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.REDSTONE_WIRE.getDefaultState(), 8, -3, 6, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.REDSTONE_WIRE.getDefaultState(), 9, -3, 6, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.REDSTONE_WIRE.getDefaultState(), 9, -3, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.MOSSY_COBBLESTONE.getDefaultState(), 9, -3, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.REDSTONE_WIRE.getDefaultState(), 9, -2, 4, p_addComponentParts_3_);
            if (!this.placedTrap2) {
                this.placedTrap2 = this.createDispenser(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 9, -2, 3, EnumFacing.WEST, LootTableList.CHESTS_JUNGLE_TEMPLE_DISPENSER);
            }
            this.setBlockState(p_addComponentParts_1_, Blocks.VINE.getDefaultState().withProperty(BlockVine.EAST, true), 8, -1, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.VINE.getDefaultState().withProperty(BlockVine.EAST, true), 8, -2, 3, p_addComponentParts_3_);
            if (!this.placedMainChest) {
                this.placedMainChest = this.generateChest(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 8, -3, 3, LootTableList.CHESTS_JUNGLE_TEMPLE);
            }
            this.setBlockState(p_addComponentParts_1_, Blocks.MOSSY_COBBLESTONE.getDefaultState(), 9, -3, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.MOSSY_COBBLESTONE.getDefaultState(), 8, -3, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.MOSSY_COBBLESTONE.getDefaultState(), 4, -3, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.MOSSY_COBBLESTONE.getDefaultState(), 5, -2, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.MOSSY_COBBLESTONE.getDefaultState(), 5, -1, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.MOSSY_COBBLESTONE.getDefaultState(), 6, -3, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.MOSSY_COBBLESTONE.getDefaultState(), 7, -2, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.MOSSY_COBBLESTONE.getDefaultState(), 7, -1, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.MOSSY_COBBLESTONE.getDefaultState(), 8, -3, 5, p_addComponentParts_3_);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, -1, 1, 9, -1, 5, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithAir(p_addComponentParts_1_, p_addComponentParts_3_, 8, -3, 8, 10, -1, 10);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getStateFromMeta(BlockStoneBrick.CHISELED_META), 8, -2, 11, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getStateFromMeta(BlockStoneBrick.CHISELED_META), 9, -2, 11, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getStateFromMeta(BlockStoneBrick.CHISELED_META), 10, -2, 11, p_addComponentParts_3_);
            IBlockState lvt_8_4_ = Blocks.LEVER.getDefaultState().withProperty(BlockLever.FACING, BlockLever.EnumOrientation.NORTH);
            this.setBlockState(p_addComponentParts_1_, lvt_8_4_, 8, -2, 12, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_8_4_, 9, -2, 12, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_8_4_, 10, -2, 12, p_addComponentParts_3_);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, -3, 8, 8, -3, 10, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 10, -3, 8, 10, -3, 10, false, p_addComponentParts_2_, junglePyramidsRandomScatteredStones);
            this.setBlockState(p_addComponentParts_1_, Blocks.MOSSY_COBBLESTONE.getDefaultState(), 10, -2, 9, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.REDSTONE_WIRE.getDefaultState(), 8, -2, 9, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.REDSTONE_WIRE.getDefaultState(), 8, -2, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.REDSTONE_WIRE.getDefaultState(), 10, -1, 9, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STICKY_PISTON.getDefaultState().withProperty(BlockPistonBase.FACING, EnumFacing.UP), 9, -2, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STICKY_PISTON.getDefaultState().withProperty(BlockPistonBase.FACING, EnumFacing.WEST), 10, -2, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STICKY_PISTON.getDefaultState().withProperty(BlockPistonBase.FACING, EnumFacing.WEST), 10, -1, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.UNPOWERED_REPEATER.getDefaultState().withProperty(BlockRedstoneRepeater.FACING, EnumFacing.NORTH), 10, -2, 10, p_addComponentParts_3_);
            if (!this.placedHiddenChest) {
                this.placedHiddenChest = this.generateChest(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 9, -3, 10, LootTableList.CHESTS_JUNGLE_TEMPLE);
            }
            return true;
        }

        static class Stones
        extends StructureComponent.BlockSelector {
            private Stones() {
            }

            @Override
            public void selectBlocks(Random p_selectBlocks_1_, int p_selectBlocks_2_, int p_selectBlocks_3_, int p_selectBlocks_4_, boolean p_selectBlocks_5_) {
                this.blockstate = p_selectBlocks_1_.nextFloat() < 0.4f ? Blocks.COBBLESTONE.getDefaultState() : Blocks.MOSSY_COBBLESTONE.getDefaultState();
            }
        }
    }

    public static class DesertPyramid
    extends Feature {
        private final boolean[] hasPlacedChest = new boolean[4];

        public DesertPyramid() {
        }

        public DesertPyramid(Random p_i2062_1_, int p_i2062_2_, int p_i2062_3_) {
            super(p_i2062_1_, p_i2062_2_, 64, p_i2062_3_, 21, 15, 21);
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setBoolean("hasPlacedChest0", this.hasPlacedChest[0]);
            p_writeStructureToNBT_1_.setBoolean("hasPlacedChest1", this.hasPlacedChest[1]);
            p_writeStructureToNBT_1_.setBoolean("hasPlacedChest2", this.hasPlacedChest[2]);
            p_writeStructureToNBT_1_.setBoolean("hasPlacedChest3", this.hasPlacedChest[3]);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.hasPlacedChest[0] = p_readStructureFromNBT_1_.getBoolean("hasPlacedChest0");
            this.hasPlacedChest[1] = p_readStructureFromNBT_1_.getBoolean("hasPlacedChest1");
            this.hasPlacedChest[2] = p_readStructureFromNBT_1_.getBoolean("hasPlacedChest2");
            this.hasPlacedChest[3] = p_readStructureFromNBT_1_.getBoolean("hasPlacedChest3");
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, -4, 0, this.scatteredFeatureSizeX - 1, 0, this.scatteredFeatureSizeZ - 1, Blocks.SANDSTONE.getDefaultState(), Blocks.SANDSTONE.getDefaultState(), false);
            for (int lvt_4_1_ = 1; lvt_4_1_ <= 9; ++lvt_4_1_) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_4_1_, lvt_4_1_, lvt_4_1_, this.scatteredFeatureSizeX - 1 - lvt_4_1_, lvt_4_1_, this.scatteredFeatureSizeZ - 1 - lvt_4_1_, Blocks.SANDSTONE.getDefaultState(), Blocks.SANDSTONE.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_4_1_ + 1, lvt_4_1_, lvt_4_1_ + 1, this.scatteredFeatureSizeX - 2 - lvt_4_1_, lvt_4_1_, this.scatteredFeatureSizeZ - 2 - lvt_4_1_, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            }
            for (int lvt_4_2_ = 0; lvt_4_2_ < this.scatteredFeatureSizeX; ++lvt_4_2_) {
                for (int lvt_5_1_ = 0; lvt_5_1_ < this.scatteredFeatureSizeZ; ++lvt_5_1_) {
                    int lvt_6_1_ = -5;
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.SANDSTONE.getDefaultState(), lvt_4_2_, -5, lvt_5_1_, p_addComponentParts_3_);
                }
            }
            IBlockState lvt_4_3_ = Blocks.SANDSTONE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.NORTH);
            IBlockState lvt_5_2_ = Blocks.SANDSTONE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.SOUTH);
            IBlockState lvt_6_2_ = Blocks.SANDSTONE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.EAST);
            IBlockState lvt_7_1_ = Blocks.SANDSTONE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.WEST);
            int lvt_8_1_ = ~EnumDyeColor.ORANGE.getDyeDamage() & 0xF;
            int lvt_9_1_ = ~EnumDyeColor.BLUE.getDyeDamage() & 0xF;
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 4, 9, 4, Blocks.SANDSTONE.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 10, 1, 3, 10, 3, Blocks.SANDSTONE.getDefaultState(), Blocks.SANDSTONE.getDefaultState(), false);
            this.setBlockState(p_addComponentParts_1_, lvt_4_3_, 2, 10, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_5_2_, 2, 10, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_6_2_, 0, 10, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_7_1_, 4, 10, 2, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, this.scatteredFeatureSizeX - 5, 0, 0, this.scatteredFeatureSizeX - 1, 9, 4, Blocks.SANDSTONE.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, this.scatteredFeatureSizeX - 4, 10, 1, this.scatteredFeatureSizeX - 2, 10, 3, Blocks.SANDSTONE.getDefaultState(), Blocks.SANDSTONE.getDefaultState(), false);
            this.setBlockState(p_addComponentParts_1_, lvt_4_3_, this.scatteredFeatureSizeX - 3, 10, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_5_2_, this.scatteredFeatureSizeX - 3, 10, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_6_2_, this.scatteredFeatureSizeX - 5, 10, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_7_1_, this.scatteredFeatureSizeX - 1, 10, 2, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 0, 0, 12, 4, 4, Blocks.SANDSTONE.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 1, 0, 11, 3, 4, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), 9, 1, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), 9, 2, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), 9, 3, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), 10, 3, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), 11, 3, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), 11, 2, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), 11, 1, 1, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 1, 8, 3, 3, Blocks.SANDSTONE.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 2, 8, 2, 2, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 12, 1, 1, 16, 3, 3, Blocks.SANDSTONE.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 12, 1, 2, 16, 2, 2, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 4, 5, this.scatteredFeatureSizeX - 6, 4, this.scatteredFeatureSizeZ - 6, Blocks.SANDSTONE.getDefaultState(), Blocks.SANDSTONE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 4, 9, 11, 4, 11, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 1, 8, 8, 3, 8, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 12, 1, 8, 12, 3, 8, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 1, 12, 8, 3, 12, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 12, 1, 12, 12, 3, 12, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 5, 4, 4, 11, Blocks.SANDSTONE.getDefaultState(), Blocks.SANDSTONE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, this.scatteredFeatureSizeX - 5, 1, 5, this.scatteredFeatureSizeX - 2, 4, 11, Blocks.SANDSTONE.getDefaultState(), Blocks.SANDSTONE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 7, 9, 6, 7, 11, Blocks.SANDSTONE.getDefaultState(), Blocks.SANDSTONE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, this.scatteredFeatureSizeX - 7, 7, 9, this.scatteredFeatureSizeX - 7, 7, 11, Blocks.SANDSTONE.getDefaultState(), Blocks.SANDSTONE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 5, 9, 5, 7, 11, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, this.scatteredFeatureSizeX - 6, 5, 9, this.scatteredFeatureSizeX - 6, 7, 11, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), false);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 5, 5, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 5, 6, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 6, 6, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), this.scatteredFeatureSizeX - 6, 5, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), this.scatteredFeatureSizeX - 6, 6, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), this.scatteredFeatureSizeX - 7, 6, 10, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 4, 4, 2, 6, 4, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, this.scatteredFeatureSizeX - 3, 4, 4, this.scatteredFeatureSizeX - 3, 6, 4, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.setBlockState(p_addComponentParts_1_, lvt_4_3_, 2, 4, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_4_3_, 2, 3, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_4_3_, this.scatteredFeatureSizeX - 3, 4, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_4_3_, this.scatteredFeatureSizeX - 3, 3, 4, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 3, 2, 2, 3, Blocks.SANDSTONE.getDefaultState(), Blocks.SANDSTONE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, this.scatteredFeatureSizeX - 3, 1, 3, this.scatteredFeatureSizeX - 2, 2, 3, Blocks.SANDSTONE.getDefaultState(), Blocks.SANDSTONE.getDefaultState(), false);
            this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getDefaultState(), 1, 1, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getDefaultState(), this.scatteredFeatureSizeX - 2, 1, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getStateFromMeta(BlockStoneSlab.EnumType.SAND.getMetadata()), 1, 2, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getStateFromMeta(BlockStoneSlab.EnumType.SAND.getMetadata()), this.scatteredFeatureSizeX - 2, 2, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_7_1_, 2, 1, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_6_2_, this.scatteredFeatureSizeX - 3, 1, 2, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 3, 5, 4, 3, 18, Blocks.SANDSTONE.getDefaultState(), Blocks.SANDSTONE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, this.scatteredFeatureSizeX - 5, 3, 5, this.scatteredFeatureSizeX - 5, 3, 17, Blocks.SANDSTONE.getDefaultState(), Blocks.SANDSTONE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 5, 4, 2, 16, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, this.scatteredFeatureSizeX - 6, 1, 5, this.scatteredFeatureSizeX - 5, 2, 16, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            for (int lvt_10_1_ = 5; lvt_10_1_ <= 17; lvt_10_1_ += 2) {
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), 4, 1, lvt_10_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.CHISELED.getMetadata()), 4, 2, lvt_10_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), this.scatteredFeatureSizeX - 5, 1, lvt_10_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.CHISELED.getMetadata()), this.scatteredFeatureSizeX - 5, 2, lvt_10_1_, p_addComponentParts_3_);
            }
            this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), 10, 0, 7, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), 10, 0, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), 9, 0, 9, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), 11, 0, 9, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), 8, 0, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), 12, 0, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), 7, 0, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), 13, 0, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), 9, 0, 11, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), 11, 0, 11, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), 10, 0, 12, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), 10, 0, 13, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_9_1_), 10, 0, 10, p_addComponentParts_3_);
            for (int lvt_10_2_ = 0; lvt_10_2_ <= this.scatteredFeatureSizeX - 1; lvt_10_2_ += this.scatteredFeatureSizeX - 1) {
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), lvt_10_2_, 2, 1, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), lvt_10_2_, 2, 2, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), lvt_10_2_, 2, 3, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), lvt_10_2_, 3, 1, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), lvt_10_2_, 3, 2, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), lvt_10_2_, 3, 3, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), lvt_10_2_, 4, 1, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.CHISELED.getMetadata()), lvt_10_2_, 4, 2, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), lvt_10_2_, 4, 3, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), lvt_10_2_, 5, 1, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), lvt_10_2_, 5, 2, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), lvt_10_2_, 5, 3, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), lvt_10_2_, 6, 1, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.CHISELED.getMetadata()), lvt_10_2_, 6, 2, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), lvt_10_2_, 6, 3, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), lvt_10_2_, 7, 1, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), lvt_10_2_, 7, 2, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), lvt_10_2_, 7, 3, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), lvt_10_2_, 8, 1, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), lvt_10_2_, 8, 2, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), lvt_10_2_, 8, 3, p_addComponentParts_3_);
            }
            for (int lvt_10_3_ = 2; lvt_10_3_ <= this.scatteredFeatureSizeX - 3; lvt_10_3_ += this.scatteredFeatureSizeX - 3 - 2) {
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), lvt_10_3_ - 1, 2, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), lvt_10_3_, 2, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), lvt_10_3_ + 1, 2, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), lvt_10_3_ - 1, 3, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), lvt_10_3_, 3, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), lvt_10_3_ + 1, 3, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), lvt_10_3_ - 1, 4, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.CHISELED.getMetadata()), lvt_10_3_, 4, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), lvt_10_3_ + 1, 4, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), lvt_10_3_ - 1, 5, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), lvt_10_3_, 5, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), lvt_10_3_ + 1, 5, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), lvt_10_3_ - 1, 6, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.CHISELED.getMetadata()), lvt_10_3_, 6, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), lvt_10_3_ + 1, 6, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), lvt_10_3_ - 1, 7, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), lvt_10_3_, 7, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), lvt_10_3_ + 1, 7, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), lvt_10_3_ - 1, 8, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), lvt_10_3_, 8, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), lvt_10_3_ + 1, 8, 0, p_addComponentParts_3_);
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 4, 0, 12, 6, 0, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), false);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 8, 6, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 12, 6, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), 9, 5, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.CHISELED.getMetadata()), 10, 5, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STAINED_HARDENED_CLAY.getStateFromMeta(lvt_8_1_), 11, 5, 0, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, -14, 8, 12, -11, 12, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, -10, 8, 12, -10, 12, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.CHISELED.getMetadata()), Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.CHISELED.getMetadata()), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, -9, 8, 12, -9, 12, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, -8, 8, 12, -1, 12, Blocks.SANDSTONE.getDefaultState(), Blocks.SANDSTONE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, -11, 9, 11, -1, 11, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONE_PRESSURE_PLATE.getDefaultState(), 10, -11, 10, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, -13, 9, 11, -13, 11, Blocks.TNT.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 8, -11, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 8, -10, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.CHISELED.getMetadata()), 7, -10, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), 7, -11, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 12, -11, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 12, -10, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.CHISELED.getMetadata()), 13, -10, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), 13, -11, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 10, -11, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 10, -10, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.CHISELED.getMetadata()), 10, -10, 7, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), 10, -11, 7, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 10, -11, 12, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 10, -10, 12, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.CHISELED.getMetadata()), 10, -10, 13, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata()), 10, -11, 13, p_addComponentParts_3_);
            for (EnumFacing lvt_11_1_ : EnumFacing.Plane.HORIZONTAL) {
                if (this.hasPlacedChest[lvt_11_1_.getHorizontalIndex()]) continue;
                int lvt_12_1_ = lvt_11_1_.getFrontOffsetX() * 2;
                int lvt_13_1_ = lvt_11_1_.getFrontOffsetZ() * 2;
                this.hasPlacedChest[lvt_11_1_.getHorizontalIndex()] = this.generateChest(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 10 + lvt_12_1_, -11, 10 + lvt_13_1_, LootTableList.CHESTS_DESERT_PYRAMID);
            }
            return true;
        }
    }

    static abstract class Feature
    extends StructureComponent {
        protected int scatteredFeatureSizeX;
        protected int scatteredFeatureSizeY;
        protected int scatteredFeatureSizeZ;
        protected int horizontalPos = -1;

        public Feature() {
        }

        protected Feature(Random p_i2065_1_, int p_i2065_2_, int p_i2065_3_, int p_i2065_4_, int p_i2065_5_, int p_i2065_6_, int p_i2065_7_) {
            super(0);
            this.scatteredFeatureSizeX = p_i2065_5_;
            this.scatteredFeatureSizeY = p_i2065_6_;
            this.scatteredFeatureSizeZ = p_i2065_7_;
            this.setCoordBaseMode(EnumFacing.Plane.HORIZONTAL.random(p_i2065_1_));
            this.boundingBox = this.getCoordBaseMode().getAxis() == EnumFacing.Axis.Z ? new StructureBoundingBox(p_i2065_2_, p_i2065_3_, p_i2065_4_, p_i2065_2_ + p_i2065_5_ - 1, p_i2065_3_ + p_i2065_6_ - 1, p_i2065_4_ + p_i2065_7_ - 1) : new StructureBoundingBox(p_i2065_2_, p_i2065_3_, p_i2065_4_, p_i2065_2_ + p_i2065_7_ - 1, p_i2065_3_ + p_i2065_6_ - 1, p_i2065_4_ + p_i2065_5_ - 1);
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            p_writeStructureToNBT_1_.setInteger("Width", this.scatteredFeatureSizeX);
            p_writeStructureToNBT_1_.setInteger("Height", this.scatteredFeatureSizeY);
            p_writeStructureToNBT_1_.setInteger("Depth", this.scatteredFeatureSizeZ);
            p_writeStructureToNBT_1_.setInteger("HPos", this.horizontalPos);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            this.scatteredFeatureSizeX = p_readStructureFromNBT_1_.getInteger("Width");
            this.scatteredFeatureSizeY = p_readStructureFromNBT_1_.getInteger("Height");
            this.scatteredFeatureSizeZ = p_readStructureFromNBT_1_.getInteger("Depth");
            this.horizontalPos = p_readStructureFromNBT_1_.getInteger("HPos");
        }

        protected boolean offsetToAverageGroundLevel(World p_offsetToAverageGroundLevel_1_, StructureBoundingBox p_offsetToAverageGroundLevel_2_, int p_offsetToAverageGroundLevel_3_) {
            if (this.horizontalPos >= 0) {
                return true;
            }
            int lvt_4_1_ = 0;
            int lvt_5_1_ = 0;
            BlockPos.MutableBlockPos lvt_6_1_ = new BlockPos.MutableBlockPos();
            for (int lvt_7_1_ = this.boundingBox.minZ; lvt_7_1_ <= this.boundingBox.maxZ; ++lvt_7_1_) {
                for (int lvt_8_1_ = this.boundingBox.minX; lvt_8_1_ <= this.boundingBox.maxX; ++lvt_8_1_) {
                    lvt_6_1_.setPos(lvt_8_1_, 64, lvt_7_1_);
                    if (!p_offsetToAverageGroundLevel_2_.isVecInside(lvt_6_1_)) continue;
                    lvt_4_1_ += Math.max(p_offsetToAverageGroundLevel_1_.getTopSolidOrLiquidBlock(lvt_6_1_).getY(), p_offsetToAverageGroundLevel_1_.provider.getAverageGroundLevel());
                    ++lvt_5_1_;
                }
            }
            if (lvt_5_1_ == 0) {
                return false;
            }
            this.horizontalPos = lvt_4_1_ / lvt_5_1_;
            this.boundingBox.offset(0, this.horizontalPos - this.boundingBox.minY + p_offsetToAverageGroundLevel_3_, 0);
            return true;
        }
    }
}

