/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkProviderEnd;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureEndCityPieces;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenEndCity
extends MapGenStructure {
    private final int citySpacing = 20;
    private final int minCitySeparation = 11;
    private final ChunkProviderEnd endProvider;

    public MapGenEndCity(ChunkProviderEnd p_i46665_1_) {
        this.endProvider = p_i46665_1_;
    }

    @Override
    public String getStructureName() {
        return "EndCity";
    }

    @Override
    protected boolean canSpawnStructureAtCoords(int p_canSpawnStructureAtCoords_1_, int p_canSpawnStructureAtCoords_2_) {
        int lvt_3_1_ = p_canSpawnStructureAtCoords_1_;
        int lvt_4_1_ = p_canSpawnStructureAtCoords_2_;
        if (p_canSpawnStructureAtCoords_1_ < 0) {
            p_canSpawnStructureAtCoords_1_ -= 19;
        }
        if (p_canSpawnStructureAtCoords_2_ < 0) {
            p_canSpawnStructureAtCoords_2_ -= 19;
        }
        int lvt_5_1_ = p_canSpawnStructureAtCoords_1_ / 20;
        int lvt_6_1_ = p_canSpawnStructureAtCoords_2_ / 20;
        Random lvt_7_1_ = this.world.setRandomSeed(lvt_5_1_, lvt_6_1_, 10387313);
        lvt_5_1_ *= 20;
        lvt_6_1_ *= 20;
        p_canSpawnStructureAtCoords_1_ = lvt_3_1_;
        p_canSpawnStructureAtCoords_2_ = lvt_4_1_;
        if (p_canSpawnStructureAtCoords_1_ == (lvt_5_1_ += (lvt_7_1_.nextInt(9) + lvt_7_1_.nextInt(9)) / 2) && p_canSpawnStructureAtCoords_2_ == (lvt_6_1_ += (lvt_7_1_.nextInt(9) + lvt_7_1_.nextInt(9)) / 2) && this.endProvider.isIslandChunk(p_canSpawnStructureAtCoords_1_, p_canSpawnStructureAtCoords_2_)) {
            int lvt_8_1_ = MapGenEndCity.getYPosForStructure(p_canSpawnStructureAtCoords_1_, p_canSpawnStructureAtCoords_2_, this.endProvider);
            return lvt_8_1_ >= 60;
        }
        return false;
    }

    @Override
    protected StructureStart getStructureStart(int p_getStructureStart_1_, int p_getStructureStart_2_) {
        return new Start(this.world, this.endProvider, this.rand, p_getStructureStart_1_, p_getStructureStart_2_);
    }

    @Override
    public BlockPos getClosestStrongholdPos(World p_getClosestStrongholdPos_1_, BlockPos p_getClosestStrongholdPos_2_, boolean p_getClosestStrongholdPos_3_) {
        this.world = p_getClosestStrongholdPos_1_;
        return MapGenEndCity.findNearestStructurePosBySpacing(p_getClosestStrongholdPos_1_, this, p_getClosestStrongholdPos_2_, 20, 11, 10387313, true, 100, p_getClosestStrongholdPos_3_);
    }

    private static int getYPosForStructure(int p_getYPosForStructure_0_, int p_getYPosForStructure_1_, ChunkProviderEnd p_getYPosForStructure_2_) {
        Random lvt_3_1_ = new Random(p_getYPosForStructure_0_ + p_getYPosForStructure_1_ * 10387313);
        Rotation lvt_4_1_ = Rotation.values()[lvt_3_1_.nextInt(Rotation.values().length)];
        ChunkPrimer lvt_5_1_ = new ChunkPrimer();
        p_getYPosForStructure_2_.setBlocksInChunk(p_getYPosForStructure_0_, p_getYPosForStructure_1_, lvt_5_1_);
        int lvt_6_1_ = 5;
        int lvt_7_1_ = 5;
        if (lvt_4_1_ == Rotation.CLOCKWISE_90) {
            lvt_6_1_ = -5;
        } else if (lvt_4_1_ == Rotation.CLOCKWISE_180) {
            lvt_6_1_ = -5;
            lvt_7_1_ = -5;
        } else if (lvt_4_1_ == Rotation.COUNTERCLOCKWISE_90) {
            lvt_7_1_ = -5;
        }
        int lvt_8_1_ = lvt_5_1_.findGroundBlockIdx(7, 7);
        int lvt_9_1_ = lvt_5_1_.findGroundBlockIdx(7, 7 + lvt_7_1_);
        int lvt_10_1_ = lvt_5_1_.findGroundBlockIdx(7 + lvt_6_1_, 7);
        int lvt_11_1_ = lvt_5_1_.findGroundBlockIdx(7 + lvt_6_1_, 7 + lvt_7_1_);
        int lvt_12_1_ = Math.min(Math.min(lvt_8_1_, lvt_9_1_), Math.min(lvt_10_1_, lvt_11_1_));
        return lvt_12_1_;
    }

    public static class Start
    extends StructureStart {
        private boolean isSizeable;

        public Start() {
        }

        public Start(World p_i46760_1_, ChunkProviderEnd p_i46760_2_, Random p_i46760_3_, int p_i46760_4_, int p_i46760_5_) {
            super(p_i46760_4_, p_i46760_5_);
            this.create(p_i46760_1_, p_i46760_2_, p_i46760_3_, p_i46760_4_, p_i46760_5_);
        }

        private void create(World p_create_1_, ChunkProviderEnd p_create_2_, Random p_create_3_, int p_create_4_, int p_create_5_) {
            Random lvt_6_1_ = new Random(p_create_4_ + p_create_5_ * 10387313);
            Rotation lvt_7_1_ = Rotation.values()[lvt_6_1_.nextInt(Rotation.values().length)];
            int lvt_8_1_ = MapGenEndCity.getYPosForStructure(p_create_4_, p_create_5_, p_create_2_);
            if (lvt_8_1_ < 60) {
                this.isSizeable = false;
                return;
            }
            BlockPos lvt_9_1_ = new BlockPos(p_create_4_ * 16 + 8, lvt_8_1_, p_create_5_ * 16 + 8);
            StructureEndCityPieces.startHouseTower(p_create_1_.getSaveHandler().getStructureTemplateManager(), lvt_9_1_, lvt_7_1_, this.components, p_create_3_);
            this.updateBoundingBox();
            this.isSizeable = true;
        }

        @Override
        public boolean isSizeableStructure() {
            return this.isSizeable;
        }
    }
}

