/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeMesa;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureMineshaftStart;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenMineshaft
extends MapGenStructure {
    private double chance = 0.004;

    public MapGenMineshaft() {
    }

    @Override
    public String getStructureName() {
        return "Mineshaft";
    }

    public MapGenMineshaft(Map<String, String> p_i2034_1_) {
        for (Map.Entry<String, String> lvt_3_1_ : p_i2034_1_.entrySet()) {
            if (!lvt_3_1_.getKey().equals("chance")) continue;
            this.chance = MathHelper.getDouble(lvt_3_1_.getValue(), this.chance);
        }
    }

    @Override
    protected boolean canSpawnStructureAtCoords(int p_canSpawnStructureAtCoords_1_, int p_canSpawnStructureAtCoords_2_) {
        return this.rand.nextDouble() < this.chance && this.rand.nextInt(80) < Math.max(Math.abs(p_canSpawnStructureAtCoords_1_), Math.abs(p_canSpawnStructureAtCoords_2_));
    }

    @Override
    public BlockPos getClosestStrongholdPos(World p_getClosestStrongholdPos_1_, BlockPos p_getClosestStrongholdPos_2_, boolean p_getClosestStrongholdPos_3_) {
        int lvt_4_1_ = 1000;
        int lvt_5_1_ = p_getClosestStrongholdPos_2_.getX() >> 4;
        int lvt_6_1_ = p_getClosestStrongholdPos_2_.getZ() >> 4;
        for (int lvt_7_1_ = 0; lvt_7_1_ <= 1000; ++lvt_7_1_) {
            for (int lvt_8_1_ = -lvt_7_1_; lvt_8_1_ <= lvt_7_1_; ++lvt_8_1_) {
                boolean lvt_9_1_ = lvt_8_1_ == -lvt_7_1_ || lvt_8_1_ == lvt_7_1_;
                for (int lvt_10_1_ = -lvt_7_1_; lvt_10_1_ <= lvt_7_1_; ++lvt_10_1_) {
                    boolean lvt_11_1_;
                    boolean bl = lvt_11_1_ = lvt_10_1_ == -lvt_7_1_ || lvt_10_1_ == lvt_7_1_;
                    if (!lvt_9_1_ && !lvt_11_1_) continue;
                    int lvt_12_1_ = lvt_5_1_ + lvt_8_1_;
                    int lvt_13_1_ = lvt_6_1_ + lvt_10_1_;
                    this.rand.setSeed((long)(lvt_12_1_ ^ lvt_13_1_) ^ p_getClosestStrongholdPos_1_.getSeed());
                    this.rand.nextInt();
                    if (!this.canSpawnStructureAtCoords(lvt_12_1_, lvt_13_1_) || p_getClosestStrongholdPos_3_ && p_getClosestStrongholdPos_1_.isChunkGeneratedAt(lvt_12_1_, lvt_13_1_)) continue;
                    return new BlockPos((lvt_12_1_ << 4) + 8, 64, (lvt_13_1_ << 4) + 8);
                }
            }
        }
        return null;
    }

    @Override
    protected StructureStart getStructureStart(int p_getStructureStart_1_, int p_getStructureStart_2_) {
        Biome lvt_3_1_ = this.world.getBiome(new BlockPos((p_getStructureStart_1_ << 4) + 8, 64, (p_getStructureStart_2_ << 4) + 8));
        Type lvt_4_1_ = lvt_3_1_ instanceof BiomeMesa ? Type.MESA : Type.NORMAL;
        return new StructureMineshaftStart(this.world, this.rand, p_getStructureStart_1_, p_getStructureStart_2_, lvt_4_1_);
    }

    public static enum Type {
        NORMAL,
        MESA;


        public static Type byId(int p_byId_0_) {
            if (p_byId_0_ < 0 || p_byId_0_ >= Type.values().length) {
                return NORMAL;
            }
            return Type.values()[p_byId_0_];
        }
    }
}

