/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureNetherBridgePieces;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenNetherBridge
extends MapGenStructure {
    private final List<Biome.SpawnListEntry> spawnList = Lists.newArrayList();

    public MapGenNetherBridge() {
        this.spawnList.add(new Biome.SpawnListEntry(EntityBlaze.class, 10, 2, 3));
        this.spawnList.add(new Biome.SpawnListEntry(EntityPigZombie.class, 5, 4, 4));
        this.spawnList.add(new Biome.SpawnListEntry(EntityWitherSkeleton.class, 8, 5, 5));
        this.spawnList.add(new Biome.SpawnListEntry(EntitySkeleton.class, 2, 5, 5));
        this.spawnList.add(new Biome.SpawnListEntry(EntityMagmaCube.class, 3, 4, 4));
    }

    @Override
    public String getStructureName() {
        return "Fortress";
    }

    public List<Biome.SpawnListEntry> getSpawnList() {
        return this.spawnList;
    }

    @Override
    protected boolean canSpawnStructureAtCoords(int p_canSpawnStructureAtCoords_1_, int p_canSpawnStructureAtCoords_2_) {
        int lvt_3_1_ = p_canSpawnStructureAtCoords_1_ >> 4;
        int lvt_4_1_ = p_canSpawnStructureAtCoords_2_ >> 4;
        this.rand.setSeed((long)(lvt_3_1_ ^ lvt_4_1_ << 4) ^ this.world.getSeed());
        this.rand.nextInt();
        if (this.rand.nextInt(3) != 0) {
            return false;
        }
        if (p_canSpawnStructureAtCoords_1_ != (lvt_3_1_ << 4) + 4 + this.rand.nextInt(8)) {
            return false;
        }
        return p_canSpawnStructureAtCoords_2_ == (lvt_4_1_ << 4) + 4 + this.rand.nextInt(8);
    }

    @Override
    protected StructureStart getStructureStart(int p_getStructureStart_1_, int p_getStructureStart_2_) {
        return new Start(this.world, this.rand, p_getStructureStart_1_, p_getStructureStart_2_);
    }

    @Override
    public BlockPos getClosestStrongholdPos(World p_getClosestStrongholdPos_1_, BlockPos p_getClosestStrongholdPos_2_, boolean p_getClosestStrongholdPos_3_) {
        int lvt_4_1_ = 1000;
        int lvt_5_1_ = p_getClosestStrongholdPos_2_.getX() >> 4;
        int lvt_6_1_ = p_getClosestStrongholdPos_2_.getZ() >> 4;
        for (int lvt_7_1_ = 0; lvt_7_1_ <= 1000; ++lvt_7_1_) {
            for (int lvt_8_1_ = -lvt_7_1_; lvt_8_1_ <= lvt_7_1_; ++lvt_8_1_) {
                boolean lvt_9_1_ = lvt_8_1_ == -lvt_7_1_ || lvt_8_1_ == lvt_7_1_;
                for (int lvt_10_1_ = -lvt_7_1_; lvt_10_1_ <= lvt_7_1_; ++lvt_10_1_) {
                    int lvt_13_1_;
                    int lvt_12_1_;
                    boolean lvt_11_1_;
                    boolean bl = lvt_11_1_ = lvt_10_1_ == -lvt_7_1_ || lvt_10_1_ == lvt_7_1_;
                    if (!lvt_9_1_ && !lvt_11_1_ || !this.canSpawnStructureAtCoords(lvt_12_1_ = lvt_5_1_ + lvt_8_1_, lvt_13_1_ = lvt_6_1_ + lvt_10_1_) || p_getClosestStrongholdPos_3_ && p_getClosestStrongholdPos_1_.isChunkGeneratedAt(lvt_12_1_, lvt_13_1_)) continue;
                    return new BlockPos((lvt_12_1_ << 4) + 8, 64, (lvt_13_1_ << 4) + 8);
                }
            }
        }
        return null;
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(World p_i2040_1_, Random p_i2040_2_, int p_i2040_3_, int p_i2040_4_) {
            super(p_i2040_3_, p_i2040_4_);
            StructureNetherBridgePieces.Start lvt_5_1_ = new StructureNetherBridgePieces.Start(p_i2040_2_, (p_i2040_3_ << 4) + 2, (p_i2040_4_ << 4) + 2);
            this.components.add(lvt_5_1_);
            lvt_5_1_.buildComponent(lvt_5_1_, this.components, p_i2040_2_);
            List<StructureComponent> lvt_6_1_ = lvt_5_1_.pendingChildren;
            while (!lvt_6_1_.isEmpty()) {
                int lvt_7_1_ = p_i2040_2_.nextInt(lvt_6_1_.size());
                StructureComponent lvt_8_1_ = lvt_6_1_.remove(lvt_7_1_);
                lvt_8_1_.buildComponent(lvt_5_1_, this.components, p_i2040_2_);
            }
            this.updateBoundingBox();
            this.setRandomHeight(p_i2040_1_, p_i2040_2_, 48, 70);
        }
    }
}

