/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenScatteredFeature
extends MapGenStructure {
    private static final List<Biome> BIOMELIST = Arrays.asList(Biomes.DESERT, Biomes.DESERT_HILLS, Biomes.JUNGLE, Biomes.JUNGLE_HILLS, Biomes.SWAMPLAND, Biomes.ICE_PLAINS, Biomes.COLD_TAIGA);
    private final List<Biome.SpawnListEntry> scatteredFeatureSpawnList = Lists.newArrayList();
    private int maxDistanceBetweenScatteredFeatures = 32;
    private final int minDistanceBetweenScatteredFeatures = 8;

    public MapGenScatteredFeature() {
        this.scatteredFeatureSpawnList.add(new Biome.SpawnListEntry(EntityWitch.class, 1, 1, 1));
    }

    public MapGenScatteredFeature(Map<String, String> p_i2061_1_) {
        this();
        for (Map.Entry<String, String> lvt_3_1_ : p_i2061_1_.entrySet()) {
            if (!lvt_3_1_.getKey().equals("distance")) continue;
            this.maxDistanceBetweenScatteredFeatures = MathHelper.getInt(lvt_3_1_.getValue(), this.maxDistanceBetweenScatteredFeatures, 9);
        }
    }

    @Override
    public String getStructureName() {
        return "Temple";
    }

    @Override
    protected boolean canSpawnStructureAtCoords(int p_canSpawnStructureAtCoords_1_, int p_canSpawnStructureAtCoords_2_) {
        int lvt_3_1_ = p_canSpawnStructureAtCoords_1_;
        int lvt_4_1_ = p_canSpawnStructureAtCoords_2_;
        if (p_canSpawnStructureAtCoords_1_ < 0) {
            p_canSpawnStructureAtCoords_1_ -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        if (p_canSpawnStructureAtCoords_2_ < 0) {
            p_canSpawnStructureAtCoords_2_ -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        int lvt_5_1_ = p_canSpawnStructureAtCoords_1_ / this.maxDistanceBetweenScatteredFeatures;
        int lvt_6_1_ = p_canSpawnStructureAtCoords_2_ / this.maxDistanceBetweenScatteredFeatures;
        Random lvt_7_1_ = this.world.setRandomSeed(lvt_5_1_, lvt_6_1_, 14357617);
        lvt_5_1_ *= this.maxDistanceBetweenScatteredFeatures;
        lvt_6_1_ *= this.maxDistanceBetweenScatteredFeatures;
        p_canSpawnStructureAtCoords_1_ = lvt_3_1_;
        p_canSpawnStructureAtCoords_2_ = lvt_4_1_;
        if (p_canSpawnStructureAtCoords_1_ == (lvt_5_1_ += lvt_7_1_.nextInt(this.maxDistanceBetweenScatteredFeatures - 8)) && p_canSpawnStructureAtCoords_2_ == (lvt_6_1_ += lvt_7_1_.nextInt(this.maxDistanceBetweenScatteredFeatures - 8))) {
            Biome lvt_8_1_ = this.world.getBiomeProvider().getBiome(new BlockPos(p_canSpawnStructureAtCoords_1_ * 16 + 8, 0, p_canSpawnStructureAtCoords_2_ * 16 + 8));
            if (lvt_8_1_ == null) {
                return false;
            }
            for (Biome lvt_10_1_ : BIOMELIST) {
                if (lvt_8_1_ != lvt_10_1_) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public BlockPos getClosestStrongholdPos(World p_getClosestStrongholdPos_1_, BlockPos p_getClosestStrongholdPos_2_, boolean p_getClosestStrongholdPos_3_) {
        this.world = p_getClosestStrongholdPos_1_;
        return MapGenScatteredFeature.findNearestStructurePosBySpacing(p_getClosestStrongholdPos_1_, this, p_getClosestStrongholdPos_2_, this.maxDistanceBetweenScatteredFeatures, 8, 14357617, false, 100, p_getClosestStrongholdPos_3_);
    }

    @Override
    protected StructureStart getStructureStart(int p_getStructureStart_1_, int p_getStructureStart_2_) {
        return new Start(this.world, this.rand, p_getStructureStart_1_, p_getStructureStart_2_);
    }

    public boolean isSwampHut(BlockPos p_isSwampHut_1_) {
        StructureStart lvt_2_1_ = this.getStructureAt(p_isSwampHut_1_);
        if (lvt_2_1_ == null || !(lvt_2_1_ instanceof Start) || lvt_2_1_.components.isEmpty()) {
            return false;
        }
        StructureComponent lvt_3_1_ = lvt_2_1_.components.get(0);
        return lvt_3_1_ instanceof ComponentScatteredFeaturePieces.SwampHut;
    }

    public List<Biome.SpawnListEntry> getScatteredFeatureSpawnList() {
        return this.scatteredFeatureSpawnList;
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(World p_i2060_1_, Random p_i2060_2_, int p_i2060_3_, int p_i2060_4_) {
            this(p_i2060_1_, p_i2060_2_, p_i2060_3_, p_i2060_4_, p_i2060_1_.getBiome(new BlockPos(p_i2060_3_ * 16 + 8, 0, p_i2060_4_ * 16 + 8)));
        }

        public Start(World p_i47072_1_, Random p_i47072_2_, int p_i47072_3_, int p_i47072_4_, Biome p_i47072_5_) {
            super(p_i47072_3_, p_i47072_4_);
            if (p_i47072_5_ == Biomes.JUNGLE || p_i47072_5_ == Biomes.JUNGLE_HILLS) {
                ComponentScatteredFeaturePieces.JunglePyramid lvt_6_1_ = new ComponentScatteredFeaturePieces.JunglePyramid(p_i47072_2_, p_i47072_3_ * 16, p_i47072_4_ * 16);
                this.components.add(lvt_6_1_);
            } else if (p_i47072_5_ == Biomes.SWAMPLAND) {
                ComponentScatteredFeaturePieces.SwampHut lvt_6_2_ = new ComponentScatteredFeaturePieces.SwampHut(p_i47072_2_, p_i47072_3_ * 16, p_i47072_4_ * 16);
                this.components.add(lvt_6_2_);
            } else if (p_i47072_5_ == Biomes.DESERT || p_i47072_5_ == Biomes.DESERT_HILLS) {
                ComponentScatteredFeaturePieces.DesertPyramid lvt_6_3_ = new ComponentScatteredFeaturePieces.DesertPyramid(p_i47072_2_, p_i47072_3_ * 16, p_i47072_4_ * 16);
                this.components.add(lvt_6_3_);
            } else if (p_i47072_5_ == Biomes.ICE_PLAINS || p_i47072_5_ == Biomes.COLD_TAIGA) {
                ComponentScatteredFeaturePieces.Igloo lvt_6_4_ = new ComponentScatteredFeaturePieces.Igloo(p_i47072_2_, p_i47072_3_ * 16, p_i47072_4_ * 16);
                this.components.add(lvt_6_4_);
            }
            this.updateBoundingBox();
        }
    }
}

