/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public abstract class MapGenStructure
extends MapGenBase {
    private MapGenStructureData structureData;
    protected Long2ObjectMap<StructureStart> structureMap = new Long2ObjectOpenHashMap(1024);

    public abstract String getStructureName();

    @Override
    protected final synchronized void recursiveGenerate(World p_recursiveGenerate_1_, final int p_recursiveGenerate_2_, final int p_recursiveGenerate_3_, int p_recursiveGenerate_4_, int p_recursiveGenerate_5_, ChunkPrimer p_recursiveGenerate_6_) {
        this.initializeStructureData(p_recursiveGenerate_1_);
        if (!this.structureMap.containsKey(ChunkPos.asLong(p_recursiveGenerate_2_, p_recursiveGenerate_3_))) {
            this.rand.nextInt();
            try {
                if (this.canSpawnStructureAtCoords(p_recursiveGenerate_2_, p_recursiveGenerate_3_)) {
                    StructureStart structurestart = this.getStructureStart(p_recursiveGenerate_2_, p_recursiveGenerate_3_);
                    this.structureMap.put(ChunkPos.asLong(p_recursiveGenerate_2_, p_recursiveGenerate_3_), (Object)structurestart);
                    if (structurestart.isSizeableStructure()) {
                        this.setStructureStart(p_recursiveGenerate_2_, p_recursiveGenerate_3_, structurestart);
                    }
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Exception preparing structure feature");
                CrashReportCategory crashreportcategory = crashreport.makeCategory("Feature being prepared");
                crashreportcategory.setDetail("Is feature chunk", new ICrashReportDetail<String>(){

                    @Override
                    public String call() throws Exception {
                        return MapGenStructure.this.canSpawnStructureAtCoords(p_recursiveGenerate_2_, p_recursiveGenerate_3_) ? "True" : "False";
                    }
                });
                crashreportcategory.addCrashSection("Chunk location", String.format("%d,%d", p_recursiveGenerate_2_, p_recursiveGenerate_3_));
                crashreportcategory.setDetail("Chunk pos hash", new ICrashReportDetail<String>(){

                    @Override
                    public String call() throws Exception {
                        return String.valueOf(ChunkPos.asLong(p_recursiveGenerate_2_, p_recursiveGenerate_3_));
                    }
                });
                crashreportcategory.setDetail("Structure type", new ICrashReportDetail<String>(){

                    @Override
                    public String call() throws Exception {
                        return MapGenStructure.this.getClass().getCanonicalName();
                    }
                });
                throw new ReportedException(crashreport);
            }
        }
    }

    public synchronized boolean generateStructure(World p_generateStructure_1_, Random p_generateStructure_2_, ChunkPos p_generateStructure_3_) {
        this.initializeStructureData(p_generateStructure_1_);
        int i = (p_generateStructure_3_.chunkXPos << 4) + 8;
        int j = (p_generateStructure_3_.chunkZPos << 4) + 8;
        boolean flag = false;
        for (StructureStart structurestart : this.structureMap.values()) {
            if (!structurestart.isSizeableStructure() || !structurestart.isValidForPostProcess(p_generateStructure_3_) || !structurestart.getBoundingBox().intersectsWith(i, j, i + 15, j + 15)) continue;
            structurestart.generateStructure(p_generateStructure_1_, p_generateStructure_2_, new StructureBoundingBox(i, j, i + 15, j + 15));
            structurestart.notifyPostProcessAt(p_generateStructure_3_);
            flag = true;
            this.setStructureStart(structurestart.getChunkPosX(), structurestart.getChunkPosZ(), structurestart);
        }
        return flag;
    }

    public boolean isInsideStructure(BlockPos p_isInsideStructure_1_) {
        this.initializeStructureData(this.world);
        return this.getStructureAt(p_isInsideStructure_1_) != null;
    }

    @Nullable
    protected StructureStart getStructureAt(BlockPos p_getStructureAt_1_) {
        for (StructureStart structurestart : this.structureMap.values()) {
            if (!structurestart.isSizeableStructure() || !structurestart.getBoundingBox().isVecInside(p_getStructureAt_1_)) continue;
            for (StructureComponent structurecomponent : structurestart.getComponents()) {
                if (!structurecomponent.getBoundingBox().isVecInside(p_getStructureAt_1_)) continue;
                return structurestart;
            }
        }
        return null;
    }

    public boolean isPositionInStructure(World p_isPositionInStructure_1_, BlockPos p_isPositionInStructure_2_) {
        this.initializeStructureData(p_isPositionInStructure_1_);
        for (StructureStart structurestart : this.structureMap.values()) {
            if (!structurestart.isSizeableStructure() || !structurestart.getBoundingBox().isVecInside(p_isPositionInStructure_2_)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public abstract BlockPos getClosestStrongholdPos(World var1, BlockPos var2, boolean var3);

    protected void initializeStructureData(World p_initializeStructureData_1_) {
        if (this.structureData == null) {
            this.structureData = (MapGenStructureData)p_initializeStructureData_1_.getPerWorldStorage().getOrLoadData(MapGenStructureData.class, this.getStructureName());
            if (this.structureData == null) {
                this.structureData = new MapGenStructureData(this.getStructureName());
                p_initializeStructureData_1_.getPerWorldStorage().setData(this.getStructureName(), this.structureData);
            } else {
                NBTTagCompound nbttagcompound = this.structureData.getTagCompound();
                for (String s : nbttagcompound.getKeySet()) {
                    NBTTagCompound nbttagcompound1;
                    NBTBase nbtbase = nbttagcompound.getTag(s);
                    if (nbtbase.getId() != 10 || !(nbttagcompound1 = (NBTTagCompound)nbtbase).hasKey("ChunkX") || !nbttagcompound1.hasKey("ChunkZ")) continue;
                    int i = nbttagcompound1.getInteger("ChunkX");
                    int j = nbttagcompound1.getInteger("ChunkZ");
                    StructureStart structurestart = MapGenStructureIO.getStructureStart(nbttagcompound1, p_initializeStructureData_1_);
                    if (structurestart == null) continue;
                    this.structureMap.put(ChunkPos.asLong(i, j), (Object)structurestart);
                }
            }
        }
    }

    private void setStructureStart(int p_setStructureStart_1_, int p_setStructureStart_2_, StructureStart p_setStructureStart_3_) {
        this.structureData.writeInstance(p_setStructureStart_3_.writeStructureComponentsToNBT(p_setStructureStart_1_, p_setStructureStart_2_), p_setStructureStart_1_, p_setStructureStart_2_);
        this.structureData.markDirty();
    }

    protected abstract boolean canSpawnStructureAtCoords(int var1, int var2);

    protected abstract StructureStart getStructureStart(int var1, int var2);

    protected static BlockPos findNearestStructurePosBySpacing(World p_findNearestStructurePosBySpacing_0_, MapGenStructure p_findNearestStructurePosBySpacing_1_, BlockPos p_findNearestStructurePosBySpacing_2_, int p_findNearestStructurePosBySpacing_3_, int p_findNearestStructurePosBySpacing_4_, int p_findNearestStructurePosBySpacing_5_, boolean p_findNearestStructurePosBySpacing_6_, int p_findNearestStructurePosBySpacing_7_, boolean p_findNearestStructurePosBySpacing_8_) {
        int i = p_findNearestStructurePosBySpacing_2_.getX() >> 4;
        int j = p_findNearestStructurePosBySpacing_2_.getZ() >> 4;
        Random random = new Random();
        block0: for (int k = 0; k <= p_findNearestStructurePosBySpacing_7_; ++k) {
            for (int l = -k; l <= k; ++l) {
                boolean flag = l == -k || l == k;
                for (int i1 = -k; i1 <= k; ++i1) {
                    boolean flag1;
                    boolean bl = flag1 = i1 == -k || i1 == k;
                    if (!flag && !flag1) continue;
                    int j1 = i + p_findNearestStructurePosBySpacing_3_ * l;
                    int k1 = j + p_findNearestStructurePosBySpacing_3_ * i1;
                    if (j1 < 0) {
                        j1 -= p_findNearestStructurePosBySpacing_3_ - 1;
                    }
                    if (k1 < 0) {
                        k1 -= p_findNearestStructurePosBySpacing_3_ - 1;
                    }
                    int l1 = j1 / p_findNearestStructurePosBySpacing_3_;
                    int i2 = k1 / p_findNearestStructurePosBySpacing_3_;
                    Random random1 = p_findNearestStructurePosBySpacing_0_.setRandomSeed(l1, i2, p_findNearestStructurePosBySpacing_5_);
                    l1 *= p_findNearestStructurePosBySpacing_3_;
                    i2 *= p_findNearestStructurePosBySpacing_3_;
                    if (p_findNearestStructurePosBySpacing_6_) {
                        l1 += (random1.nextInt(p_findNearestStructurePosBySpacing_3_ - p_findNearestStructurePosBySpacing_4_) + random1.nextInt(p_findNearestStructurePosBySpacing_3_ - p_findNearestStructurePosBySpacing_4_)) / 2;
                        i2 += (random1.nextInt(p_findNearestStructurePosBySpacing_3_ - p_findNearestStructurePosBySpacing_4_) + random1.nextInt(p_findNearestStructurePosBySpacing_3_ - p_findNearestStructurePosBySpacing_4_)) / 2;
                    } else {
                        l1 += random1.nextInt(p_findNearestStructurePosBySpacing_3_ - p_findNearestStructurePosBySpacing_4_);
                        i2 += random1.nextInt(p_findNearestStructurePosBySpacing_3_ - p_findNearestStructurePosBySpacing_4_);
                    }
                    MapGenBase.setupChunkSeed(p_findNearestStructurePosBySpacing_0_.getSeed(), random, l1, i2);
                    random.nextInt();
                    if (p_findNearestStructurePosBySpacing_1_.canSpawnStructureAtCoords(l1, i2)) {
                        if (p_findNearestStructurePosBySpacing_8_ && p_findNearestStructurePosBySpacing_0_.isChunkGeneratedAt(l1, i2)) continue;
                        return new BlockPos((l1 << 4) + 8, 64, (i2 << 4) + 8);
                    }
                    if (k == 0) break;
                }
                if (k == 0) continue block0;
            }
        }
        return null;
    }
}

