/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces;
import net.minecraft.world.gen.structure.MapGenEndCity;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureEndCityPieces;
import net.minecraft.world.gen.structure.StructureMineshaftPieces;
import net.minecraft.world.gen.structure.StructureMineshaftStart;
import net.minecraft.world.gen.structure.StructureNetherBridgePieces;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraft.world.gen.structure.StructureOceanMonumentPieces;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.StructureStrongholdPieces;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.gen.structure.WoodlandMansion;
import net.minecraft.world.gen.structure.WoodlandMansionPieces;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MapGenStructureIO {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, Class<? extends StructureStart>> startNameToClassMap = Maps.newHashMap();
    private static final Map<Class<? extends StructureStart>, String> startClassToNameMap = Maps.newHashMap();
    private static final Map<String, Class<? extends StructureComponent>> componentNameToClassMap = Maps.newHashMap();
    private static final Map<Class<? extends StructureComponent>, String> componentClassToNameMap = Maps.newHashMap();

    public static void registerStructure(Class<? extends StructureStart> p_registerStructure_0_, String p_registerStructure_1_) {
        startNameToClassMap.put(p_registerStructure_1_, p_registerStructure_0_);
        startClassToNameMap.put(p_registerStructure_0_, p_registerStructure_1_);
    }

    public static void registerStructureComponent(Class<? extends StructureComponent> p_registerStructureComponent_0_, String p_registerStructureComponent_1_) {
        componentNameToClassMap.put(p_registerStructureComponent_1_, p_registerStructureComponent_0_);
        componentClassToNameMap.put(p_registerStructureComponent_0_, p_registerStructureComponent_1_);
    }

    public static String getStructureStartName(StructureStart p_getStructureStartName_0_) {
        return startClassToNameMap.get(p_getStructureStartName_0_.getClass());
    }

    public static String getStructureComponentName(StructureComponent p_getStructureComponentName_0_) {
        return componentClassToNameMap.get(p_getStructureComponentName_0_.getClass());
    }

    @Nullable
    public static StructureStart getStructureStart(NBTTagCompound p_getStructureStart_0_, World p_getStructureStart_1_) {
        StructureStart lvt_2_1_ = null;
        try {
            Class<? extends StructureStart> lvt_3_1_ = startNameToClassMap.get(p_getStructureStart_0_.getString("id"));
            if (lvt_3_1_ != null) {
                lvt_2_1_ = lvt_3_1_.newInstance();
            }
        }
        catch (Exception lvt_3_2_) {
            LOGGER.warn("Failed Start with id {}", new Object[]{p_getStructureStart_0_.getString("id")});
            lvt_3_2_.printStackTrace();
        }
        if (lvt_2_1_ != null) {
            lvt_2_1_.readStructureComponentsFromNBT(p_getStructureStart_1_, p_getStructureStart_0_);
        } else {
            LOGGER.warn("Skipping Structure with id {}", new Object[]{p_getStructureStart_0_.getString("id")});
        }
        return lvt_2_1_;
    }

    public static StructureComponent getStructureComponent(NBTTagCompound p_getStructureComponent_0_, World p_getStructureComponent_1_) {
        StructureComponent lvt_2_1_ = null;
        try {
            Class<? extends StructureComponent> lvt_3_1_ = componentNameToClassMap.get(p_getStructureComponent_0_.getString("id"));
            if (lvt_3_1_ != null) {
                lvt_2_1_ = lvt_3_1_.newInstance();
            }
        }
        catch (Exception lvt_3_2_) {
            LOGGER.warn("Failed Piece with id {}", new Object[]{p_getStructureComponent_0_.getString("id")});
            lvt_3_2_.printStackTrace();
        }
        if (lvt_2_1_ != null) {
            lvt_2_1_.readStructureBaseNBT(p_getStructureComponent_1_, p_getStructureComponent_0_);
        } else {
            LOGGER.warn("Skipping Piece with id {}", new Object[]{p_getStructureComponent_0_.getString("id")});
        }
        return lvt_2_1_;
    }

    static {
        MapGenStructureIO.registerStructure(StructureMineshaftStart.class, "Mineshaft");
        MapGenStructureIO.registerStructure(MapGenVillage.Start.class, "Village");
        MapGenStructureIO.registerStructure(MapGenNetherBridge.Start.class, "Fortress");
        MapGenStructureIO.registerStructure(MapGenStronghold.Start.class, "Stronghold");
        MapGenStructureIO.registerStructure(MapGenScatteredFeature.Start.class, "Temple");
        MapGenStructureIO.registerStructure(StructureOceanMonument.StartMonument.class, "Monument");
        MapGenStructureIO.registerStructure(MapGenEndCity.Start.class, "EndCity");
        MapGenStructureIO.registerStructure(WoodlandMansion.Start.class, "Mansion");
        StructureMineshaftPieces.registerStructurePieces();
        StructureVillagePieces.registerVillagePieces();
        StructureNetherBridgePieces.registerNetherFortressPieces();
        StructureStrongholdPieces.registerStrongholdPieces();
        ComponentScatteredFeaturePieces.registerScatteredFeaturePieces();
        StructureOceanMonumentPieces.registerOceanMonumentPieces();
        StructureEndCityPieces.registerPieces();
        WoodlandMansionPieces.registerWoodlandMansionPieces();
    }
}

