/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public class MapGenVillage
extends MapGenStructure {
    public static List<Biome> VILLAGE_SPAWN_BIOMES = Arrays.asList(Biomes.PLAINS, Biomes.DESERT, Biomes.SAVANNA, Biomes.TAIGA);
    private int size;
    private int distance = 32;
    private final int minTownSeparation = 8;

    public MapGenVillage() {
    }

    public MapGenVillage(Map<String, String> p_i2093_1_) {
        this();
        for (Map.Entry<String, String> lvt_3_1_ : p_i2093_1_.entrySet()) {
            if (lvt_3_1_.getKey().equals("size")) {
                this.size = MathHelper.getInt(lvt_3_1_.getValue(), this.size, 0);
                continue;
            }
            if (!lvt_3_1_.getKey().equals("distance")) continue;
            this.distance = MathHelper.getInt(lvt_3_1_.getValue(), this.distance, 9);
        }
    }

    @Override
    public String getStructureName() {
        return "Village";
    }

    @Override
    protected boolean canSpawnStructureAtCoords(int p_canSpawnStructureAtCoords_1_, int p_canSpawnStructureAtCoords_2_) {
        boolean lvt_8_1_;
        int lvt_3_1_ = p_canSpawnStructureAtCoords_1_;
        int lvt_4_1_ = p_canSpawnStructureAtCoords_2_;
        if (p_canSpawnStructureAtCoords_1_ < 0) {
            p_canSpawnStructureAtCoords_1_ -= this.distance - 1;
        }
        if (p_canSpawnStructureAtCoords_2_ < 0) {
            p_canSpawnStructureAtCoords_2_ -= this.distance - 1;
        }
        int lvt_5_1_ = p_canSpawnStructureAtCoords_1_ / this.distance;
        int lvt_6_1_ = p_canSpawnStructureAtCoords_2_ / this.distance;
        Random lvt_7_1_ = this.world.setRandomSeed(lvt_5_1_, lvt_6_1_, 10387312);
        lvt_5_1_ *= this.distance;
        lvt_6_1_ *= this.distance;
        p_canSpawnStructureAtCoords_1_ = lvt_3_1_;
        p_canSpawnStructureAtCoords_2_ = lvt_4_1_;
        return p_canSpawnStructureAtCoords_1_ == (lvt_5_1_ += lvt_7_1_.nextInt(this.distance - 8)) && p_canSpawnStructureAtCoords_2_ == (lvt_6_1_ += lvt_7_1_.nextInt(this.distance - 8)) && (lvt_8_1_ = this.world.getBiomeProvider().areBiomesViable(p_canSpawnStructureAtCoords_1_ * 16 + 8, p_canSpawnStructureAtCoords_2_ * 16 + 8, 0, VILLAGE_SPAWN_BIOMES));
    }

    @Override
    public BlockPos getClosestStrongholdPos(World p_getClosestStrongholdPos_1_, BlockPos p_getClosestStrongholdPos_2_, boolean p_getClosestStrongholdPos_3_) {
        this.world = p_getClosestStrongholdPos_1_;
        return MapGenVillage.findNearestStructurePosBySpacing(p_getClosestStrongholdPos_1_, this, p_getClosestStrongholdPos_2_, this.distance, 8, 10387312, false, 100, p_getClosestStrongholdPos_3_);
    }

    @Override
    protected StructureStart getStructureStart(int p_getStructureStart_1_, int p_getStructureStart_2_) {
        return new Start(this.world, this.rand, p_getStructureStart_1_, p_getStructureStart_2_, this.size);
    }

    public static class Start
    extends StructureStart {
        private boolean hasMoreThanTwoComponents;

        public Start() {
        }

        public Start(World p_i2092_1_, Random p_i2092_2_, int p_i2092_3_, int p_i2092_4_, int p_i2092_5_) {
            super(p_i2092_3_, p_i2092_4_);
            List<StructureVillagePieces.PieceWeight> lvt_6_1_ = StructureVillagePieces.getStructureVillageWeightedPieceList(p_i2092_2_, p_i2092_5_);
            StructureVillagePieces.Start lvt_7_1_ = new StructureVillagePieces.Start(p_i2092_1_.getBiomeProvider(), 0, p_i2092_2_, (p_i2092_3_ << 4) + 2, (p_i2092_4_ << 4) + 2, lvt_6_1_, p_i2092_5_);
            this.components.add(lvt_7_1_);
            lvt_7_1_.buildComponent(lvt_7_1_, this.components, p_i2092_2_);
            List<StructureComponent> lvt_8_1_ = lvt_7_1_.pendingRoads;
            List<StructureComponent> lvt_9_1_ = lvt_7_1_.pendingHouses;
            while (!lvt_8_1_.isEmpty() || !lvt_9_1_.isEmpty()) {
                if (lvt_8_1_.isEmpty()) {
                    int lvt_10_1_ = p_i2092_2_.nextInt(lvt_9_1_.size());
                    StructureComponent lvt_11_1_ = lvt_9_1_.remove(lvt_10_1_);
                    lvt_11_1_.buildComponent(lvt_7_1_, this.components, p_i2092_2_);
                    continue;
                }
                int lvt_10_2_ = p_i2092_2_.nextInt(lvt_8_1_.size());
                StructureComponent lvt_11_2_ = lvt_8_1_.remove(lvt_10_2_);
                lvt_11_2_.buildComponent(lvt_7_1_, this.components, p_i2092_2_);
            }
            this.updateBoundingBox();
            int lvt_10_3_ = 0;
            for (StructureComponent lvt_12_1_ : this.components) {
                if (lvt_12_1_ instanceof StructureVillagePieces.Road) continue;
                ++lvt_10_3_;
            }
            this.hasMoreThanTwoComponents = lvt_10_3_ > 2;
        }

        @Override
        public boolean isSizeableStructure() {
            return this.hasMoreThanTwoComponents;
        }

        @Override
        public void writeToNBT(NBTTagCompound p_writeToNBT_1_) {
            super.writeToNBT(p_writeToNBT_1_);
            p_writeToNBT_1_.setBoolean("Valid", this.hasMoreThanTwoComponents);
        }

        @Override
        public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
            super.readFromNBT(p_readFromNBT_1_);
            this.hasMoreThanTwoComponents = p_readFromNBT_1_.getBoolean("Valid");
        }
    }
}

