/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import com.google.common.base.Objects;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3i;

public class StructureBoundingBox {
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;

    public StructureBoundingBox() {
    }

    public StructureBoundingBox(int[] p_i43000_1_) {
        if (p_i43000_1_.length == 6) {
            this.minX = p_i43000_1_[0];
            this.minY = p_i43000_1_[1];
            this.minZ = p_i43000_1_[2];
            this.maxX = p_i43000_1_[3];
            this.maxY = p_i43000_1_[4];
            this.maxZ = p_i43000_1_[5];
        }
    }

    public static StructureBoundingBox getNewBoundingBox() {
        return new StructureBoundingBox(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public static StructureBoundingBox getComponentToAddBoundingBox(int p_getComponentToAddBoundingBox_0_, int p_getComponentToAddBoundingBox_1_, int p_getComponentToAddBoundingBox_2_, int p_getComponentToAddBoundingBox_3_, int p_getComponentToAddBoundingBox_4_, int p_getComponentToAddBoundingBox_5_, int p_getComponentToAddBoundingBox_6_, int p_getComponentToAddBoundingBox_7_, int p_getComponentToAddBoundingBox_8_, EnumFacing p_getComponentToAddBoundingBox_9_) {
        switch (p_getComponentToAddBoundingBox_9_) {
            default: {
                return new StructureBoundingBox(p_getComponentToAddBoundingBox_0_ + p_getComponentToAddBoundingBox_3_, p_getComponentToAddBoundingBox_1_ + p_getComponentToAddBoundingBox_4_, p_getComponentToAddBoundingBox_2_ + p_getComponentToAddBoundingBox_5_, p_getComponentToAddBoundingBox_0_ + p_getComponentToAddBoundingBox_6_ - 1 + p_getComponentToAddBoundingBox_3_, p_getComponentToAddBoundingBox_1_ + p_getComponentToAddBoundingBox_7_ - 1 + p_getComponentToAddBoundingBox_4_, p_getComponentToAddBoundingBox_2_ + p_getComponentToAddBoundingBox_8_ - 1 + p_getComponentToAddBoundingBox_5_);
            }
            case NORTH: {
                return new StructureBoundingBox(p_getComponentToAddBoundingBox_0_ + p_getComponentToAddBoundingBox_3_, p_getComponentToAddBoundingBox_1_ + p_getComponentToAddBoundingBox_4_, p_getComponentToAddBoundingBox_2_ - p_getComponentToAddBoundingBox_8_ + 1 + p_getComponentToAddBoundingBox_5_, p_getComponentToAddBoundingBox_0_ + p_getComponentToAddBoundingBox_6_ - 1 + p_getComponentToAddBoundingBox_3_, p_getComponentToAddBoundingBox_1_ + p_getComponentToAddBoundingBox_7_ - 1 + p_getComponentToAddBoundingBox_4_, p_getComponentToAddBoundingBox_2_ + p_getComponentToAddBoundingBox_5_);
            }
            case SOUTH: {
                return new StructureBoundingBox(p_getComponentToAddBoundingBox_0_ + p_getComponentToAddBoundingBox_3_, p_getComponentToAddBoundingBox_1_ + p_getComponentToAddBoundingBox_4_, p_getComponentToAddBoundingBox_2_ + p_getComponentToAddBoundingBox_5_, p_getComponentToAddBoundingBox_0_ + p_getComponentToAddBoundingBox_6_ - 1 + p_getComponentToAddBoundingBox_3_, p_getComponentToAddBoundingBox_1_ + p_getComponentToAddBoundingBox_7_ - 1 + p_getComponentToAddBoundingBox_4_, p_getComponentToAddBoundingBox_2_ + p_getComponentToAddBoundingBox_8_ - 1 + p_getComponentToAddBoundingBox_5_);
            }
            case WEST: {
                return new StructureBoundingBox(p_getComponentToAddBoundingBox_0_ - p_getComponentToAddBoundingBox_8_ + 1 + p_getComponentToAddBoundingBox_5_, p_getComponentToAddBoundingBox_1_ + p_getComponentToAddBoundingBox_4_, p_getComponentToAddBoundingBox_2_ + p_getComponentToAddBoundingBox_3_, p_getComponentToAddBoundingBox_0_ + p_getComponentToAddBoundingBox_5_, p_getComponentToAddBoundingBox_1_ + p_getComponentToAddBoundingBox_7_ - 1 + p_getComponentToAddBoundingBox_4_, p_getComponentToAddBoundingBox_2_ + p_getComponentToAddBoundingBox_6_ - 1 + p_getComponentToAddBoundingBox_3_);
            }
            case EAST: 
        }
        return new StructureBoundingBox(p_getComponentToAddBoundingBox_0_ + p_getComponentToAddBoundingBox_5_, p_getComponentToAddBoundingBox_1_ + p_getComponentToAddBoundingBox_4_, p_getComponentToAddBoundingBox_2_ + p_getComponentToAddBoundingBox_3_, p_getComponentToAddBoundingBox_0_ + p_getComponentToAddBoundingBox_8_ - 1 + p_getComponentToAddBoundingBox_5_, p_getComponentToAddBoundingBox_1_ + p_getComponentToAddBoundingBox_7_ - 1 + p_getComponentToAddBoundingBox_4_, p_getComponentToAddBoundingBox_2_ + p_getComponentToAddBoundingBox_6_ - 1 + p_getComponentToAddBoundingBox_3_);
    }

    public static StructureBoundingBox createProper(int p_createProper_0_, int p_createProper_1_, int p_createProper_2_, int p_createProper_3_, int p_createProper_4_, int p_createProper_5_) {
        return new StructureBoundingBox(Math.min(p_createProper_0_, p_createProper_3_), Math.min(p_createProper_1_, p_createProper_4_), Math.min(p_createProper_2_, p_createProper_5_), Math.max(p_createProper_0_, p_createProper_3_), Math.max(p_createProper_1_, p_createProper_4_), Math.max(p_createProper_2_, p_createProper_5_));
    }

    public StructureBoundingBox(StructureBoundingBox p_i2031_1_) {
        this.minX = p_i2031_1_.minX;
        this.minY = p_i2031_1_.minY;
        this.minZ = p_i2031_1_.minZ;
        this.maxX = p_i2031_1_.maxX;
        this.maxY = p_i2031_1_.maxY;
        this.maxZ = p_i2031_1_.maxZ;
    }

    public StructureBoundingBox(int p_i2032_1_, int p_i2032_2_, int p_i2032_3_, int p_i2032_4_, int p_i2032_5_, int p_i2032_6_) {
        this.minX = p_i2032_1_;
        this.minY = p_i2032_2_;
        this.minZ = p_i2032_3_;
        this.maxX = p_i2032_4_;
        this.maxY = p_i2032_5_;
        this.maxZ = p_i2032_6_;
    }

    public StructureBoundingBox(Vec3i p_i45626_1_, Vec3i p_i45626_2_) {
        this.minX = Math.min(p_i45626_1_.getX(), p_i45626_2_.getX());
        this.minY = Math.min(p_i45626_1_.getY(), p_i45626_2_.getY());
        this.minZ = Math.min(p_i45626_1_.getZ(), p_i45626_2_.getZ());
        this.maxX = Math.max(p_i45626_1_.getX(), p_i45626_2_.getX());
        this.maxY = Math.max(p_i45626_1_.getY(), p_i45626_2_.getY());
        this.maxZ = Math.max(p_i45626_1_.getZ(), p_i45626_2_.getZ());
    }

    public StructureBoundingBox(int p_i2033_1_, int p_i2033_2_, int p_i2033_3_, int p_i2033_4_) {
        this.minX = p_i2033_1_;
        this.minZ = p_i2033_2_;
        this.maxX = p_i2033_3_;
        this.maxZ = p_i2033_4_;
        this.minY = 1;
        this.maxY = 512;
    }

    public boolean intersectsWith(StructureBoundingBox p_intersectsWith_1_) {
        return this.maxX >= p_intersectsWith_1_.minX && this.minX <= p_intersectsWith_1_.maxX && this.maxZ >= p_intersectsWith_1_.minZ && this.minZ <= p_intersectsWith_1_.maxZ && this.maxY >= p_intersectsWith_1_.minY && this.minY <= p_intersectsWith_1_.maxY;
    }

    public boolean intersectsWith(int p_intersectsWith_1_, int p_intersectsWith_2_, int p_intersectsWith_3_, int p_intersectsWith_4_) {
        return this.maxX >= p_intersectsWith_1_ && this.minX <= p_intersectsWith_3_ && this.maxZ >= p_intersectsWith_2_ && this.minZ <= p_intersectsWith_4_;
    }

    public void expandTo(StructureBoundingBox p_expandTo_1_) {
        this.minX = Math.min(this.minX, p_expandTo_1_.minX);
        this.minY = Math.min(this.minY, p_expandTo_1_.minY);
        this.minZ = Math.min(this.minZ, p_expandTo_1_.minZ);
        this.maxX = Math.max(this.maxX, p_expandTo_1_.maxX);
        this.maxY = Math.max(this.maxY, p_expandTo_1_.maxY);
        this.maxZ = Math.max(this.maxZ, p_expandTo_1_.maxZ);
    }

    public void offset(int p_offset_1_, int p_offset_2_, int p_offset_3_) {
        this.minX += p_offset_1_;
        this.minY += p_offset_2_;
        this.minZ += p_offset_3_;
        this.maxX += p_offset_1_;
        this.maxY += p_offset_2_;
        this.maxZ += p_offset_3_;
    }

    public boolean isVecInside(Vec3i p_isVecInside_1_) {
        return p_isVecInside_1_.getX() >= this.minX && p_isVecInside_1_.getX() <= this.maxX && p_isVecInside_1_.getZ() >= this.minZ && p_isVecInside_1_.getZ() <= this.maxZ && p_isVecInside_1_.getY() >= this.minY && p_isVecInside_1_.getY() <= this.maxY;
    }

    public Vec3i getLength() {
        return new Vec3i(this.maxX - this.minX, this.maxY - this.minY, this.maxZ - this.minZ);
    }

    public int getXSize() {
        return this.maxX - this.minX + 1;
    }

    public int getYSize() {
        return this.maxY - this.minY + 1;
    }

    public int getZSize() {
        return this.maxZ - this.minZ + 1;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("x0", this.minX).add("y0", this.minY).add("z0", this.minZ).add("x1", this.maxX).add("y1", this.maxY).add("z1", this.maxZ).toString();
    }

    public NBTTagIntArray toNBTTagIntArray() {
        return new NBTTagIntArray(new int[]{this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ});
    }
}

