/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.TemplateManager;

public abstract class StructureComponent {
    protected StructureBoundingBox boundingBox;
    @Nullable
    private EnumFacing coordBaseMode;
    private Mirror mirror;
    private Rotation rotation;
    protected int componentType;

    public StructureComponent() {
    }

    protected StructureComponent(int p_i2091_1_) {
        this.componentType = p_i2091_1_;
    }

    public final NBTTagCompound createStructureBaseNBT() {
        if (MapGenStructureIO.getStructureComponentName(this) == null) {
            throw new RuntimeException("StructureComponent \"" + this.getClass().getName() + "\" missing ID Mapping, Modder see MapGenStructureIO");
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.setString("id", MapGenStructureIO.getStructureComponentName(this));
        nbttagcompound.setTag("BB", this.boundingBox.toNBTTagIntArray());
        EnumFacing enumfacing = this.getCoordBaseMode();
        nbttagcompound.setInteger("O", enumfacing == null ? -1 : enumfacing.getHorizontalIndex());
        nbttagcompound.setInteger("GD", this.componentType);
        this.writeStructureToNBT(nbttagcompound);
        return nbttagcompound;
    }

    protected abstract void writeStructureToNBT(NBTTagCompound var1);

    public void readStructureBaseNBT(World p_readStructureBaseNBT_1_, NBTTagCompound p_readStructureBaseNBT_2_) {
        int i;
        if (p_readStructureBaseNBT_2_.hasKey("BB")) {
            this.boundingBox = new StructureBoundingBox(p_readStructureBaseNBT_2_.getIntArray("BB"));
        }
        this.setCoordBaseMode((i = p_readStructureBaseNBT_2_.getInteger("O")) == -1 ? null : EnumFacing.getHorizontal(i));
        this.componentType = p_readStructureBaseNBT_2_.getInteger("GD");
        this.readStructureFromNBT(p_readStructureBaseNBT_2_, p_readStructureBaseNBT_1_.getSaveHandler().getStructureTemplateManager());
    }

    protected abstract void readStructureFromNBT(NBTTagCompound var1, TemplateManager var2);

    public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
    }

    public abstract boolean addComponentParts(World var1, Random var2, StructureBoundingBox var3);

    public StructureBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public int getComponentType() {
        return this.componentType;
    }

    public static StructureComponent findIntersecting(List<StructureComponent> p_findIntersecting_0_, StructureBoundingBox p_findIntersecting_1_) {
        for (StructureComponent structurecomponent : p_findIntersecting_0_) {
            if (structurecomponent.getBoundingBox() == null || !structurecomponent.getBoundingBox().intersectsWith(p_findIntersecting_1_)) continue;
            return structurecomponent;
        }
        return null;
    }

    protected boolean isLiquidInStructureBoundingBox(World p_isLiquidInStructureBoundingBox_1_, StructureBoundingBox p_isLiquidInStructureBoundingBox_2_) {
        int i = Math.max(this.boundingBox.minX - 1, p_isLiquidInStructureBoundingBox_2_.minX);
        int j = Math.max(this.boundingBox.minY - 1, p_isLiquidInStructureBoundingBox_2_.minY);
        int k = Math.max(this.boundingBox.minZ - 1, p_isLiquidInStructureBoundingBox_2_.minZ);
        int l = Math.min(this.boundingBox.maxX + 1, p_isLiquidInStructureBoundingBox_2_.maxX);
        int i1 = Math.min(this.boundingBox.maxY + 1, p_isLiquidInStructureBoundingBox_2_.maxY);
        int j1 = Math.min(this.boundingBox.maxZ + 1, p_isLiquidInStructureBoundingBox_2_.maxZ);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = k; l1 <= j1; ++l1) {
                if (p_isLiquidInStructureBoundingBox_1_.getBlockState(blockpos$mutableblockpos.setPos(k1, j, l1)).getMaterial().isLiquid()) {
                    return true;
                }
                if (!p_isLiquidInStructureBoundingBox_1_.getBlockState(blockpos$mutableblockpos.setPos(k1, i1, l1)).getMaterial().isLiquid()) continue;
                return true;
            }
        }
        for (int i2 = i; i2 <= l; ++i2) {
            for (int k2 = j; k2 <= i1; ++k2) {
                if (p_isLiquidInStructureBoundingBox_1_.getBlockState(blockpos$mutableblockpos.setPos(i2, k2, k)).getMaterial().isLiquid()) {
                    return true;
                }
                if (!p_isLiquidInStructureBoundingBox_1_.getBlockState(blockpos$mutableblockpos.setPos(i2, k2, j1)).getMaterial().isLiquid()) continue;
                return true;
            }
        }
        for (int j2 = k; j2 <= j1; ++j2) {
            for (int l2 = j; l2 <= i1; ++l2) {
                if (p_isLiquidInStructureBoundingBox_1_.getBlockState(blockpos$mutableblockpos.setPos(i, l2, j2)).getMaterial().isLiquid()) {
                    return true;
                }
                if (!p_isLiquidInStructureBoundingBox_1_.getBlockState(blockpos$mutableblockpos.setPos(l, l2, j2)).getMaterial().isLiquid()) continue;
                return true;
            }
        }
        return false;
    }

    protected int getXWithOffset(int p_getXWithOffset_1_, int p_getXWithOffset_2_) {
        EnumFacing enumfacing = this.getCoordBaseMode();
        if (enumfacing == null) {
            return p_getXWithOffset_1_;
        }
        switch (enumfacing) {
            case NORTH: 
            case SOUTH: {
                return this.boundingBox.minX + p_getXWithOffset_1_;
            }
            case WEST: {
                return this.boundingBox.maxX - p_getXWithOffset_2_;
            }
            case EAST: {
                return this.boundingBox.minX + p_getXWithOffset_2_;
            }
        }
        return p_getXWithOffset_1_;
    }

    protected int getYWithOffset(int p_getYWithOffset_1_) {
        return this.getCoordBaseMode() == null ? p_getYWithOffset_1_ : p_getYWithOffset_1_ + this.boundingBox.minY;
    }

    protected int getZWithOffset(int p_getZWithOffset_1_, int p_getZWithOffset_2_) {
        EnumFacing enumfacing = this.getCoordBaseMode();
        if (enumfacing == null) {
            return p_getZWithOffset_2_;
        }
        switch (enumfacing) {
            case NORTH: {
                return this.boundingBox.maxZ - p_getZWithOffset_2_;
            }
            case SOUTH: {
                return this.boundingBox.minZ + p_getZWithOffset_2_;
            }
            case WEST: 
            case EAST: {
                return this.boundingBox.minZ + p_getZWithOffset_1_;
            }
        }
        return p_getZWithOffset_2_;
    }

    protected void setBlockState(World p_setBlockState_1_, IBlockState p_setBlockState_2_, int p_setBlockState_3_, int p_setBlockState_4_, int p_setBlockState_5_, StructureBoundingBox p_setBlockState_6_) {
        BlockPos blockpos = new BlockPos(this.getXWithOffset(p_setBlockState_3_, p_setBlockState_5_), this.getYWithOffset(p_setBlockState_4_), this.getZWithOffset(p_setBlockState_3_, p_setBlockState_5_));
        if (p_setBlockState_6_.isVecInside(blockpos)) {
            if (this.mirror != Mirror.NONE) {
                p_setBlockState_2_ = p_setBlockState_2_.withMirror(this.mirror);
            }
            if (this.rotation != Rotation.NONE) {
                p_setBlockState_2_ = p_setBlockState_2_.withRotation(this.rotation);
            }
            p_setBlockState_1_.setBlockState(blockpos, p_setBlockState_2_, 2);
        }
    }

    protected IBlockState getBlockStateFromPos(World p_getBlockStateFromPos_1_, int p_getBlockStateFromPos_2_, int p_getBlockStateFromPos_3_, int p_getBlockStateFromPos_4_, StructureBoundingBox p_getBlockStateFromPos_5_) {
        int k;
        int j;
        int i = this.getXWithOffset(p_getBlockStateFromPos_2_, p_getBlockStateFromPos_4_);
        BlockPos blockpos = new BlockPos(i, j = this.getYWithOffset(p_getBlockStateFromPos_3_), k = this.getZWithOffset(p_getBlockStateFromPos_2_, p_getBlockStateFromPos_4_));
        return !p_getBlockStateFromPos_5_.isVecInside(blockpos) ? Blocks.AIR.getDefaultState() : p_getBlockStateFromPos_1_.getBlockState(blockpos);
    }

    protected int getSkyBrightness(World p_getSkyBrightness_1_, int p_getSkyBrightness_2_, int p_getSkyBrightness_3_, int p_getSkyBrightness_4_, StructureBoundingBox p_getSkyBrightness_5_) {
        int k;
        int j;
        int i = this.getXWithOffset(p_getSkyBrightness_2_, p_getSkyBrightness_4_);
        BlockPos blockpos = new BlockPos(i, j = this.getYWithOffset(p_getSkyBrightness_3_ + 1), k = this.getZWithOffset(p_getSkyBrightness_2_, p_getSkyBrightness_4_));
        return !p_getSkyBrightness_5_.isVecInside(blockpos) ? EnumSkyBlock.SKY.defaultLightValue : p_getSkyBrightness_1_.getLightFor(EnumSkyBlock.SKY, blockpos);
    }

    protected void fillWithAir(World p_fillWithAir_1_, StructureBoundingBox p_fillWithAir_2_, int p_fillWithAir_3_, int p_fillWithAir_4_, int p_fillWithAir_5_, int p_fillWithAir_6_, int p_fillWithAir_7_, int p_fillWithAir_8_) {
        for (int i = p_fillWithAir_4_; i <= p_fillWithAir_7_; ++i) {
            for (int j = p_fillWithAir_3_; j <= p_fillWithAir_6_; ++j) {
                for (int k = p_fillWithAir_5_; k <= p_fillWithAir_8_; ++k) {
                    this.setBlockState(p_fillWithAir_1_, Blocks.AIR.getDefaultState(), j, i, k, p_fillWithAir_2_);
                }
            }
        }
    }

    protected void fillWithBlocks(World p_fillWithBlocks_1_, StructureBoundingBox p_fillWithBlocks_2_, int p_fillWithBlocks_3_, int p_fillWithBlocks_4_, int p_fillWithBlocks_5_, int p_fillWithBlocks_6_, int p_fillWithBlocks_7_, int p_fillWithBlocks_8_, IBlockState p_fillWithBlocks_9_, IBlockState p_fillWithBlocks_10_, boolean p_fillWithBlocks_11_) {
        for (int i = p_fillWithBlocks_4_; i <= p_fillWithBlocks_7_; ++i) {
            for (int j = p_fillWithBlocks_3_; j <= p_fillWithBlocks_6_; ++j) {
                for (int k = p_fillWithBlocks_5_; k <= p_fillWithBlocks_8_; ++k) {
                    if (p_fillWithBlocks_11_ && this.getBlockStateFromPos(p_fillWithBlocks_1_, j, i, k, p_fillWithBlocks_2_).getMaterial() == Material.AIR) continue;
                    if (i != p_fillWithBlocks_4_ && i != p_fillWithBlocks_7_ && j != p_fillWithBlocks_3_ && j != p_fillWithBlocks_6_ && k != p_fillWithBlocks_5_ && k != p_fillWithBlocks_8_) {
                        this.setBlockState(p_fillWithBlocks_1_, p_fillWithBlocks_10_, j, i, k, p_fillWithBlocks_2_);
                        continue;
                    }
                    this.setBlockState(p_fillWithBlocks_1_, p_fillWithBlocks_9_, j, i, k, p_fillWithBlocks_2_);
                }
            }
        }
    }

    protected void fillWithRandomizedBlocks(World p_fillWithRandomizedBlocks_1_, StructureBoundingBox p_fillWithRandomizedBlocks_2_, int p_fillWithRandomizedBlocks_3_, int p_fillWithRandomizedBlocks_4_, int p_fillWithRandomizedBlocks_5_, int p_fillWithRandomizedBlocks_6_, int p_fillWithRandomizedBlocks_7_, int p_fillWithRandomizedBlocks_8_, boolean p_fillWithRandomizedBlocks_9_, Random p_fillWithRandomizedBlocks_10_, BlockSelector p_fillWithRandomizedBlocks_11_) {
        for (int i = p_fillWithRandomizedBlocks_4_; i <= p_fillWithRandomizedBlocks_7_; ++i) {
            for (int j = p_fillWithRandomizedBlocks_3_; j <= p_fillWithRandomizedBlocks_6_; ++j) {
                for (int k = p_fillWithRandomizedBlocks_5_; k <= p_fillWithRandomizedBlocks_8_; ++k) {
                    if (p_fillWithRandomizedBlocks_9_ && this.getBlockStateFromPos(p_fillWithRandomizedBlocks_1_, j, i, k, p_fillWithRandomizedBlocks_2_).getMaterial() == Material.AIR) continue;
                    p_fillWithRandomizedBlocks_11_.selectBlocks(p_fillWithRandomizedBlocks_10_, j, i, k, i == p_fillWithRandomizedBlocks_4_ || i == p_fillWithRandomizedBlocks_7_ || j == p_fillWithRandomizedBlocks_3_ || j == p_fillWithRandomizedBlocks_6_ || k == p_fillWithRandomizedBlocks_5_ || k == p_fillWithRandomizedBlocks_8_);
                    this.setBlockState(p_fillWithRandomizedBlocks_1_, p_fillWithRandomizedBlocks_11_.getBlockState(), j, i, k, p_fillWithRandomizedBlocks_2_);
                }
            }
        }
    }

    protected void generateMaybeBox(World p_generateMaybeBox_1_, StructureBoundingBox p_generateMaybeBox_2_, Random p_generateMaybeBox_3_, float p_generateMaybeBox_4_, int p_generateMaybeBox_5_, int p_generateMaybeBox_6_, int p_generateMaybeBox_7_, int p_generateMaybeBox_8_, int p_generateMaybeBox_9_, int p_generateMaybeBox_10_, IBlockState p_generateMaybeBox_11_, IBlockState p_generateMaybeBox_12_, boolean p_generateMaybeBox_13_, int p_generateMaybeBox_14_) {
        for (int i = p_generateMaybeBox_6_; i <= p_generateMaybeBox_9_; ++i) {
            for (int j = p_generateMaybeBox_5_; j <= p_generateMaybeBox_8_; ++j) {
                for (int k = p_generateMaybeBox_7_; k <= p_generateMaybeBox_10_; ++k) {
                    if (!(p_generateMaybeBox_3_.nextFloat() <= p_generateMaybeBox_4_) || p_generateMaybeBox_13_ && this.getBlockStateFromPos(p_generateMaybeBox_1_, j, i, k, p_generateMaybeBox_2_).getMaterial() == Material.AIR || p_generateMaybeBox_14_ > 0 && this.getSkyBrightness(p_generateMaybeBox_1_, j, i, k, p_generateMaybeBox_2_) >= p_generateMaybeBox_14_) continue;
                    if (i != p_generateMaybeBox_6_ && i != p_generateMaybeBox_9_ && j != p_generateMaybeBox_5_ && j != p_generateMaybeBox_8_ && k != p_generateMaybeBox_7_ && k != p_generateMaybeBox_10_) {
                        this.setBlockState(p_generateMaybeBox_1_, p_generateMaybeBox_12_, j, i, k, p_generateMaybeBox_2_);
                        continue;
                    }
                    this.setBlockState(p_generateMaybeBox_1_, p_generateMaybeBox_11_, j, i, k, p_generateMaybeBox_2_);
                }
            }
        }
    }

    protected void randomlyPlaceBlock(World p_randomlyPlaceBlock_1_, StructureBoundingBox p_randomlyPlaceBlock_2_, Random p_randomlyPlaceBlock_3_, float p_randomlyPlaceBlock_4_, int p_randomlyPlaceBlock_5_, int p_randomlyPlaceBlock_6_, int p_randomlyPlaceBlock_7_, IBlockState p_randomlyPlaceBlock_8_) {
        if (p_randomlyPlaceBlock_3_.nextFloat() < p_randomlyPlaceBlock_4_) {
            this.setBlockState(p_randomlyPlaceBlock_1_, p_randomlyPlaceBlock_8_, p_randomlyPlaceBlock_5_, p_randomlyPlaceBlock_6_, p_randomlyPlaceBlock_7_, p_randomlyPlaceBlock_2_);
        }
    }

    protected void randomlyRareFillWithBlocks(World p_randomlyRareFillWithBlocks_1_, StructureBoundingBox p_randomlyRareFillWithBlocks_2_, int p_randomlyRareFillWithBlocks_3_, int p_randomlyRareFillWithBlocks_4_, int p_randomlyRareFillWithBlocks_5_, int p_randomlyRareFillWithBlocks_6_, int p_randomlyRareFillWithBlocks_7_, int p_randomlyRareFillWithBlocks_8_, IBlockState p_randomlyRareFillWithBlocks_9_, boolean p_randomlyRareFillWithBlocks_10_) {
        float f = p_randomlyRareFillWithBlocks_6_ - p_randomlyRareFillWithBlocks_3_ + 1;
        float f1 = p_randomlyRareFillWithBlocks_7_ - p_randomlyRareFillWithBlocks_4_ + 1;
        float f2 = p_randomlyRareFillWithBlocks_8_ - p_randomlyRareFillWithBlocks_5_ + 1;
        float f3 = (float)p_randomlyRareFillWithBlocks_3_ + f / 2.0f;
        float f4 = (float)p_randomlyRareFillWithBlocks_5_ + f2 / 2.0f;
        for (int i = p_randomlyRareFillWithBlocks_4_; i <= p_randomlyRareFillWithBlocks_7_; ++i) {
            float f5 = (float)(i - p_randomlyRareFillWithBlocks_4_) / f1;
            for (int j = p_randomlyRareFillWithBlocks_3_; j <= p_randomlyRareFillWithBlocks_6_; ++j) {
                float f6 = ((float)j - f3) / (f * 0.5f);
                for (int k = p_randomlyRareFillWithBlocks_5_; k <= p_randomlyRareFillWithBlocks_8_; ++k) {
                    float f8;
                    float f7 = ((float)k - f4) / (f2 * 0.5f);
                    if (p_randomlyRareFillWithBlocks_10_ && this.getBlockStateFromPos(p_randomlyRareFillWithBlocks_1_, j, i, k, p_randomlyRareFillWithBlocks_2_).getMaterial() == Material.AIR || !((f8 = f6 * f6 + f5 * f5 + f7 * f7) <= 1.05f)) continue;
                    this.setBlockState(p_randomlyRareFillWithBlocks_1_, p_randomlyRareFillWithBlocks_9_, j, i, k, p_randomlyRareFillWithBlocks_2_);
                }
            }
        }
    }

    protected void clearCurrentPositionBlocksUpwards(World p_clearCurrentPositionBlocksUpwards_1_, int p_clearCurrentPositionBlocksUpwards_2_, int p_clearCurrentPositionBlocksUpwards_3_, int p_clearCurrentPositionBlocksUpwards_4_, StructureBoundingBox p_clearCurrentPositionBlocksUpwards_5_) {
        BlockPos blockpos = new BlockPos(this.getXWithOffset(p_clearCurrentPositionBlocksUpwards_2_, p_clearCurrentPositionBlocksUpwards_4_), this.getYWithOffset(p_clearCurrentPositionBlocksUpwards_3_), this.getZWithOffset(p_clearCurrentPositionBlocksUpwards_2_, p_clearCurrentPositionBlocksUpwards_4_));
        if (p_clearCurrentPositionBlocksUpwards_5_.isVecInside(blockpos)) {
            while (!p_clearCurrentPositionBlocksUpwards_1_.isAirBlock(blockpos) && blockpos.getY() < 255) {
                p_clearCurrentPositionBlocksUpwards_1_.setBlockState(blockpos, Blocks.AIR.getDefaultState(), 2);
                blockpos = blockpos.up();
            }
        }
    }

    protected void replaceAirAndLiquidDownwards(World p_replaceAirAndLiquidDownwards_1_, IBlockState p_replaceAirAndLiquidDownwards_2_, int p_replaceAirAndLiquidDownwards_3_, int p_replaceAirAndLiquidDownwards_4_, int p_replaceAirAndLiquidDownwards_5_, StructureBoundingBox p_replaceAirAndLiquidDownwards_6_) {
        int k;
        int j;
        int i = this.getXWithOffset(p_replaceAirAndLiquidDownwards_3_, p_replaceAirAndLiquidDownwards_5_);
        if (p_replaceAirAndLiquidDownwards_6_.isVecInside(new BlockPos(i, j = this.getYWithOffset(p_replaceAirAndLiquidDownwards_4_), k = this.getZWithOffset(p_replaceAirAndLiquidDownwards_3_, p_replaceAirAndLiquidDownwards_5_)))) {
            while ((p_replaceAirAndLiquidDownwards_1_.isAirBlock(new BlockPos(i, j, k)) || p_replaceAirAndLiquidDownwards_1_.getBlockState(new BlockPos(i, j, k)).getMaterial().isLiquid()) && j > 1) {
                p_replaceAirAndLiquidDownwards_1_.setBlockState(new BlockPos(i, j, k), p_replaceAirAndLiquidDownwards_2_, 2);
                --j;
            }
        }
    }

    protected boolean generateChest(World p_generateChest_1_, StructureBoundingBox p_generateChest_2_, Random p_generateChest_3_, int p_generateChest_4_, int p_generateChest_5_, int p_generateChest_6_, ResourceLocation p_generateChest_7_) {
        BlockPos blockpos = new BlockPos(this.getXWithOffset(p_generateChest_4_, p_generateChest_6_), this.getYWithOffset(p_generateChest_5_), this.getZWithOffset(p_generateChest_4_, p_generateChest_6_));
        return this.generateChest(p_generateChest_1_, p_generateChest_2_, p_generateChest_3_, blockpos, p_generateChest_7_, null);
    }

    protected boolean generateChest(World p_generateChest_1_, StructureBoundingBox p_generateChest_2_, Random p_generateChest_3_, BlockPos p_generateChest_4_, ResourceLocation p_generateChest_5_, IBlockState p_generateChest_6_) {
        if (p_generateChest_2_.isVecInside(p_generateChest_4_) && p_generateChest_1_.getBlockState(p_generateChest_4_).getBlock() != Blocks.CHEST) {
            if (p_generateChest_6_ == null) {
                p_generateChest_6_ = Blocks.CHEST.correctFacing(p_generateChest_1_, p_generateChest_4_, Blocks.CHEST.getDefaultState());
            }
            p_generateChest_1_.setBlockState(p_generateChest_4_, p_generateChest_6_, 2);
            TileEntity tileentity = p_generateChest_1_.getTileEntity(p_generateChest_4_);
            if (tileentity instanceof TileEntityChest) {
                ((TileEntityChest)tileentity).setLootTable(p_generateChest_5_, p_generateChest_3_.nextLong());
            }
            return true;
        }
        return false;
    }

    protected boolean createDispenser(World p_createDispenser_1_, StructureBoundingBox p_createDispenser_2_, Random p_createDispenser_3_, int p_createDispenser_4_, int p_createDispenser_5_, int p_createDispenser_6_, EnumFacing p_createDispenser_7_, ResourceLocation p_createDispenser_8_) {
        BlockPos blockpos = new BlockPos(this.getXWithOffset(p_createDispenser_4_, p_createDispenser_6_), this.getYWithOffset(p_createDispenser_5_), this.getZWithOffset(p_createDispenser_4_, p_createDispenser_6_));
        if (p_createDispenser_2_.isVecInside(blockpos) && p_createDispenser_1_.getBlockState(blockpos).getBlock() != Blocks.DISPENSER) {
            this.setBlockState(p_createDispenser_1_, Blocks.DISPENSER.getDefaultState().withProperty(BlockDispenser.FACING, p_createDispenser_7_), p_createDispenser_4_, p_createDispenser_5_, p_createDispenser_6_, p_createDispenser_2_);
            TileEntity tileentity = p_createDispenser_1_.getTileEntity(blockpos);
            if (tileentity instanceof TileEntityDispenser) {
                ((TileEntityDispenser)tileentity).setLootTable(p_createDispenser_8_, p_createDispenser_3_.nextLong());
            }
            return true;
        }
        return false;
    }

    protected void generateDoor(World p_generateDoor_1_, StructureBoundingBox p_generateDoor_2_, Random p_generateDoor_3_, int p_generateDoor_4_, int p_generateDoor_5_, int p_generateDoor_6_, EnumFacing p_generateDoor_7_, BlockDoor p_generateDoor_8_) {
        this.setBlockState(p_generateDoor_1_, p_generateDoor_8_.getDefaultState().withProperty(BlockDoor.FACING, p_generateDoor_7_), p_generateDoor_4_, p_generateDoor_5_, p_generateDoor_6_, p_generateDoor_2_);
        this.setBlockState(p_generateDoor_1_, p_generateDoor_8_.getDefaultState().withProperty(BlockDoor.FACING, p_generateDoor_7_).withProperty(BlockDoor.HALF, BlockDoor.EnumDoorHalf.UPPER), p_generateDoor_4_, p_generateDoor_5_ + 1, p_generateDoor_6_, p_generateDoor_2_);
    }

    public void offset(int p_offset_1_, int p_offset_2_, int p_offset_3_) {
        this.boundingBox.offset(p_offset_1_, p_offset_2_, p_offset_3_);
    }

    @Nullable
    public EnumFacing getCoordBaseMode() {
        return this.coordBaseMode;
    }

    public void setCoordBaseMode(EnumFacing p_setCoordBaseMode_1_) {
        this.coordBaseMode = p_setCoordBaseMode_1_;
        if (p_setCoordBaseMode_1_ == null) {
            this.rotation = Rotation.NONE;
            this.mirror = Mirror.NONE;
        } else {
            switch (p_setCoordBaseMode_1_) {
                case SOUTH: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    this.rotation = Rotation.NONE;
                    break;
                }
                case WEST: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    this.rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                case EAST: {
                    this.mirror = Mirror.NONE;
                    this.rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                default: {
                    this.mirror = Mirror.NONE;
                    this.rotation = Rotation.NONE;
                }
            }
        }
    }

    public static abstract class BlockSelector {
        protected IBlockState blockstate = Blocks.AIR.getDefaultState();

        public abstract void selectBlocks(Random var1, int var2, int var3, int var4, boolean var5);

        public IBlockState getBlockState() {
            return this.blockstate;
        }
    }
}

