/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import java.util.Map;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public abstract class StructureComponentTemplate
extends StructureComponent {
    private static final PlacementSettings DEFAULT_PLACE_SETTINGS = new PlacementSettings();
    protected Template template;
    protected PlacementSettings placeSettings = DEFAULT_PLACE_SETTINGS.setIgnoreEntities(true).setReplacedBlock(Blocks.AIR);
    protected BlockPos templatePosition;

    public StructureComponentTemplate() {
    }

    public StructureComponentTemplate(int p_i46662_1_) {
        super(p_i46662_1_);
    }

    protected void setup(Template p_setup_1_, BlockPos p_setup_2_, PlacementSettings p_setup_3_) {
        this.template = p_setup_1_;
        this.setCoordBaseMode(EnumFacing.NORTH);
        this.templatePosition = p_setup_2_;
        this.placeSettings = p_setup_3_;
        this.setBoundingBoxFromTemplate();
    }

    @Override
    protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
        p_writeStructureToNBT_1_.setInteger("TPX", this.templatePosition.getX());
        p_writeStructureToNBT_1_.setInteger("TPY", this.templatePosition.getY());
        p_writeStructureToNBT_1_.setInteger("TPZ", this.templatePosition.getZ());
    }

    @Override
    protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
        this.templatePosition = new BlockPos(p_readStructureFromNBT_1_.getInteger("TPX"), p_readStructureFromNBT_1_.getInteger("TPY"), p_readStructureFromNBT_1_.getInteger("TPZ"));
    }

    @Override
    public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
        this.placeSettings.setBoundingBox(p_addComponentParts_3_);
        this.template.addBlocksToWorld(p_addComponentParts_1_, this.templatePosition, this.placeSettings, 18);
        Map<BlockPos, String> lvt_4_1_ = this.template.getDataBlocks(this.templatePosition, this.placeSettings);
        for (Map.Entry<BlockPos, String> lvt_6_1_ : lvt_4_1_.entrySet()) {
            String lvt_7_1_ = lvt_6_1_.getValue();
            this.handleDataMarker(lvt_7_1_, lvt_6_1_.getKey(), p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_);
        }
        return true;
    }

    protected abstract void handleDataMarker(String var1, BlockPos var2, World var3, Random var4, StructureBoundingBox var5);

    private void setBoundingBoxFromTemplate() {
        Rotation lvt_1_1_ = this.placeSettings.getRotation();
        BlockPos lvt_2_1_ = this.template.transformedSize(lvt_1_1_);
        Mirror lvt_3_1_ = this.placeSettings.getMirror();
        this.boundingBox = new StructureBoundingBox(0, 0, 0, lvt_2_1_.getX(), lvt_2_1_.getY() - 1, lvt_2_1_.getZ());
        switch (lvt_1_1_) {
            case NONE: {
                break;
            }
            case CLOCKWISE_90: {
                this.boundingBox.offset(-lvt_2_1_.getX(), 0, 0);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                this.boundingBox.offset(0, 0, -lvt_2_1_.getZ());
                break;
            }
            case CLOCKWISE_180: {
                this.boundingBox.offset(-lvt_2_1_.getX(), 0, -lvt_2_1_.getZ());
            }
        }
        switch (lvt_3_1_) {
            case NONE: {
                break;
            }
            case FRONT_BACK: {
                BlockPos lvt_4_1_ = BlockPos.ORIGIN;
                lvt_4_1_ = lvt_1_1_ == Rotation.CLOCKWISE_90 || lvt_1_1_ == Rotation.COUNTERCLOCKWISE_90 ? lvt_4_1_.offset(lvt_1_1_.rotate(EnumFacing.WEST), lvt_2_1_.getZ()) : (lvt_1_1_ == Rotation.CLOCKWISE_180 ? lvt_4_1_.offset(EnumFacing.EAST, lvt_2_1_.getX()) : lvt_4_1_.offset(EnumFacing.WEST, lvt_2_1_.getX()));
                this.boundingBox.offset(lvt_4_1_.getX(), 0, lvt_4_1_.getZ());
                break;
            }
            case LEFT_RIGHT: {
                BlockPos lvt_4_2_ = BlockPos.ORIGIN;
                lvt_4_2_ = lvt_1_1_ == Rotation.CLOCKWISE_90 || lvt_1_1_ == Rotation.COUNTERCLOCKWISE_90 ? lvt_4_2_.offset(lvt_1_1_.rotate(EnumFacing.NORTH), lvt_2_1_.getX()) : (lvt_1_1_ == Rotation.CLOCKWISE_180 ? lvt_4_2_.offset(EnumFacing.SOUTH, lvt_2_1_.getZ()) : lvt_4_2_.offset(EnumFacing.NORTH, lvt_2_1_.getZ()));
                this.boundingBox.offset(lvt_4_2_.getX(), 0, lvt_4_2_.getZ());
            }
        }
        this.boundingBox.offset(this.templatePosition.getX(), this.templatePosition.getY(), this.templatePosition.getZ());
    }

    @Override
    public void offset(int p_offset_1_, int p_offset_2_, int p_offset_3_) {
        super.offset(p_offset_1_, p_offset_2_, p_offset_3_);
        this.templatePosition = this.templatePosition.add(p_offset_1_, p_offset_2_, p_offset_3_);
    }
}

