/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureComponentTemplate;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class StructureEndCityPieces {
    private static final PlacementSettings OVERWRITE = new PlacementSettings().setIgnoreEntities(true);
    private static final PlacementSettings INSERT = new PlacementSettings().setIgnoreEntities(true).setReplacedBlock(Blocks.AIR);
    private static final IGenerator HOUSE_TOWER_GENERATOR = new IGenerator(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(TemplateManager p_generate_1_, int p_generate_2_, CityTemplate p_generate_3_, BlockPos p_generate_4_, List<StructureComponent> p_generate_5_, Random p_generate_6_) {
            if (p_generate_2_ > 8) {
                return false;
            }
            Rotation lvt_7_1_ = p_generate_3_.placeSettings.getRotation();
            CityTemplate lvt_8_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, p_generate_3_, p_generate_4_, "base_floor", lvt_7_1_, true));
            int lvt_9_1_ = p_generate_6_.nextInt(3);
            if (lvt_9_1_ == 0) {
                lvt_8_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_8_1_, new BlockPos(-1, 4, -1), "base_roof", lvt_7_1_, true));
            } else if (lvt_9_1_ == 1) {
                lvt_8_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_8_1_, new BlockPos(-1, 0, -1), "second_floor_2", lvt_7_1_, false));
                lvt_8_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_8_1_, new BlockPos(-1, 8, -1), "second_roof", lvt_7_1_, false));
                StructureEndCityPieces.recursiveChildren(p_generate_1_, TOWER_GENERATOR, p_generate_2_ + 1, lvt_8_1_, null, p_generate_5_, p_generate_6_);
            } else if (lvt_9_1_ == 2) {
                lvt_8_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_8_1_, new BlockPos(-1, 0, -1), "second_floor_2", lvt_7_1_, false));
                lvt_8_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_8_1_, new BlockPos(-1, 4, -1), "third_floor_c", lvt_7_1_, false));
                lvt_8_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_8_1_, new BlockPos(-1, 8, -1), "third_roof", lvt_7_1_, true));
                StructureEndCityPieces.recursiveChildren(p_generate_1_, TOWER_GENERATOR, p_generate_2_ + 1, lvt_8_1_, null, p_generate_5_, p_generate_6_);
            }
            return true;
        }
    };
    private static final List<Tuple<Rotation, BlockPos>> TOWER_BRIDGES = Lists.newArrayList((Object[])new Tuple[]{new Tuple<Rotation, BlockPos>(Rotation.NONE, new BlockPos(1, -1, 0)), new Tuple<Rotation, BlockPos>(Rotation.CLOCKWISE_90, new BlockPos(6, -1, 1)), new Tuple<Rotation, BlockPos>(Rotation.COUNTERCLOCKWISE_90, new BlockPos(0, -1, 5)), new Tuple<Rotation, BlockPos>(Rotation.CLOCKWISE_180, new BlockPos(5, -1, 6))});
    private static final IGenerator TOWER_GENERATOR = new IGenerator(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(TemplateManager p_generate_1_, int p_generate_2_, CityTemplate p_generate_3_, BlockPos p_generate_4_, List<StructureComponent> p_generate_5_, Random p_generate_6_) {
            Rotation lvt_7_1_ = p_generate_3_.placeSettings.getRotation();
            CityTemplate lvt_8_1_ = p_generate_3_;
            lvt_8_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_8_1_, new BlockPos(3 + p_generate_6_.nextInt(2), -3, 3 + p_generate_6_.nextInt(2)), "tower_base", lvt_7_1_, true));
            lvt_8_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_8_1_, new BlockPos(0, 7, 0), "tower_piece", lvt_7_1_, true));
            CityTemplate lvt_9_1_ = p_generate_6_.nextInt(3) == 0 ? lvt_8_1_ : null;
            int lvt_10_1_ = 1 + p_generate_6_.nextInt(3);
            for (int lvt_11_1_ = 0; lvt_11_1_ < lvt_10_1_; ++lvt_11_1_) {
                lvt_8_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_8_1_, new BlockPos(0, 4, 0), "tower_piece", lvt_7_1_, true));
                if (lvt_11_1_ >= lvt_10_1_ - 1 || !p_generate_6_.nextBoolean()) continue;
                lvt_9_1_ = lvt_8_1_;
            }
            if (lvt_9_1_ != null) {
                for (Tuple lvt_12_1_ : TOWER_BRIDGES) {
                    if (!p_generate_6_.nextBoolean()) continue;
                    CityTemplate lvt_13_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_9_1_, (BlockPos)lvt_12_1_.getSecond(), "bridge_end", lvt_7_1_.add((Rotation)((Object)lvt_12_1_.getFirst())), true));
                    StructureEndCityPieces.recursiveChildren(p_generate_1_, TOWER_BRIDGE_GENERATOR, p_generate_2_ + 1, lvt_13_1_, null, p_generate_5_, p_generate_6_);
                }
                lvt_8_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_8_1_, new BlockPos(-1, 4, -1), "tower_top", lvt_7_1_, true));
            } else if (p_generate_2_ == 7) {
                lvt_8_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_8_1_, new BlockPos(-1, 4, -1), "tower_top", lvt_7_1_, true));
            } else {
                return StructureEndCityPieces.recursiveChildren(p_generate_1_, FAT_TOWER_GENERATOR, p_generate_2_ + 1, lvt_8_1_, null, p_generate_5_, p_generate_6_);
            }
            return true;
        }
    };
    private static final IGenerator TOWER_BRIDGE_GENERATOR = new IGenerator(){
        public boolean shipCreated;

        @Override
        public void init() {
            this.shipCreated = false;
        }

        @Override
        public boolean generate(TemplateManager p_generate_1_, int p_generate_2_, CityTemplate p_generate_3_, BlockPos p_generate_4_, List<StructureComponent> p_generate_5_, Random p_generate_6_) {
            Rotation lvt_7_1_ = p_generate_3_.placeSettings.getRotation();
            int lvt_8_1_ = p_generate_6_.nextInt(4) + 1;
            CityTemplate lvt_9_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, p_generate_3_, new BlockPos(0, 0, -4), "bridge_piece", lvt_7_1_, true));
            lvt_9_1_.componentType = -1;
            int lvt_10_1_ = 0;
            for (int lvt_11_1_ = 0; lvt_11_1_ < lvt_8_1_; ++lvt_11_1_) {
                if (p_generate_6_.nextBoolean()) {
                    lvt_9_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_9_1_, new BlockPos(0, lvt_10_1_, -4), "bridge_piece", lvt_7_1_, true));
                    lvt_10_1_ = 0;
                    continue;
                }
                lvt_9_1_ = p_generate_6_.nextBoolean() ? StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_9_1_, new BlockPos(0, lvt_10_1_, -4), "bridge_steep_stairs", lvt_7_1_, true)) : StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_9_1_, new BlockPos(0, lvt_10_1_, -8), "bridge_gentle_stairs", lvt_7_1_, true));
                lvt_10_1_ = 4;
            }
            if (this.shipCreated || p_generate_6_.nextInt(10 - p_generate_2_) != 0) {
                if (!StructureEndCityPieces.recursiveChildren(p_generate_1_, HOUSE_TOWER_GENERATOR, p_generate_2_ + 1, lvt_9_1_, new BlockPos(-3, lvt_10_1_ + 1, -11), p_generate_5_, p_generate_6_)) {
                    return false;
                }
            } else {
                StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_9_1_, new BlockPos(-8 + p_generate_6_.nextInt(8), lvt_10_1_, -70 + p_generate_6_.nextInt(10)), "ship", lvt_7_1_, true));
                this.shipCreated = true;
            }
            lvt_9_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_9_1_, new BlockPos(4, lvt_10_1_, 0), "bridge_end", lvt_7_1_.add(Rotation.CLOCKWISE_180), true));
            lvt_9_1_.componentType = -1;
            return true;
        }
    };
    private static final List<Tuple<Rotation, BlockPos>> FAT_TOWER_BRIDGES = Lists.newArrayList((Object[])new Tuple[]{new Tuple<Rotation, BlockPos>(Rotation.NONE, new BlockPos(4, -1, 0)), new Tuple<Rotation, BlockPos>(Rotation.CLOCKWISE_90, new BlockPos(12, -1, 4)), new Tuple<Rotation, BlockPos>(Rotation.COUNTERCLOCKWISE_90, new BlockPos(0, -1, 8)), new Tuple<Rotation, BlockPos>(Rotation.CLOCKWISE_180, new BlockPos(8, -1, 12))});
    private static final IGenerator FAT_TOWER_GENERATOR = new IGenerator(){

        @Override
        public void init() {
        }

        @Override
        public boolean generate(TemplateManager p_generate_1_, int p_generate_2_, CityTemplate p_generate_3_, BlockPos p_generate_4_, List<StructureComponent> p_generate_5_, Random p_generate_6_) {
            Rotation lvt_8_1_ = p_generate_3_.placeSettings.getRotation();
            CityTemplate lvt_7_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, p_generate_3_, new BlockPos(-3, 4, -3), "fat_tower_base", lvt_8_1_, true));
            lvt_7_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_7_1_, new BlockPos(0, 4, 0), "fat_tower_middle", lvt_8_1_, true));
            for (int lvt_9_1_ = 0; lvt_9_1_ < 2 && p_generate_6_.nextInt(3) != 0; ++lvt_9_1_) {
                lvt_7_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_7_1_, new BlockPos(0, 8, 0), "fat_tower_middle", lvt_8_1_, true));
                for (Tuple lvt_11_1_ : FAT_TOWER_BRIDGES) {
                    if (!p_generate_6_.nextBoolean()) continue;
                    CityTemplate lvt_12_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_7_1_, (BlockPos)lvt_11_1_.getSecond(), "bridge_end", lvt_8_1_.add((Rotation)((Object)lvt_11_1_.getFirst())), true));
                    StructureEndCityPieces.recursiveChildren(p_generate_1_, TOWER_BRIDGE_GENERATOR, p_generate_2_ + 1, lvt_12_1_, null, p_generate_5_, p_generate_6_);
                }
            }
            lvt_7_1_ = StructureEndCityPieces.addHelper(p_generate_5_, StructureEndCityPieces.addPiece(p_generate_1_, lvt_7_1_, new BlockPos(-2, 8, -2), "fat_tower_top", lvt_8_1_, true));
            return true;
        }
    };

    public static void registerPieces() {
        MapGenStructureIO.registerStructureComponent(CityTemplate.class, "ECP");
    }

    private static CityTemplate addPiece(TemplateManager p_addPiece_0_, CityTemplate p_addPiece_1_, BlockPos p_addPiece_2_, String p_addPiece_3_, Rotation p_addPiece_4_, boolean p_addPiece_5_) {
        CityTemplate lvt_6_1_ = new CityTemplate(p_addPiece_0_, p_addPiece_3_, p_addPiece_1_.templatePosition, p_addPiece_4_, p_addPiece_5_);
        BlockPos lvt_7_1_ = p_addPiece_1_.template.calculateConnectedPos(p_addPiece_1_.placeSettings, p_addPiece_2_, lvt_6_1_.placeSettings, BlockPos.ORIGIN);
        lvt_6_1_.offset(lvt_7_1_.getX(), lvt_7_1_.getY(), lvt_7_1_.getZ());
        return lvt_6_1_;
    }

    public static void startHouseTower(TemplateManager p_startHouseTower_0_, BlockPos p_startHouseTower_1_, Rotation p_startHouseTower_2_, List<StructureComponent> p_startHouseTower_3_, Random p_startHouseTower_4_) {
        FAT_TOWER_GENERATOR.init();
        HOUSE_TOWER_GENERATOR.init();
        TOWER_BRIDGE_GENERATOR.init();
        TOWER_GENERATOR.init();
        CityTemplate lvt_5_1_ = StructureEndCityPieces.addHelper(p_startHouseTower_3_, new CityTemplate(p_startHouseTower_0_, "base_floor", p_startHouseTower_1_, p_startHouseTower_2_, true));
        lvt_5_1_ = StructureEndCityPieces.addHelper(p_startHouseTower_3_, StructureEndCityPieces.addPiece(p_startHouseTower_0_, lvt_5_1_, new BlockPos(-1, 0, -1), "second_floor", p_startHouseTower_2_, false));
        lvt_5_1_ = StructureEndCityPieces.addHelper(p_startHouseTower_3_, StructureEndCityPieces.addPiece(p_startHouseTower_0_, lvt_5_1_, new BlockPos(-1, 4, -1), "third_floor", p_startHouseTower_2_, false));
        lvt_5_1_ = StructureEndCityPieces.addHelper(p_startHouseTower_3_, StructureEndCityPieces.addPiece(p_startHouseTower_0_, lvt_5_1_, new BlockPos(-1, 8, -1), "third_roof", p_startHouseTower_2_, true));
        StructureEndCityPieces.recursiveChildren(p_startHouseTower_0_, TOWER_GENERATOR, 1, lvt_5_1_, null, p_startHouseTower_3_, p_startHouseTower_4_);
    }

    private static CityTemplate addHelper(List<StructureComponent> p_addHelper_0_, CityTemplate p_addHelper_1_) {
        p_addHelper_0_.add(p_addHelper_1_);
        return p_addHelper_1_;
    }

    private static boolean recursiveChildren(TemplateManager p_recursiveChildren_0_, IGenerator p_recursiveChildren_1_, int p_recursiveChildren_2_, CityTemplate p_recursiveChildren_3_, BlockPos p_recursiveChildren_4_, List<StructureComponent> p_recursiveChildren_5_, Random p_recursiveChildren_6_) {
        if (p_recursiveChildren_2_ > 8) {
            return false;
        }
        ArrayList lvt_7_1_ = Lists.newArrayList();
        if (p_recursiveChildren_1_.generate(p_recursiveChildren_0_, p_recursiveChildren_2_, p_recursiveChildren_3_, p_recursiveChildren_4_, lvt_7_1_, p_recursiveChildren_6_)) {
            boolean lvt_8_1_ = false;
            int lvt_9_1_ = p_recursiveChildren_6_.nextInt();
            for (StructureComponent lvt_11_1_ : lvt_7_1_) {
                lvt_11_1_.componentType = lvt_9_1_;
                StructureComponent lvt_12_1_ = StructureComponent.findIntersecting(p_recursiveChildren_5_, lvt_11_1_.getBoundingBox());
                if (lvt_12_1_ == null || lvt_12_1_.componentType == p_recursiveChildren_3_.componentType) continue;
                lvt_8_1_ = true;
                break;
            }
            if (!lvt_8_1_) {
                p_recursiveChildren_5_.addAll(lvt_7_1_);
                return true;
            }
        }
        return false;
    }

    static interface IGenerator {
        public void init();

        public boolean generate(TemplateManager var1, int var2, CityTemplate var3, BlockPos var4, List<StructureComponent> var5, Random var6);
    }

    public static class CityTemplate
    extends StructureComponentTemplate {
        private String pieceName;
        private Rotation rotation;
        private boolean overwrite;

        public CityTemplate() {
        }

        public CityTemplate(TemplateManager p_i47214_1_, String p_i47214_2_, BlockPos p_i47214_3_, Rotation p_i47214_4_, boolean p_i47214_5_) {
            super(0);
            this.pieceName = p_i47214_2_;
            this.templatePosition = p_i47214_3_;
            this.rotation = p_i47214_4_;
            this.overwrite = p_i47214_5_;
            this.loadTemplate(p_i47214_1_);
        }

        private void loadTemplate(TemplateManager p_loadTemplate_1_) {
            Template lvt_2_1_ = p_loadTemplate_1_.getTemplate(null, new ResourceLocation("endcity/" + this.pieceName));
            PlacementSettings lvt_3_1_ = (this.overwrite ? OVERWRITE : INSERT).copy().setRotation(this.rotation);
            this.setup(lvt_2_1_, this.templatePosition, lvt_3_1_);
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setString("Template", this.pieceName);
            p_writeStructureToNBT_1_.setString("Rot", this.rotation.name());
            p_writeStructureToNBT_1_.setBoolean("OW", this.overwrite);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.pieceName = p_readStructureFromNBT_1_.getString("Template");
            this.rotation = Rotation.valueOf(p_readStructureFromNBT_1_.getString("Rot"));
            this.overwrite = p_readStructureFromNBT_1_.getBoolean("OW");
            this.loadTemplate(p_readStructureFromNBT_2_);
        }

        @Override
        protected void handleDataMarker(String p_handleDataMarker_1_, BlockPos p_handleDataMarker_2_, World p_handleDataMarker_3_, Random p_handleDataMarker_4_, StructureBoundingBox p_handleDataMarker_5_) {
            if (p_handleDataMarker_1_.startsWith("Chest")) {
                TileEntity lvt_7_1_;
                BlockPos lvt_6_1_ = p_handleDataMarker_2_.down();
                if (p_handleDataMarker_5_.isVecInside(lvt_6_1_) && (lvt_7_1_ = p_handleDataMarker_3_.getTileEntity(lvt_6_1_)) instanceof TileEntityChest) {
                    ((TileEntityChest)lvt_7_1_).setLootTable(LootTableList.CHESTS_END_CITY_TREASURE, p_handleDataMarker_4_.nextLong());
                }
            } else if (p_handleDataMarker_1_.startsWith("Sentry")) {
                EntityShulker lvt_6_2_ = new EntityShulker(p_handleDataMarker_3_);
                lvt_6_2_.setPosition((double)p_handleDataMarker_2_.getX() + 0.5, (double)p_handleDataMarker_2_.getY() + 0.5, (double)p_handleDataMarker_2_.getZ() + 0.5);
                lvt_6_2_.setAttachmentPos(p_handleDataMarker_2_);
                p_handleDataMarker_3_.spawnEntity(lvt_6_2_);
            } else if (p_handleDataMarker_1_.startsWith("Elytra")) {
                EntityItemFrame lvt_6_3_ = new EntityItemFrame(p_handleDataMarker_3_, p_handleDataMarker_2_, this.rotation.rotate(EnumFacing.SOUTH));
                lvt_6_3_.setDisplayedItem(new ItemStack(Items.ELYTRA));
                p_handleDataMarker_3_.spawnEntity(lvt_6_3_);
            }
        }
    }
}

