/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class StructureMineshaftPieces {
    public static void registerStructurePieces() {
        MapGenStructureIO.registerStructureComponent(Corridor.class, "MSCorridor");
        MapGenStructureIO.registerStructureComponent(Cross.class, "MSCrossing");
        MapGenStructureIO.registerStructureComponent(Room.class, "MSRoom");
        MapGenStructureIO.registerStructureComponent(Stairs.class, "MSStairs");
    }

    private static Peice createRandomShaftPiece(List<StructureComponent> p_createRandomShaftPiece_0_, Random p_createRandomShaftPiece_1_, int p_createRandomShaftPiece_2_, int p_createRandomShaftPiece_3_, int p_createRandomShaftPiece_4_, EnumFacing p_createRandomShaftPiece_5_, int p_createRandomShaftPiece_6_, MapGenMineshaft.Type p_createRandomShaftPiece_7_) {
        int lvt_8_1_ = p_createRandomShaftPiece_1_.nextInt(100);
        if (lvt_8_1_ >= 80) {
            StructureBoundingBox lvt_9_1_ = Cross.findCrossing(p_createRandomShaftPiece_0_, p_createRandomShaftPiece_1_, p_createRandomShaftPiece_2_, p_createRandomShaftPiece_3_, p_createRandomShaftPiece_4_, p_createRandomShaftPiece_5_);
            if (lvt_9_1_ != null) {
                return new Cross(p_createRandomShaftPiece_6_, p_createRandomShaftPiece_1_, lvt_9_1_, p_createRandomShaftPiece_5_, p_createRandomShaftPiece_7_);
            }
        } else if (lvt_8_1_ >= 70) {
            StructureBoundingBox lvt_9_2_ = Stairs.findStairs(p_createRandomShaftPiece_0_, p_createRandomShaftPiece_1_, p_createRandomShaftPiece_2_, p_createRandomShaftPiece_3_, p_createRandomShaftPiece_4_, p_createRandomShaftPiece_5_);
            if (lvt_9_2_ != null) {
                return new Stairs(p_createRandomShaftPiece_6_, p_createRandomShaftPiece_1_, lvt_9_2_, p_createRandomShaftPiece_5_, p_createRandomShaftPiece_7_);
            }
        } else {
            StructureBoundingBox lvt_9_3_ = Corridor.findCorridorSize(p_createRandomShaftPiece_0_, p_createRandomShaftPiece_1_, p_createRandomShaftPiece_2_, p_createRandomShaftPiece_3_, p_createRandomShaftPiece_4_, p_createRandomShaftPiece_5_);
            if (lvt_9_3_ != null) {
                return new Corridor(p_createRandomShaftPiece_6_, p_createRandomShaftPiece_1_, lvt_9_3_, p_createRandomShaftPiece_5_, p_createRandomShaftPiece_7_);
            }
        }
        return null;
    }

    private static Peice generateAndAddPiece(StructureComponent p_generateAndAddPiece_0_, List<StructureComponent> p_generateAndAddPiece_1_, Random p_generateAndAddPiece_2_, int p_generateAndAddPiece_3_, int p_generateAndAddPiece_4_, int p_generateAndAddPiece_5_, EnumFacing p_generateAndAddPiece_6_, int p_generateAndAddPiece_7_) {
        if (p_generateAndAddPiece_7_ > 8) {
            return null;
        }
        if (Math.abs(p_generateAndAddPiece_3_ - p_generateAndAddPiece_0_.getBoundingBox().minX) > 80 || Math.abs(p_generateAndAddPiece_5_ - p_generateAndAddPiece_0_.getBoundingBox().minZ) > 80) {
            return null;
        }
        MapGenMineshaft.Type lvt_8_1_ = ((Peice)p_generateAndAddPiece_0_).mineShaftType;
        Peice lvt_9_1_ = StructureMineshaftPieces.createRandomShaftPiece(p_generateAndAddPiece_1_, p_generateAndAddPiece_2_, p_generateAndAddPiece_3_, p_generateAndAddPiece_4_, p_generateAndAddPiece_5_, p_generateAndAddPiece_6_, p_generateAndAddPiece_7_ + 1, lvt_8_1_);
        if (lvt_9_1_ != null) {
            p_generateAndAddPiece_1_.add(lvt_9_1_);
            lvt_9_1_.buildComponent(p_generateAndAddPiece_0_, p_generateAndAddPiece_1_, p_generateAndAddPiece_2_);
        }
        return lvt_9_1_;
    }

    public static class Stairs
    extends Peice {
        public Stairs() {
        }

        public Stairs(int p_i47136_1_, Random p_i47136_2_, StructureBoundingBox p_i47136_3_, EnumFacing p_i47136_4_, MapGenMineshaft.Type p_i47136_5_) {
            super(p_i47136_1_, p_i47136_5_);
            this.setCoordBaseMode(p_i47136_4_);
            this.boundingBox = p_i47136_3_;
        }

        public static StructureBoundingBox findStairs(List<StructureComponent> p_findStairs_0_, Random p_findStairs_1_, int p_findStairs_2_, int p_findStairs_3_, int p_findStairs_4_, EnumFacing p_findStairs_5_) {
            StructureBoundingBox lvt_6_1_ = new StructureBoundingBox(p_findStairs_2_, p_findStairs_3_ - 5, p_findStairs_4_, p_findStairs_2_, p_findStairs_3_ + 2, p_findStairs_4_);
            switch (p_findStairs_5_) {
                default: {
                    lvt_6_1_.maxX = p_findStairs_2_ + 2;
                    lvt_6_1_.minZ = p_findStairs_4_ - 8;
                    break;
                }
                case SOUTH: {
                    lvt_6_1_.maxX = p_findStairs_2_ + 2;
                    lvt_6_1_.maxZ = p_findStairs_4_ + 8;
                    break;
                }
                case WEST: {
                    lvt_6_1_.minX = p_findStairs_2_ - 8;
                    lvt_6_1_.maxZ = p_findStairs_4_ + 2;
                    break;
                }
                case EAST: {
                    lvt_6_1_.maxX = p_findStairs_2_ + 8;
                    lvt_6_1_.maxZ = p_findStairs_4_ + 2;
                }
            }
            if (StructureComponent.findIntersecting(p_findStairs_0_, lvt_6_1_) != null) {
                return null;
            }
            return lvt_6_1_;
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            int lvt_4_1_ = this.getComponentType();
            EnumFacing lvt_5_1_ = this.getCoordBaseMode();
            if (lvt_5_1_ != null) {
                switch (lvt_5_1_) {
                    default: {
                        StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX, this.boundingBox.minY, this.boundingBox.minZ - 1, EnumFacing.NORTH, lvt_4_1_);
                        break;
                    }
                    case SOUTH: {
                        StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX, this.boundingBox.minY, this.boundingBox.maxZ + 1, EnumFacing.SOUTH, lvt_4_1_);
                        break;
                    }
                    case WEST: {
                        StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX - 1, this.boundingBox.minY, this.boundingBox.minZ, EnumFacing.WEST, lvt_4_1_);
                        break;
                    }
                    case EAST: {
                        StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.maxX + 1, this.boundingBox.minY, this.boundingBox.minZ, EnumFacing.EAST, lvt_4_1_);
                    }
                }
            }
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.isLiquidInStructureBoundingBox(p_addComponentParts_1_, p_addComponentParts_3_)) {
                return false;
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5, 0, 2, 7, 1, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 7, 2, 2, 8, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            for (int lvt_4_1_ = 0; lvt_4_1_ < 5; ++lvt_4_1_) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5 - lvt_4_1_ - (lvt_4_1_ < 4 ? 1 : 0), 2 + lvt_4_1_, 2, 7 - lvt_4_1_, 2 + lvt_4_1_, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            }
            return true;
        }
    }

    public static class Cross
    extends Peice {
        private EnumFacing corridorDirection;
        private boolean isMultipleFloors;

        public Cross() {
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setBoolean("tf", this.isMultipleFloors);
            p_writeStructureToNBT_1_.setInteger("D", this.corridorDirection.getHorizontalIndex());
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.isMultipleFloors = p_readStructureFromNBT_1_.getBoolean("tf");
            this.corridorDirection = EnumFacing.getHorizontal(p_readStructureFromNBT_1_.getInteger("D"));
        }

        public Cross(int p_i47139_1_, Random p_i47139_2_, StructureBoundingBox p_i47139_3_, EnumFacing p_i47139_4_, MapGenMineshaft.Type p_i47139_5_) {
            super(p_i47139_1_, p_i47139_5_);
            this.corridorDirection = p_i47139_4_;
            this.boundingBox = p_i47139_3_;
            this.isMultipleFloors = p_i47139_3_.getYSize() > 3;
        }

        public static StructureBoundingBox findCrossing(List<StructureComponent> p_findCrossing_0_, Random p_findCrossing_1_, int p_findCrossing_2_, int p_findCrossing_3_, int p_findCrossing_4_, EnumFacing p_findCrossing_5_) {
            StructureBoundingBox lvt_6_1_ = new StructureBoundingBox(p_findCrossing_2_, p_findCrossing_3_, p_findCrossing_4_, p_findCrossing_2_, p_findCrossing_3_ + 2, p_findCrossing_4_);
            if (p_findCrossing_1_.nextInt(4) == 0) {
                lvt_6_1_.maxY += 4;
            }
            switch (p_findCrossing_5_) {
                default: {
                    lvt_6_1_.minX = p_findCrossing_2_ - 1;
                    lvt_6_1_.maxX = p_findCrossing_2_ + 3;
                    lvt_6_1_.minZ = p_findCrossing_4_ - 4;
                    break;
                }
                case SOUTH: {
                    lvt_6_1_.minX = p_findCrossing_2_ - 1;
                    lvt_6_1_.maxX = p_findCrossing_2_ + 3;
                    lvt_6_1_.maxZ = p_findCrossing_4_ + 3 + 1;
                    break;
                }
                case WEST: {
                    lvt_6_1_.minX = p_findCrossing_2_ - 4;
                    lvt_6_1_.minZ = p_findCrossing_4_ - 1;
                    lvt_6_1_.maxZ = p_findCrossing_4_ + 3;
                    break;
                }
                case EAST: {
                    lvt_6_1_.maxX = p_findCrossing_2_ + 3 + 1;
                    lvt_6_1_.minZ = p_findCrossing_4_ - 1;
                    lvt_6_1_.maxZ = p_findCrossing_4_ + 3;
                }
            }
            if (StructureComponent.findIntersecting(p_findCrossing_0_, lvt_6_1_) != null) {
                return null;
            }
            return lvt_6_1_;
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            int lvt_4_1_ = this.getComponentType();
            switch (this.corridorDirection) {
                default: {
                    StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX + 1, this.boundingBox.minY, this.boundingBox.minZ - 1, EnumFacing.NORTH, lvt_4_1_);
                    StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX - 1, this.boundingBox.minY, this.boundingBox.minZ + 1, EnumFacing.WEST, lvt_4_1_);
                    StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.maxX + 1, this.boundingBox.minY, this.boundingBox.minZ + 1, EnumFacing.EAST, lvt_4_1_);
                    break;
                }
                case SOUTH: {
                    StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX + 1, this.boundingBox.minY, this.boundingBox.maxZ + 1, EnumFacing.SOUTH, lvt_4_1_);
                    StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX - 1, this.boundingBox.minY, this.boundingBox.minZ + 1, EnumFacing.WEST, lvt_4_1_);
                    StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.maxX + 1, this.boundingBox.minY, this.boundingBox.minZ + 1, EnumFacing.EAST, lvt_4_1_);
                    break;
                }
                case WEST: {
                    StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX + 1, this.boundingBox.minY, this.boundingBox.minZ - 1, EnumFacing.NORTH, lvt_4_1_);
                    StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX + 1, this.boundingBox.minY, this.boundingBox.maxZ + 1, EnumFacing.SOUTH, lvt_4_1_);
                    StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX - 1, this.boundingBox.minY, this.boundingBox.minZ + 1, EnumFacing.WEST, lvt_4_1_);
                    break;
                }
                case EAST: {
                    StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX + 1, this.boundingBox.minY, this.boundingBox.minZ - 1, EnumFacing.NORTH, lvt_4_1_);
                    StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX + 1, this.boundingBox.minY, this.boundingBox.maxZ + 1, EnumFacing.SOUTH, lvt_4_1_);
                    StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.maxX + 1, this.boundingBox.minY, this.boundingBox.minZ + 1, EnumFacing.EAST, lvt_4_1_);
                }
            }
            if (this.isMultipleFloors) {
                if (p_buildComponent_3_.nextBoolean()) {
                    StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX + 1, this.boundingBox.minY + 3 + 1, this.boundingBox.minZ - 1, EnumFacing.NORTH, lvt_4_1_);
                }
                if (p_buildComponent_3_.nextBoolean()) {
                    StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX - 1, this.boundingBox.minY + 3 + 1, this.boundingBox.minZ + 1, EnumFacing.WEST, lvt_4_1_);
                }
                if (p_buildComponent_3_.nextBoolean()) {
                    StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.maxX + 1, this.boundingBox.minY + 3 + 1, this.boundingBox.minZ + 1, EnumFacing.EAST, lvt_4_1_);
                }
                if (p_buildComponent_3_.nextBoolean()) {
                    StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX + 1, this.boundingBox.minY + 3 + 1, this.boundingBox.maxZ + 1, EnumFacing.SOUTH, lvt_4_1_);
                }
            }
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.isLiquidInStructureBoundingBox(p_addComponentParts_1_, p_addComponentParts_3_)) {
                return false;
            }
            IBlockState lvt_4_1_ = this.getPlanksBlock();
            if (this.isMultipleFloors) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, this.boundingBox.minX + 1, this.boundingBox.minY, this.boundingBox.minZ, this.boundingBox.maxX - 1, this.boundingBox.minY + 3 - 1, this.boundingBox.maxZ, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, this.boundingBox.minX, this.boundingBox.minY, this.boundingBox.minZ + 1, this.boundingBox.maxX, this.boundingBox.minY + 3 - 1, this.boundingBox.maxZ - 1, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, this.boundingBox.minX + 1, this.boundingBox.maxY - 2, this.boundingBox.minZ, this.boundingBox.maxX - 1, this.boundingBox.maxY, this.boundingBox.maxZ, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, this.boundingBox.minX, this.boundingBox.maxY - 2, this.boundingBox.minZ + 1, this.boundingBox.maxX, this.boundingBox.maxY, this.boundingBox.maxZ - 1, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, this.boundingBox.minX + 1, this.boundingBox.minY + 3, this.boundingBox.minZ + 1, this.boundingBox.maxX - 1, this.boundingBox.minY + 3, this.boundingBox.maxZ - 1, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            } else {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, this.boundingBox.minX + 1, this.boundingBox.minY, this.boundingBox.minZ, this.boundingBox.maxX - 1, this.boundingBox.maxY, this.boundingBox.maxZ, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, this.boundingBox.minX, this.boundingBox.minY, this.boundingBox.minZ + 1, this.boundingBox.maxX, this.boundingBox.maxY, this.boundingBox.maxZ - 1, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            }
            this.placeSupportPillar(p_addComponentParts_1_, p_addComponentParts_3_, this.boundingBox.minX + 1, this.boundingBox.minY, this.boundingBox.minZ + 1, this.boundingBox.maxY);
            this.placeSupportPillar(p_addComponentParts_1_, p_addComponentParts_3_, this.boundingBox.minX + 1, this.boundingBox.minY, this.boundingBox.maxZ - 1, this.boundingBox.maxY);
            this.placeSupportPillar(p_addComponentParts_1_, p_addComponentParts_3_, this.boundingBox.maxX - 1, this.boundingBox.minY, this.boundingBox.minZ + 1, this.boundingBox.maxY);
            this.placeSupportPillar(p_addComponentParts_1_, p_addComponentParts_3_, this.boundingBox.maxX - 1, this.boundingBox.minY, this.boundingBox.maxZ - 1, this.boundingBox.maxY);
            for (int lvt_5_1_ = this.boundingBox.minX; lvt_5_1_ <= this.boundingBox.maxX; ++lvt_5_1_) {
                for (int lvt_6_1_ = this.boundingBox.minZ; lvt_6_1_ <= this.boundingBox.maxZ; ++lvt_6_1_) {
                    if (this.getBlockStateFromPos(p_addComponentParts_1_, lvt_5_1_, this.boundingBox.minY - 1, lvt_6_1_, p_addComponentParts_3_).getMaterial() != Material.AIR || this.getSkyBrightness(p_addComponentParts_1_, lvt_5_1_, this.boundingBox.minY - 1, lvt_6_1_, p_addComponentParts_3_) >= 8) continue;
                    this.setBlockState(p_addComponentParts_1_, lvt_4_1_, lvt_5_1_, this.boundingBox.minY - 1, lvt_6_1_, p_addComponentParts_3_);
                }
            }
            return true;
        }

        private void placeSupportPillar(World p_placeSupportPillar_1_, StructureBoundingBox p_placeSupportPillar_2_, int p_placeSupportPillar_3_, int p_placeSupportPillar_4_, int p_placeSupportPillar_5_, int p_placeSupportPillar_6_) {
            if (this.getBlockStateFromPos(p_placeSupportPillar_1_, p_placeSupportPillar_3_, p_placeSupportPillar_6_ + 1, p_placeSupportPillar_5_, p_placeSupportPillar_2_).getMaterial() != Material.AIR) {
                this.fillWithBlocks(p_placeSupportPillar_1_, p_placeSupportPillar_2_, p_placeSupportPillar_3_, p_placeSupportPillar_4_, p_placeSupportPillar_5_, p_placeSupportPillar_3_, p_placeSupportPillar_6_, p_placeSupportPillar_5_, this.getPlanksBlock(), Blocks.AIR.getDefaultState(), false);
            }
        }
    }

    public static class Corridor
    extends Peice {
        private boolean hasRails;
        private boolean hasSpiders;
        private boolean spawnerPlaced;
        private int sectionCount;

        public Corridor() {
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setBoolean("hr", this.hasRails);
            p_writeStructureToNBT_1_.setBoolean("sc", this.hasSpiders);
            p_writeStructureToNBT_1_.setBoolean("hps", this.spawnerPlaced);
            p_writeStructureToNBT_1_.setInteger("Num", this.sectionCount);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.hasRails = p_readStructureFromNBT_1_.getBoolean("hr");
            this.hasSpiders = p_readStructureFromNBT_1_.getBoolean("sc");
            this.spawnerPlaced = p_readStructureFromNBT_1_.getBoolean("hps");
            this.sectionCount = p_readStructureFromNBT_1_.getInteger("Num");
        }

        public Corridor(int p_i47140_1_, Random p_i47140_2_, StructureBoundingBox p_i47140_3_, EnumFacing p_i47140_4_, MapGenMineshaft.Type p_i47140_5_) {
            super(p_i47140_1_, p_i47140_5_);
            this.setCoordBaseMode(p_i47140_4_);
            this.boundingBox = p_i47140_3_;
            this.hasRails = p_i47140_2_.nextInt(3) == 0;
            this.hasSpiders = !this.hasRails && p_i47140_2_.nextInt(23) == 0;
            this.sectionCount = this.getCoordBaseMode().getAxis() == EnumFacing.Axis.Z ? p_i47140_3_.getZSize() / 5 : p_i47140_3_.getXSize() / 5;
        }

        public static StructureBoundingBox findCorridorSize(List<StructureComponent> p_findCorridorSize_0_, Random p_findCorridorSize_1_, int p_findCorridorSize_2_, int p_findCorridorSize_3_, int p_findCorridorSize_4_, EnumFacing p_findCorridorSize_5_) {
            int lvt_7_1_;
            StructureBoundingBox lvt_6_1_ = new StructureBoundingBox(p_findCorridorSize_2_, p_findCorridorSize_3_, p_findCorridorSize_4_, p_findCorridorSize_2_, p_findCorridorSize_3_ + 2, p_findCorridorSize_4_);
            for (lvt_7_1_ = p_findCorridorSize_1_.nextInt(3) + 2; lvt_7_1_ > 0; --lvt_7_1_) {
                int lvt_8_1_ = lvt_7_1_ * 5;
                switch (p_findCorridorSize_5_) {
                    default: {
                        lvt_6_1_.maxX = p_findCorridorSize_2_ + 2;
                        lvt_6_1_.minZ = p_findCorridorSize_4_ - (lvt_8_1_ - 1);
                        break;
                    }
                    case SOUTH: {
                        lvt_6_1_.maxX = p_findCorridorSize_2_ + 2;
                        lvt_6_1_.maxZ = p_findCorridorSize_4_ + (lvt_8_1_ - 1);
                        break;
                    }
                    case WEST: {
                        lvt_6_1_.minX = p_findCorridorSize_2_ - (lvt_8_1_ - 1);
                        lvt_6_1_.maxZ = p_findCorridorSize_4_ + 2;
                        break;
                    }
                    case EAST: {
                        lvt_6_1_.maxX = p_findCorridorSize_2_ + (lvt_8_1_ - 1);
                        lvt_6_1_.maxZ = p_findCorridorSize_4_ + 2;
                    }
                }
                if (StructureComponent.findIntersecting(p_findCorridorSize_0_, lvt_6_1_) == null) break;
            }
            if (lvt_7_1_ > 0) {
                return lvt_6_1_;
            }
            return null;
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            block24: {
                int lvt_4_1_ = this.getComponentType();
                int lvt_5_1_ = p_buildComponent_3_.nextInt(4);
                EnumFacing lvt_6_1_ = this.getCoordBaseMode();
                if (lvt_6_1_ != null) {
                    switch (lvt_6_1_) {
                        default: {
                            if (lvt_5_1_ <= 1) {
                                StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX, this.boundingBox.minY - 1 + p_buildComponent_3_.nextInt(3), this.boundingBox.minZ - 1, lvt_6_1_, lvt_4_1_);
                                break;
                            }
                            if (lvt_5_1_ == 2) {
                                StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX - 1, this.boundingBox.minY - 1 + p_buildComponent_3_.nextInt(3), this.boundingBox.minZ, EnumFacing.WEST, lvt_4_1_);
                                break;
                            }
                            StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.maxX + 1, this.boundingBox.minY - 1 + p_buildComponent_3_.nextInt(3), this.boundingBox.minZ, EnumFacing.EAST, lvt_4_1_);
                            break;
                        }
                        case SOUTH: {
                            if (lvt_5_1_ <= 1) {
                                StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX, this.boundingBox.minY - 1 + p_buildComponent_3_.nextInt(3), this.boundingBox.maxZ + 1, lvt_6_1_, lvt_4_1_);
                                break;
                            }
                            if (lvt_5_1_ == 2) {
                                StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX - 1, this.boundingBox.minY - 1 + p_buildComponent_3_.nextInt(3), this.boundingBox.maxZ - 3, EnumFacing.WEST, lvt_4_1_);
                                break;
                            }
                            StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.maxX + 1, this.boundingBox.minY - 1 + p_buildComponent_3_.nextInt(3), this.boundingBox.maxZ - 3, EnumFacing.EAST, lvt_4_1_);
                            break;
                        }
                        case WEST: {
                            if (lvt_5_1_ <= 1) {
                                StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX - 1, this.boundingBox.minY - 1 + p_buildComponent_3_.nextInt(3), this.boundingBox.minZ, lvt_6_1_, lvt_4_1_);
                                break;
                            }
                            if (lvt_5_1_ == 2) {
                                StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX, this.boundingBox.minY - 1 + p_buildComponent_3_.nextInt(3), this.boundingBox.minZ - 1, EnumFacing.NORTH, lvt_4_1_);
                                break;
                            }
                            StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX, this.boundingBox.minY - 1 + p_buildComponent_3_.nextInt(3), this.boundingBox.maxZ + 1, EnumFacing.SOUTH, lvt_4_1_);
                            break;
                        }
                        case EAST: {
                            if (lvt_5_1_ <= 1) {
                                StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.maxX + 1, this.boundingBox.minY - 1 + p_buildComponent_3_.nextInt(3), this.boundingBox.minZ, lvt_6_1_, lvt_4_1_);
                                break;
                            }
                            if (lvt_5_1_ == 2) {
                                StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.maxX - 3, this.boundingBox.minY - 1 + p_buildComponent_3_.nextInt(3), this.boundingBox.minZ - 1, EnumFacing.NORTH, lvt_4_1_);
                                break;
                            }
                            StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.maxX - 3, this.boundingBox.minY - 1 + p_buildComponent_3_.nextInt(3), this.boundingBox.maxZ + 1, EnumFacing.SOUTH, lvt_4_1_);
                        }
                    }
                }
                if (lvt_4_1_ >= 8) break block24;
                if (lvt_6_1_ == EnumFacing.NORTH || lvt_6_1_ == EnumFacing.SOUTH) {
                    int lvt_7_1_ = this.boundingBox.minZ + 3;
                    while (lvt_7_1_ + 3 <= this.boundingBox.maxZ) {
                        int lvt_8_1_ = p_buildComponent_3_.nextInt(5);
                        if (lvt_8_1_ == 0) {
                            StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX - 1, this.boundingBox.minY, lvt_7_1_, EnumFacing.WEST, lvt_4_1_ + 1);
                        } else if (lvt_8_1_ == 1) {
                            StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.maxX + 1, this.boundingBox.minY, lvt_7_1_, EnumFacing.EAST, lvt_4_1_ + 1);
                        }
                        lvt_7_1_ += 5;
                    }
                } else {
                    int lvt_7_2_ = this.boundingBox.minX + 3;
                    while (lvt_7_2_ + 3 <= this.boundingBox.maxX) {
                        int lvt_8_2_ = p_buildComponent_3_.nextInt(5);
                        if (lvt_8_2_ == 0) {
                            StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, lvt_7_2_, this.boundingBox.minY, this.boundingBox.minZ - 1, EnumFacing.NORTH, lvt_4_1_ + 1);
                        } else if (lvt_8_2_ == 1) {
                            StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, lvt_7_2_, this.boundingBox.minY, this.boundingBox.maxZ + 1, EnumFacing.SOUTH, lvt_4_1_ + 1);
                        }
                        lvt_7_2_ += 5;
                    }
                }
            }
        }

        @Override
        protected boolean generateChest(World p_generateChest_1_, StructureBoundingBox p_generateChest_2_, Random p_generateChest_3_, int p_generateChest_4_, int p_generateChest_5_, int p_generateChest_6_, ResourceLocation p_generateChest_7_) {
            BlockPos lvt_8_1_ = new BlockPos(this.getXWithOffset(p_generateChest_4_, p_generateChest_6_), this.getYWithOffset(p_generateChest_5_), this.getZWithOffset(p_generateChest_4_, p_generateChest_6_));
            if (p_generateChest_2_.isVecInside(lvt_8_1_) && p_generateChest_1_.getBlockState(lvt_8_1_).getMaterial() == Material.AIR && p_generateChest_1_.getBlockState(lvt_8_1_.down()).getMaterial() != Material.AIR) {
                IBlockState lvt_9_1_ = Blocks.RAIL.getDefaultState().withProperty(BlockRail.SHAPE, p_generateChest_3_.nextBoolean() ? BlockRailBase.EnumRailDirection.NORTH_SOUTH : BlockRailBase.EnumRailDirection.EAST_WEST);
                this.setBlockState(p_generateChest_1_, lvt_9_1_, p_generateChest_4_, p_generateChest_5_, p_generateChest_6_, p_generateChest_2_);
                EntityMinecartChest lvt_10_1_ = new EntityMinecartChest(p_generateChest_1_, (float)lvt_8_1_.getX() + 0.5f, (float)lvt_8_1_.getY() + 0.5f, (float)lvt_8_1_.getZ() + 0.5f);
                lvt_10_1_.setLootTable(p_generateChest_7_, p_generateChest_3_.nextLong());
                p_generateChest_1_.spawnEntity(lvt_10_1_);
                return true;
            }
            return false;
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.isLiquidInStructureBoundingBox(p_addComponentParts_1_, p_addComponentParts_3_)) {
                return false;
            }
            boolean lvt_4_1_ = false;
            int lvt_5_1_ = 2;
            boolean lvt_6_1_ = false;
            int lvt_7_1_ = 2;
            int lvt_8_1_ = this.sectionCount * 5 - 1;
            IBlockState lvt_9_1_ = this.getPlanksBlock();
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 2, 1, lvt_8_1_, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.generateMaybeBox(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 0.8f, 0, 2, 0, 2, 2, lvt_8_1_, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false, 0);
            if (this.hasSpiders) {
                this.generateMaybeBox(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 0.6f, 0, 0, 0, 2, 1, lvt_8_1_, Blocks.WEB.getDefaultState(), Blocks.AIR.getDefaultState(), false, 8);
            }
            for (int lvt_10_1_ = 0; lvt_10_1_ < this.sectionCount; ++lvt_10_1_) {
                int lvt_15_1_;
                int lvt_11_1_ = 2 + lvt_10_1_ * 5;
                this.placeSupport(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, lvt_11_1_, 2, 2, p_addComponentParts_2_);
                this.placeCobWeb(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 0.1f, 0, 2, lvt_11_1_ - 1);
                this.placeCobWeb(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 0.1f, 2, 2, lvt_11_1_ - 1);
                this.placeCobWeb(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 0.1f, 0, 2, lvt_11_1_ + 1);
                this.placeCobWeb(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 0.1f, 2, 2, lvt_11_1_ + 1);
                this.placeCobWeb(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 0.05f, 0, 2, lvt_11_1_ - 2);
                this.placeCobWeb(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 0.05f, 2, 2, lvt_11_1_ - 2);
                this.placeCobWeb(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 0.05f, 0, 2, lvt_11_1_ + 2);
                this.placeCobWeb(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 0.05f, 2, 2, lvt_11_1_ + 2);
                if (p_addComponentParts_2_.nextInt(100) == 0) {
                    this.generateChest(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 2, 0, lvt_11_1_ - 1, LootTableList.CHESTS_ABANDONED_MINESHAFT);
                }
                if (p_addComponentParts_2_.nextInt(100) == 0) {
                    this.generateChest(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 0, 0, lvt_11_1_ + 1, LootTableList.CHESTS_ABANDONED_MINESHAFT);
                }
                if (!this.hasSpiders || this.spawnerPlaced) continue;
                int lvt_12_1_ = this.getYWithOffset(0);
                int lvt_13_1_ = lvt_11_1_ - 1 + p_addComponentParts_2_.nextInt(3);
                int lvt_14_1_ = this.getXWithOffset(1, lvt_13_1_);
                BlockPos lvt_16_1_ = new BlockPos(lvt_14_1_, lvt_12_1_, lvt_15_1_ = this.getZWithOffset(1, lvt_13_1_));
                if (!p_addComponentParts_3_.isVecInside(lvt_16_1_) || this.getSkyBrightness(p_addComponentParts_1_, 1, 0, lvt_13_1_, p_addComponentParts_3_) >= 8) continue;
                this.spawnerPlaced = true;
                p_addComponentParts_1_.setBlockState(lvt_16_1_, Blocks.MOB_SPAWNER.getDefaultState(), 2);
                TileEntity lvt_17_1_ = p_addComponentParts_1_.getTileEntity(lvt_16_1_);
                if (!(lvt_17_1_ instanceof TileEntityMobSpawner)) continue;
                ((TileEntityMobSpawner)lvt_17_1_).getSpawnerBaseLogic().setEntityId(EntityList.getKey(EntityCaveSpider.class));
            }
            for (int lvt_10_2_ = 0; lvt_10_2_ <= 2; ++lvt_10_2_) {
                for (int lvt_11_2_ = 0; lvt_11_2_ <= lvt_8_1_; ++lvt_11_2_) {
                    int lvt_12_2_ = -1;
                    IBlockState lvt_13_2_ = this.getBlockStateFromPos(p_addComponentParts_1_, lvt_10_2_, -1, lvt_11_2_, p_addComponentParts_3_);
                    if (lvt_13_2_.getMaterial() != Material.AIR || this.getSkyBrightness(p_addComponentParts_1_, lvt_10_2_, -1, lvt_11_2_, p_addComponentParts_3_) >= 8) continue;
                    int lvt_14_2_ = -1;
                    this.setBlockState(p_addComponentParts_1_, lvt_9_1_, lvt_10_2_, -1, lvt_11_2_, p_addComponentParts_3_);
                }
            }
            if (this.hasRails) {
                IBlockState lvt_10_3_ = Blocks.RAIL.getDefaultState().withProperty(BlockRail.SHAPE, BlockRailBase.EnumRailDirection.NORTH_SOUTH);
                for (int lvt_11_3_ = 0; lvt_11_3_ <= lvt_8_1_; ++lvt_11_3_) {
                    IBlockState lvt_12_3_ = this.getBlockStateFromPos(p_addComponentParts_1_, 1, -1, lvt_11_3_, p_addComponentParts_3_);
                    if (lvt_12_3_.getMaterial() == Material.AIR || !lvt_12_3_.isFullBlock()) continue;
                    float lvt_13_3_ = this.getSkyBrightness(p_addComponentParts_1_, 1, 0, lvt_11_3_, p_addComponentParts_3_) > 8 ? 0.9f : 0.7f;
                    this.randomlyPlaceBlock(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, lvt_13_3_, 1, 0, lvt_11_3_, lvt_10_3_);
                }
            }
            return true;
        }

        private void placeSupport(World p_placeSupport_1_, StructureBoundingBox p_placeSupport_2_, int p_placeSupport_3_, int p_placeSupport_4_, int p_placeSupport_5_, int p_placeSupport_6_, int p_placeSupport_7_, Random p_placeSupport_8_) {
            if (!this.isSupportingBox(p_placeSupport_1_, p_placeSupport_2_, p_placeSupport_3_, p_placeSupport_7_, p_placeSupport_6_, p_placeSupport_5_)) {
                return;
            }
            IBlockState lvt_9_1_ = this.getPlanksBlock();
            IBlockState lvt_10_1_ = this.getFenceBlock();
            IBlockState lvt_11_1_ = Blocks.AIR.getDefaultState();
            this.fillWithBlocks(p_placeSupport_1_, p_placeSupport_2_, p_placeSupport_3_, p_placeSupport_4_, p_placeSupport_5_, p_placeSupport_3_, p_placeSupport_6_ - 1, p_placeSupport_5_, lvt_10_1_, lvt_11_1_, false);
            this.fillWithBlocks(p_placeSupport_1_, p_placeSupport_2_, p_placeSupport_7_, p_placeSupport_4_, p_placeSupport_5_, p_placeSupport_7_, p_placeSupport_6_ - 1, p_placeSupport_5_, lvt_10_1_, lvt_11_1_, false);
            if (p_placeSupport_8_.nextInt(4) == 0) {
                this.fillWithBlocks(p_placeSupport_1_, p_placeSupport_2_, p_placeSupport_3_, p_placeSupport_6_, p_placeSupport_5_, p_placeSupport_3_, p_placeSupport_6_, p_placeSupport_5_, lvt_9_1_, lvt_11_1_, false);
                this.fillWithBlocks(p_placeSupport_1_, p_placeSupport_2_, p_placeSupport_7_, p_placeSupport_6_, p_placeSupport_5_, p_placeSupport_7_, p_placeSupport_6_, p_placeSupport_5_, lvt_9_1_, lvt_11_1_, false);
            } else {
                this.fillWithBlocks(p_placeSupport_1_, p_placeSupport_2_, p_placeSupport_3_, p_placeSupport_6_, p_placeSupport_5_, p_placeSupport_7_, p_placeSupport_6_, p_placeSupport_5_, lvt_9_1_, lvt_11_1_, false);
                this.randomlyPlaceBlock(p_placeSupport_1_, p_placeSupport_2_, p_placeSupport_8_, 0.05f, p_placeSupport_3_ + 1, p_placeSupport_6_, p_placeSupport_5_ - 1, Blocks.TORCH.getDefaultState().withProperty(BlockTorch.FACING, EnumFacing.NORTH));
                this.randomlyPlaceBlock(p_placeSupport_1_, p_placeSupport_2_, p_placeSupport_8_, 0.05f, p_placeSupport_3_ + 1, p_placeSupport_6_, p_placeSupport_5_ + 1, Blocks.TORCH.getDefaultState().withProperty(BlockTorch.FACING, EnumFacing.SOUTH));
            }
        }

        private void placeCobWeb(World p_placeCobWeb_1_, StructureBoundingBox p_placeCobWeb_2_, Random p_placeCobWeb_3_, float p_placeCobWeb_4_, int p_placeCobWeb_5_, int p_placeCobWeb_6_, int p_placeCobWeb_7_) {
            if (this.getSkyBrightness(p_placeCobWeb_1_, p_placeCobWeb_5_, p_placeCobWeb_6_, p_placeCobWeb_7_, p_placeCobWeb_2_) < 8) {
                this.randomlyPlaceBlock(p_placeCobWeb_1_, p_placeCobWeb_2_, p_placeCobWeb_3_, p_placeCobWeb_4_, p_placeCobWeb_5_, p_placeCobWeb_6_, p_placeCobWeb_7_, Blocks.WEB.getDefaultState());
            }
        }
    }

    public static class Room
    extends Peice {
        private final List<StructureBoundingBox> roomsLinkedToTheRoom = Lists.newLinkedList();

        public Room() {
        }

        public Room(int p_i47137_1_, Random p_i47137_2_, int p_i47137_3_, int p_i47137_4_, MapGenMineshaft.Type p_i47137_5_) {
            super(p_i47137_1_, p_i47137_5_);
            this.mineShaftType = p_i47137_5_;
            this.boundingBox = new StructureBoundingBox(p_i47137_3_, 50, p_i47137_4_, p_i47137_3_ + 7 + p_i47137_2_.nextInt(6), 54 + p_i47137_2_.nextInt(6), p_i47137_4_ + 7 + p_i47137_2_.nextInt(6));
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            int lvt_5_1_;
            int lvt_4_1_ = this.getComponentType();
            int lvt_6_1_ = this.boundingBox.getYSize() - 3 - 1;
            if (lvt_6_1_ <= 0) {
                lvt_6_1_ = 1;
            }
            for (lvt_5_1_ = 0; lvt_5_1_ < this.boundingBox.getXSize() && (lvt_5_1_ += p_buildComponent_3_.nextInt(this.boundingBox.getXSize())) + 3 <= this.boundingBox.getXSize(); lvt_5_1_ += 4) {
                Peice lvt_7_1_ = StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX + lvt_5_1_, this.boundingBox.minY + p_buildComponent_3_.nextInt(lvt_6_1_) + 1, this.boundingBox.minZ - 1, EnumFacing.NORTH, lvt_4_1_);
                if (lvt_7_1_ == null) continue;
                StructureBoundingBox lvt_8_1_ = lvt_7_1_.getBoundingBox();
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(lvt_8_1_.minX, lvt_8_1_.minY, this.boundingBox.minZ, lvt_8_1_.maxX, lvt_8_1_.maxY, this.boundingBox.minZ + 1));
            }
            for (lvt_5_1_ = 0; lvt_5_1_ < this.boundingBox.getXSize() && (lvt_5_1_ += p_buildComponent_3_.nextInt(this.boundingBox.getXSize())) + 3 <= this.boundingBox.getXSize(); lvt_5_1_ += 4) {
                Peice lvt_7_2_ = StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX + lvt_5_1_, this.boundingBox.minY + p_buildComponent_3_.nextInt(lvt_6_1_) + 1, this.boundingBox.maxZ + 1, EnumFacing.SOUTH, lvt_4_1_);
                if (lvt_7_2_ == null) continue;
                StructureBoundingBox lvt_8_2_ = lvt_7_2_.getBoundingBox();
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(lvt_8_2_.minX, lvt_8_2_.minY, this.boundingBox.maxZ - 1, lvt_8_2_.maxX, lvt_8_2_.maxY, this.boundingBox.maxZ));
            }
            for (lvt_5_1_ = 0; lvt_5_1_ < this.boundingBox.getZSize() && (lvt_5_1_ += p_buildComponent_3_.nextInt(this.boundingBox.getZSize())) + 3 <= this.boundingBox.getZSize(); lvt_5_1_ += 4) {
                Peice lvt_7_3_ = StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX - 1, this.boundingBox.minY + p_buildComponent_3_.nextInt(lvt_6_1_) + 1, this.boundingBox.minZ + lvt_5_1_, EnumFacing.WEST, lvt_4_1_);
                if (lvt_7_3_ == null) continue;
                StructureBoundingBox lvt_8_3_ = lvt_7_3_.getBoundingBox();
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(this.boundingBox.minX, lvt_8_3_.minY, lvt_8_3_.minZ, this.boundingBox.minX + 1, lvt_8_3_.maxY, lvt_8_3_.maxZ));
            }
            for (lvt_5_1_ = 0; lvt_5_1_ < this.boundingBox.getZSize() && (lvt_5_1_ += p_buildComponent_3_.nextInt(this.boundingBox.getZSize())) + 3 <= this.boundingBox.getZSize(); lvt_5_1_ += 4) {
                Peice lvt_7_4_ = StructureMineshaftPieces.generateAndAddPiece(p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.maxX + 1, this.boundingBox.minY + p_buildComponent_3_.nextInt(lvt_6_1_) + 1, this.boundingBox.minZ + lvt_5_1_, EnumFacing.EAST, lvt_4_1_);
                if (lvt_7_4_ == null) continue;
                StructureBoundingBox lvt_8_4_ = lvt_7_4_.getBoundingBox();
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(this.boundingBox.maxX - 1, lvt_8_4_.minY, lvt_8_4_.minZ, this.boundingBox.maxX, lvt_8_4_.maxY, lvt_8_4_.maxZ));
            }
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.isLiquidInStructureBoundingBox(p_addComponentParts_1_, p_addComponentParts_3_)) {
                return false;
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, this.boundingBox.minX, this.boundingBox.minY, this.boundingBox.minZ, this.boundingBox.maxX, this.boundingBox.minY, this.boundingBox.maxZ, Blocks.DIRT.getDefaultState(), Blocks.AIR.getDefaultState(), true);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, this.boundingBox.minX, this.boundingBox.minY + 1, this.boundingBox.minZ, this.boundingBox.maxX, Math.min(this.boundingBox.minY + 3, this.boundingBox.maxY), this.boundingBox.maxZ, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            for (StructureBoundingBox lvt_5_1_ : this.roomsLinkedToTheRoom) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_5_1_.minX, lvt_5_1_.maxY - 2, lvt_5_1_.minZ, lvt_5_1_.maxX, lvt_5_1_.maxY, lvt_5_1_.maxZ, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            }
            this.randomlyRareFillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, this.boundingBox.minX, this.boundingBox.minY + 4, this.boundingBox.minZ, this.boundingBox.maxX, this.boundingBox.maxY, this.boundingBox.maxZ, Blocks.AIR.getDefaultState(), false);
            return true;
        }

        @Override
        public void offset(int p_offset_1_, int p_offset_2_, int p_offset_3_) {
            super.offset(p_offset_1_, p_offset_2_, p_offset_3_);
            for (StructureBoundingBox lvt_5_1_ : this.roomsLinkedToTheRoom) {
                lvt_5_1_.offset(p_offset_1_, p_offset_2_, p_offset_3_);
            }
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            NBTTagList lvt_2_1_ = new NBTTagList();
            for (StructureBoundingBox lvt_4_1_ : this.roomsLinkedToTheRoom) {
                lvt_2_1_.appendTag(lvt_4_1_.toNBTTagIntArray());
            }
            p_writeStructureToNBT_1_.setTag("Entrances", lvt_2_1_);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            NBTTagList lvt_3_1_ = p_readStructureFromNBT_1_.getTagList("Entrances", 11);
            for (int lvt_4_1_ = 0; lvt_4_1_ < lvt_3_1_.tagCount(); ++lvt_4_1_) {
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(lvt_3_1_.getIntArrayAt(lvt_4_1_)));
            }
        }
    }

    static abstract class Peice
    extends StructureComponent {
        protected MapGenMineshaft.Type mineShaftType;

        public Peice() {
        }

        public Peice(int p_i47138_1_, MapGenMineshaft.Type p_i47138_2_) {
            super(p_i47138_1_);
            this.mineShaftType = p_i47138_2_;
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            p_writeStructureToNBT_1_.setInteger("MST", this.mineShaftType.ordinal());
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            this.mineShaftType = MapGenMineshaft.Type.byId(p_readStructureFromNBT_1_.getInteger("MST"));
        }

        protected IBlockState getPlanksBlock() {
            switch (this.mineShaftType) {
                default: {
                    return Blocks.PLANKS.getDefaultState();
                }
                case MESA: 
            }
            return Blocks.PLANKS.getDefaultState().withProperty(BlockPlanks.VARIANT, BlockPlanks.EnumType.DARK_OAK);
        }

        protected IBlockState getFenceBlock() {
            switch (this.mineShaftType) {
                default: {
                    return Blocks.OAK_FENCE.getDefaultState();
                }
                case MESA: 
            }
            return Blocks.DARK_OAK_FENCE.getDefaultState();
        }

        protected boolean isSupportingBox(World p_isSupportingBox_1_, StructureBoundingBox p_isSupportingBox_2_, int p_isSupportingBox_3_, int p_isSupportingBox_4_, int p_isSupportingBox_5_, int p_isSupportingBox_6_) {
            for (int lvt_7_1_ = p_isSupportingBox_3_; lvt_7_1_ <= p_isSupportingBox_4_; ++lvt_7_1_) {
                if (this.getBlockStateFromPos(p_isSupportingBox_1_, lvt_7_1_, p_isSupportingBox_5_ + 1, p_isSupportingBox_6_, p_isSupportingBox_2_).getMaterial() != Material.AIR) continue;
                return false;
            }
            return true;
        }
    }
}

