/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class StructureNetherBridgePieces {
    private static final PieceWeight[] PRIMARY_COMPONENTS = new PieceWeight[]{new PieceWeight(Straight.class, 30, 0, true), new PieceWeight(Crossing3.class, 10, 4), new PieceWeight(Crossing.class, 10, 4), new PieceWeight(Stairs.class, 10, 3), new PieceWeight(Throne.class, 5, 2), new PieceWeight(Entrance.class, 5, 1)};
    private static final PieceWeight[] SECONDARY_COMPONENTS = new PieceWeight[]{new PieceWeight(Corridor5.class, 25, 0, true), new PieceWeight(Crossing2.class, 15, 5), new PieceWeight(Corridor2.class, 5, 10), new PieceWeight(Corridor.class, 5, 10), new PieceWeight(Corridor3.class, 10, 3, true), new PieceWeight(Corridor4.class, 7, 2), new PieceWeight(NetherStalkRoom.class, 5, 2)};

    public static void registerNetherFortressPieces() {
        MapGenStructureIO.registerStructureComponent(Crossing3.class, "NeBCr");
        MapGenStructureIO.registerStructureComponent(End.class, "NeBEF");
        MapGenStructureIO.registerStructureComponent(Straight.class, "NeBS");
        MapGenStructureIO.registerStructureComponent(Corridor3.class, "NeCCS");
        MapGenStructureIO.registerStructureComponent(Corridor4.class, "NeCTB");
        MapGenStructureIO.registerStructureComponent(Entrance.class, "NeCE");
        MapGenStructureIO.registerStructureComponent(Crossing2.class, "NeSCSC");
        MapGenStructureIO.registerStructureComponent(Corridor.class, "NeSCLT");
        MapGenStructureIO.registerStructureComponent(Corridor5.class, "NeSC");
        MapGenStructureIO.registerStructureComponent(Corridor2.class, "NeSCRT");
        MapGenStructureIO.registerStructureComponent(NetherStalkRoom.class, "NeCSR");
        MapGenStructureIO.registerStructureComponent(Throne.class, "NeMT");
        MapGenStructureIO.registerStructureComponent(Crossing.class, "NeRC");
        MapGenStructureIO.registerStructureComponent(Stairs.class, "NeSR");
        MapGenStructureIO.registerStructureComponent(Start.class, "NeStart");
    }

    private static Piece findAndCreateBridgePieceFactory(PieceWeight p_findAndCreateBridgePieceFactory_0_, List<StructureComponent> p_findAndCreateBridgePieceFactory_1_, Random p_findAndCreateBridgePieceFactory_2_, int p_findAndCreateBridgePieceFactory_3_, int p_findAndCreateBridgePieceFactory_4_, int p_findAndCreateBridgePieceFactory_5_, EnumFacing p_findAndCreateBridgePieceFactory_6_, int p_findAndCreateBridgePieceFactory_7_) {
        Class<? extends Piece> lvt_8_1_ = p_findAndCreateBridgePieceFactory_0_.weightClass;
        Piece lvt_9_1_ = null;
        if (lvt_8_1_ == Straight.class) {
            lvt_9_1_ = Straight.createPiece(p_findAndCreateBridgePieceFactory_1_, p_findAndCreateBridgePieceFactory_2_, p_findAndCreateBridgePieceFactory_3_, p_findAndCreateBridgePieceFactory_4_, p_findAndCreateBridgePieceFactory_5_, p_findAndCreateBridgePieceFactory_6_, p_findAndCreateBridgePieceFactory_7_);
        } else if (lvt_8_1_ == Crossing3.class) {
            lvt_9_1_ = Crossing3.createPiece(p_findAndCreateBridgePieceFactory_1_, p_findAndCreateBridgePieceFactory_2_, p_findAndCreateBridgePieceFactory_3_, p_findAndCreateBridgePieceFactory_4_, p_findAndCreateBridgePieceFactory_5_, p_findAndCreateBridgePieceFactory_6_, p_findAndCreateBridgePieceFactory_7_);
        } else if (lvt_8_1_ == Crossing.class) {
            lvt_9_1_ = Crossing.createPiece(p_findAndCreateBridgePieceFactory_1_, p_findAndCreateBridgePieceFactory_2_, p_findAndCreateBridgePieceFactory_3_, p_findAndCreateBridgePieceFactory_4_, p_findAndCreateBridgePieceFactory_5_, p_findAndCreateBridgePieceFactory_6_, p_findAndCreateBridgePieceFactory_7_);
        } else if (lvt_8_1_ == Stairs.class) {
            lvt_9_1_ = Stairs.createPiece(p_findAndCreateBridgePieceFactory_1_, p_findAndCreateBridgePieceFactory_2_, p_findAndCreateBridgePieceFactory_3_, p_findAndCreateBridgePieceFactory_4_, p_findAndCreateBridgePieceFactory_5_, p_findAndCreateBridgePieceFactory_7_, p_findAndCreateBridgePieceFactory_6_);
        } else if (lvt_8_1_ == Throne.class) {
            lvt_9_1_ = Throne.createPiece(p_findAndCreateBridgePieceFactory_1_, p_findAndCreateBridgePieceFactory_2_, p_findAndCreateBridgePieceFactory_3_, p_findAndCreateBridgePieceFactory_4_, p_findAndCreateBridgePieceFactory_5_, p_findAndCreateBridgePieceFactory_7_, p_findAndCreateBridgePieceFactory_6_);
        } else if (lvt_8_1_ == Entrance.class) {
            lvt_9_1_ = Entrance.createPiece(p_findAndCreateBridgePieceFactory_1_, p_findAndCreateBridgePieceFactory_2_, p_findAndCreateBridgePieceFactory_3_, p_findAndCreateBridgePieceFactory_4_, p_findAndCreateBridgePieceFactory_5_, p_findAndCreateBridgePieceFactory_6_, p_findAndCreateBridgePieceFactory_7_);
        } else if (lvt_8_1_ == Corridor5.class) {
            lvt_9_1_ = Corridor5.createPiece(p_findAndCreateBridgePieceFactory_1_, p_findAndCreateBridgePieceFactory_2_, p_findAndCreateBridgePieceFactory_3_, p_findAndCreateBridgePieceFactory_4_, p_findAndCreateBridgePieceFactory_5_, p_findAndCreateBridgePieceFactory_6_, p_findAndCreateBridgePieceFactory_7_);
        } else if (lvt_8_1_ == Corridor2.class) {
            lvt_9_1_ = Corridor2.createPiece(p_findAndCreateBridgePieceFactory_1_, p_findAndCreateBridgePieceFactory_2_, p_findAndCreateBridgePieceFactory_3_, p_findAndCreateBridgePieceFactory_4_, p_findAndCreateBridgePieceFactory_5_, p_findAndCreateBridgePieceFactory_6_, p_findAndCreateBridgePieceFactory_7_);
        } else if (lvt_8_1_ == Corridor.class) {
            lvt_9_1_ = Corridor.createPiece(p_findAndCreateBridgePieceFactory_1_, p_findAndCreateBridgePieceFactory_2_, p_findAndCreateBridgePieceFactory_3_, p_findAndCreateBridgePieceFactory_4_, p_findAndCreateBridgePieceFactory_5_, p_findAndCreateBridgePieceFactory_6_, p_findAndCreateBridgePieceFactory_7_);
        } else if (lvt_8_1_ == Corridor3.class) {
            lvt_9_1_ = Corridor3.createPiece(p_findAndCreateBridgePieceFactory_1_, p_findAndCreateBridgePieceFactory_2_, p_findAndCreateBridgePieceFactory_3_, p_findAndCreateBridgePieceFactory_4_, p_findAndCreateBridgePieceFactory_5_, p_findAndCreateBridgePieceFactory_6_, p_findAndCreateBridgePieceFactory_7_);
        } else if (lvt_8_1_ == Corridor4.class) {
            lvt_9_1_ = Corridor4.createPiece(p_findAndCreateBridgePieceFactory_1_, p_findAndCreateBridgePieceFactory_2_, p_findAndCreateBridgePieceFactory_3_, p_findAndCreateBridgePieceFactory_4_, p_findAndCreateBridgePieceFactory_5_, p_findAndCreateBridgePieceFactory_6_, p_findAndCreateBridgePieceFactory_7_);
        } else if (lvt_8_1_ == Crossing2.class) {
            lvt_9_1_ = Crossing2.createPiece(p_findAndCreateBridgePieceFactory_1_, p_findAndCreateBridgePieceFactory_2_, p_findAndCreateBridgePieceFactory_3_, p_findAndCreateBridgePieceFactory_4_, p_findAndCreateBridgePieceFactory_5_, p_findAndCreateBridgePieceFactory_6_, p_findAndCreateBridgePieceFactory_7_);
        } else if (lvt_8_1_ == NetherStalkRoom.class) {
            lvt_9_1_ = NetherStalkRoom.createPiece(p_findAndCreateBridgePieceFactory_1_, p_findAndCreateBridgePieceFactory_2_, p_findAndCreateBridgePieceFactory_3_, p_findAndCreateBridgePieceFactory_4_, p_findAndCreateBridgePieceFactory_5_, p_findAndCreateBridgePieceFactory_6_, p_findAndCreateBridgePieceFactory_7_);
        }
        return lvt_9_1_;
    }

    public static class Corridor4
    extends Piece {
        public Corridor4() {
        }

        public Corridor4(int p_i45618_1_, Random p_i45618_2_, StructureBoundingBox p_i45618_3_, EnumFacing p_i45618_4_) {
            super(p_i45618_1_);
            this.setCoordBaseMode(p_i45618_4_);
            this.boundingBox = p_i45618_3_;
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            int lvt_4_1_ = 1;
            EnumFacing lvt_5_1_ = this.getCoordBaseMode();
            if (lvt_5_1_ == EnumFacing.WEST || lvt_5_1_ == EnumFacing.NORTH) {
                lvt_4_1_ = 5;
            }
            this.getNextComponentX((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 0, lvt_4_1_, p_buildComponent_3_.nextInt(8) > 0);
            this.getNextComponentZ((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 0, lvt_4_1_, p_buildComponent_3_.nextInt(8) > 0);
        }

        public static Corridor4 createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -3, 0, 0, 9, 7, 9, p_createPiece_5_);
            if (!Corridor4.isAboveGround(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new Corridor4(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 8, 1, 8, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 8, 5, 8, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 6, 0, 8, 6, 5, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 2, 5, 0, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 2, 0, 8, 5, 0, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 0, 1, 4, 0, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 3, 0, 7, 4, 0, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 4, 8, 2, 8, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 4, 2, 2, 4, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 1, 4, 7, 2, 4, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 8, 8, 3, 8, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 6, 0, 3, 7, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 3, 6, 8, 3, 7, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 4, 0, 5, 5, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 3, 4, 8, 5, 5, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 5, 2, 5, 5, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 3, 5, 7, 5, 5, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 4, 5, 1, 5, 5, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 4, 5, 7, 5, 5, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            for (int lvt_4_1_ = 0; lvt_4_1_ <= 5; ++lvt_4_1_) {
                for (int lvt_5_1_ = 0; lvt_5_1_ <= 8; ++lvt_5_1_) {
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_5_1_, -1, lvt_4_1_, p_addComponentParts_3_);
                }
            }
            return true;
        }
    }

    public static class Corridor3
    extends Piece {
        public Corridor3() {
        }

        public Corridor3(int p_i45619_1_, Random p_i45619_2_, StructureBoundingBox p_i45619_3_, EnumFacing p_i45619_4_) {
            super(p_i45619_1_);
            this.setCoordBaseMode(p_i45619_4_);
            this.boundingBox = p_i45619_3_;
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            this.getNextComponentNormal((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 1, 0, true);
        }

        public static Corridor3 createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -1, -7, 0, 5, 14, 10, p_createPiece_5_);
            if (!Corridor3.isAboveGround(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new Corridor3(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            IBlockState lvt_4_1_ = Blocks.NETHER_BRICK_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.SOUTH);
            for (int lvt_5_1_ = 0; lvt_5_1_ <= 9; ++lvt_5_1_) {
                int lvt_6_1_ = Math.max(1, 7 - lvt_5_1_);
                int lvt_7_1_ = Math.min(Math.max(lvt_6_1_ + 5, 14 - lvt_5_1_), 13);
                int lvt_8_1_ = lvt_5_1_;
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, lvt_8_1_, 4, lvt_6_1_, lvt_8_1_, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, lvt_6_1_ + 1, lvt_8_1_, 3, lvt_7_1_ - 1, lvt_8_1_, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
                if (lvt_5_1_ <= 6) {
                    this.setBlockState(p_addComponentParts_1_, lvt_4_1_, 1, lvt_6_1_ + 1, lvt_8_1_, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, lvt_4_1_, 2, lvt_6_1_ + 1, lvt_8_1_, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, lvt_4_1_, 3, lvt_6_1_ + 1, lvt_8_1_, p_addComponentParts_3_);
                }
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, lvt_7_1_, lvt_8_1_, 4, lvt_7_1_, lvt_8_1_, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, lvt_6_1_ + 1, lvt_8_1_, 0, lvt_7_1_ - 1, lvt_8_1_, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, lvt_6_1_ + 1, lvt_8_1_, 4, lvt_7_1_ - 1, lvt_8_1_, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
                if ((lvt_5_1_ & 1) == 0) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, lvt_6_1_ + 2, lvt_8_1_, 0, lvt_6_1_ + 3, lvt_8_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, lvt_6_1_ + 2, lvt_8_1_, 4, lvt_6_1_ + 3, lvt_8_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
                }
                for (int lvt_9_1_ = 0; lvt_9_1_ <= 4; ++lvt_9_1_) {
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_9_1_, -1, lvt_8_1_, p_addComponentParts_3_);
                }
            }
            return true;
        }
    }

    public static class Corridor
    extends Piece {
        private boolean chest;

        public Corridor() {
        }

        public Corridor(int p_i45615_1_, Random p_i45615_2_, StructureBoundingBox p_i45615_3_, EnumFacing p_i45615_4_) {
            super(p_i45615_1_);
            this.setCoordBaseMode(p_i45615_4_);
            this.boundingBox = p_i45615_3_;
            this.chest = p_i45615_2_.nextInt(3) == 0;
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.chest = p_readStructureFromNBT_1_.getBoolean("Chest");
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setBoolean("Chest", this.chest);
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            this.getNextComponentX((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 0, 1, true);
        }

        public static Corridor createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -1, 0, 0, 5, 7, 5, p_createPiece_5_);
            if (!Corridor.isAboveGround(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new Corridor(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 4, 1, 4, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 4, 5, 4, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 2, 0, 4, 5, 4, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 3, 1, 4, 4, 1, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 3, 3, 4, 4, 3, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 0, 5, 0, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 4, 3, 5, 4, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 4, 1, 4, 4, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 3, 4, 3, 4, 4, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            if (this.chest && p_addComponentParts_3_.isVecInside(new BlockPos(this.getXWithOffset(3, 3), this.getYWithOffset(2), this.getZWithOffset(3, 3)))) {
                this.chest = false;
                this.generateChest(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 3, 2, 3, LootTableList.CHESTS_NETHER_BRIDGE);
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 6, 0, 4, 6, 4, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            for (int lvt_4_1_ = 0; lvt_4_1_ <= 4; ++lvt_4_1_) {
                for (int lvt_5_1_ = 0; lvt_5_1_ <= 4; ++lvt_5_1_) {
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_4_1_, -1, lvt_5_1_, p_addComponentParts_3_);
                }
            }
            return true;
        }
    }

    public static class Corridor2
    extends Piece {
        private boolean chest;

        public Corridor2() {
        }

        public Corridor2(int p_i45613_1_, Random p_i45613_2_, StructureBoundingBox p_i45613_3_, EnumFacing p_i45613_4_) {
            super(p_i45613_1_);
            this.setCoordBaseMode(p_i45613_4_);
            this.boundingBox = p_i45613_3_;
            this.chest = p_i45613_2_.nextInt(3) == 0;
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.chest = p_readStructureFromNBT_1_.getBoolean("Chest");
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setBoolean("Chest", this.chest);
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            this.getNextComponentZ((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 0, 1, true);
        }

        public static Corridor2 createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -1, 0, 0, 5, 7, 5, p_createPiece_5_);
            if (!Corridor2.isAboveGround(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new Corridor2(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 4, 1, 4, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 4, 5, 4, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 0, 5, 4, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 1, 0, 4, 1, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 3, 0, 4, 3, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 2, 0, 4, 5, 0, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 4, 4, 5, 4, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 4, 1, 4, 4, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 3, 4, 3, 4, 4, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            if (this.chest && p_addComponentParts_3_.isVecInside(new BlockPos(this.getXWithOffset(1, 3), this.getYWithOffset(2), this.getZWithOffset(1, 3)))) {
                this.chest = false;
                this.generateChest(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 1, 2, 3, LootTableList.CHESTS_NETHER_BRIDGE);
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 6, 0, 4, 6, 4, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            for (int lvt_4_1_ = 0; lvt_4_1_ <= 4; ++lvt_4_1_) {
                for (int lvt_5_1_ = 0; lvt_5_1_ <= 4; ++lvt_5_1_) {
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_4_1_, -1, lvt_5_1_, p_addComponentParts_3_);
                }
            }
            return true;
        }
    }

    public static class Crossing2
    extends Piece {
        public Crossing2() {
        }

        public Crossing2(int p_i45616_1_, Random p_i45616_2_, StructureBoundingBox p_i45616_3_, EnumFacing p_i45616_4_) {
            super(p_i45616_1_);
            this.setCoordBaseMode(p_i45616_4_);
            this.boundingBox = p_i45616_3_;
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            this.getNextComponentNormal((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 1, 0, true);
            this.getNextComponentX((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 0, 1, true);
            this.getNextComponentZ((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 0, 1, true);
        }

        public static Crossing2 createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -1, 0, 0, 5, 7, 5, p_createPiece_5_);
            if (!Crossing2.isAboveGround(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new Crossing2(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 4, 1, 4, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 4, 5, 4, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 0, 5, 0, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 2, 0, 4, 5, 0, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 4, 0, 5, 4, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 2, 4, 4, 5, 4, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 6, 0, 4, 6, 4, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            for (int lvt_4_1_ = 0; lvt_4_1_ <= 4; ++lvt_4_1_) {
                for (int lvt_5_1_ = 0; lvt_5_1_ <= 4; ++lvt_5_1_) {
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_4_1_, -1, lvt_5_1_, p_addComponentParts_3_);
                }
            }
            return true;
        }
    }

    public static class Corridor5
    extends Piece {
        public Corridor5() {
        }

        public Corridor5(int p_i45614_1_, Random p_i45614_2_, StructureBoundingBox p_i45614_3_, EnumFacing p_i45614_4_) {
            super(p_i45614_1_);
            this.setCoordBaseMode(p_i45614_4_);
            this.boundingBox = p_i45614_3_;
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            this.getNextComponentNormal((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 1, 0, true);
        }

        public static Corridor5 createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -1, 0, 0, 5, 7, 5, p_createPiece_5_);
            if (!Corridor5.isAboveGround(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new Corridor5(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 4, 1, 4, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 4, 5, 4, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 0, 5, 4, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 2, 0, 4, 5, 4, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 1, 0, 4, 1, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 3, 0, 4, 3, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 3, 1, 4, 4, 1, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 3, 3, 4, 4, 3, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 6, 0, 4, 6, 4, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            for (int lvt_4_1_ = 0; lvt_4_1_ <= 4; ++lvt_4_1_) {
                for (int lvt_5_1_ = 0; lvt_5_1_ <= 4; ++lvt_5_1_) {
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_4_1_, -1, lvt_5_1_, p_addComponentParts_3_);
                }
            }
            return true;
        }
    }

    public static class NetherStalkRoom
    extends Piece {
        public NetherStalkRoom() {
        }

        public NetherStalkRoom(int p_i45612_1_, Random p_i45612_2_, StructureBoundingBox p_i45612_3_, EnumFacing p_i45612_4_) {
            super(p_i45612_1_);
            this.setCoordBaseMode(p_i45612_4_);
            this.boundingBox = p_i45612_3_;
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            this.getNextComponentNormal((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 5, 3, true);
            this.getNextComponentNormal((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 5, 11, true);
        }

        public static NetherStalkRoom createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -5, -3, 0, 13, 14, 13, p_createPiece_5_);
            if (!NetherStalkRoom.isAboveGround(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new NetherStalkRoom(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 0, 12, 4, 12, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5, 0, 12, 13, 12, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5, 0, 1, 12, 12, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 11, 5, 0, 12, 12, 12, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 5, 11, 4, 12, 12, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 5, 11, 10, 12, 12, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 9, 11, 7, 12, 12, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 5, 0, 4, 12, 1, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 5, 0, 10, 12, 1, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 9, 0, 7, 12, 1, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 11, 2, 10, 12, 10, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            for (int lvt_4_1_ = 1; lvt_4_1_ <= 11; lvt_4_1_ += 2) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_4_1_, 10, 0, lvt_4_1_, 11, 0, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_4_1_, 10, 12, lvt_4_1_, 11, 12, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 10, lvt_4_1_, 0, 11, lvt_4_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 12, 10, lvt_4_1_, 12, 11, lvt_4_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
                this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_4_1_, 13, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_4_1_, 13, 12, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), 0, 13, lvt_4_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), 12, 13, lvt_4_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), lvt_4_1_ + 1, 13, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), lvt_4_1_ + 1, 13, 12, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), 0, 13, lvt_4_1_ + 1, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), 12, 13, lvt_4_1_ + 1, p_addComponentParts_3_);
            }
            this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), 0, 13, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), 0, 13, 12, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), 0, 13, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), 12, 13, 0, p_addComponentParts_3_);
            for (int lvt_4_2_ = 3; lvt_4_2_ <= 9; lvt_4_2_ += 2) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 7, lvt_4_2_, 1, 8, lvt_4_2_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 11, 7, lvt_4_2_, 11, 8, lvt_4_2_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            }
            IBlockState lvt_4_3_ = Blocks.NETHER_BRICK_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.NORTH);
            for (int lvt_5_1_ = 0; lvt_5_1_ <= 6; ++lvt_5_1_) {
                int lvt_6_1_ = lvt_5_1_ + 4;
                for (int lvt_7_1_ = 5; lvt_7_1_ <= 7; ++lvt_7_1_) {
                    this.setBlockState(p_addComponentParts_1_, lvt_4_3_, lvt_7_1_, 5 + lvt_5_1_, lvt_6_1_, p_addComponentParts_3_);
                }
                if (lvt_6_1_ >= 5 && lvt_6_1_ <= 8) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 5, lvt_6_1_, 7, lvt_5_1_ + 4, lvt_6_1_, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
                } else if (lvt_6_1_ >= 9 && lvt_6_1_ <= 10) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 8, lvt_6_1_, 7, lvt_5_1_ + 4, lvt_6_1_, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
                }
                if (lvt_5_1_ < 1) continue;
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 6 + lvt_5_1_, lvt_6_1_, 7, 9 + lvt_5_1_, lvt_6_1_, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            }
            for (int lvt_5_2_ = 5; lvt_5_2_ <= 7; ++lvt_5_2_) {
                this.setBlockState(p_addComponentParts_1_, lvt_4_3_, lvt_5_2_, 12, 11, p_addComponentParts_3_);
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 6, 7, 5, 7, 7, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 6, 7, 7, 7, 7, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 13, 12, 7, 13, 12, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 5, 2, 3, 5, 3, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 5, 9, 3, 5, 10, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 5, 4, 2, 5, 8, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 5, 2, 10, 5, 3, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 5, 9, 10, 5, 10, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 10, 5, 4, 10, 5, 8, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            IBlockState lvt_5_3_ = lvt_4_3_.withProperty(BlockStairs.FACING, EnumFacing.EAST);
            IBlockState lvt_6_2_ = lvt_4_3_.withProperty(BlockStairs.FACING, EnumFacing.WEST);
            this.setBlockState(p_addComponentParts_1_, lvt_6_2_, 4, 5, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_6_2_, 4, 5, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_6_2_, 4, 5, 9, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_6_2_, 4, 5, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_5_3_, 8, 5, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_5_3_, 8, 5, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_5_3_, 8, 5, 9, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_5_3_, 8, 5, 10, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 4, 4, 4, 4, 8, Blocks.SOUL_SAND.getDefaultState(), Blocks.SOUL_SAND.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 4, 4, 9, 4, 8, Blocks.SOUL_SAND.getDefaultState(), Blocks.SOUL_SAND.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 5, 4, 4, 5, 8, Blocks.NETHER_WART.getDefaultState(), Blocks.NETHER_WART.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 5, 4, 9, 5, 8, Blocks.NETHER_WART.getDefaultState(), Blocks.NETHER_WART.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 2, 0, 8, 2, 12, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 4, 12, 2, 8, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 0, 0, 8, 1, 3, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 0, 9, 8, 1, 12, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 4, 3, 1, 8, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 0, 4, 12, 1, 8, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            for (int lvt_7_2_ = 4; lvt_7_2_ <= 8; ++lvt_7_2_) {
                for (int lvt_8_1_ = 0; lvt_8_1_ <= 2; ++lvt_8_1_) {
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_7_2_, -1, lvt_8_1_, p_addComponentParts_3_);
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_7_2_, -1, 12 - lvt_8_1_, p_addComponentParts_3_);
                }
            }
            for (int lvt_7_3_ = 0; lvt_7_3_ <= 2; ++lvt_7_3_) {
                for (int lvt_8_2_ = 4; lvt_8_2_ <= 8; ++lvt_8_2_) {
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_7_3_, -1, lvt_8_2_, p_addComponentParts_3_);
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), 12 - lvt_7_3_, -1, lvt_8_2_, p_addComponentParts_3_);
                }
            }
            return true;
        }
    }

    public static class Entrance
    extends Piece {
        public Entrance() {
        }

        public Entrance(int p_i45617_1_, Random p_i45617_2_, StructureBoundingBox p_i45617_3_, EnumFacing p_i45617_4_) {
            super(p_i45617_1_);
            this.setCoordBaseMode(p_i45617_4_);
            this.boundingBox = p_i45617_3_;
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            this.getNextComponentNormal((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 5, 3, true);
        }

        public static Entrance createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -5, -3, 0, 13, 14, 13, p_createPiece_5_);
            if (!Entrance.isAboveGround(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new Entrance(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 0, 12, 4, 12, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5, 0, 12, 13, 12, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5, 0, 1, 12, 12, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 11, 5, 0, 12, 12, 12, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 5, 11, 4, 12, 12, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 5, 11, 10, 12, 12, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 9, 11, 7, 12, 12, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 5, 0, 4, 12, 1, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 5, 0, 10, 12, 1, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 9, 0, 7, 12, 1, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 11, 2, 10, 12, 10, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 8, 0, 7, 8, 0, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            for (int lvt_4_1_ = 1; lvt_4_1_ <= 11; lvt_4_1_ += 2) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_4_1_, 10, 0, lvt_4_1_, 11, 0, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_4_1_, 10, 12, lvt_4_1_, 11, 12, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 10, lvt_4_1_, 0, 11, lvt_4_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 12, 10, lvt_4_1_, 12, 11, lvt_4_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
                this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_4_1_, 13, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_4_1_, 13, 12, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), 0, 13, lvt_4_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), 12, 13, lvt_4_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), lvt_4_1_ + 1, 13, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), lvt_4_1_ + 1, 13, 12, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), 0, 13, lvt_4_1_ + 1, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), 12, 13, lvt_4_1_ + 1, p_addComponentParts_3_);
            }
            this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), 0, 13, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), 0, 13, 12, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), 0, 13, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), 12, 13, 0, p_addComponentParts_3_);
            for (int lvt_4_2_ = 3; lvt_4_2_ <= 9; lvt_4_2_ += 2) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 7, lvt_4_2_, 1, 8, lvt_4_2_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 11, 7, lvt_4_2_, 11, 8, lvt_4_2_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 2, 0, 8, 2, 12, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 4, 12, 2, 8, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 0, 0, 8, 1, 3, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 0, 9, 8, 1, 12, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 4, 3, 1, 8, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 0, 4, 12, 1, 8, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            for (int lvt_4_3_ = 4; lvt_4_3_ <= 8; ++lvt_4_3_) {
                for (int lvt_5_1_ = 0; lvt_5_1_ <= 2; ++lvt_5_1_) {
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_4_3_, -1, lvt_5_1_, p_addComponentParts_3_);
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_4_3_, -1, 12 - lvt_5_1_, p_addComponentParts_3_);
                }
            }
            for (int lvt_4_4_ = 0; lvt_4_4_ <= 2; ++lvt_4_4_) {
                for (int lvt_5_2_ = 4; lvt_5_2_ <= 8; ++lvt_5_2_) {
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_4_4_, -1, lvt_5_2_, p_addComponentParts_3_);
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), 12 - lvt_4_4_, -1, lvt_5_2_, p_addComponentParts_3_);
                }
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 5, 5, 7, 5, 7, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 1, 6, 6, 4, 6, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), 6, 0, 6, p_addComponentParts_3_);
            IBlockState lvt_4_5_ = Blocks.FLOWING_LAVA.getDefaultState();
            this.setBlockState(p_addComponentParts_1_, lvt_4_5_, 6, 5, 6, p_addComponentParts_3_);
            BlockPos lvt_5_3_ = new BlockPos(this.getXWithOffset(6, 6), this.getYWithOffset(5), this.getZWithOffset(6, 6));
            if (p_addComponentParts_3_.isVecInside(lvt_5_3_)) {
                p_addComponentParts_1_.immediateBlockTick(lvt_5_3_, lvt_4_5_, p_addComponentParts_2_);
            }
            return true;
        }
    }

    public static class Throne
    extends Piece {
        private boolean hasSpawner;

        public Throne() {
        }

        public Throne(int p_i45611_1_, Random p_i45611_2_, StructureBoundingBox p_i45611_3_, EnumFacing p_i45611_4_) {
            super(p_i45611_1_);
            this.setCoordBaseMode(p_i45611_4_);
            this.boundingBox = p_i45611_3_;
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.hasSpawner = p_readStructureFromNBT_1_.getBoolean("Mob");
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setBoolean("Mob", this.hasSpawner);
        }

        public static Throne createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, int p_createPiece_5_, EnumFacing p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -2, 0, 0, 7, 8, 9, p_createPiece_6_);
            if (!Throne.isAboveGround(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new Throne(p_createPiece_5_, p_createPiece_1_, lvt_7_1_, p_createPiece_6_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            BlockPos lvt_4_1_;
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 6, 7, 7, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, 0, 5, 1, 7, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 1, 5, 2, 7, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 2, 5, 3, 7, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 4, 3, 5, 4, 7, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 0, 1, 4, 2, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 2, 0, 5, 4, 2, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 5, 2, 1, 5, 3, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 5, 2, 5, 5, 3, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5, 3, 0, 5, 8, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 5, 3, 6, 5, 8, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 5, 8, 5, 5, 8, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), 1, 6, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK_FENCE.getDefaultState(), 5, 6, 3, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 6, 3, 0, 6, 8, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 6, 3, 6, 6, 8, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 6, 8, 5, 7, 8, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 8, 8, 4, 8, 8, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            if (!this.hasSpawner && p_addComponentParts_3_.isVecInside(lvt_4_1_ = new BlockPos(this.getXWithOffset(3, 5), this.getYWithOffset(5), this.getZWithOffset(3, 5)))) {
                this.hasSpawner = true;
                p_addComponentParts_1_.setBlockState(lvt_4_1_, Blocks.MOB_SPAWNER.getDefaultState(), 2);
                TileEntity lvt_5_1_ = p_addComponentParts_1_.getTileEntity(lvt_4_1_);
                if (lvt_5_1_ instanceof TileEntityMobSpawner) {
                    ((TileEntityMobSpawner)lvt_5_1_).getSpawnerBaseLogic().setEntityId(EntityList.getKey(EntityBlaze.class));
                }
            }
            for (int lvt_4_2_ = 0; lvt_4_2_ <= 6; ++lvt_4_2_) {
                for (int lvt_5_2_ = 0; lvt_5_2_ <= 6; ++lvt_5_2_) {
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_4_2_, -1, lvt_5_2_, p_addComponentParts_3_);
                }
            }
            return true;
        }
    }

    public static class Stairs
    extends Piece {
        public Stairs() {
        }

        public Stairs(int p_i45609_1_, Random p_i45609_2_, StructureBoundingBox p_i45609_3_, EnumFacing p_i45609_4_) {
            super(p_i45609_1_);
            this.setCoordBaseMode(p_i45609_4_);
            this.boundingBox = p_i45609_3_;
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            this.getNextComponentZ((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 6, 2, false);
        }

        public static Stairs createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, int p_createPiece_5_, EnumFacing p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -2, 0, 0, 7, 11, 7, p_createPiece_6_);
            if (!Stairs.isAboveGround(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new Stairs(p_createPiece_5_, p_createPiece_1_, lvt_7_1_, p_createPiece_6_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 6, 1, 6, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 6, 10, 6, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 1, 8, 0, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 2, 0, 6, 8, 0, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 1, 0, 8, 6, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 2, 1, 6, 8, 6, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 6, 5, 8, 6, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 2, 0, 5, 4, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 3, 2, 6, 5, 2, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 3, 4, 6, 5, 4, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.setBlockState(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), 5, 2, 5, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 2, 5, 4, 3, 5, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 2, 5, 3, 4, 5, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 2, 5, 2, 5, 5, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 5, 1, 6, 5, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 7, 1, 5, 7, 4, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 8, 2, 6, 8, 4, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 6, 0, 4, 8, 0, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 5, 0, 4, 5, 0, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            for (int lvt_4_1_ = 0; lvt_4_1_ <= 6; ++lvt_4_1_) {
                for (int lvt_5_1_ = 0; lvt_5_1_ <= 6; ++lvt_5_1_) {
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_4_1_, -1, lvt_5_1_, p_addComponentParts_3_);
                }
            }
            return true;
        }
    }

    public static class Crossing
    extends Piece {
        public Crossing() {
        }

        public Crossing(int p_i45610_1_, Random p_i45610_2_, StructureBoundingBox p_i45610_3_, EnumFacing p_i45610_4_) {
            super(p_i45610_1_);
            this.setCoordBaseMode(p_i45610_4_);
            this.boundingBox = p_i45610_3_;
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            this.getNextComponentNormal((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 2, 0, false);
            this.getNextComponentX((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 0, 2, false);
            this.getNextComponentZ((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 0, 2, false);
        }

        public static Crossing createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -2, 0, 0, 7, 9, 7, p_createPiece_5_);
            if (!Crossing.isAboveGround(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new Crossing(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 6, 1, 6, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 6, 7, 6, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 1, 6, 0, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 6, 1, 6, 6, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 2, 0, 6, 6, 0, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 2, 6, 6, 6, 6, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 0, 6, 1, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 5, 0, 6, 6, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 2, 0, 6, 6, 1, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 2, 5, 6, 6, 6, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 6, 0, 4, 6, 0, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 5, 0, 4, 5, 0, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 6, 6, 4, 6, 6, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 5, 6, 4, 5, 6, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 6, 2, 0, 6, 4, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5, 2, 0, 5, 4, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 6, 2, 6, 6, 4, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 5, 2, 6, 5, 4, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            for (int lvt_4_1_ = 0; lvt_4_1_ <= 6; ++lvt_4_1_) {
                for (int lvt_5_1_ = 0; lvt_5_1_ <= 6; ++lvt_5_1_) {
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_4_1_, -1, lvt_5_1_, p_addComponentParts_3_);
                }
            }
            return true;
        }
    }

    public static class Crossing3
    extends Piece {
        public Crossing3() {
        }

        public Crossing3(int p_i45622_1_, Random p_i45622_2_, StructureBoundingBox p_i45622_3_, EnumFacing p_i45622_4_) {
            super(p_i45622_1_);
            this.setCoordBaseMode(p_i45622_4_);
            this.boundingBox = p_i45622_3_;
        }

        protected Crossing3(Random p_i2042_1_, int p_i2042_2_, int p_i2042_3_) {
            super(0);
            this.setCoordBaseMode(EnumFacing.Plane.HORIZONTAL.random(p_i2042_1_));
            this.boundingBox = this.getCoordBaseMode().getAxis() == EnumFacing.Axis.Z ? new StructureBoundingBox(p_i2042_2_, 64, p_i2042_3_, p_i2042_2_ + 19 - 1, 73, p_i2042_3_ + 19 - 1) : new StructureBoundingBox(p_i2042_2_, 64, p_i2042_3_, p_i2042_2_ + 19 - 1, 73, p_i2042_3_ + 19 - 1);
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            this.getNextComponentNormal((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 8, 3, false);
            this.getNextComponentX((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 3, 8, false);
            this.getNextComponentZ((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 3, 8, false);
        }

        public static Crossing3 createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -8, -3, 0, 19, 10, 19, p_createPiece_5_);
            if (!Crossing3.isAboveGround(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new Crossing3(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 3, 0, 11, 4, 18, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 7, 18, 4, 11, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 5, 0, 10, 7, 18, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5, 8, 18, 7, 10, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 5, 0, 7, 5, 7, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 5, 11, 7, 5, 18, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 11, 5, 0, 11, 5, 7, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 11, 5, 11, 11, 5, 18, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5, 7, 7, 5, 7, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 11, 5, 7, 18, 5, 7, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5, 11, 7, 5, 11, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 11, 5, 11, 18, 5, 11, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 2, 0, 11, 2, 5, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 2, 13, 11, 2, 18, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 0, 0, 11, 1, 3, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 0, 15, 11, 1, 18, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            for (int lvt_4_1_ = 7; lvt_4_1_ <= 11; ++lvt_4_1_) {
                for (int lvt_5_1_ = 0; lvt_5_1_ <= 2; ++lvt_5_1_) {
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_4_1_, -1, lvt_5_1_, p_addComponentParts_3_);
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_4_1_, -1, 18 - lvt_5_1_, p_addComponentParts_3_);
                }
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 7, 5, 2, 11, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 13, 2, 7, 18, 2, 11, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 7, 3, 1, 11, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 15, 0, 7, 18, 1, 11, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            for (int lvt_4_2_ = 0; lvt_4_2_ <= 2; ++lvt_4_2_) {
                for (int lvt_5_2_ = 7; lvt_5_2_ <= 11; ++lvt_5_2_) {
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_4_2_, -1, lvt_5_2_, p_addComponentParts_3_);
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), 18 - lvt_4_2_, -1, lvt_5_2_, p_addComponentParts_3_);
                }
            }
            return true;
        }
    }

    public static class End
    extends Piece {
        private int fillSeed;

        public End() {
        }

        public End(int p_i45621_1_, Random p_i45621_2_, StructureBoundingBox p_i45621_3_, EnumFacing p_i45621_4_) {
            super(p_i45621_1_);
            this.setCoordBaseMode(p_i45621_4_);
            this.boundingBox = p_i45621_3_;
            this.fillSeed = p_i45621_2_.nextInt();
        }

        public static End createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -1, -3, 0, 5, 10, 8, p_createPiece_5_);
            if (!End.isAboveGround(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new End(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.fillSeed = p_readStructureFromNBT_1_.getInteger("Seed");
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setInteger("Seed", this.fillSeed);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            Random lvt_4_1_ = new Random(this.fillSeed);
            for (int lvt_5_1_ = 0; lvt_5_1_ <= 4; ++lvt_5_1_) {
                for (int lvt_6_1_ = 3; lvt_6_1_ <= 4; ++lvt_6_1_) {
                    int lvt_7_1_ = lvt_4_1_.nextInt(8);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_5_1_, lvt_6_1_, 0, lvt_5_1_, lvt_6_1_, lvt_7_1_, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
                }
            }
            int lvt_5_2_ = lvt_4_1_.nextInt(8);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5, 0, 0, 5, lvt_5_2_, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            int lvt_5_3_ = lvt_4_1_.nextInt(8);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 5, 0, 4, 5, lvt_5_3_, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            for (int lvt_5_4_ = 0; lvt_5_4_ <= 4; ++lvt_5_4_) {
                int lvt_6_2_ = lvt_4_1_.nextInt(5);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_5_4_, 2, 0, lvt_5_4_, 2, lvt_6_2_, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            }
            for (int lvt_5_5_ = 0; lvt_5_5_ <= 4; ++lvt_5_5_) {
                for (int lvt_6_3_ = 0; lvt_6_3_ <= 1; ++lvt_6_3_) {
                    int lvt_7_2_ = lvt_4_1_.nextInt(3);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_5_5_, lvt_6_3_, 0, lvt_5_5_, lvt_6_3_, lvt_7_2_, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
                }
            }
            return true;
        }
    }

    public static class Straight
    extends Piece {
        public Straight() {
        }

        public Straight(int p_i45620_1_, Random p_i45620_2_, StructureBoundingBox p_i45620_3_, EnumFacing p_i45620_4_) {
            super(p_i45620_1_);
            this.setCoordBaseMode(p_i45620_4_);
            this.boundingBox = p_i45620_3_;
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            this.getNextComponentNormal((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 1, 3, false);
        }

        public static Straight createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -1, -3, 0, 5, 10, 19, p_createPiece_5_);
            if (!Straight.isAboveGround(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new Straight(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 0, 4, 4, 18, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 5, 0, 3, 7, 18, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5, 0, 0, 5, 18, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 5, 0, 4, 5, 18, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 4, 2, 5, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 13, 4, 2, 18, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 4, 1, 3, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 15, 4, 1, 18, Blocks.NETHER_BRICK.getDefaultState(), Blocks.NETHER_BRICK.getDefaultState(), false);
            for (int lvt_4_1_ = 0; lvt_4_1_ <= 4; ++lvt_4_1_) {
                for (int lvt_5_1_ = 0; lvt_5_1_ <= 2; ++lvt_5_1_) {
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_4_1_, -1, lvt_5_1_, p_addComponentParts_3_);
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.NETHER_BRICK.getDefaultState(), lvt_4_1_, -1, 18 - lvt_5_1_, p_addComponentParts_3_);
                }
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 1, 0, 4, 1, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 4, 0, 4, 4, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 14, 0, 4, 14, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 17, 0, 4, 17, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 1, 4, 4, 1, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 3, 4, 4, 4, 4, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 3, 14, 4, 4, 14, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 17, 4, 4, 17, Blocks.NETHER_BRICK_FENCE.getDefaultState(), Blocks.NETHER_BRICK_FENCE.getDefaultState(), false);
            return true;
        }
    }

    public static class Start
    extends Crossing3 {
        public PieceWeight theNetherBridgePieceWeight;
        public List<PieceWeight> primaryWeights;
        public List<PieceWeight> secondaryWeights;
        public List<StructureComponent> pendingChildren = Lists.newArrayList();

        public Start() {
        }

        public Start(Random p_i2059_1_, int p_i2059_2_, int p_i2059_3_) {
            super(p_i2059_1_, p_i2059_2_, p_i2059_3_);
            this.primaryWeights = Lists.newArrayList();
            for (PieceWeight lvt_7_1_ : PRIMARY_COMPONENTS) {
                lvt_7_1_.placeCount = 0;
                this.primaryWeights.add(lvt_7_1_);
            }
            this.secondaryWeights = Lists.newArrayList();
            for (PieceWeight lvt_7_2_ : SECONDARY_COMPONENTS) {
                lvt_7_2_.placeCount = 0;
                this.secondaryWeights.add(lvt_7_2_);
            }
        }
    }

    static abstract class Piece
    extends StructureComponent {
        public Piece() {
        }

        protected Piece(int p_i2054_1_) {
            super(p_i2054_1_);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
        }

        private int getTotalWeight(List<PieceWeight> p_getTotalWeight_1_) {
            boolean lvt_2_1_ = false;
            int lvt_3_1_ = 0;
            for (PieceWeight lvt_5_1_ : p_getTotalWeight_1_) {
                if (lvt_5_1_.maxPlaceCount > 0 && lvt_5_1_.placeCount < lvt_5_1_.maxPlaceCount) {
                    lvt_2_1_ = true;
                }
                lvt_3_1_ += lvt_5_1_.weight;
            }
            return lvt_2_1_ ? lvt_3_1_ : -1;
        }

        private Piece generatePiece(Start p_generatePiece_1_, List<PieceWeight> p_generatePiece_2_, List<StructureComponent> p_generatePiece_3_, Random p_generatePiece_4_, int p_generatePiece_5_, int p_generatePiece_6_, int p_generatePiece_7_, EnumFacing p_generatePiece_8_, int p_generatePiece_9_) {
            int lvt_10_1_ = this.getTotalWeight(p_generatePiece_2_);
            boolean lvt_11_1_ = lvt_10_1_ > 0 && p_generatePiece_9_ <= 30;
            int lvt_12_1_ = 0;
            block0: while (lvt_12_1_ < 5 && lvt_11_1_) {
                ++lvt_12_1_;
                int lvt_13_1_ = p_generatePiece_4_.nextInt(lvt_10_1_);
                for (PieceWeight lvt_15_1_ : p_generatePiece_2_) {
                    if ((lvt_13_1_ -= lvt_15_1_.weight) >= 0) continue;
                    if (!lvt_15_1_.doPlace(p_generatePiece_9_) || lvt_15_1_ == p_generatePiece_1_.theNetherBridgePieceWeight && !lvt_15_1_.allowInRow) continue block0;
                    Piece lvt_16_1_ = StructureNetherBridgePieces.findAndCreateBridgePieceFactory(lvt_15_1_, p_generatePiece_3_, p_generatePiece_4_, p_generatePiece_5_, p_generatePiece_6_, p_generatePiece_7_, p_generatePiece_8_, p_generatePiece_9_);
                    if (lvt_16_1_ == null) continue;
                    ++lvt_15_1_.placeCount;
                    p_generatePiece_1_.theNetherBridgePieceWeight = lvt_15_1_;
                    if (!lvt_15_1_.isValid()) {
                        p_generatePiece_2_.remove(lvt_15_1_);
                    }
                    return lvt_16_1_;
                }
            }
            return End.createPiece(p_generatePiece_3_, p_generatePiece_4_, p_generatePiece_5_, p_generatePiece_6_, p_generatePiece_7_, p_generatePiece_8_, p_generatePiece_9_);
        }

        private StructureComponent generateAndAddPiece(Start p_generateAndAddPiece_1_, List<StructureComponent> p_generateAndAddPiece_2_, Random p_generateAndAddPiece_3_, int p_generateAndAddPiece_4_, int p_generateAndAddPiece_5_, int p_generateAndAddPiece_6_, EnumFacing p_generateAndAddPiece_7_, int p_generateAndAddPiece_8_, boolean p_generateAndAddPiece_9_) {
            Piece lvt_11_1_;
            if (Math.abs(p_generateAndAddPiece_4_ - p_generateAndAddPiece_1_.getBoundingBox().minX) > 112 || Math.abs(p_generateAndAddPiece_6_ - p_generateAndAddPiece_1_.getBoundingBox().minZ) > 112) {
                return End.createPiece(p_generateAndAddPiece_2_, p_generateAndAddPiece_3_, p_generateAndAddPiece_4_, p_generateAndAddPiece_5_, p_generateAndAddPiece_6_, p_generateAndAddPiece_7_, p_generateAndAddPiece_8_);
            }
            List<PieceWeight> lvt_10_1_ = p_generateAndAddPiece_1_.primaryWeights;
            if (p_generateAndAddPiece_9_) {
                lvt_10_1_ = p_generateAndAddPiece_1_.secondaryWeights;
            }
            if ((lvt_11_1_ = this.generatePiece(p_generateAndAddPiece_1_, lvt_10_1_, p_generateAndAddPiece_2_, p_generateAndAddPiece_3_, p_generateAndAddPiece_4_, p_generateAndAddPiece_5_, p_generateAndAddPiece_6_, p_generateAndAddPiece_7_, p_generateAndAddPiece_8_ + 1)) != null) {
                p_generateAndAddPiece_2_.add(lvt_11_1_);
                p_generateAndAddPiece_1_.pendingChildren.add(lvt_11_1_);
            }
            return lvt_11_1_;
        }

        @Nullable
        protected StructureComponent getNextComponentNormal(Start p_getNextComponentNormal_1_, List<StructureComponent> p_getNextComponentNormal_2_, Random p_getNextComponentNormal_3_, int p_getNextComponentNormal_4_, int p_getNextComponentNormal_5_, boolean p_getNextComponentNormal_6_) {
            EnumFacing lvt_7_1_ = this.getCoordBaseMode();
            if (lvt_7_1_ != null) {
                switch (lvt_7_1_) {
                    case NORTH: {
                        return this.generateAndAddPiece(p_getNextComponentNormal_1_, p_getNextComponentNormal_2_, p_getNextComponentNormal_3_, this.boundingBox.minX + p_getNextComponentNormal_4_, this.boundingBox.minY + p_getNextComponentNormal_5_, this.boundingBox.minZ - 1, lvt_7_1_, this.getComponentType(), p_getNextComponentNormal_6_);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(p_getNextComponentNormal_1_, p_getNextComponentNormal_2_, p_getNextComponentNormal_3_, this.boundingBox.minX + p_getNextComponentNormal_4_, this.boundingBox.minY + p_getNextComponentNormal_5_, this.boundingBox.maxZ + 1, lvt_7_1_, this.getComponentType(), p_getNextComponentNormal_6_);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(p_getNextComponentNormal_1_, p_getNextComponentNormal_2_, p_getNextComponentNormal_3_, this.boundingBox.minX - 1, this.boundingBox.minY + p_getNextComponentNormal_5_, this.boundingBox.minZ + p_getNextComponentNormal_4_, lvt_7_1_, this.getComponentType(), p_getNextComponentNormal_6_);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(p_getNextComponentNormal_1_, p_getNextComponentNormal_2_, p_getNextComponentNormal_3_, this.boundingBox.maxX + 1, this.boundingBox.minY + p_getNextComponentNormal_5_, this.boundingBox.minZ + p_getNextComponentNormal_4_, lvt_7_1_, this.getComponentType(), p_getNextComponentNormal_6_);
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructureComponent getNextComponentX(Start p_getNextComponentX_1_, List<StructureComponent> p_getNextComponentX_2_, Random p_getNextComponentX_3_, int p_getNextComponentX_4_, int p_getNextComponentX_5_, boolean p_getNextComponentX_6_) {
            EnumFacing lvt_7_1_ = this.getCoordBaseMode();
            if (lvt_7_1_ != null) {
                switch (lvt_7_1_) {
                    case NORTH: {
                        return this.generateAndAddPiece(p_getNextComponentX_1_, p_getNextComponentX_2_, p_getNextComponentX_3_, this.boundingBox.minX - 1, this.boundingBox.minY + p_getNextComponentX_4_, this.boundingBox.minZ + p_getNextComponentX_5_, EnumFacing.WEST, this.getComponentType(), p_getNextComponentX_6_);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(p_getNextComponentX_1_, p_getNextComponentX_2_, p_getNextComponentX_3_, this.boundingBox.minX - 1, this.boundingBox.minY + p_getNextComponentX_4_, this.boundingBox.minZ + p_getNextComponentX_5_, EnumFacing.WEST, this.getComponentType(), p_getNextComponentX_6_);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(p_getNextComponentX_1_, p_getNextComponentX_2_, p_getNextComponentX_3_, this.boundingBox.minX + p_getNextComponentX_5_, this.boundingBox.minY + p_getNextComponentX_4_, this.boundingBox.minZ - 1, EnumFacing.NORTH, this.getComponentType(), p_getNextComponentX_6_);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(p_getNextComponentX_1_, p_getNextComponentX_2_, p_getNextComponentX_3_, this.boundingBox.minX + p_getNextComponentX_5_, this.boundingBox.minY + p_getNextComponentX_4_, this.boundingBox.minZ - 1, EnumFacing.NORTH, this.getComponentType(), p_getNextComponentX_6_);
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructureComponent getNextComponentZ(Start p_getNextComponentZ_1_, List<StructureComponent> p_getNextComponentZ_2_, Random p_getNextComponentZ_3_, int p_getNextComponentZ_4_, int p_getNextComponentZ_5_, boolean p_getNextComponentZ_6_) {
            EnumFacing lvt_7_1_ = this.getCoordBaseMode();
            if (lvt_7_1_ != null) {
                switch (lvt_7_1_) {
                    case NORTH: {
                        return this.generateAndAddPiece(p_getNextComponentZ_1_, p_getNextComponentZ_2_, p_getNextComponentZ_3_, this.boundingBox.maxX + 1, this.boundingBox.minY + p_getNextComponentZ_4_, this.boundingBox.minZ + p_getNextComponentZ_5_, EnumFacing.EAST, this.getComponentType(), p_getNextComponentZ_6_);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(p_getNextComponentZ_1_, p_getNextComponentZ_2_, p_getNextComponentZ_3_, this.boundingBox.maxX + 1, this.boundingBox.minY + p_getNextComponentZ_4_, this.boundingBox.minZ + p_getNextComponentZ_5_, EnumFacing.EAST, this.getComponentType(), p_getNextComponentZ_6_);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(p_getNextComponentZ_1_, p_getNextComponentZ_2_, p_getNextComponentZ_3_, this.boundingBox.minX + p_getNextComponentZ_5_, this.boundingBox.minY + p_getNextComponentZ_4_, this.boundingBox.maxZ + 1, EnumFacing.SOUTH, this.getComponentType(), p_getNextComponentZ_6_);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(p_getNextComponentZ_1_, p_getNextComponentZ_2_, p_getNextComponentZ_3_, this.boundingBox.minX + p_getNextComponentZ_5_, this.boundingBox.minY + p_getNextComponentZ_4_, this.boundingBox.maxZ + 1, EnumFacing.SOUTH, this.getComponentType(), p_getNextComponentZ_6_);
                    }
                }
            }
            return null;
        }

        protected static boolean isAboveGround(StructureBoundingBox p_isAboveGround_0_) {
            return p_isAboveGround_0_ != null && p_isAboveGround_0_.minY > 10;
        }
    }

    static class PieceWeight {
        public Class<? extends Piece> weightClass;
        public final int weight;
        public int placeCount;
        public int maxPlaceCount;
        public boolean allowInRow;

        public PieceWeight(Class<? extends Piece> p_i2055_1_, int p_i2055_2_, int p_i2055_3_, boolean p_i2055_4_) {
            this.weightClass = p_i2055_1_;
            this.weight = p_i2055_2_;
            this.maxPlaceCount = p_i2055_3_;
            this.allowInRow = p_i2055_4_;
        }

        public PieceWeight(Class<? extends Piece> p_i2056_1_, int p_i2056_2_, int p_i2056_3_) {
            this(p_i2056_1_, p_i2056_2_, p_i2056_3_, false);
        }

        public boolean doPlace(int p_doPlace_1_) {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }

        public boolean isValid() {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }
    }
}

