/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureOceanMonumentPieces;
import net.minecraft.world.gen.structure.StructureStart;

public class StructureOceanMonument
extends MapGenStructure {
    private int spacing = 32;
    private int separation = 5;
    public static final List<Biome> WATER_BIOMES = Arrays.asList(Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.RIVER, Biomes.FROZEN_OCEAN, Biomes.FROZEN_RIVER);
    public static final List<Biome> SPAWN_BIOMES = Arrays.asList(Biomes.DEEP_OCEAN);
    private static final List<Biome.SpawnListEntry> MONUMENT_ENEMIES = Lists.newArrayList();

    public StructureOceanMonument() {
    }

    public StructureOceanMonument(Map<String, String> p_i45608_1_) {
        this();
        for (Map.Entry<String, String> lvt_3_1_ : p_i45608_1_.entrySet()) {
            if (lvt_3_1_.getKey().equals("spacing")) {
                this.spacing = MathHelper.getInt(lvt_3_1_.getValue(), this.spacing, 1);
                continue;
            }
            if (!lvt_3_1_.getKey().equals("separation")) continue;
            this.separation = MathHelper.getInt(lvt_3_1_.getValue(), this.separation, 1);
        }
    }

    @Override
    public String getStructureName() {
        return "Monument";
    }

    @Override
    protected boolean canSpawnStructureAtCoords(int p_canSpawnStructureAtCoords_1_, int p_canSpawnStructureAtCoords_2_) {
        int lvt_3_1_ = p_canSpawnStructureAtCoords_1_;
        int lvt_4_1_ = p_canSpawnStructureAtCoords_2_;
        if (p_canSpawnStructureAtCoords_1_ < 0) {
            p_canSpawnStructureAtCoords_1_ -= this.spacing - 1;
        }
        if (p_canSpawnStructureAtCoords_2_ < 0) {
            p_canSpawnStructureAtCoords_2_ -= this.spacing - 1;
        }
        int lvt_5_1_ = p_canSpawnStructureAtCoords_1_ / this.spacing;
        int lvt_6_1_ = p_canSpawnStructureAtCoords_2_ / this.spacing;
        Random lvt_7_1_ = this.world.setRandomSeed(lvt_5_1_, lvt_6_1_, 10387313);
        lvt_5_1_ *= this.spacing;
        lvt_6_1_ *= this.spacing;
        p_canSpawnStructureAtCoords_1_ = lvt_3_1_;
        p_canSpawnStructureAtCoords_2_ = lvt_4_1_;
        if (p_canSpawnStructureAtCoords_1_ == (lvt_5_1_ += (lvt_7_1_.nextInt(this.spacing - this.separation) + lvt_7_1_.nextInt(this.spacing - this.separation)) / 2) && p_canSpawnStructureAtCoords_2_ == (lvt_6_1_ += (lvt_7_1_.nextInt(this.spacing - this.separation) + lvt_7_1_.nextInt(this.spacing - this.separation)) / 2)) {
            if (!this.world.getBiomeProvider().areBiomesViable(p_canSpawnStructureAtCoords_1_ * 16 + 8, p_canSpawnStructureAtCoords_2_ * 16 + 8, 16, SPAWN_BIOMES)) {
                return false;
            }
            boolean lvt_8_1_ = this.world.getBiomeProvider().areBiomesViable(p_canSpawnStructureAtCoords_1_ * 16 + 8, p_canSpawnStructureAtCoords_2_ * 16 + 8, 29, WATER_BIOMES);
            if (lvt_8_1_) {
                return true;
            }
        }
        return false;
    }

    @Override
    public BlockPos getClosestStrongholdPos(World p_getClosestStrongholdPos_1_, BlockPos p_getClosestStrongholdPos_2_, boolean p_getClosestStrongholdPos_3_) {
        this.world = p_getClosestStrongholdPos_1_;
        return StructureOceanMonument.findNearestStructurePosBySpacing(p_getClosestStrongholdPos_1_, this, p_getClosestStrongholdPos_2_, this.spacing, this.separation, 10387313, true, 100, p_getClosestStrongholdPos_3_);
    }

    @Override
    protected StructureStart getStructureStart(int p_getStructureStart_1_, int p_getStructureStart_2_) {
        return new StartMonument(this.world, this.rand, p_getStructureStart_1_, p_getStructureStart_2_);
    }

    public List<Biome.SpawnListEntry> getScatteredFeatureSpawnList() {
        return MONUMENT_ENEMIES;
    }

    static {
        MONUMENT_ENEMIES.add(new Biome.SpawnListEntry(EntityGuardian.class, 1, 2, 4));
    }

    public static class StartMonument
    extends StructureStart {
        private final Set<ChunkPos> processed = Sets.newHashSet();
        private boolean wasCreated;

        public StartMonument() {
        }

        public StartMonument(World p_i45607_1_, Random p_i45607_2_, int p_i45607_3_, int p_i45607_4_) {
            super(p_i45607_3_, p_i45607_4_);
            this.create(p_i45607_1_, p_i45607_2_, p_i45607_3_, p_i45607_4_);
        }

        private void create(World p_create_1_, Random p_create_2_, int p_create_3_, int p_create_4_) {
            p_create_2_.setSeed(p_create_1_.getSeed());
            long lvt_5_1_ = p_create_2_.nextLong();
            long lvt_7_1_ = p_create_2_.nextLong();
            long lvt_9_1_ = (long)p_create_3_ * lvt_5_1_;
            long lvt_11_1_ = (long)p_create_4_ * lvt_7_1_;
            p_create_2_.setSeed(lvt_9_1_ ^ lvt_11_1_ ^ p_create_1_.getSeed());
            int lvt_13_1_ = p_create_3_ * 16 + 8 - 29;
            int lvt_14_1_ = p_create_4_ * 16 + 8 - 29;
            EnumFacing lvt_15_1_ = EnumFacing.Plane.HORIZONTAL.random(p_create_2_);
            this.components.add(new StructureOceanMonumentPieces.MonumentBuilding(p_create_2_, lvt_13_1_, lvt_14_1_, lvt_15_1_));
            this.updateBoundingBox();
            this.wasCreated = true;
        }

        @Override
        public void generateStructure(World p_generateStructure_1_, Random p_generateStructure_2_, StructureBoundingBox p_generateStructure_3_) {
            if (!this.wasCreated) {
                this.components.clear();
                this.create(p_generateStructure_1_, p_generateStructure_2_, this.getChunkPosX(), this.getChunkPosZ());
            }
            super.generateStructure(p_generateStructure_1_, p_generateStructure_2_, p_generateStructure_3_);
        }

        @Override
        public boolean isValidForPostProcess(ChunkPos p_isValidForPostProcess_1_) {
            if (this.processed.contains(p_isValidForPostProcess_1_)) {
                return false;
            }
            return super.isValidForPostProcess(p_isValidForPostProcess_1_);
        }

        @Override
        public void notifyPostProcessAt(ChunkPos p_notifyPostProcessAt_1_) {
            super.notifyPostProcessAt(p_notifyPostProcessAt_1_);
            this.processed.add(p_notifyPostProcessAt_1_);
        }

        @Override
        public void writeToNBT(NBTTagCompound p_writeToNBT_1_) {
            super.writeToNBT(p_writeToNBT_1_);
            NBTTagList lvt_2_1_ = new NBTTagList();
            for (ChunkPos lvt_4_1_ : this.processed) {
                NBTTagCompound lvt_5_1_ = new NBTTagCompound();
                lvt_5_1_.setInteger("X", lvt_4_1_.chunkXPos);
                lvt_5_1_.setInteger("Z", lvt_4_1_.chunkZPos);
                lvt_2_1_.appendTag(lvt_5_1_);
            }
            p_writeToNBT_1_.setTag("Processed", lvt_2_1_);
        }

        @Override
        public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
            super.readFromNBT(p_readFromNBT_1_);
            if (p_readFromNBT_1_.hasKey("Processed", 9)) {
                NBTTagList lvt_2_1_ = p_readFromNBT_1_.getTagList("Processed", 10);
                for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_1_.tagCount(); ++lvt_3_1_) {
                    NBTTagCompound lvt_4_1_ = lvt_2_1_.getCompoundTagAt(lvt_3_1_);
                    this.processed.add(new ChunkPos(lvt_4_1_.getInteger("X"), lvt_4_1_.getInteger("Z")));
                }
            }
        }
    }
}

