/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockPrismarine;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class StructureOceanMonumentPieces {
    public static void registerOceanMonumentPieces() {
        MapGenStructureIO.registerStructureComponent(MonumentBuilding.class, "OMB");
        MapGenStructureIO.registerStructureComponent(MonumentCoreRoom.class, "OMCR");
        MapGenStructureIO.registerStructureComponent(DoubleXRoom.class, "OMDXR");
        MapGenStructureIO.registerStructureComponent(DoubleXYRoom.class, "OMDXYR");
        MapGenStructureIO.registerStructureComponent(DoubleYRoom.class, "OMDYR");
        MapGenStructureIO.registerStructureComponent(DoubleYZRoom.class, "OMDYZR");
        MapGenStructureIO.registerStructureComponent(DoubleZRoom.class, "OMDZR");
        MapGenStructureIO.registerStructureComponent(EntryRoom.class, "OMEntry");
        MapGenStructureIO.registerStructureComponent(Penthouse.class, "OMPenthouse");
        MapGenStructureIO.registerStructureComponent(SimpleRoom.class, "OMSimple");
        MapGenStructureIO.registerStructureComponent(SimpleTopRoom.class, "OMSimpleT");
    }

    static class YZDoubleRoomFitHelper
    implements MonumentRoomFitHelper {
        private YZDoubleRoomFitHelper() {
        }

        @Override
        public boolean fits(RoomDefinition p_fits_1_) {
            if (p_fits_1_.hasOpening[EnumFacing.NORTH.getIndex()] && !p_fits_1_.connections[EnumFacing.NORTH.getIndex()].claimed && p_fits_1_.hasOpening[EnumFacing.UP.getIndex()] && !p_fits_1_.connections[EnumFacing.UP.getIndex()].claimed) {
                RoomDefinition lvt_2_1_ = p_fits_1_.connections[EnumFacing.NORTH.getIndex()];
                return lvt_2_1_.hasOpening[EnumFacing.UP.getIndex()] && !lvt_2_1_.connections[EnumFacing.UP.getIndex()].claimed;
            }
            return false;
        }

        @Override
        public Piece create(EnumFacing p_create_1_, RoomDefinition p_create_2_, Random p_create_3_) {
            p_create_2_.claimed = true;
            p_create_2_.connections[EnumFacing.NORTH.getIndex()].claimed = true;
            p_create_2_.connections[EnumFacing.UP.getIndex()].claimed = true;
            p_create_2_.connections[EnumFacing.NORTH.getIndex()].connections[EnumFacing.UP.getIndex()].claimed = true;
            return new DoubleYZRoom(p_create_1_, p_create_2_, p_create_3_);
        }
    }

    static class XYDoubleRoomFitHelper
    implements MonumentRoomFitHelper {
        private XYDoubleRoomFitHelper() {
        }

        @Override
        public boolean fits(RoomDefinition p_fits_1_) {
            if (p_fits_1_.hasOpening[EnumFacing.EAST.getIndex()] && !p_fits_1_.connections[EnumFacing.EAST.getIndex()].claimed && p_fits_1_.hasOpening[EnumFacing.UP.getIndex()] && !p_fits_1_.connections[EnumFacing.UP.getIndex()].claimed) {
                RoomDefinition lvt_2_1_ = p_fits_1_.connections[EnumFacing.EAST.getIndex()];
                return lvt_2_1_.hasOpening[EnumFacing.UP.getIndex()] && !lvt_2_1_.connections[EnumFacing.UP.getIndex()].claimed;
            }
            return false;
        }

        @Override
        public Piece create(EnumFacing p_create_1_, RoomDefinition p_create_2_, Random p_create_3_) {
            p_create_2_.claimed = true;
            p_create_2_.connections[EnumFacing.EAST.getIndex()].claimed = true;
            p_create_2_.connections[EnumFacing.UP.getIndex()].claimed = true;
            p_create_2_.connections[EnumFacing.EAST.getIndex()].connections[EnumFacing.UP.getIndex()].claimed = true;
            return new DoubleXYRoom(p_create_1_, p_create_2_, p_create_3_);
        }
    }

    static class ZDoubleRoomFitHelper
    implements MonumentRoomFitHelper {
        private ZDoubleRoomFitHelper() {
        }

        @Override
        public boolean fits(RoomDefinition p_fits_1_) {
            return p_fits_1_.hasOpening[EnumFacing.NORTH.getIndex()] && !p_fits_1_.connections[EnumFacing.NORTH.getIndex()].claimed;
        }

        @Override
        public Piece create(EnumFacing p_create_1_, RoomDefinition p_create_2_, Random p_create_3_) {
            RoomDefinition lvt_4_1_ = p_create_2_;
            if (!p_create_2_.hasOpening[EnumFacing.NORTH.getIndex()] || p_create_2_.connections[EnumFacing.NORTH.getIndex()].claimed) {
                lvt_4_1_ = p_create_2_.connections[EnumFacing.SOUTH.getIndex()];
            }
            lvt_4_1_.claimed = true;
            lvt_4_1_.connections[EnumFacing.NORTH.getIndex()].claimed = true;
            return new DoubleZRoom(p_create_1_, lvt_4_1_, p_create_3_);
        }
    }

    static class XDoubleRoomFitHelper
    implements MonumentRoomFitHelper {
        private XDoubleRoomFitHelper() {
        }

        @Override
        public boolean fits(RoomDefinition p_fits_1_) {
            return p_fits_1_.hasOpening[EnumFacing.EAST.getIndex()] && !p_fits_1_.connections[EnumFacing.EAST.getIndex()].claimed;
        }

        @Override
        public Piece create(EnumFacing p_create_1_, RoomDefinition p_create_2_, Random p_create_3_) {
            p_create_2_.claimed = true;
            p_create_2_.connections[EnumFacing.EAST.getIndex()].claimed = true;
            return new DoubleXRoom(p_create_1_, p_create_2_, p_create_3_);
        }
    }

    static class YDoubleRoomFitHelper
    implements MonumentRoomFitHelper {
        private YDoubleRoomFitHelper() {
        }

        @Override
        public boolean fits(RoomDefinition p_fits_1_) {
            return p_fits_1_.hasOpening[EnumFacing.UP.getIndex()] && !p_fits_1_.connections[EnumFacing.UP.getIndex()].claimed;
        }

        @Override
        public Piece create(EnumFacing p_create_1_, RoomDefinition p_create_2_, Random p_create_3_) {
            p_create_2_.claimed = true;
            p_create_2_.connections[EnumFacing.UP.getIndex()].claimed = true;
            return new DoubleYRoom(p_create_1_, p_create_2_, p_create_3_);
        }
    }

    static class FitSimpleRoomTopHelper
    implements MonumentRoomFitHelper {
        private FitSimpleRoomTopHelper() {
        }

        @Override
        public boolean fits(RoomDefinition p_fits_1_) {
            return !p_fits_1_.hasOpening[EnumFacing.WEST.getIndex()] && !p_fits_1_.hasOpening[EnumFacing.EAST.getIndex()] && !p_fits_1_.hasOpening[EnumFacing.NORTH.getIndex()] && !p_fits_1_.hasOpening[EnumFacing.SOUTH.getIndex()] && !p_fits_1_.hasOpening[EnumFacing.UP.getIndex()];
        }

        @Override
        public Piece create(EnumFacing p_create_1_, RoomDefinition p_create_2_, Random p_create_3_) {
            p_create_2_.claimed = true;
            return new SimpleTopRoom(p_create_1_, p_create_2_, p_create_3_);
        }
    }

    static class FitSimpleRoomHelper
    implements MonumentRoomFitHelper {
        private FitSimpleRoomHelper() {
        }

        @Override
        public boolean fits(RoomDefinition p_fits_1_) {
            return true;
        }

        @Override
        public Piece create(EnumFacing p_create_1_, RoomDefinition p_create_2_, Random p_create_3_) {
            p_create_2_.claimed = true;
            return new SimpleRoom(p_create_1_, p_create_2_, p_create_3_);
        }
    }

    static interface MonumentRoomFitHelper {
        public boolean fits(RoomDefinition var1);

        public Piece create(EnumFacing var1, RoomDefinition var2, Random var3);
    }

    static class RoomDefinition {
        int index;
        RoomDefinition[] connections = new RoomDefinition[6];
        boolean[] hasOpening = new boolean[6];
        boolean claimed;
        boolean isSource;
        int scanIndex;

        public RoomDefinition(int p_i45584_1_) {
            this.index = p_i45584_1_;
        }

        public void setConnection(EnumFacing p_setConnection_1_, RoomDefinition p_setConnection_2_) {
            this.connections[p_setConnection_1_.getIndex()] = p_setConnection_2_;
            p_setConnection_2_.connections[p_setConnection_1_.getOpposite().getIndex()] = this;
        }

        public void updateOpenings() {
            for (int lvt_1_1_ = 0; lvt_1_1_ < 6; ++lvt_1_1_) {
                this.hasOpening[lvt_1_1_] = this.connections[lvt_1_1_] != null;
            }
        }

        public boolean findSource(int p_findSource_1_) {
            if (this.isSource) {
                return true;
            }
            this.scanIndex = p_findSource_1_;
            for (int lvt_2_1_ = 0; lvt_2_1_ < 6; ++lvt_2_1_) {
                if (this.connections[lvt_2_1_] == null || !this.hasOpening[lvt_2_1_] || this.connections[lvt_2_1_].scanIndex == p_findSource_1_ || !this.connections[lvt_2_1_].findSource(p_findSource_1_)) continue;
                return true;
            }
            return false;
        }

        public boolean isSpecial() {
            return this.index >= 75;
        }

        public int countOpenings() {
            int lvt_1_1_ = 0;
            for (int lvt_2_1_ = 0; lvt_2_1_ < 6; ++lvt_2_1_) {
                if (!this.hasOpening[lvt_2_1_]) continue;
                ++lvt_1_1_;
            }
            return lvt_1_1_;
        }
    }

    public static class Penthouse
    extends Piece {
        public Penthouse() {
        }

        public Penthouse(EnumFacing p_i45591_1_, StructureBoundingBox p_i45591_2_) {
            super(p_i45591_1_, p_i45591_2_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, -1, 2, 11, -1, 11, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, -1, 0, 1, -1, 11, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 12, -1, 0, 13, -1, 11, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, -1, 0, 11, -1, 1, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, -1, 12, 11, -1, 13, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 0, 0, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 13, 0, 0, 13, 0, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, 0, 12, 0, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, 13, 12, 0, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            for (int lvt_4_1_ = 2; lvt_4_1_ <= 11; lvt_4_1_ += 3) {
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 0, 0, lvt_4_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 13, 0, lvt_4_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, lvt_4_1_, 0, 0, p_addComponentParts_3_);
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 0, 3, 4, 0, 9, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 0, 3, 11, 0, 9, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 0, 9, 9, 0, 11, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 5, 0, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 8, 0, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 10, 0, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 3, 0, 10, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 0, 3, 3, 0, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 10, 0, 3, 10, 0, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 0, 10, 7, 0, 10, DARK_PRISMARINE, DARK_PRISMARINE, false);
            int lvt_4_2_ = 3;
            for (int lvt_5_1_ = 0; lvt_5_1_ < 2; ++lvt_5_1_) {
                for (int lvt_6_1_ = 2; lvt_6_1_ <= 8; lvt_6_1_ += 3) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_4_2_, 0, lvt_6_1_, lvt_4_2_, 2, lvt_6_1_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
                lvt_4_2_ = 10;
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 0, 10, 5, 2, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 0, 10, 8, 2, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, -1, 7, 7, -1, 8, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 6, -1, 3, 7, -1, 4, false);
            this.spawnElder(p_addComponentParts_1_, p_addComponentParts_3_, 6, 1, 6);
            return true;
        }
    }

    public static class WingRoom
    extends Piece {
        private int mainDesign;

        public WingRoom() {
        }

        public WingRoom(EnumFacing p_i45585_1_, StructureBoundingBox p_i45585_2_, int p_i45585_3_) {
            super(p_i45585_1_, p_i45585_2_);
            this.mainDesign = p_i45585_3_ & 1;
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.mainDesign == 0) {
                for (int lvt_4_1_ = 0; lvt_4_1_ < 4; ++lvt_4_1_) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 10 - lvt_4_1_, 3 - lvt_4_1_, 20 - lvt_4_1_, 12 + lvt_4_1_, 3 - lvt_4_1_, 20, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 0, 6, 15, 0, 16, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 0, 6, 6, 3, 20, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 16, 0, 6, 16, 3, 20, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 1, 7, 7, 1, 20, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 15, 1, 7, 15, 1, 20, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 1, 6, 9, 3, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 13, 1, 6, 15, 3, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 1, 7, 9, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 13, 1, 7, 14, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 0, 5, 13, 0, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 10, 0, 7, 12, 0, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 0, 10, 8, 0, 12, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 14, 0, 10, 14, 0, 12, DARK_PRISMARINE, DARK_PRISMARINE, false);
                for (int lvt_4_2_ = 18; lvt_4_2_ >= 7; lvt_4_2_ -= 3) {
                    this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 6, 3, lvt_4_2_, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 16, 3, lvt_4_2_, p_addComponentParts_3_);
                }
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 10, 0, 10, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 12, 0, 10, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 10, 0, 12, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 12, 0, 12, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 8, 3, 6, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 14, 3, 6, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 4, 2, 4, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 4, 1, 4, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 4, 0, 4, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 18, 2, 4, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 18, 1, 4, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 18, 0, 4, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 4, 2, 18, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 4, 1, 18, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 4, 0, 18, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 18, 2, 18, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 18, 1, 18, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 18, 0, 18, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 9, 7, 20, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 13, 7, 20, p_addComponentParts_3_);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 0, 21, 7, 4, 21, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 15, 0, 21, 16, 4, 21, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.spawnElder(p_addComponentParts_1_, p_addComponentParts_3_, 11, 2, 16);
            } else if (this.mainDesign == 1) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 3, 18, 13, 3, 20, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 0, 18, 9, 2, 18, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 13, 0, 18, 13, 2, 18, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                int lvt_4_3_ = 9;
                int lvt_5_1_ = 20;
                int lvt_6_1_ = 5;
                for (int lvt_7_1_ = 0; lvt_7_1_ < 2; ++lvt_7_1_) {
                    this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, lvt_4_3_, 6, 20, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, lvt_4_3_, 5, 20, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, lvt_4_3_, 4, 20, p_addComponentParts_3_);
                    lvt_4_3_ = 13;
                }
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 3, 7, 15, 3, 14, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                lvt_4_3_ = 10;
                for (int lvt_7_2_ = 0; lvt_7_2_ < 2; ++lvt_7_2_) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_4_3_, 0, 10, lvt_4_3_, 6, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_4_3_, 0, 12, lvt_4_3_, 6, 12, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, lvt_4_3_, 0, 10, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, lvt_4_3_, 0, 12, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, lvt_4_3_, 4, 10, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, lvt_4_3_, 4, 12, p_addComponentParts_3_);
                    lvt_4_3_ = 12;
                }
                lvt_4_3_ = 8;
                for (int lvt_7_3_ = 0; lvt_7_3_ < 2; ++lvt_7_3_) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_4_3_, 0, 7, lvt_4_3_, 2, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_4_3_, 0, 14, lvt_4_3_, 2, 14, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    lvt_4_3_ = 14;
                }
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 3, 8, 8, 3, 13, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 14, 3, 8, 14, 3, 13, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.spawnElder(p_addComponentParts_1_, p_addComponentParts_3_, 11, 5, 13);
            }
            return true;
        }
    }

    public static class MonumentCoreRoom
    extends Piece {
        public MonumentCoreRoom() {
        }

        public MonumentCoreRoom(EnumFacing p_i45598_1_, RoomDefinition p_i45598_2_, Random p_i45598_3_) {
            super(1, p_i45598_1_, p_i45598_2_, 2, 2, 2);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            this.generateBoxOnFillOnly(p_addComponentParts_1_, p_addComponentParts_3_, 1, 8, 0, 14, 8, 14, ROUGH_PRISMARINE);
            int lvt_4_1_ = 7;
            IBlockState lvt_5_1_ = BRICKS_PRISMARINE;
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 7, 0, 0, 7, 15, lvt_5_1_, lvt_5_1_, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 15, 7, 0, 15, 7, 15, lvt_5_1_, lvt_5_1_, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 7, 0, 15, 7, 0, lvt_5_1_, lvt_5_1_, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 7, 15, 14, 7, 15, lvt_5_1_, lvt_5_1_, false);
            for (int lvt_4_2_ = 1; lvt_4_2_ <= 6; ++lvt_4_2_) {
                IBlockState lvt_5_2_ = BRICKS_PRISMARINE;
                if (lvt_4_2_ == 2 || lvt_4_2_ == 6) {
                    lvt_5_2_ = ROUGH_PRISMARINE;
                }
                for (int lvt_6_1_ = 0; lvt_6_1_ <= 15; lvt_6_1_ += 15) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_6_1_, lvt_4_2_, 0, lvt_6_1_, lvt_4_2_, 1, lvt_5_2_, lvt_5_2_, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_6_1_, lvt_4_2_, 6, lvt_6_1_, lvt_4_2_, 9, lvt_5_2_, lvt_5_2_, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_6_1_, lvt_4_2_, 14, lvt_6_1_, lvt_4_2_, 15, lvt_5_2_, lvt_5_2_, false);
                }
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, lvt_4_2_, 0, 1, lvt_4_2_, 0, lvt_5_2_, lvt_5_2_, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, lvt_4_2_, 0, 9, lvt_4_2_, 0, lvt_5_2_, lvt_5_2_, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 14, lvt_4_2_, 0, 14, lvt_4_2_, 0, lvt_5_2_, lvt_5_2_, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, lvt_4_2_, 15, 14, lvt_4_2_, 15, lvt_5_2_, lvt_5_2_, false);
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 3, 6, 9, 6, 9, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 4, 7, 8, 5, 8, Blocks.GOLD_BLOCK.getDefaultState(), Blocks.GOLD_BLOCK.getDefaultState(), false);
            for (int lvt_4_3_ = 3; lvt_4_3_ <= 6; lvt_4_3_ += 3) {
                for (int lvt_5_3_ = 6; lvt_5_3_ <= 9; lvt_5_3_ += 3) {
                    this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, lvt_5_3_, lvt_4_3_, 6, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, lvt_5_3_, lvt_4_3_, 9, p_addComponentParts_3_);
                }
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 1, 6, 5, 2, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 1, 9, 5, 2, 9, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 10, 1, 6, 10, 2, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 10, 1, 9, 10, 2, 9, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 1, 5, 6, 2, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 1, 5, 9, 2, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 1, 10, 6, 2, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 1, 10, 9, 2, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 2, 5, 5, 6, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 2, 10, 5, 6, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 10, 2, 5, 10, 6, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 10, 2, 10, 10, 6, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 7, 1, 5, 7, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 10, 7, 1, 10, 7, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 7, 9, 5, 7, 14, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 10, 7, 9, 10, 7, 14, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 7, 5, 6, 7, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 7, 10, 6, 7, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 7, 5, 14, 7, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 7, 10, 14, 7, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 1, 2, 2, 1, 3, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 2, 3, 1, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 13, 1, 2, 13, 1, 3, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 12, 1, 2, 12, 1, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 1, 12, 2, 1, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 13, 3, 1, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 13, 1, 12, 13, 1, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 12, 1, 13, 12, 1, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            return true;
        }
    }

    public static class DoubleYZRoom
    extends Piece {
        public DoubleYZRoom() {
        }

        public DoubleYZRoom(EnumFacing p_i45594_1_, RoomDefinition p_i45594_2_, Random p_i45594_3_) {
            super(1, p_i45594_1_, p_i45594_2_, 1, 2, 2);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            RoomDefinition lvt_4_1_ = this.roomDefinition.connections[EnumFacing.NORTH.getIndex()];
            RoomDefinition lvt_5_1_ = this.roomDefinition;
            RoomDefinition lvt_6_1_ = lvt_4_1_.connections[EnumFacing.UP.getIndex()];
            RoomDefinition lvt_7_1_ = lvt_5_1_.connections[EnumFacing.UP.getIndex()];
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(p_addComponentParts_1_, p_addComponentParts_3_, 0, 8, lvt_4_1_.hasOpening[EnumFacing.DOWN.getIndex()]);
                this.generateDefaultFloor(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, lvt_5_1_.hasOpening[EnumFacing.DOWN.getIndex()]);
            }
            if (lvt_7_1_.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(p_addComponentParts_1_, p_addComponentParts_3_, 1, 8, 1, 6, 8, 7, ROUGH_PRISMARINE);
            }
            if (lvt_6_1_.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(p_addComponentParts_1_, p_addComponentParts_3_, 1, 8, 8, 6, 8, 14, ROUGH_PRISMARINE);
            }
            for (int lvt_8_1_ = 1; lvt_8_1_ <= 7; ++lvt_8_1_) {
                IBlockState lvt_9_1_ = BRICKS_PRISMARINE;
                if (lvt_8_1_ == 2 || lvt_8_1_ == 6) {
                    lvt_9_1_ = ROUGH_PRISMARINE;
                }
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, lvt_8_1_, 0, 0, lvt_8_1_, 15, lvt_9_1_, lvt_9_1_, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, lvt_8_1_, 0, 7, lvt_8_1_, 15, lvt_9_1_, lvt_9_1_, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, lvt_8_1_, 0, 6, lvt_8_1_, 0, lvt_9_1_, lvt_9_1_, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, lvt_8_1_, 15, 6, lvt_8_1_, 15, lvt_9_1_, lvt_9_1_, false);
            }
            for (int lvt_8_2_ = 1; lvt_8_2_ <= 7; ++lvt_8_2_) {
                IBlockState lvt_9_2_ = DARK_PRISMARINE;
                if (lvt_8_2_ == 2 || lvt_8_2_ == 6) {
                    lvt_9_2_ = SEA_LANTERN;
                }
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, lvt_8_2_, 7, 4, lvt_8_2_, 8, lvt_9_2_, lvt_9_2_, false);
            }
            if (lvt_5_1_.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 0, 4, 2, 0, false);
            }
            if (lvt_5_1_.hasOpening[EnumFacing.EAST.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 7, 1, 3, 7, 2, 4, false);
            }
            if (lvt_5_1_.hasOpening[EnumFacing.WEST.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 3, 0, 2, 4, false);
            }
            if (lvt_4_1_.hasOpening[EnumFacing.NORTH.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 15, 4, 2, 15, false);
            }
            if (lvt_4_1_.hasOpening[EnumFacing.WEST.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 11, 0, 2, 12, false);
            }
            if (lvt_4_1_.hasOpening[EnumFacing.EAST.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 7, 1, 11, 7, 2, 12, false);
            }
            if (lvt_7_1_.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 3, 5, 0, 4, 6, 0, false);
            }
            if (lvt_7_1_.hasOpening[EnumFacing.EAST.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 7, 5, 3, 7, 6, 4, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 4, 2, 6, 4, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 1, 2, 6, 3, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 1, 5, 6, 3, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            }
            if (lvt_7_1_.hasOpening[EnumFacing.WEST.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5, 3, 0, 6, 4, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 4, 2, 2, 4, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 2, 1, 3, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 5, 1, 3, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            }
            if (lvt_6_1_.hasOpening[EnumFacing.NORTH.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 3, 5, 15, 4, 6, 15, false);
            }
            if (lvt_6_1_.hasOpening[EnumFacing.WEST.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5, 11, 0, 6, 12, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 4, 10, 2, 4, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 10, 1, 3, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 13, 1, 3, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            }
            if (lvt_6_1_.hasOpening[EnumFacing.EAST.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 7, 5, 11, 7, 6, 12, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 4, 10, 6, 4, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 1, 10, 6, 3, 10, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 1, 13, 6, 3, 13, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            }
            return true;
        }
    }

    public static class DoubleXYRoom
    extends Piece {
        public DoubleXYRoom() {
        }

        public DoubleXYRoom(EnumFacing p_i45596_1_, RoomDefinition p_i45596_2_, Random p_i45596_3_) {
            super(1, p_i45596_1_, p_i45596_2_, 2, 2, 1);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            RoomDefinition lvt_4_1_ = this.roomDefinition.connections[EnumFacing.EAST.getIndex()];
            RoomDefinition lvt_5_1_ = this.roomDefinition;
            RoomDefinition lvt_6_1_ = lvt_5_1_.connections[EnumFacing.UP.getIndex()];
            RoomDefinition lvt_7_1_ = lvt_4_1_.connections[EnumFacing.UP.getIndex()];
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(p_addComponentParts_1_, p_addComponentParts_3_, 8, 0, lvt_4_1_.hasOpening[EnumFacing.DOWN.getIndex()]);
                this.generateDefaultFloor(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, lvt_5_1_.hasOpening[EnumFacing.DOWN.getIndex()]);
            }
            if (lvt_6_1_.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(p_addComponentParts_1_, p_addComponentParts_3_, 1, 8, 1, 7, 8, 6, ROUGH_PRISMARINE);
            }
            if (lvt_7_1_.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(p_addComponentParts_1_, p_addComponentParts_3_, 8, 8, 1, 14, 8, 6, ROUGH_PRISMARINE);
            }
            for (int lvt_8_1_ = 1; lvt_8_1_ <= 7; ++lvt_8_1_) {
                IBlockState lvt_9_1_ = BRICKS_PRISMARINE;
                if (lvt_8_1_ == 2 || lvt_8_1_ == 6) {
                    lvt_9_1_ = ROUGH_PRISMARINE;
                }
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, lvt_8_1_, 0, 0, lvt_8_1_, 7, lvt_9_1_, lvt_9_1_, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 15, lvt_8_1_, 0, 15, lvt_8_1_, 7, lvt_9_1_, lvt_9_1_, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, lvt_8_1_, 0, 15, lvt_8_1_, 0, lvt_9_1_, lvt_9_1_, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, lvt_8_1_, 7, 14, lvt_8_1_, 7, lvt_9_1_, lvt_9_1_, false);
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 1, 3, 2, 7, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 2, 4, 7, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 5, 4, 7, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 13, 1, 3, 13, 7, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 11, 1, 2, 12, 7, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 11, 1, 5, 12, 7, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 1, 3, 5, 3, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 10, 1, 3, 10, 3, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 7, 2, 10, 7, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 5, 2, 5, 7, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 10, 5, 2, 10, 7, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 5, 5, 5, 7, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 10, 5, 5, 10, 7, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 6, 6, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 9, 6, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 6, 6, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 9, 6, 5, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 4, 3, 6, 4, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 4, 3, 10, 4, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 5, 4, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 5, 4, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 10, 4, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 10, 4, 5, p_addComponentParts_3_);
            if (lvt_5_1_.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 0, 4, 2, 0, false);
            }
            if (lvt_5_1_.hasOpening[EnumFacing.NORTH.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 7, 4, 2, 7, false);
            }
            if (lvt_5_1_.hasOpening[EnumFacing.WEST.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 3, 0, 2, 4, false);
            }
            if (lvt_4_1_.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 11, 1, 0, 12, 2, 0, false);
            }
            if (lvt_4_1_.hasOpening[EnumFacing.NORTH.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 11, 1, 7, 12, 2, 7, false);
            }
            if (lvt_4_1_.hasOpening[EnumFacing.EAST.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 15, 1, 3, 15, 2, 4, false);
            }
            if (lvt_6_1_.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 3, 5, 0, 4, 6, 0, false);
            }
            if (lvt_6_1_.hasOpening[EnumFacing.NORTH.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 3, 5, 7, 4, 6, 7, false);
            }
            if (lvt_6_1_.hasOpening[EnumFacing.WEST.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5, 3, 0, 6, 4, false);
            }
            if (lvt_7_1_.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 11, 5, 0, 12, 6, 0, false);
            }
            if (lvt_7_1_.hasOpening[EnumFacing.NORTH.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 11, 5, 7, 12, 6, 7, false);
            }
            if (lvt_7_1_.hasOpening[EnumFacing.EAST.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 15, 5, 3, 15, 6, 4, false);
            }
            return true;
        }
    }

    public static class DoubleZRoom
    extends Piece {
        public DoubleZRoom() {
        }

        public DoubleZRoom(EnumFacing p_i45593_1_, RoomDefinition p_i45593_2_, Random p_i45593_3_) {
            super(1, p_i45593_1_, p_i45593_2_, 1, 1, 2);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            RoomDefinition lvt_4_1_ = this.roomDefinition.connections[EnumFacing.NORTH.getIndex()];
            RoomDefinition lvt_5_1_ = this.roomDefinition;
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(p_addComponentParts_1_, p_addComponentParts_3_, 0, 8, lvt_4_1_.hasOpening[EnumFacing.DOWN.getIndex()]);
                this.generateDefaultFloor(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, lvt_5_1_.hasOpening[EnumFacing.DOWN.getIndex()]);
            }
            if (lvt_5_1_.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(p_addComponentParts_1_, p_addComponentParts_3_, 1, 4, 1, 6, 4, 7, ROUGH_PRISMARINE);
            }
            if (lvt_4_1_.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(p_addComponentParts_1_, p_addComponentParts_3_, 1, 4, 8, 6, 4, 14, ROUGH_PRISMARINE);
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 0, 0, 3, 15, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 3, 0, 7, 3, 15, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 0, 7, 3, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 15, 6, 3, 15, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 0, 2, 15, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 2, 0, 7, 2, 15, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 0, 7, 2, 0, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 15, 6, 2, 15, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 0, 0, 1, 15, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 1, 0, 7, 1, 15, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 0, 7, 1, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 15, 6, 1, 15, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 1, 1, 1, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 1, 1, 6, 1, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 1, 1, 3, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 3, 1, 6, 3, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 13, 1, 1, 14, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 1, 13, 6, 1, 14, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 13, 1, 3, 14, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 3, 13, 6, 3, 14, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 1, 6, 2, 3, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 1, 6, 5, 3, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 1, 9, 2, 3, 9, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 1, 9, 5, 3, 9, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 2, 6, 4, 2, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 2, 9, 4, 2, 9, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 2, 7, 2, 2, 8, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 2, 7, 5, 2, 8, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 2, 2, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 5, 2, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 2, 2, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 5, 2, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 2, 3, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 5, 3, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 2, 3, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, 5, 3, 10, p_addComponentParts_3_);
            if (lvt_5_1_.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 0, 4, 2, 0, false);
            }
            if (lvt_5_1_.hasOpening[EnumFacing.EAST.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 7, 1, 3, 7, 2, 4, false);
            }
            if (lvt_5_1_.hasOpening[EnumFacing.WEST.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 3, 0, 2, 4, false);
            }
            if (lvt_4_1_.hasOpening[EnumFacing.NORTH.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 15, 4, 2, 15, false);
            }
            if (lvt_4_1_.hasOpening[EnumFacing.WEST.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 11, 0, 2, 12, false);
            }
            if (lvt_4_1_.hasOpening[EnumFacing.EAST.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 7, 1, 11, 7, 2, 12, false);
            }
            return true;
        }
    }

    public static class DoubleXRoom
    extends Piece {
        public DoubleXRoom() {
        }

        public DoubleXRoom(EnumFacing p_i45597_1_, RoomDefinition p_i45597_2_, Random p_i45597_3_) {
            super(1, p_i45597_1_, p_i45597_2_, 2, 1, 1);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            RoomDefinition lvt_4_1_ = this.roomDefinition.connections[EnumFacing.EAST.getIndex()];
            RoomDefinition lvt_5_1_ = this.roomDefinition;
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(p_addComponentParts_1_, p_addComponentParts_3_, 8, 0, lvt_4_1_.hasOpening[EnumFacing.DOWN.getIndex()]);
                this.generateDefaultFloor(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, lvt_5_1_.hasOpening[EnumFacing.DOWN.getIndex()]);
            }
            if (lvt_5_1_.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(p_addComponentParts_1_, p_addComponentParts_3_, 1, 4, 1, 7, 4, 6, ROUGH_PRISMARINE);
            }
            if (lvt_4_1_.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(p_addComponentParts_1_, p_addComponentParts_3_, 8, 4, 1, 14, 4, 6, ROUGH_PRISMARINE);
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 0, 0, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 15, 3, 0, 15, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 0, 15, 3, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 7, 14, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 0, 2, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 15, 2, 0, 15, 2, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 0, 15, 2, 0, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 7, 14, 2, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 0, 0, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 15, 1, 0, 15, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 0, 15, 1, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 7, 14, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 1, 0, 10, 1, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 2, 0, 9, 2, 3, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 3, 0, 10, 3, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 6, 2, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 9, 2, 3, p_addComponentParts_3_);
            if (lvt_5_1_.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 0, 4, 2, 0, false);
            }
            if (lvt_5_1_.hasOpening[EnumFacing.NORTH.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 7, 4, 2, 7, false);
            }
            if (lvt_5_1_.hasOpening[EnumFacing.WEST.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 3, 0, 2, 4, false);
            }
            if (lvt_4_1_.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 11, 1, 0, 12, 2, 0, false);
            }
            if (lvt_4_1_.hasOpening[EnumFacing.NORTH.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 11, 1, 7, 12, 2, 7, false);
            }
            if (lvt_4_1_.hasOpening[EnumFacing.EAST.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 15, 1, 3, 15, 2, 4, false);
            }
            return true;
        }
    }

    public static class DoubleYRoom
    extends Piece {
        public DoubleYRoom() {
        }

        public DoubleYRoom(EnumFacing p_i45595_1_, RoomDefinition p_i45595_2_, Random p_i45595_3_) {
            super(1, p_i45595_1_, p_i45595_2_, 1, 2, 1);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, this.roomDefinition.hasOpening[EnumFacing.DOWN.getIndex()]);
            }
            RoomDefinition lvt_4_1_ = this.roomDefinition.connections[EnumFacing.UP.getIndex()];
            if (lvt_4_1_.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(p_addComponentParts_1_, p_addComponentParts_3_, 1, 8, 1, 6, 8, 6, ROUGH_PRISMARINE);
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 4, 0, 0, 4, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 4, 0, 7, 4, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 4, 0, 6, 4, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 4, 7, 6, 4, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 4, 1, 2, 4, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 4, 2, 1, 4, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 4, 1, 5, 4, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 4, 2, 6, 4, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 4, 5, 2, 4, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 4, 5, 1, 4, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 4, 5, 5, 4, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 4, 5, 6, 4, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            RoomDefinition lvt_5_1_ = this.roomDefinition;
            for (int lvt_6_1_ = 1; lvt_6_1_ <= 5; lvt_6_1_ += 4) {
                int lvt_7_1_ = 0;
                if (lvt_5_1_.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, lvt_6_1_, lvt_7_1_, 2, lvt_6_1_ + 2, lvt_7_1_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, lvt_6_1_, lvt_7_1_, 5, lvt_6_1_ + 2, lvt_7_1_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, lvt_6_1_ + 2, lvt_7_1_, 4, lvt_6_1_ + 2, lvt_7_1_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                } else {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, lvt_6_1_, lvt_7_1_, 7, lvt_6_1_ + 2, lvt_7_1_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, lvt_6_1_ + 1, lvt_7_1_, 7, lvt_6_1_ + 1, lvt_7_1_, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                }
                lvt_7_1_ = 7;
                if (lvt_5_1_.hasOpening[EnumFacing.NORTH.getIndex()]) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, lvt_6_1_, lvt_7_1_, 2, lvt_6_1_ + 2, lvt_7_1_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, lvt_6_1_, lvt_7_1_, 5, lvt_6_1_ + 2, lvt_7_1_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, lvt_6_1_ + 2, lvt_7_1_, 4, lvt_6_1_ + 2, lvt_7_1_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                } else {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, lvt_6_1_, lvt_7_1_, 7, lvt_6_1_ + 2, lvt_7_1_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, lvt_6_1_ + 1, lvt_7_1_, 7, lvt_6_1_ + 1, lvt_7_1_, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                }
                int lvt_8_1_ = 0;
                if (lvt_5_1_.hasOpening[EnumFacing.WEST.getIndex()]) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_8_1_, lvt_6_1_, 2, lvt_8_1_, lvt_6_1_ + 2, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_8_1_, lvt_6_1_, 5, lvt_8_1_, lvt_6_1_ + 2, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_8_1_, lvt_6_1_ + 2, 3, lvt_8_1_, lvt_6_1_ + 2, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                } else {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_8_1_, lvt_6_1_, 0, lvt_8_1_, lvt_6_1_ + 2, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_8_1_, lvt_6_1_ + 1, 0, lvt_8_1_, lvt_6_1_ + 1, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                }
                lvt_8_1_ = 7;
                if (lvt_5_1_.hasOpening[EnumFacing.EAST.getIndex()]) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_8_1_, lvt_6_1_, 2, lvt_8_1_, lvt_6_1_ + 2, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_8_1_, lvt_6_1_, 5, lvt_8_1_, lvt_6_1_ + 2, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_8_1_, lvt_6_1_ + 2, 3, lvt_8_1_, lvt_6_1_ + 2, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                } else {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_8_1_, lvt_6_1_, 0, lvt_8_1_, lvt_6_1_ + 2, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_8_1_, lvt_6_1_ + 1, 0, lvt_8_1_, lvt_6_1_ + 1, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                }
                lvt_5_1_ = lvt_4_1_;
            }
            return true;
        }
    }

    public static class SimpleTopRoom
    extends Piece {
        public SimpleTopRoom() {
        }

        public SimpleTopRoom(EnumFacing p_i45586_1_, RoomDefinition p_i45586_2_, Random p_i45586_3_) {
            super(1, p_i45586_1_, p_i45586_2_, 1, 1, 1);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, this.roomDefinition.hasOpening[EnumFacing.DOWN.getIndex()]);
            }
            if (this.roomDefinition.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(p_addComponentParts_1_, p_addComponentParts_3_, 1, 4, 1, 6, 4, 6, ROUGH_PRISMARINE);
            }
            for (int lvt_4_1_ = 1; lvt_4_1_ <= 6; ++lvt_4_1_) {
                for (int lvt_5_1_ = 1; lvt_5_1_ <= 6; ++lvt_5_1_) {
                    if (p_addComponentParts_2_.nextInt(3) == 0) continue;
                    int lvt_6_1_ = 2 + (p_addComponentParts_2_.nextInt(4) == 0 ? 0 : 1);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_4_1_, lvt_6_1_, lvt_5_1_, lvt_4_1_, 3, lvt_5_1_, Blocks.SPONGE.getStateFromMeta(1), Blocks.SPONGE.getStateFromMeta(1), false);
                }
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 0, 0, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 1, 0, 7, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 0, 6, 1, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 7, 6, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 0, 2, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 2, 0, 7, 2, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 0, 6, 2, 0, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 7, 6, 2, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 0, 0, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 3, 0, 7, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 0, 6, 3, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 7, 6, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 3, 0, 2, 4, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 1, 3, 7, 2, 4, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 0, 4, 2, 0, DARK_PRISMARINE, DARK_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 7, 4, 2, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);
            if (this.roomDefinition.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 0, 4, 2, 0, false);
            }
            return true;
        }
    }

    public static class SimpleRoom
    extends Piece {
        private int mainDesign;

        public SimpleRoom() {
        }

        public SimpleRoom(EnumFacing p_i45587_1_, RoomDefinition p_i45587_2_, Random p_i45587_3_) {
            super(1, p_i45587_1_, p_i45587_2_, 1, 1, 1);
            this.mainDesign = p_i45587_3_.nextInt(3);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            boolean lvt_4_1_;
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, this.roomDefinition.hasOpening[EnumFacing.DOWN.getIndex()]);
            }
            if (this.roomDefinition.connections[EnumFacing.UP.getIndex()] == null) {
                this.generateBoxOnFillOnly(p_addComponentParts_1_, p_addComponentParts_3_, 1, 4, 1, 6, 4, 6, ROUGH_PRISMARINE);
            }
            boolean bl = lvt_4_1_ = this.mainDesign != 0 && p_addComponentParts_2_.nextBoolean() && !this.roomDefinition.hasOpening[EnumFacing.DOWN.getIndex()] && !this.roomDefinition.hasOpening[EnumFacing.UP.getIndex()] && this.roomDefinition.countOpenings() > 1;
            if (this.mainDesign == 0) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 0, 2, 1, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 0, 2, 3, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 0, 2, 2, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 0, 2, 2, 0, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 1, 2, 1, p_addComponentParts_3_);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 1, 0, 7, 1, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 3, 0, 7, 3, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 2, 0, 7, 2, 2, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 2, 0, 6, 2, 0, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 6, 2, 1, p_addComponentParts_3_);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 5, 2, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 5, 2, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 5, 0, 2, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 7, 2, 2, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 1, 2, 6, p_addComponentParts_3_);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 1, 5, 7, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 3, 5, 7, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 2, 5, 7, 2, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 2, 7, 6, 2, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 6, 2, 6, p_addComponentParts_3_);
                if (this.roomDefinition.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 3, 0, 4, 3, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                } else {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 3, 0, 4, 3, 1, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 2, 0, 4, 2, 0, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 0, 4, 1, 1, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
                if (this.roomDefinition.hasOpening[EnumFacing.NORTH.getIndex()]) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 3, 7, 4, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                } else {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 3, 6, 4, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 2, 7, 4, 2, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 6, 4, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
                if (this.roomDefinition.hasOpening[EnumFacing.WEST.getIndex()]) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 3, 0, 3, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                } else {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 3, 1, 3, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 3, 0, 2, 4, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 3, 1, 1, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
                if (this.roomDefinition.hasOpening[EnumFacing.EAST.getIndex()]) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 3, 3, 7, 3, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                } else {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 3, 3, 7, 3, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 2, 3, 7, 2, 4, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 1, 3, 7, 1, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
            } else if (this.mainDesign == 1) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 1, 2, 2, 3, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 1, 5, 2, 3, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 1, 5, 5, 3, 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 1, 2, 5, 3, 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 2, 2, 2, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 2, 2, 5, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 5, 2, 5, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, SEA_LANTERN, 5, 2, 2, p_addComponentParts_3_);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 0, 1, 3, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 1, 0, 3, 1, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 7, 1, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 6, 0, 3, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 1, 7, 7, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 1, 6, 7, 3, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 1, 0, 7, 3, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 1, 1, 7, 3, 1, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.setBlockState(p_addComponentParts_1_, ROUGH_PRISMARINE, 1, 2, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, ROUGH_PRISMARINE, 0, 2, 1, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, ROUGH_PRISMARINE, 1, 2, 7, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, ROUGH_PRISMARINE, 0, 2, 6, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, ROUGH_PRISMARINE, 6, 2, 7, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, ROUGH_PRISMARINE, 7, 2, 6, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, ROUGH_PRISMARINE, 6, 2, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, ROUGH_PRISMARINE, 7, 2, 1, p_addComponentParts_3_);
                if (!this.roomDefinition.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 0, 6, 3, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 0, 6, 2, 0, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 0, 6, 1, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
                if (!this.roomDefinition.hasOpening[EnumFacing.NORTH.getIndex()]) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 7, 6, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 7, 6, 2, 7, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 7, 6, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
                if (!this.roomDefinition.hasOpening[EnumFacing.WEST.getIndex()]) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 1, 0, 3, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 1, 0, 2, 6, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 1, 0, 1, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
                if (!this.roomDefinition.hasOpening[EnumFacing.EAST.getIndex()]) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 3, 1, 7, 3, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 2, 1, 7, 2, 6, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 1, 1, 7, 1, 6, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
            } else if (this.mainDesign == 2) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 0, 0, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 1, 0, 7, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 0, 6, 1, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 7, 6, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 0, 2, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 2, 0, 7, 2, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 0, 6, 2, 0, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 7, 6, 2, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 0, 0, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 3, 0, 7, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 0, 6, 3, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 7, 6, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 3, 0, 2, 4, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 1, 3, 7, 2, 4, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 0, 4, 2, 0, DARK_PRISMARINE, DARK_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 7, 4, 2, 7, DARK_PRISMARINE, DARK_PRISMARINE, false);
                if (this.roomDefinition.hasOpening[EnumFacing.SOUTH.getIndex()]) {
                    this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 0, 4, 2, 0, false);
                }
                if (this.roomDefinition.hasOpening[EnumFacing.NORTH.getIndex()]) {
                    this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 7, 4, 2, 7, false);
                }
                if (this.roomDefinition.hasOpening[EnumFacing.WEST.getIndex()]) {
                    this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 3, 0, 2, 4, false);
                }
                if (this.roomDefinition.hasOpening[EnumFacing.EAST.getIndex()]) {
                    this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 7, 1, 3, 7, 2, 4, false);
                }
            }
            if (lvt_4_1_) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 3, 4, 1, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 2, 3, 4, 2, 4, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 3, 3, 4, 3, 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            }
            return true;
        }
    }

    public static class EntryRoom
    extends Piece {
        public EntryRoom() {
        }

        public EntryRoom(EnumFacing p_i45592_1_, RoomDefinition p_i45592_2_) {
            super(1, p_i45592_1_, p_i45592_2_, 1, 1, 1);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 0, 2, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 3, 0, 7, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 1, 2, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 2, 0, 7, 2, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 0, 0, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 1, 0, 7, 1, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 7, 7, 3, 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 0, 2, 3, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 1, 0, 6, 3, 0, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            if (this.roomDefinition.hasOpening[EnumFacing.NORTH.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 7, 4, 2, 7, false);
            }
            if (this.roomDefinition.hasOpening[EnumFacing.WEST.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 3, 1, 2, 4, false);
            }
            if (this.roomDefinition.hasOpening[EnumFacing.EAST.getIndex()]) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 6, 1, 3, 7, 2, 4, false);
            }
            return true;
        }
    }

    public static class MonumentBuilding
    extends Piece {
        private RoomDefinition sourceRoom;
        private RoomDefinition coreRoom;
        private final List<Piece> childPieces = Lists.newArrayList();

        public MonumentBuilding() {
        }

        public MonumentBuilding(Random p_i45599_1_, int p_i45599_2_, int p_i45599_3_, EnumFacing p_i45599_4_) {
            super(0);
            this.setCoordBaseMode(p_i45599_4_);
            EnumFacing lvt_5_1_ = this.getCoordBaseMode();
            this.boundingBox = lvt_5_1_.getAxis() == EnumFacing.Axis.Z ? new StructureBoundingBox(p_i45599_2_, 39, p_i45599_3_, p_i45599_2_ + 58 - 1, 61, p_i45599_3_ + 58 - 1) : new StructureBoundingBox(p_i45599_2_, 39, p_i45599_3_, p_i45599_2_ + 58 - 1, 61, p_i45599_3_ + 58 - 1);
            List<RoomDefinition> lvt_6_1_ = this.generateRoomGraph(p_i45599_1_);
            this.sourceRoom.claimed = true;
            this.childPieces.add(new EntryRoom(lvt_5_1_, this.sourceRoom));
            this.childPieces.add(new MonumentCoreRoom(lvt_5_1_, this.coreRoom, p_i45599_1_));
            ArrayList lvt_7_1_ = Lists.newArrayList();
            lvt_7_1_.add(new XYDoubleRoomFitHelper());
            lvt_7_1_.add(new YZDoubleRoomFitHelper());
            lvt_7_1_.add(new ZDoubleRoomFitHelper());
            lvt_7_1_.add(new XDoubleRoomFitHelper());
            lvt_7_1_.add(new YDoubleRoomFitHelper());
            lvt_7_1_.add(new FitSimpleRoomTopHelper());
            lvt_7_1_.add(new FitSimpleRoomHelper());
            block0: for (RoomDefinition lvt_9_1_ : lvt_6_1_) {
                if (lvt_9_1_.claimed || lvt_9_1_.isSpecial()) continue;
                for (Object lvt_11_1_ : lvt_7_1_) {
                    if (!lvt_11_1_.fits(lvt_9_1_)) continue;
                    this.childPieces.add(lvt_11_1_.create(lvt_5_1_, lvt_9_1_, p_i45599_1_));
                    continue block0;
                }
            }
            int lvt_8_1_ = this.boundingBox.minY;
            int lvt_9_2_ = this.getXWithOffset(9, 22);
            int lvt_10_1_ = this.getZWithOffset(9, 22);
            for (Piece lvt_12_1_ : this.childPieces) {
                lvt_12_1_.getBoundingBox().offset(lvt_9_2_, lvt_8_1_, lvt_10_1_);
            }
            StructureBoundingBox lvt_11_2_ = StructureBoundingBox.createProper(this.getXWithOffset(1, 1), this.getYWithOffset(1), this.getZWithOffset(1, 1), this.getXWithOffset(23, 21), this.getYWithOffset(8), this.getZWithOffset(23, 21));
            StructureBoundingBox lvt_12_2_ = StructureBoundingBox.createProper(this.getXWithOffset(34, 1), this.getYWithOffset(1), this.getZWithOffset(34, 1), this.getXWithOffset(56, 21), this.getYWithOffset(8), this.getZWithOffset(56, 21));
            StructureBoundingBox lvt_13_1_ = StructureBoundingBox.createProper(this.getXWithOffset(22, 22), this.getYWithOffset(13), this.getZWithOffset(22, 22), this.getXWithOffset(35, 35), this.getYWithOffset(17), this.getZWithOffset(35, 35));
            int lvt_14_1_ = p_i45599_1_.nextInt();
            this.childPieces.add(new WingRoom(lvt_5_1_, lvt_11_2_, lvt_14_1_++));
            this.childPieces.add(new WingRoom(lvt_5_1_, lvt_12_2_, lvt_14_1_++));
            this.childPieces.add(new Penthouse(lvt_5_1_, lvt_13_1_));
        }

        private List<RoomDefinition> generateRoomGraph(Random p_generateRoomGraph_1_) {
            RoomDefinition[] lvt_2_1_ = new RoomDefinition[75];
            for (int lvt_3_1_ = 0; lvt_3_1_ < 5; ++lvt_3_1_) {
                for (int lvt_4_1_ = 0; lvt_4_1_ < 4; ++lvt_4_1_) {
                    boolean lvt_5_1_ = false;
                    int lvt_6_1_ = MonumentBuilding.getRoomIndex(lvt_3_1_, 0, lvt_4_1_);
                    lvt_2_1_[lvt_6_1_] = new RoomDefinition(lvt_6_1_);
                }
            }
            for (int lvt_3_2_ = 0; lvt_3_2_ < 5; ++lvt_3_2_) {
                for (int lvt_4_2_ = 0; lvt_4_2_ < 4; ++lvt_4_2_) {
                    boolean lvt_5_2_ = true;
                    int lvt_6_2_ = MonumentBuilding.getRoomIndex(lvt_3_2_, 1, lvt_4_2_);
                    lvt_2_1_[lvt_6_2_] = new RoomDefinition(lvt_6_2_);
                }
            }
            for (int lvt_3_3_ = 1; lvt_3_3_ < 4; ++lvt_3_3_) {
                for (int lvt_4_3_ = 0; lvt_4_3_ < 2; ++lvt_4_3_) {
                    int lvt_5_3_ = 2;
                    int lvt_6_3_ = MonumentBuilding.getRoomIndex(lvt_3_3_, 2, lvt_4_3_);
                    lvt_2_1_[lvt_6_3_] = new RoomDefinition(lvt_6_3_);
                }
            }
            this.sourceRoom = lvt_2_1_[GRIDROOM_SOURCE_INDEX];
            for (int lvt_3_4_ = 0; lvt_3_4_ < 5; ++lvt_3_4_) {
                for (int lvt_4_4_ = 0; lvt_4_4_ < 5; ++lvt_4_4_) {
                    for (int lvt_5_4_ = 0; lvt_5_4_ < 3; ++lvt_5_4_) {
                        int lvt_6_4_ = MonumentBuilding.getRoomIndex(lvt_3_4_, lvt_5_4_, lvt_4_4_);
                        if (lvt_2_1_[lvt_6_4_] == null) continue;
                        for (EnumFacing lvt_10_1_ : EnumFacing.values()) {
                            int lvt_14_1_;
                            int lvt_11_1_ = lvt_3_4_ + lvt_10_1_.getFrontOffsetX();
                            int lvt_12_1_ = lvt_5_4_ + lvt_10_1_.getFrontOffsetY();
                            int lvt_13_1_ = lvt_4_4_ + lvt_10_1_.getFrontOffsetZ();
                            if (lvt_11_1_ < 0 || lvt_11_1_ >= 5 || lvt_13_1_ < 0 || lvt_13_1_ >= 5 || lvt_12_1_ < 0 || lvt_12_1_ >= 3 || lvt_2_1_[lvt_14_1_ = MonumentBuilding.getRoomIndex(lvt_11_1_, lvt_12_1_, lvt_13_1_)] == null) continue;
                            if (lvt_13_1_ == lvt_4_4_) {
                                lvt_2_1_[lvt_6_4_].setConnection(lvt_10_1_, lvt_2_1_[lvt_14_1_]);
                                continue;
                            }
                            lvt_2_1_[lvt_6_4_].setConnection(lvt_10_1_.getOpposite(), lvt_2_1_[lvt_14_1_]);
                        }
                    }
                }
            }
            RoomDefinition lvt_3_5_ = new RoomDefinition(1003);
            RoomDefinition lvt_4_5_ = new RoomDefinition(1001);
            RoomDefinition lvt_5_5_ = new RoomDefinition(1002);
            lvt_2_1_[GRIDROOM_TOP_CONNECT_INDEX].setConnection(EnumFacing.UP, lvt_3_5_);
            lvt_2_1_[GRIDROOM_LEFTWING_CONNECT_INDEX].setConnection(EnumFacing.SOUTH, lvt_4_5_);
            lvt_2_1_[GRIDROOM_RIGHTWING_CONNECT_INDEX].setConnection(EnumFacing.SOUTH, lvt_5_5_);
            lvt_3_5_.claimed = true;
            lvt_4_5_.claimed = true;
            lvt_5_5_.claimed = true;
            this.sourceRoom.isSource = true;
            this.coreRoom = lvt_2_1_[MonumentBuilding.getRoomIndex(p_generateRoomGraph_1_.nextInt(4), 0, 2)];
            this.coreRoom.claimed = true;
            this.coreRoom.connections[EnumFacing.EAST.getIndex()].claimed = true;
            this.coreRoom.connections[EnumFacing.NORTH.getIndex()].claimed = true;
            this.coreRoom.connections[EnumFacing.EAST.getIndex()].connections[EnumFacing.NORTH.getIndex()].claimed = true;
            this.coreRoom.connections[EnumFacing.UP.getIndex()].claimed = true;
            this.coreRoom.connections[EnumFacing.EAST.getIndex()].connections[EnumFacing.UP.getIndex()].claimed = true;
            this.coreRoom.connections[EnumFacing.NORTH.getIndex()].connections[EnumFacing.UP.getIndex()].claimed = true;
            this.coreRoom.connections[EnumFacing.EAST.getIndex()].connections[EnumFacing.NORTH.getIndex()].connections[EnumFacing.UP.getIndex()].claimed = true;
            ArrayList lvt_6_5_ = Lists.newArrayList();
            for (RoomDefinition lvt_10_2_ : lvt_2_1_) {
                if (lvt_10_2_ == null) continue;
                lvt_10_2_.updateOpenings();
                lvt_6_5_.add(lvt_10_2_);
            }
            lvt_3_5_.updateOpenings();
            Collections.shuffle(lvt_6_5_, p_generateRoomGraph_1_);
            int lvt_7_1_ = 1;
            for (RoomDefinition lvt_9_1_ : lvt_6_5_) {
                int lvt_10_3_ = 0;
                for (int lvt_11_2_ = 0; lvt_10_3_ < 2 && lvt_11_2_ < 5; ++lvt_11_2_) {
                    int lvt_12_2_ = p_generateRoomGraph_1_.nextInt(6);
                    if (!lvt_9_1_.hasOpening[lvt_12_2_]) continue;
                    int lvt_13_2_ = EnumFacing.getFront(lvt_12_2_).getOpposite().getIndex();
                    lvt_9_1_.hasOpening[lvt_12_2_] = false;
                    lvt_9_1_.connections[lvt_12_2_].hasOpening[lvt_13_2_] = false;
                    if (lvt_9_1_.findSource(lvt_7_1_++) && lvt_9_1_.connections[lvt_12_2_].findSource(lvt_7_1_++)) {
                        ++lvt_10_3_;
                        continue;
                    }
                    lvt_9_1_.hasOpening[lvt_12_2_] = true;
                    lvt_9_1_.connections[lvt_12_2_].hasOpening[lvt_13_2_] = true;
                }
            }
            lvt_6_5_.add(lvt_3_5_);
            lvt_6_5_.add(lvt_4_5_);
            lvt_6_5_.add(lvt_5_5_);
            return lvt_6_5_;
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            int lvt_4_1_ = Math.max(p_addComponentParts_1_.getSeaLevel(), 64) - this.boundingBox.minY;
            this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 58, lvt_4_1_, 58, false);
            this.generateWing(false, 0, p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_);
            this.generateWing(true, 33, p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_);
            this.generateEntranceArchs(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_);
            this.generateEntranceWall(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_);
            this.generateRoofPiece(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_);
            this.generateLowerWall(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_);
            this.generateMiddleWall(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_);
            this.generateUpperWall(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_);
            for (int lvt_5_1_ = 0; lvt_5_1_ < 7; ++lvt_5_1_) {
                int lvt_6_1_ = 0;
                while (lvt_6_1_ < 7) {
                    if (lvt_6_1_ == 0 && lvt_5_1_ == 3) {
                        lvt_6_1_ = 6;
                    }
                    int lvt_7_1_ = lvt_5_1_ * 9;
                    int lvt_8_1_ = lvt_6_1_ * 9;
                    for (int lvt_9_1_ = 0; lvt_9_1_ < 4; ++lvt_9_1_) {
                        for (int lvt_10_1_ = 0; lvt_10_1_ < 4; ++lvt_10_1_) {
                            this.setBlockState(p_addComponentParts_1_, BRICKS_PRISMARINE, lvt_7_1_ + lvt_9_1_, 0, lvt_8_1_ + lvt_10_1_, p_addComponentParts_3_);
                            this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, BRICKS_PRISMARINE, lvt_7_1_ + lvt_9_1_, -1, lvt_8_1_ + lvt_10_1_, p_addComponentParts_3_);
                        }
                    }
                    if (lvt_5_1_ == 0 || lvt_5_1_ == 6) {
                        ++lvt_6_1_;
                        continue;
                    }
                    lvt_6_1_ += 6;
                }
            }
            for (int lvt_5_2_ = 0; lvt_5_2_ < 5; ++lvt_5_2_) {
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, -1 - lvt_5_2_, 0 + lvt_5_2_ * 2, -1 - lvt_5_2_, -1 - lvt_5_2_, 23, 58 + lvt_5_2_, false);
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 58 + lvt_5_2_, 0 + lvt_5_2_ * 2, -1 - lvt_5_2_, 58 + lvt_5_2_, 23, 58 + lvt_5_2_, false);
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 0 - lvt_5_2_, 0 + lvt_5_2_ * 2, -1 - lvt_5_2_, 57 + lvt_5_2_, 23, -1 - lvt_5_2_, false);
                this.generateWaterBox(p_addComponentParts_1_, p_addComponentParts_3_, 0 - lvt_5_2_, 0 + lvt_5_2_ * 2, 58 + lvt_5_2_, 57 + lvt_5_2_, 23, 58 + lvt_5_2_, false);
            }
            for (Piece lvt_6_2_ : this.childPieces) {
                if (!lvt_6_2_.getBoundingBox().intersectsWith(p_addComponentParts_3_)) continue;
                lvt_6_2_.addComponentParts(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_);
            }
            return true;
        }

        private void generateWing(boolean p_generateWing_1_, int p_generateWing_2_, World p_generateWing_3_, Random p_generateWing_4_, StructureBoundingBox p_generateWing_5_) {
            int lvt_6_1_ = 24;
            if (this.doesChunkIntersect(p_generateWing_5_, p_generateWing_2_, 0, p_generateWing_2_ + 23, 20)) {
                this.fillWithBlocks(p_generateWing_3_, p_generateWing_5_, p_generateWing_2_ + 0, 0, 0, p_generateWing_2_ + 24, 0, 20, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(p_generateWing_3_, p_generateWing_5_, p_generateWing_2_ + 0, 1, 0, p_generateWing_2_ + 24, 10, 20, false);
                for (int lvt_7_1_ = 0; lvt_7_1_ < 4; ++lvt_7_1_) {
                    this.fillWithBlocks(p_generateWing_3_, p_generateWing_5_, p_generateWing_2_ + lvt_7_1_, lvt_7_1_ + 1, lvt_7_1_, p_generateWing_2_ + lvt_7_1_, lvt_7_1_ + 1, 20, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_generateWing_3_, p_generateWing_5_, p_generateWing_2_ + lvt_7_1_ + 7, lvt_7_1_ + 5, lvt_7_1_ + 7, p_generateWing_2_ + lvt_7_1_ + 7, lvt_7_1_ + 5, 20, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_generateWing_3_, p_generateWing_5_, p_generateWing_2_ + 17 - lvt_7_1_, lvt_7_1_ + 5, lvt_7_1_ + 7, p_generateWing_2_ + 17 - lvt_7_1_, lvt_7_1_ + 5, 20, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_generateWing_3_, p_generateWing_5_, p_generateWing_2_ + 24 - lvt_7_1_, lvt_7_1_ + 1, lvt_7_1_, p_generateWing_2_ + 24 - lvt_7_1_, lvt_7_1_ + 1, 20, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_generateWing_3_, p_generateWing_5_, p_generateWing_2_ + lvt_7_1_ + 1, lvt_7_1_ + 1, lvt_7_1_, p_generateWing_2_ + 23 - lvt_7_1_, lvt_7_1_ + 1, lvt_7_1_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_generateWing_3_, p_generateWing_5_, p_generateWing_2_ + lvt_7_1_ + 8, lvt_7_1_ + 5, lvt_7_1_ + 7, p_generateWing_2_ + 16 - lvt_7_1_, lvt_7_1_ + 5, lvt_7_1_ + 7, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
                this.fillWithBlocks(p_generateWing_3_, p_generateWing_5_, p_generateWing_2_ + 4, 4, 4, p_generateWing_2_ + 6, 4, 20, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateWing_3_, p_generateWing_5_, p_generateWing_2_ + 7, 4, 4, p_generateWing_2_ + 17, 4, 6, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateWing_3_, p_generateWing_5_, p_generateWing_2_ + 18, 4, 4, p_generateWing_2_ + 20, 4, 20, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateWing_3_, p_generateWing_5_, p_generateWing_2_ + 11, 8, 11, p_generateWing_2_ + 13, 8, 20, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.setBlockState(p_generateWing_3_, DOT_DECO_DATA, p_generateWing_2_ + 12, 9, 12, p_generateWing_5_);
                this.setBlockState(p_generateWing_3_, DOT_DECO_DATA, p_generateWing_2_ + 12, 9, 15, p_generateWing_5_);
                this.setBlockState(p_generateWing_3_, DOT_DECO_DATA, p_generateWing_2_ + 12, 9, 18, p_generateWing_5_);
                int lvt_7_2_ = p_generateWing_2_ + (p_generateWing_1_ ? 19 : 5);
                int lvt_8_1_ = p_generateWing_2_ + (p_generateWing_1_ ? 5 : 19);
                for (int lvt_9_1_ = 20; lvt_9_1_ >= 5; lvt_9_1_ -= 3) {
                    this.setBlockState(p_generateWing_3_, DOT_DECO_DATA, lvt_7_2_, 5, lvt_9_1_, p_generateWing_5_);
                }
                for (int lvt_9_2_ = 19; lvt_9_2_ >= 7; lvt_9_2_ -= 3) {
                    this.setBlockState(p_generateWing_3_, DOT_DECO_DATA, lvt_8_1_, 5, lvt_9_2_, p_generateWing_5_);
                }
                for (int lvt_9_3_ = 0; lvt_9_3_ < 4; ++lvt_9_3_) {
                    int lvt_10_1_ = p_generateWing_1_ ? p_generateWing_2_ + (24 - (17 - lvt_9_3_ * 3)) : p_generateWing_2_ + 17 - lvt_9_3_ * 3;
                    this.setBlockState(p_generateWing_3_, DOT_DECO_DATA, lvt_10_1_, 5, 5, p_generateWing_5_);
                }
                this.setBlockState(p_generateWing_3_, DOT_DECO_DATA, lvt_8_1_, 5, 5, p_generateWing_5_);
                this.fillWithBlocks(p_generateWing_3_, p_generateWing_5_, p_generateWing_2_ + 11, 1, 12, p_generateWing_2_ + 13, 7, 12, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateWing_3_, p_generateWing_5_, p_generateWing_2_ + 12, 1, 11, p_generateWing_2_ + 12, 7, 13, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            }
        }

        private void generateEntranceArchs(World p_generateEntranceArchs_1_, Random p_generateEntranceArchs_2_, StructureBoundingBox p_generateEntranceArchs_3_) {
            if (this.doesChunkIntersect(p_generateEntranceArchs_3_, 22, 5, 35, 17)) {
                this.generateWaterBox(p_generateEntranceArchs_1_, p_generateEntranceArchs_3_, 25, 0, 0, 32, 8, 20, false);
                for (int lvt_4_1_ = 0; lvt_4_1_ < 4; ++lvt_4_1_) {
                    this.fillWithBlocks(p_generateEntranceArchs_1_, p_generateEntranceArchs_3_, 24, 2, 5 + lvt_4_1_ * 4, 24, 4, 5 + lvt_4_1_ * 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_generateEntranceArchs_1_, p_generateEntranceArchs_3_, 22, 4, 5 + lvt_4_1_ * 4, 23, 4, 5 + lvt_4_1_ * 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.setBlockState(p_generateEntranceArchs_1_, BRICKS_PRISMARINE, 25, 5, 5 + lvt_4_1_ * 4, p_generateEntranceArchs_3_);
                    this.setBlockState(p_generateEntranceArchs_1_, BRICKS_PRISMARINE, 26, 6, 5 + lvt_4_1_ * 4, p_generateEntranceArchs_3_);
                    this.setBlockState(p_generateEntranceArchs_1_, SEA_LANTERN, 26, 5, 5 + lvt_4_1_ * 4, p_generateEntranceArchs_3_);
                    this.fillWithBlocks(p_generateEntranceArchs_1_, p_generateEntranceArchs_3_, 33, 2, 5 + lvt_4_1_ * 4, 33, 4, 5 + lvt_4_1_ * 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_generateEntranceArchs_1_, p_generateEntranceArchs_3_, 34, 4, 5 + lvt_4_1_ * 4, 35, 4, 5 + lvt_4_1_ * 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.setBlockState(p_generateEntranceArchs_1_, BRICKS_PRISMARINE, 32, 5, 5 + lvt_4_1_ * 4, p_generateEntranceArchs_3_);
                    this.setBlockState(p_generateEntranceArchs_1_, BRICKS_PRISMARINE, 31, 6, 5 + lvt_4_1_ * 4, p_generateEntranceArchs_3_);
                    this.setBlockState(p_generateEntranceArchs_1_, SEA_LANTERN, 31, 5, 5 + lvt_4_1_ * 4, p_generateEntranceArchs_3_);
                    this.fillWithBlocks(p_generateEntranceArchs_1_, p_generateEntranceArchs_3_, 27, 6, 5 + lvt_4_1_ * 4, 30, 6, 5 + lvt_4_1_ * 4, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                }
            }
        }

        private void generateEntranceWall(World p_generateEntranceWall_1_, Random p_generateEntranceWall_2_, StructureBoundingBox p_generateEntranceWall_3_) {
            if (this.doesChunkIntersect(p_generateEntranceWall_3_, 15, 20, 42, 21)) {
                this.fillWithBlocks(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 15, 0, 21, 42, 0, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 26, 1, 21, 31, 3, 21, false);
                this.fillWithBlocks(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 21, 12, 21, 36, 12, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 17, 11, 21, 40, 11, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 16, 10, 21, 41, 10, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 15, 7, 21, 42, 9, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 16, 6, 21, 41, 6, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 17, 5, 21, 40, 5, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 21, 4, 21, 36, 4, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 22, 3, 21, 26, 3, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 31, 3, 21, 35, 3, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 23, 2, 21, 25, 2, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 32, 2, 21, 34, 2, 21, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 28, 4, 20, 29, 4, 21, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.setBlockState(p_generateEntranceWall_1_, BRICKS_PRISMARINE, 27, 3, 21, p_generateEntranceWall_3_);
                this.setBlockState(p_generateEntranceWall_1_, BRICKS_PRISMARINE, 30, 3, 21, p_generateEntranceWall_3_);
                this.setBlockState(p_generateEntranceWall_1_, BRICKS_PRISMARINE, 26, 2, 21, p_generateEntranceWall_3_);
                this.setBlockState(p_generateEntranceWall_1_, BRICKS_PRISMARINE, 31, 2, 21, p_generateEntranceWall_3_);
                this.setBlockState(p_generateEntranceWall_1_, BRICKS_PRISMARINE, 25, 1, 21, p_generateEntranceWall_3_);
                this.setBlockState(p_generateEntranceWall_1_, BRICKS_PRISMARINE, 32, 1, 21, p_generateEntranceWall_3_);
                for (int lvt_4_1_ = 0; lvt_4_1_ < 7; ++lvt_4_1_) {
                    this.setBlockState(p_generateEntranceWall_1_, DARK_PRISMARINE, 28 - lvt_4_1_, 6 + lvt_4_1_, 21, p_generateEntranceWall_3_);
                    this.setBlockState(p_generateEntranceWall_1_, DARK_PRISMARINE, 29 + lvt_4_1_, 6 + lvt_4_1_, 21, p_generateEntranceWall_3_);
                }
                for (int lvt_4_2_ = 0; lvt_4_2_ < 4; ++lvt_4_2_) {
                    this.setBlockState(p_generateEntranceWall_1_, DARK_PRISMARINE, 28 - lvt_4_2_, 9 + lvt_4_2_, 21, p_generateEntranceWall_3_);
                    this.setBlockState(p_generateEntranceWall_1_, DARK_PRISMARINE, 29 + lvt_4_2_, 9 + lvt_4_2_, 21, p_generateEntranceWall_3_);
                }
                this.setBlockState(p_generateEntranceWall_1_, DARK_PRISMARINE, 28, 12, 21, p_generateEntranceWall_3_);
                this.setBlockState(p_generateEntranceWall_1_, DARK_PRISMARINE, 29, 12, 21, p_generateEntranceWall_3_);
                for (int lvt_4_3_ = 0; lvt_4_3_ < 3; ++lvt_4_3_) {
                    this.setBlockState(p_generateEntranceWall_1_, DARK_PRISMARINE, 22 - lvt_4_3_ * 2, 8, 21, p_generateEntranceWall_3_);
                    this.setBlockState(p_generateEntranceWall_1_, DARK_PRISMARINE, 22 - lvt_4_3_ * 2, 9, 21, p_generateEntranceWall_3_);
                    this.setBlockState(p_generateEntranceWall_1_, DARK_PRISMARINE, 35 + lvt_4_3_ * 2, 8, 21, p_generateEntranceWall_3_);
                    this.setBlockState(p_generateEntranceWall_1_, DARK_PRISMARINE, 35 + lvt_4_3_ * 2, 9, 21, p_generateEntranceWall_3_);
                }
                this.generateWaterBox(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 15, 13, 21, 42, 15, 21, false);
                this.generateWaterBox(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 15, 1, 21, 15, 6, 21, false);
                this.generateWaterBox(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 16, 1, 21, 16, 5, 21, false);
                this.generateWaterBox(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 17, 1, 21, 20, 4, 21, false);
                this.generateWaterBox(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 21, 1, 21, 21, 3, 21, false);
                this.generateWaterBox(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 22, 1, 21, 22, 2, 21, false);
                this.generateWaterBox(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 23, 1, 21, 24, 1, 21, false);
                this.generateWaterBox(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 42, 1, 21, 42, 6, 21, false);
                this.generateWaterBox(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 41, 1, 21, 41, 5, 21, false);
                this.generateWaterBox(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 37, 1, 21, 40, 4, 21, false);
                this.generateWaterBox(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 36, 1, 21, 36, 3, 21, false);
                this.generateWaterBox(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 33, 1, 21, 34, 1, 21, false);
                this.generateWaterBox(p_generateEntranceWall_1_, p_generateEntranceWall_3_, 35, 1, 21, 35, 2, 21, false);
            }
        }

        private void generateRoofPiece(World p_generateRoofPiece_1_, Random p_generateRoofPiece_2_, StructureBoundingBox p_generateRoofPiece_3_) {
            if (this.doesChunkIntersect(p_generateRoofPiece_3_, 21, 21, 36, 36)) {
                this.fillWithBlocks(p_generateRoofPiece_1_, p_generateRoofPiece_3_, 21, 0, 22, 36, 0, 36, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(p_generateRoofPiece_1_, p_generateRoofPiece_3_, 21, 1, 22, 36, 23, 36, false);
                for (int lvt_4_1_ = 0; lvt_4_1_ < 4; ++lvt_4_1_) {
                    this.fillWithBlocks(p_generateRoofPiece_1_, p_generateRoofPiece_3_, 21 + lvt_4_1_, 13 + lvt_4_1_, 21 + lvt_4_1_, 36 - lvt_4_1_, 13 + lvt_4_1_, 21 + lvt_4_1_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_generateRoofPiece_1_, p_generateRoofPiece_3_, 21 + lvt_4_1_, 13 + lvt_4_1_, 36 - lvt_4_1_, 36 - lvt_4_1_, 13 + lvt_4_1_, 36 - lvt_4_1_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_generateRoofPiece_1_, p_generateRoofPiece_3_, 21 + lvt_4_1_, 13 + lvt_4_1_, 22 + lvt_4_1_, 21 + lvt_4_1_, 13 + lvt_4_1_, 35 - lvt_4_1_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                    this.fillWithBlocks(p_generateRoofPiece_1_, p_generateRoofPiece_3_, 36 - lvt_4_1_, 13 + lvt_4_1_, 22 + lvt_4_1_, 36 - lvt_4_1_, 13 + lvt_4_1_, 35 - lvt_4_1_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
                this.fillWithBlocks(p_generateRoofPiece_1_, p_generateRoofPiece_3_, 25, 16, 25, 32, 16, 32, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateRoofPiece_1_, p_generateRoofPiece_3_, 25, 17, 25, 25, 19, 25, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_generateRoofPiece_1_, p_generateRoofPiece_3_, 32, 17, 25, 32, 19, 25, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_generateRoofPiece_1_, p_generateRoofPiece_3_, 25, 17, 32, 25, 19, 32, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_generateRoofPiece_1_, p_generateRoofPiece_3_, 32, 17, 32, 32, 19, 32, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.setBlockState(p_generateRoofPiece_1_, BRICKS_PRISMARINE, 26, 20, 26, p_generateRoofPiece_3_);
                this.setBlockState(p_generateRoofPiece_1_, BRICKS_PRISMARINE, 27, 21, 27, p_generateRoofPiece_3_);
                this.setBlockState(p_generateRoofPiece_1_, SEA_LANTERN, 27, 20, 27, p_generateRoofPiece_3_);
                this.setBlockState(p_generateRoofPiece_1_, BRICKS_PRISMARINE, 26, 20, 31, p_generateRoofPiece_3_);
                this.setBlockState(p_generateRoofPiece_1_, BRICKS_PRISMARINE, 27, 21, 30, p_generateRoofPiece_3_);
                this.setBlockState(p_generateRoofPiece_1_, SEA_LANTERN, 27, 20, 30, p_generateRoofPiece_3_);
                this.setBlockState(p_generateRoofPiece_1_, BRICKS_PRISMARINE, 31, 20, 31, p_generateRoofPiece_3_);
                this.setBlockState(p_generateRoofPiece_1_, BRICKS_PRISMARINE, 30, 21, 30, p_generateRoofPiece_3_);
                this.setBlockState(p_generateRoofPiece_1_, SEA_LANTERN, 30, 20, 30, p_generateRoofPiece_3_);
                this.setBlockState(p_generateRoofPiece_1_, BRICKS_PRISMARINE, 31, 20, 26, p_generateRoofPiece_3_);
                this.setBlockState(p_generateRoofPiece_1_, BRICKS_PRISMARINE, 30, 21, 27, p_generateRoofPiece_3_);
                this.setBlockState(p_generateRoofPiece_1_, SEA_LANTERN, 30, 20, 27, p_generateRoofPiece_3_);
                this.fillWithBlocks(p_generateRoofPiece_1_, p_generateRoofPiece_3_, 28, 21, 27, 29, 21, 27, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateRoofPiece_1_, p_generateRoofPiece_3_, 27, 21, 28, 27, 21, 29, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateRoofPiece_1_, p_generateRoofPiece_3_, 28, 21, 30, 29, 21, 30, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateRoofPiece_1_, p_generateRoofPiece_3_, 30, 21, 28, 30, 21, 29, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            }
        }

        private void generateLowerWall(World p_generateLowerWall_1_, Random p_generateLowerWall_2_, StructureBoundingBox p_generateLowerWall_3_) {
            if (this.doesChunkIntersect(p_generateLowerWall_3_, 0, 21, 6, 58)) {
                this.fillWithBlocks(p_generateLowerWall_1_, p_generateLowerWall_3_, 0, 0, 21, 6, 0, 57, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(p_generateLowerWall_1_, p_generateLowerWall_3_, 0, 1, 21, 6, 7, 57, false);
                this.fillWithBlocks(p_generateLowerWall_1_, p_generateLowerWall_3_, 4, 4, 21, 6, 4, 53, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                for (int lvt_4_1_ = 0; lvt_4_1_ < 4; ++lvt_4_1_) {
                    this.fillWithBlocks(p_generateLowerWall_1_, p_generateLowerWall_3_, lvt_4_1_, lvt_4_1_ + 1, 21, lvt_4_1_, lvt_4_1_ + 1, 57 - lvt_4_1_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
                for (int lvt_4_2_ = 23; lvt_4_2_ < 53; lvt_4_2_ += 3) {
                    this.setBlockState(p_generateLowerWall_1_, DOT_DECO_DATA, 5, 5, lvt_4_2_, p_generateLowerWall_3_);
                }
                this.setBlockState(p_generateLowerWall_1_, DOT_DECO_DATA, 5, 5, 52, p_generateLowerWall_3_);
                for (int lvt_4_3_ = 0; lvt_4_3_ < 4; ++lvt_4_3_) {
                    this.fillWithBlocks(p_generateLowerWall_1_, p_generateLowerWall_3_, lvt_4_3_, lvt_4_3_ + 1, 21, lvt_4_3_, lvt_4_3_ + 1, 57 - lvt_4_3_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
                this.fillWithBlocks(p_generateLowerWall_1_, p_generateLowerWall_3_, 4, 1, 52, 6, 3, 52, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateLowerWall_1_, p_generateLowerWall_3_, 5, 1, 51, 5, 3, 53, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            }
            if (this.doesChunkIntersect(p_generateLowerWall_3_, 51, 21, 58, 58)) {
                this.fillWithBlocks(p_generateLowerWall_1_, p_generateLowerWall_3_, 51, 0, 21, 57, 0, 57, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(p_generateLowerWall_1_, p_generateLowerWall_3_, 51, 1, 21, 57, 7, 57, false);
                this.fillWithBlocks(p_generateLowerWall_1_, p_generateLowerWall_3_, 51, 4, 21, 53, 4, 53, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                for (int lvt_4_4_ = 0; lvt_4_4_ < 4; ++lvt_4_4_) {
                    this.fillWithBlocks(p_generateLowerWall_1_, p_generateLowerWall_3_, 57 - lvt_4_4_, lvt_4_4_ + 1, 21, 57 - lvt_4_4_, lvt_4_4_ + 1, 57 - lvt_4_4_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
                for (int lvt_4_5_ = 23; lvt_4_5_ < 53; lvt_4_5_ += 3) {
                    this.setBlockState(p_generateLowerWall_1_, DOT_DECO_DATA, 52, 5, lvt_4_5_, p_generateLowerWall_3_);
                }
                this.setBlockState(p_generateLowerWall_1_, DOT_DECO_DATA, 52, 5, 52, p_generateLowerWall_3_);
                this.fillWithBlocks(p_generateLowerWall_1_, p_generateLowerWall_3_, 51, 1, 52, 53, 3, 52, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateLowerWall_1_, p_generateLowerWall_3_, 52, 1, 51, 52, 3, 53, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            }
            if (this.doesChunkIntersect(p_generateLowerWall_3_, 0, 51, 57, 57)) {
                this.fillWithBlocks(p_generateLowerWall_1_, p_generateLowerWall_3_, 7, 0, 51, 50, 0, 57, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(p_generateLowerWall_1_, p_generateLowerWall_3_, 7, 1, 51, 50, 10, 57, false);
                for (int lvt_4_6_ = 0; lvt_4_6_ < 4; ++lvt_4_6_) {
                    this.fillWithBlocks(p_generateLowerWall_1_, p_generateLowerWall_3_, lvt_4_6_ + 1, lvt_4_6_ + 1, 57 - lvt_4_6_, 56 - lvt_4_6_, lvt_4_6_ + 1, 57 - lvt_4_6_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
            }
        }

        private void generateMiddleWall(World p_generateMiddleWall_1_, Random p_generateMiddleWall_2_, StructureBoundingBox p_generateMiddleWall_3_) {
            if (this.doesChunkIntersect(p_generateMiddleWall_3_, 7, 21, 13, 50)) {
                this.fillWithBlocks(p_generateMiddleWall_1_, p_generateMiddleWall_3_, 7, 0, 21, 13, 0, 50, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(p_generateMiddleWall_1_, p_generateMiddleWall_3_, 7, 1, 21, 13, 10, 50, false);
                this.fillWithBlocks(p_generateMiddleWall_1_, p_generateMiddleWall_3_, 11, 8, 21, 13, 8, 53, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                for (int lvt_4_1_ = 0; lvt_4_1_ < 4; ++lvt_4_1_) {
                    this.fillWithBlocks(p_generateMiddleWall_1_, p_generateMiddleWall_3_, lvt_4_1_ + 7, lvt_4_1_ + 5, 21, lvt_4_1_ + 7, lvt_4_1_ + 5, 54, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
                for (int lvt_4_2_ = 21; lvt_4_2_ <= 45; lvt_4_2_ += 3) {
                    this.setBlockState(p_generateMiddleWall_1_, DOT_DECO_DATA, 12, 9, lvt_4_2_, p_generateMiddleWall_3_);
                }
            }
            if (this.doesChunkIntersect(p_generateMiddleWall_3_, 44, 21, 50, 54)) {
                this.fillWithBlocks(p_generateMiddleWall_1_, p_generateMiddleWall_3_, 44, 0, 21, 50, 0, 50, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(p_generateMiddleWall_1_, p_generateMiddleWall_3_, 44, 1, 21, 50, 10, 50, false);
                this.fillWithBlocks(p_generateMiddleWall_1_, p_generateMiddleWall_3_, 44, 8, 21, 46, 8, 53, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                for (int lvt_4_3_ = 0; lvt_4_3_ < 4; ++lvt_4_3_) {
                    this.fillWithBlocks(p_generateMiddleWall_1_, p_generateMiddleWall_3_, 50 - lvt_4_3_, lvt_4_3_ + 5, 21, 50 - lvt_4_3_, lvt_4_3_ + 5, 54, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
                for (int lvt_4_4_ = 21; lvt_4_4_ <= 45; lvt_4_4_ += 3) {
                    this.setBlockState(p_generateMiddleWall_1_, DOT_DECO_DATA, 45, 9, lvt_4_4_, p_generateMiddleWall_3_);
                }
            }
            if (this.doesChunkIntersect(p_generateMiddleWall_3_, 8, 44, 49, 54)) {
                this.fillWithBlocks(p_generateMiddleWall_1_, p_generateMiddleWall_3_, 14, 0, 44, 43, 0, 50, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(p_generateMiddleWall_1_, p_generateMiddleWall_3_, 14, 1, 44, 43, 10, 50, false);
                for (int lvt_4_5_ = 12; lvt_4_5_ <= 45; lvt_4_5_ += 3) {
                    this.setBlockState(p_generateMiddleWall_1_, DOT_DECO_DATA, lvt_4_5_, 9, 45, p_generateMiddleWall_3_);
                    this.setBlockState(p_generateMiddleWall_1_, DOT_DECO_DATA, lvt_4_5_, 9, 52, p_generateMiddleWall_3_);
                    if (lvt_4_5_ != 12 && lvt_4_5_ != 18 && lvt_4_5_ != 24 && lvt_4_5_ != 33 && lvt_4_5_ != 39 && lvt_4_5_ != 45) continue;
                    this.setBlockState(p_generateMiddleWall_1_, DOT_DECO_DATA, lvt_4_5_, 9, 47, p_generateMiddleWall_3_);
                    this.setBlockState(p_generateMiddleWall_1_, DOT_DECO_DATA, lvt_4_5_, 9, 50, p_generateMiddleWall_3_);
                    this.setBlockState(p_generateMiddleWall_1_, DOT_DECO_DATA, lvt_4_5_, 10, 45, p_generateMiddleWall_3_);
                    this.setBlockState(p_generateMiddleWall_1_, DOT_DECO_DATA, lvt_4_5_, 10, 46, p_generateMiddleWall_3_);
                    this.setBlockState(p_generateMiddleWall_1_, DOT_DECO_DATA, lvt_4_5_, 10, 51, p_generateMiddleWall_3_);
                    this.setBlockState(p_generateMiddleWall_1_, DOT_DECO_DATA, lvt_4_5_, 10, 52, p_generateMiddleWall_3_);
                    this.setBlockState(p_generateMiddleWall_1_, DOT_DECO_DATA, lvt_4_5_, 11, 47, p_generateMiddleWall_3_);
                    this.setBlockState(p_generateMiddleWall_1_, DOT_DECO_DATA, lvt_4_5_, 11, 50, p_generateMiddleWall_3_);
                    this.setBlockState(p_generateMiddleWall_1_, DOT_DECO_DATA, lvt_4_5_, 12, 48, p_generateMiddleWall_3_);
                    this.setBlockState(p_generateMiddleWall_1_, DOT_DECO_DATA, lvt_4_5_, 12, 49, p_generateMiddleWall_3_);
                }
                for (int lvt_4_6_ = 0; lvt_4_6_ < 3; ++lvt_4_6_) {
                    this.fillWithBlocks(p_generateMiddleWall_1_, p_generateMiddleWall_3_, 8 + lvt_4_6_, 5 + lvt_4_6_, 54, 49 - lvt_4_6_, 5 + lvt_4_6_, 54, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                }
                this.fillWithBlocks(p_generateMiddleWall_1_, p_generateMiddleWall_3_, 11, 8, 54, 46, 8, 54, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_generateMiddleWall_1_, p_generateMiddleWall_3_, 14, 8, 44, 43, 8, 53, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            }
        }

        private void generateUpperWall(World p_generateUpperWall_1_, Random p_generateUpperWall_2_, StructureBoundingBox p_generateUpperWall_3_) {
            if (this.doesChunkIntersect(p_generateUpperWall_3_, 14, 21, 20, 43)) {
                this.fillWithBlocks(p_generateUpperWall_1_, p_generateUpperWall_3_, 14, 0, 21, 20, 0, 43, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(p_generateUpperWall_1_, p_generateUpperWall_3_, 14, 1, 22, 20, 14, 43, false);
                this.fillWithBlocks(p_generateUpperWall_1_, p_generateUpperWall_3_, 18, 12, 22, 20, 12, 39, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateUpperWall_1_, p_generateUpperWall_3_, 18, 12, 21, 20, 12, 21, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                for (int lvt_4_1_ = 0; lvt_4_1_ < 4; ++lvt_4_1_) {
                    this.fillWithBlocks(p_generateUpperWall_1_, p_generateUpperWall_3_, lvt_4_1_ + 14, lvt_4_1_ + 9, 21, lvt_4_1_ + 14, lvt_4_1_ + 9, 43 - lvt_4_1_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
                for (int lvt_4_2_ = 23; lvt_4_2_ <= 39; lvt_4_2_ += 3) {
                    this.setBlockState(p_generateUpperWall_1_, DOT_DECO_DATA, 19, 13, lvt_4_2_, p_generateUpperWall_3_);
                }
            }
            if (this.doesChunkIntersect(p_generateUpperWall_3_, 37, 21, 43, 43)) {
                this.fillWithBlocks(p_generateUpperWall_1_, p_generateUpperWall_3_, 37, 0, 21, 43, 0, 43, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(p_generateUpperWall_1_, p_generateUpperWall_3_, 37, 1, 22, 43, 14, 43, false);
                this.fillWithBlocks(p_generateUpperWall_1_, p_generateUpperWall_3_, 37, 12, 22, 39, 12, 39, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateUpperWall_1_, p_generateUpperWall_3_, 37, 12, 21, 39, 12, 21, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                for (int lvt_4_3_ = 0; lvt_4_3_ < 4; ++lvt_4_3_) {
                    this.fillWithBlocks(p_generateUpperWall_1_, p_generateUpperWall_3_, 43 - lvt_4_3_, lvt_4_3_ + 9, 21, 43 - lvt_4_3_, lvt_4_3_ + 9, 43 - lvt_4_3_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
                for (int lvt_4_4_ = 23; lvt_4_4_ <= 39; lvt_4_4_ += 3) {
                    this.setBlockState(p_generateUpperWall_1_, DOT_DECO_DATA, 38, 13, lvt_4_4_, p_generateUpperWall_3_);
                }
            }
            if (this.doesChunkIntersect(p_generateUpperWall_3_, 15, 37, 42, 43)) {
                this.fillWithBlocks(p_generateUpperWall_1_, p_generateUpperWall_3_, 21, 0, 37, 36, 0, 43, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.generateWaterBox(p_generateUpperWall_1_, p_generateUpperWall_3_, 21, 1, 37, 36, 14, 43, false);
                this.fillWithBlocks(p_generateUpperWall_1_, p_generateUpperWall_3_, 21, 12, 37, 36, 12, 39, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                for (int lvt_4_5_ = 0; lvt_4_5_ < 4; ++lvt_4_5_) {
                    this.fillWithBlocks(p_generateUpperWall_1_, p_generateUpperWall_3_, 15 + lvt_4_5_, lvt_4_5_ + 9, 43 - lvt_4_5_, 42 - lvt_4_5_, lvt_4_5_ + 9, 43 - lvt_4_5_, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                }
                for (int lvt_4_6_ = 21; lvt_4_6_ <= 36; lvt_4_6_ += 3) {
                    this.setBlockState(p_generateUpperWall_1_, DOT_DECO_DATA, lvt_4_6_, 13, 38, p_generateUpperWall_3_);
                }
            }
        }
    }

    public static abstract class Piece
    extends StructureComponent {
        protected static final IBlockState ROUGH_PRISMARINE = Blocks.PRISMARINE.getStateFromMeta(BlockPrismarine.ROUGH_META);
        protected static final IBlockState BRICKS_PRISMARINE = Blocks.PRISMARINE.getStateFromMeta(BlockPrismarine.BRICKS_META);
        protected static final IBlockState DARK_PRISMARINE = Blocks.PRISMARINE.getStateFromMeta(BlockPrismarine.DARK_META);
        protected static final IBlockState DOT_DECO_DATA = BRICKS_PRISMARINE;
        protected static final IBlockState SEA_LANTERN = Blocks.SEA_LANTERN.getDefaultState();
        protected static final IBlockState WATER = Blocks.WATER.getDefaultState();
        protected static final int GRIDROOM_SOURCE_INDEX = Piece.getRoomIndex(2, 0, 0);
        protected static final int GRIDROOM_TOP_CONNECT_INDEX = Piece.getRoomIndex(2, 2, 0);
        protected static final int GRIDROOM_LEFTWING_CONNECT_INDEX = Piece.getRoomIndex(0, 1, 0);
        protected static final int GRIDROOM_RIGHTWING_CONNECT_INDEX = Piece.getRoomIndex(4, 1, 0);
        protected RoomDefinition roomDefinition;

        protected static final int getRoomIndex(int p_getRoomIndex_0_, int p_getRoomIndex_1_, int p_getRoomIndex_2_) {
            return p_getRoomIndex_1_ * 25 + p_getRoomIndex_2_ * 5 + p_getRoomIndex_0_;
        }

        public Piece() {
            super(0);
        }

        public Piece(int p_i45588_1_) {
            super(p_i45588_1_);
        }

        public Piece(EnumFacing p_i45589_1_, StructureBoundingBox p_i45589_2_) {
            super(1);
            this.setCoordBaseMode(p_i45589_1_);
            this.boundingBox = p_i45589_2_;
        }

        protected Piece(int p_i45590_1_, EnumFacing p_i45590_2_, RoomDefinition p_i45590_3_, int p_i45590_4_, int p_i45590_5_, int p_i45590_6_) {
            super(p_i45590_1_);
            this.setCoordBaseMode(p_i45590_2_);
            this.roomDefinition = p_i45590_3_;
            int lvt_7_1_ = p_i45590_3_.index;
            int lvt_8_1_ = lvt_7_1_ % 5;
            int lvt_9_1_ = lvt_7_1_ / 5 % 5;
            int lvt_10_1_ = lvt_7_1_ / 25;
            this.boundingBox = p_i45590_2_ == EnumFacing.NORTH || p_i45590_2_ == EnumFacing.SOUTH ? new StructureBoundingBox(0, 0, 0, p_i45590_4_ * 8 - 1, p_i45590_5_ * 4 - 1, p_i45590_6_ * 8 - 1) : new StructureBoundingBox(0, 0, 0, p_i45590_6_ * 8 - 1, p_i45590_5_ * 4 - 1, p_i45590_4_ * 8 - 1);
            switch (p_i45590_2_) {
                case NORTH: {
                    this.boundingBox.offset(lvt_8_1_ * 8, lvt_10_1_ * 4, -(lvt_9_1_ + p_i45590_6_) * 8 + 1);
                    break;
                }
                case SOUTH: {
                    this.boundingBox.offset(lvt_8_1_ * 8, lvt_10_1_ * 4, lvt_9_1_ * 8);
                    break;
                }
                case WEST: {
                    this.boundingBox.offset(-(lvt_9_1_ + p_i45590_6_) * 8 + 1, lvt_10_1_ * 4, lvt_8_1_ * 8);
                    break;
                }
                default: {
                    this.boundingBox.offset(lvt_9_1_ * 8, lvt_10_1_ * 4, lvt_8_1_ * 8);
                }
            }
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
        }

        protected void generateWaterBox(World p_generateWaterBox_1_, StructureBoundingBox p_generateWaterBox_2_, int p_generateWaterBox_3_, int p_generateWaterBox_4_, int p_generateWaterBox_5_, int p_generateWaterBox_6_, int p_generateWaterBox_7_, int p_generateWaterBox_8_, boolean p_generateWaterBox_9_) {
            for (int lvt_10_1_ = p_generateWaterBox_4_; lvt_10_1_ <= p_generateWaterBox_7_; ++lvt_10_1_) {
                for (int lvt_11_1_ = p_generateWaterBox_3_; lvt_11_1_ <= p_generateWaterBox_6_; ++lvt_11_1_) {
                    for (int lvt_12_1_ = p_generateWaterBox_5_; lvt_12_1_ <= p_generateWaterBox_8_; ++lvt_12_1_) {
                        if (p_generateWaterBox_9_ && this.getBlockStateFromPos(p_generateWaterBox_1_, lvt_11_1_, lvt_10_1_, lvt_12_1_, p_generateWaterBox_2_).getMaterial() == Material.AIR) continue;
                        if (this.getYWithOffset(lvt_10_1_) >= p_generateWaterBox_1_.getSeaLevel()) {
                            this.setBlockState(p_generateWaterBox_1_, Blocks.AIR.getDefaultState(), lvt_11_1_, lvt_10_1_, lvt_12_1_, p_generateWaterBox_2_);
                            continue;
                        }
                        this.setBlockState(p_generateWaterBox_1_, WATER, lvt_11_1_, lvt_10_1_, lvt_12_1_, p_generateWaterBox_2_);
                    }
                }
            }
        }

        protected void generateDefaultFloor(World p_generateDefaultFloor_1_, StructureBoundingBox p_generateDefaultFloor_2_, int p_generateDefaultFloor_3_, int p_generateDefaultFloor_4_, boolean p_generateDefaultFloor_5_) {
            if (p_generateDefaultFloor_5_) {
                this.fillWithBlocks(p_generateDefaultFloor_1_, p_generateDefaultFloor_2_, p_generateDefaultFloor_3_ + 0, 0, p_generateDefaultFloor_4_ + 0, p_generateDefaultFloor_3_ + 2, 0, p_generateDefaultFloor_4_ + 8 - 1, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateDefaultFloor_1_, p_generateDefaultFloor_2_, p_generateDefaultFloor_3_ + 5, 0, p_generateDefaultFloor_4_ + 0, p_generateDefaultFloor_3_ + 8 - 1, 0, p_generateDefaultFloor_4_ + 8 - 1, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateDefaultFloor_1_, p_generateDefaultFloor_2_, p_generateDefaultFloor_3_ + 3, 0, p_generateDefaultFloor_4_ + 0, p_generateDefaultFloor_3_ + 4, 0, p_generateDefaultFloor_4_ + 2, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateDefaultFloor_1_, p_generateDefaultFloor_2_, p_generateDefaultFloor_3_ + 3, 0, p_generateDefaultFloor_4_ + 5, p_generateDefaultFloor_3_ + 4, 0, p_generateDefaultFloor_4_ + 8 - 1, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
                this.fillWithBlocks(p_generateDefaultFloor_1_, p_generateDefaultFloor_2_, p_generateDefaultFloor_3_ + 3, 0, p_generateDefaultFloor_4_ + 2, p_generateDefaultFloor_3_ + 4, 0, p_generateDefaultFloor_4_ + 2, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_generateDefaultFloor_1_, p_generateDefaultFloor_2_, p_generateDefaultFloor_3_ + 3, 0, p_generateDefaultFloor_4_ + 5, p_generateDefaultFloor_3_ + 4, 0, p_generateDefaultFloor_4_ + 5, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_generateDefaultFloor_1_, p_generateDefaultFloor_2_, p_generateDefaultFloor_3_ + 2, 0, p_generateDefaultFloor_4_ + 3, p_generateDefaultFloor_3_ + 2, 0, p_generateDefaultFloor_4_ + 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
                this.fillWithBlocks(p_generateDefaultFloor_1_, p_generateDefaultFloor_2_, p_generateDefaultFloor_3_ + 5, 0, p_generateDefaultFloor_4_ + 3, p_generateDefaultFloor_3_ + 5, 0, p_generateDefaultFloor_4_ + 4, BRICKS_PRISMARINE, BRICKS_PRISMARINE, false);
            } else {
                this.fillWithBlocks(p_generateDefaultFloor_1_, p_generateDefaultFloor_2_, p_generateDefaultFloor_3_ + 0, 0, p_generateDefaultFloor_4_ + 0, p_generateDefaultFloor_3_ + 8 - 1, 0, p_generateDefaultFloor_4_ + 8 - 1, ROUGH_PRISMARINE, ROUGH_PRISMARINE, false);
            }
        }

        protected void generateBoxOnFillOnly(World p_generateBoxOnFillOnly_1_, StructureBoundingBox p_generateBoxOnFillOnly_2_, int p_generateBoxOnFillOnly_3_, int p_generateBoxOnFillOnly_4_, int p_generateBoxOnFillOnly_5_, int p_generateBoxOnFillOnly_6_, int p_generateBoxOnFillOnly_7_, int p_generateBoxOnFillOnly_8_, IBlockState p_generateBoxOnFillOnly_9_) {
            for (int lvt_10_1_ = p_generateBoxOnFillOnly_4_; lvt_10_1_ <= p_generateBoxOnFillOnly_7_; ++lvt_10_1_) {
                for (int lvt_11_1_ = p_generateBoxOnFillOnly_3_; lvt_11_1_ <= p_generateBoxOnFillOnly_6_; ++lvt_11_1_) {
                    for (int lvt_12_1_ = p_generateBoxOnFillOnly_5_; lvt_12_1_ <= p_generateBoxOnFillOnly_8_; ++lvt_12_1_) {
                        if (this.getBlockStateFromPos(p_generateBoxOnFillOnly_1_, lvt_11_1_, lvt_10_1_, lvt_12_1_, p_generateBoxOnFillOnly_2_) != WATER) continue;
                        this.setBlockState(p_generateBoxOnFillOnly_1_, p_generateBoxOnFillOnly_9_, lvt_11_1_, lvt_10_1_, lvt_12_1_, p_generateBoxOnFillOnly_2_);
                    }
                }
            }
        }

        protected boolean doesChunkIntersect(StructureBoundingBox p_doesChunkIntersect_1_, int p_doesChunkIntersect_2_, int p_doesChunkIntersect_3_, int p_doesChunkIntersect_4_, int p_doesChunkIntersect_5_) {
            int lvt_6_1_ = this.getXWithOffset(p_doesChunkIntersect_2_, p_doesChunkIntersect_3_);
            int lvt_7_1_ = this.getZWithOffset(p_doesChunkIntersect_2_, p_doesChunkIntersect_3_);
            int lvt_8_1_ = this.getXWithOffset(p_doesChunkIntersect_4_, p_doesChunkIntersect_5_);
            int lvt_9_1_ = this.getZWithOffset(p_doesChunkIntersect_4_, p_doesChunkIntersect_5_);
            return p_doesChunkIntersect_1_.intersectsWith(Math.min(lvt_6_1_, lvt_8_1_), Math.min(lvt_7_1_, lvt_9_1_), Math.max(lvt_6_1_, lvt_8_1_), Math.max(lvt_7_1_, lvt_9_1_));
        }

        protected boolean spawnElder(World p_spawnElder_1_, StructureBoundingBox p_spawnElder_2_, int p_spawnElder_3_, int p_spawnElder_4_, int p_spawnElder_5_) {
            int lvt_8_1_;
            int lvt_7_1_;
            int lvt_6_1_ = this.getXWithOffset(p_spawnElder_3_, p_spawnElder_5_);
            if (p_spawnElder_2_.isVecInside(new BlockPos(lvt_6_1_, lvt_7_1_ = this.getYWithOffset(p_spawnElder_4_), lvt_8_1_ = this.getZWithOffset(p_spawnElder_3_, p_spawnElder_5_)))) {
                EntityElderGuardian lvt_9_1_ = new EntityElderGuardian(p_spawnElder_1_);
                lvt_9_1_.heal(lvt_9_1_.getMaxHealth());
                lvt_9_1_.setLocationAndAngles((double)lvt_6_1_ + 0.5, lvt_7_1_, (double)lvt_8_1_ + 0.5, 0.0f, 0.0f);
                lvt_9_1_.onInitialSpawn(p_spawnElder_1_.getDifficultyForLocation(new BlockPos(lvt_9_1_)), null);
                p_spawnElder_1_.spawnEntity(lvt_9_1_);
                return true;
            }
            return false;
        }
    }
}

