/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public abstract class StructureStart {
    protected List<StructureComponent> components = Lists.newLinkedList();
    protected StructureBoundingBox boundingBox;
    private int chunkPosX;
    private int chunkPosZ;

    public StructureStart() {
    }

    public StructureStart(int p_i43002_1_, int p_i43002_2_) {
        this.chunkPosX = p_i43002_1_;
        this.chunkPosZ = p_i43002_2_;
    }

    public StructureBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public List<StructureComponent> getComponents() {
        return this.components;
    }

    public void generateStructure(World p_generateStructure_1_, Random p_generateStructure_2_, StructureBoundingBox p_generateStructure_3_) {
        Iterator<StructureComponent> iterator = this.components.iterator();
        while (iterator.hasNext()) {
            StructureComponent structurecomponent = iterator.next();
            if (!structurecomponent.getBoundingBox().intersectsWith(p_generateStructure_3_) || structurecomponent.addComponentParts(p_generateStructure_1_, p_generateStructure_2_, p_generateStructure_3_)) continue;
            iterator.remove();
        }
    }

    protected void updateBoundingBox() {
        this.boundingBox = StructureBoundingBox.getNewBoundingBox();
        for (StructureComponent structurecomponent : this.components) {
            this.boundingBox.expandTo(structurecomponent.getBoundingBox());
        }
    }

    public NBTTagCompound writeStructureComponentsToNBT(int p_writeStructureComponentsToNBT_1_, int p_writeStructureComponentsToNBT_2_) {
        if (MapGenStructureIO.getStructureStartName(this) == null) {
            throw new RuntimeException("StructureStart \"" + this.getClass().getName() + "\" missing ID Mapping, Modder see MapGenStructureIO");
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.setString("id", MapGenStructureIO.getStructureStartName(this));
        nbttagcompound.setInteger("ChunkX", p_writeStructureComponentsToNBT_1_);
        nbttagcompound.setInteger("ChunkZ", p_writeStructureComponentsToNBT_2_);
        nbttagcompound.setTag("BB", this.boundingBox.toNBTTagIntArray());
        NBTTagList nbttaglist = new NBTTagList();
        for (StructureComponent structurecomponent : this.components) {
            nbttaglist.appendTag(structurecomponent.createStructureBaseNBT());
        }
        nbttagcompound.setTag("Children", nbttaglist);
        this.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    public void writeToNBT(NBTTagCompound p_writeToNBT_1_) {
    }

    public void readStructureComponentsFromNBT(World p_readStructureComponentsFromNBT_1_, NBTTagCompound p_readStructureComponentsFromNBT_2_) {
        this.chunkPosX = p_readStructureComponentsFromNBT_2_.getInteger("ChunkX");
        this.chunkPosZ = p_readStructureComponentsFromNBT_2_.getInteger("ChunkZ");
        if (p_readStructureComponentsFromNBT_2_.hasKey("BB")) {
            this.boundingBox = new StructureBoundingBox(p_readStructureComponentsFromNBT_2_.getIntArray("BB"));
        }
        NBTTagList nbttaglist = p_readStructureComponentsFromNBT_2_.getTagList("Children", 10);
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            StructureComponent tmp = MapGenStructureIO.getStructureComponent(nbttaglist.getCompoundTagAt(i), p_readStructureComponentsFromNBT_1_);
            if (tmp == null) continue;
            this.components.add(tmp);
        }
        this.readFromNBT(p_readStructureComponentsFromNBT_2_);
    }

    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
    }

    protected void markAvailableHeight(World p_markAvailableHeight_1_, Random p_markAvailableHeight_2_, int p_markAvailableHeight_3_) {
        int i = p_markAvailableHeight_1_.getSeaLevel() - p_markAvailableHeight_3_;
        int j = this.boundingBox.getYSize() + 1;
        if (j < i) {
            j += p_markAvailableHeight_2_.nextInt(i - j);
        }
        int k = j - this.boundingBox.maxY;
        this.boundingBox.offset(0, k, 0);
        for (StructureComponent structurecomponent : this.components) {
            structurecomponent.offset(0, k, 0);
        }
    }

    protected void setRandomHeight(World p_setRandomHeight_1_, Random p_setRandomHeight_2_, int p_setRandomHeight_3_, int p_setRandomHeight_4_) {
        int i = p_setRandomHeight_4_ - p_setRandomHeight_3_ + 1 - this.boundingBox.getYSize();
        int j = i > 1 ? p_setRandomHeight_3_ + p_setRandomHeight_2_.nextInt(i) : p_setRandomHeight_3_;
        int k = j - this.boundingBox.minY;
        this.boundingBox.offset(0, k, 0);
        for (StructureComponent structurecomponent : this.components) {
            structurecomponent.offset(0, k, 0);
        }
    }

    public boolean isSizeableStructure() {
        return true;
    }

    public boolean isValidForPostProcess(ChunkPos p_isValidForPostProcess_1_) {
        return true;
    }

    public void notifyPostProcessAt(ChunkPos p_notifyPostProcessAt_1_) {
    }

    public int getChunkPosX() {
        return this.chunkPosX;
    }

    public int getChunkPosZ() {
        return this.chunkPosZ;
    }
}

