/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class StructureStrongholdPieces {
    private static final PieceWeight[] PIECE_WEIGHTS = new PieceWeight[]{new PieceWeight(Straight.class, 40, 0), new PieceWeight(Prison.class, 5, 5), new PieceWeight(LeftTurn.class, 20, 0), new PieceWeight(RightTurn.class, 20, 0), new PieceWeight(RoomCrossing.class, 10, 6), new PieceWeight(StairsStraight.class, 5, 5), new PieceWeight(Stairs.class, 5, 5), new PieceWeight(Crossing.class, 5, 4), new PieceWeight(ChestCorridor.class, 5, 4), new PieceWeight(Library.class, 10, 2){

        @Override
        public boolean canSpawnMoreStructuresOfType(int p_canSpawnMoreStructuresOfType_1_) {
            return super.canSpawnMoreStructuresOfType(p_canSpawnMoreStructuresOfType_1_) && p_canSpawnMoreStructuresOfType_1_ > 4;
        }
    }, new PieceWeight(PortalRoom.class, 20, 1){

        @Override
        public boolean canSpawnMoreStructuresOfType(int p_canSpawnMoreStructuresOfType_1_) {
            return super.canSpawnMoreStructuresOfType(p_canSpawnMoreStructuresOfType_1_) && p_canSpawnMoreStructuresOfType_1_ > 5;
        }
    }};
    private static List<PieceWeight> structurePieceList;
    private static Class<? extends Stronghold> strongComponentType;
    static int totalWeight;
    private static final Stones STRONGHOLD_STONES;

    public static void registerStrongholdPieces() {
        MapGenStructureIO.registerStructureComponent(ChestCorridor.class, "SHCC");
        MapGenStructureIO.registerStructureComponent(Corridor.class, "SHFC");
        MapGenStructureIO.registerStructureComponent(Crossing.class, "SH5C");
        MapGenStructureIO.registerStructureComponent(LeftTurn.class, "SHLT");
        MapGenStructureIO.registerStructureComponent(Library.class, "SHLi");
        MapGenStructureIO.registerStructureComponent(PortalRoom.class, "SHPR");
        MapGenStructureIO.registerStructureComponent(Prison.class, "SHPH");
        MapGenStructureIO.registerStructureComponent(RightTurn.class, "SHRT");
        MapGenStructureIO.registerStructureComponent(RoomCrossing.class, "SHRC");
        MapGenStructureIO.registerStructureComponent(Stairs.class, "SHSD");
        MapGenStructureIO.registerStructureComponent(Stairs2.class, "SHStart");
        MapGenStructureIO.registerStructureComponent(Straight.class, "SHS");
        MapGenStructureIO.registerStructureComponent(StairsStraight.class, "SHSSD");
    }

    public static void prepareStructurePieces() {
        structurePieceList = Lists.newArrayList();
        for (PieceWeight lvt_3_1_ : PIECE_WEIGHTS) {
            lvt_3_1_.instancesSpawned = 0;
            structurePieceList.add(lvt_3_1_);
        }
        strongComponentType = null;
    }

    private static boolean canAddStructurePieces() {
        boolean lvt_0_1_ = false;
        totalWeight = 0;
        for (PieceWeight lvt_2_1_ : structurePieceList) {
            if (lvt_2_1_.instancesLimit > 0 && lvt_2_1_.instancesSpawned < lvt_2_1_.instancesLimit) {
                lvt_0_1_ = true;
            }
            totalWeight += lvt_2_1_.pieceWeight;
        }
        return lvt_0_1_;
    }

    private static Stronghold findAndCreatePieceFactory(Class<? extends Stronghold> p_findAndCreatePieceFactory_0_, List<StructureComponent> p_findAndCreatePieceFactory_1_, Random p_findAndCreatePieceFactory_2_, int p_findAndCreatePieceFactory_3_, int p_findAndCreatePieceFactory_4_, int p_findAndCreatePieceFactory_5_, EnumFacing p_findAndCreatePieceFactory_6_, int p_findAndCreatePieceFactory_7_) {
        Stronghold lvt_8_1_ = null;
        if (p_findAndCreatePieceFactory_0_ == Straight.class) {
            lvt_8_1_ = Straight.createPiece(p_findAndCreatePieceFactory_1_, p_findAndCreatePieceFactory_2_, p_findAndCreatePieceFactory_3_, p_findAndCreatePieceFactory_4_, p_findAndCreatePieceFactory_5_, p_findAndCreatePieceFactory_6_, p_findAndCreatePieceFactory_7_);
        } else if (p_findAndCreatePieceFactory_0_ == Prison.class) {
            lvt_8_1_ = Prison.createPiece(p_findAndCreatePieceFactory_1_, p_findAndCreatePieceFactory_2_, p_findAndCreatePieceFactory_3_, p_findAndCreatePieceFactory_4_, p_findAndCreatePieceFactory_5_, p_findAndCreatePieceFactory_6_, p_findAndCreatePieceFactory_7_);
        } else if (p_findAndCreatePieceFactory_0_ == LeftTurn.class) {
            lvt_8_1_ = LeftTurn.createPiece(p_findAndCreatePieceFactory_1_, p_findAndCreatePieceFactory_2_, p_findAndCreatePieceFactory_3_, p_findAndCreatePieceFactory_4_, p_findAndCreatePieceFactory_5_, p_findAndCreatePieceFactory_6_, p_findAndCreatePieceFactory_7_);
        } else if (p_findAndCreatePieceFactory_0_ == RightTurn.class) {
            lvt_8_1_ = RightTurn.createPiece(p_findAndCreatePieceFactory_1_, p_findAndCreatePieceFactory_2_, p_findAndCreatePieceFactory_3_, p_findAndCreatePieceFactory_4_, p_findAndCreatePieceFactory_5_, p_findAndCreatePieceFactory_6_, p_findAndCreatePieceFactory_7_);
        } else if (p_findAndCreatePieceFactory_0_ == RoomCrossing.class) {
            lvt_8_1_ = RoomCrossing.createPiece(p_findAndCreatePieceFactory_1_, p_findAndCreatePieceFactory_2_, p_findAndCreatePieceFactory_3_, p_findAndCreatePieceFactory_4_, p_findAndCreatePieceFactory_5_, p_findAndCreatePieceFactory_6_, p_findAndCreatePieceFactory_7_);
        } else if (p_findAndCreatePieceFactory_0_ == StairsStraight.class) {
            lvt_8_1_ = StairsStraight.createPiece(p_findAndCreatePieceFactory_1_, p_findAndCreatePieceFactory_2_, p_findAndCreatePieceFactory_3_, p_findAndCreatePieceFactory_4_, p_findAndCreatePieceFactory_5_, p_findAndCreatePieceFactory_6_, p_findAndCreatePieceFactory_7_);
        } else if (p_findAndCreatePieceFactory_0_ == Stairs.class) {
            lvt_8_1_ = Stairs.createPiece(p_findAndCreatePieceFactory_1_, p_findAndCreatePieceFactory_2_, p_findAndCreatePieceFactory_3_, p_findAndCreatePieceFactory_4_, p_findAndCreatePieceFactory_5_, p_findAndCreatePieceFactory_6_, p_findAndCreatePieceFactory_7_);
        } else if (p_findAndCreatePieceFactory_0_ == Crossing.class) {
            lvt_8_1_ = Crossing.createPiece(p_findAndCreatePieceFactory_1_, p_findAndCreatePieceFactory_2_, p_findAndCreatePieceFactory_3_, p_findAndCreatePieceFactory_4_, p_findAndCreatePieceFactory_5_, p_findAndCreatePieceFactory_6_, p_findAndCreatePieceFactory_7_);
        } else if (p_findAndCreatePieceFactory_0_ == ChestCorridor.class) {
            lvt_8_1_ = ChestCorridor.createPiece(p_findAndCreatePieceFactory_1_, p_findAndCreatePieceFactory_2_, p_findAndCreatePieceFactory_3_, p_findAndCreatePieceFactory_4_, p_findAndCreatePieceFactory_5_, p_findAndCreatePieceFactory_6_, p_findAndCreatePieceFactory_7_);
        } else if (p_findAndCreatePieceFactory_0_ == Library.class) {
            lvt_8_1_ = Library.createPiece(p_findAndCreatePieceFactory_1_, p_findAndCreatePieceFactory_2_, p_findAndCreatePieceFactory_3_, p_findAndCreatePieceFactory_4_, p_findAndCreatePieceFactory_5_, p_findAndCreatePieceFactory_6_, p_findAndCreatePieceFactory_7_);
        } else if (p_findAndCreatePieceFactory_0_ == PortalRoom.class) {
            lvt_8_1_ = PortalRoom.createPiece(p_findAndCreatePieceFactory_1_, p_findAndCreatePieceFactory_2_, p_findAndCreatePieceFactory_3_, p_findAndCreatePieceFactory_4_, p_findAndCreatePieceFactory_5_, p_findAndCreatePieceFactory_6_, p_findAndCreatePieceFactory_7_);
        }
        return lvt_8_1_;
    }

    private static Stronghold generatePieceFromSmallDoor(Stairs2 p_generatePieceFromSmallDoor_0_, List<StructureComponent> p_generatePieceFromSmallDoor_1_, Random p_generatePieceFromSmallDoor_2_, int p_generatePieceFromSmallDoor_3_, int p_generatePieceFromSmallDoor_4_, int p_generatePieceFromSmallDoor_5_, EnumFacing p_generatePieceFromSmallDoor_6_, int p_generatePieceFromSmallDoor_7_) {
        if (!StructureStrongholdPieces.canAddStructurePieces()) {
            return null;
        }
        if (strongComponentType != null) {
            Stronghold lvt_8_1_ = StructureStrongholdPieces.findAndCreatePieceFactory(strongComponentType, p_generatePieceFromSmallDoor_1_, p_generatePieceFromSmallDoor_2_, p_generatePieceFromSmallDoor_3_, p_generatePieceFromSmallDoor_4_, p_generatePieceFromSmallDoor_5_, p_generatePieceFromSmallDoor_6_, p_generatePieceFromSmallDoor_7_);
            strongComponentType = null;
            if (lvt_8_1_ != null) {
                return lvt_8_1_;
            }
        }
        int lvt_8_2_ = 0;
        block0: while (lvt_8_2_ < 5) {
            ++lvt_8_2_;
            int lvt_9_1_ = p_generatePieceFromSmallDoor_2_.nextInt(totalWeight);
            for (PieceWeight lvt_11_1_ : structurePieceList) {
                if ((lvt_9_1_ -= lvt_11_1_.pieceWeight) >= 0) continue;
                if (!lvt_11_1_.canSpawnMoreStructuresOfType(p_generatePieceFromSmallDoor_7_) || lvt_11_1_ == p_generatePieceFromSmallDoor_0_.strongholdPieceWeight) continue block0;
                Stronghold lvt_12_1_ = StructureStrongholdPieces.findAndCreatePieceFactory(lvt_11_1_.pieceClass, p_generatePieceFromSmallDoor_1_, p_generatePieceFromSmallDoor_2_, p_generatePieceFromSmallDoor_3_, p_generatePieceFromSmallDoor_4_, p_generatePieceFromSmallDoor_5_, p_generatePieceFromSmallDoor_6_, p_generatePieceFromSmallDoor_7_);
                if (lvt_12_1_ == null) continue;
                ++lvt_11_1_.instancesSpawned;
                p_generatePieceFromSmallDoor_0_.strongholdPieceWeight = lvt_11_1_;
                if (!lvt_11_1_.canSpawnMoreStructures()) {
                    structurePieceList.remove(lvt_11_1_);
                }
                return lvt_12_1_;
            }
        }
        StructureBoundingBox lvt_9_2_ = Corridor.findPieceBox(p_generatePieceFromSmallDoor_1_, p_generatePieceFromSmallDoor_2_, p_generatePieceFromSmallDoor_3_, p_generatePieceFromSmallDoor_4_, p_generatePieceFromSmallDoor_5_, p_generatePieceFromSmallDoor_6_);
        if (lvt_9_2_ != null && lvt_9_2_.minY > 1) {
            return new Corridor(p_generatePieceFromSmallDoor_7_, p_generatePieceFromSmallDoor_2_, lvt_9_2_, p_generatePieceFromSmallDoor_6_);
        }
        return null;
    }

    private static StructureComponent generateAndAddPiece(Stairs2 p_generateAndAddPiece_0_, List<StructureComponent> p_generateAndAddPiece_1_, Random p_generateAndAddPiece_2_, int p_generateAndAddPiece_3_, int p_generateAndAddPiece_4_, int p_generateAndAddPiece_5_, EnumFacing p_generateAndAddPiece_6_, int p_generateAndAddPiece_7_) {
        if (p_generateAndAddPiece_7_ > 50) {
            return null;
        }
        if (Math.abs(p_generateAndAddPiece_3_ - p_generateAndAddPiece_0_.getBoundingBox().minX) > 112 || Math.abs(p_generateAndAddPiece_5_ - p_generateAndAddPiece_0_.getBoundingBox().minZ) > 112) {
            return null;
        }
        Stronghold lvt_8_1_ = StructureStrongholdPieces.generatePieceFromSmallDoor(p_generateAndAddPiece_0_, p_generateAndAddPiece_1_, p_generateAndAddPiece_2_, p_generateAndAddPiece_3_, p_generateAndAddPiece_4_, p_generateAndAddPiece_5_, p_generateAndAddPiece_6_, p_generateAndAddPiece_7_ + 1);
        if (lvt_8_1_ != null) {
            p_generateAndAddPiece_1_.add(lvt_8_1_);
            p_generateAndAddPiece_0_.pendingChildren.add(lvt_8_1_);
        }
        return lvt_8_1_;
    }

    static {
        STRONGHOLD_STONES = new Stones();
    }

    static class Stones
    extends StructureComponent.BlockSelector {
        private Stones() {
        }

        @Override
        public void selectBlocks(Random p_selectBlocks_1_, int p_selectBlocks_2_, int p_selectBlocks_3_, int p_selectBlocks_4_, boolean p_selectBlocks_5_) {
            float lvt_6_1_;
            this.blockstate = p_selectBlocks_5_ ? ((lvt_6_1_ = p_selectBlocks_1_.nextFloat()) < 0.2f ? Blocks.STONEBRICK.getStateFromMeta(BlockStoneBrick.CRACKED_META) : (lvt_6_1_ < 0.5f ? Blocks.STONEBRICK.getStateFromMeta(BlockStoneBrick.MOSSY_META) : (lvt_6_1_ < 0.55f ? Blocks.MONSTER_EGG.getStateFromMeta(BlockSilverfish.EnumType.STONEBRICK.getMetadata()) : Blocks.STONEBRICK.getDefaultState()))) : Blocks.AIR.getDefaultState();
        }
    }

    public static class PortalRoom
    extends Stronghold {
        private boolean hasSpawner;

        public PortalRoom() {
        }

        public PortalRoom(int p_i45577_1_, Random p_i45577_2_, StructureBoundingBox p_i45577_3_, EnumFacing p_i45577_4_) {
            super(p_i45577_1_);
            this.setCoordBaseMode(p_i45577_4_);
            this.boundingBox = p_i45577_3_;
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setBoolean("Mob", this.hasSpawner);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.hasSpawner = p_readStructureFromNBT_1_.getBoolean("Mob");
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            if (p_buildComponent_1_ != null) {
                ((Stairs2)p_buildComponent_1_).strongholdPortalRoom = this;
            }
        }

        public static PortalRoom createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -4, -1, 0, 11, 8, 16, p_createPiece_5_);
            if (!PortalRoom.canStrongholdGoDeeper(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new PortalRoom(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 10, 7, 15, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.placeDoor(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_, Stronghold.Door.GRATES, 4, 1, 0);
            int lvt_4_1_ = 6;
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, lvt_4_1_, 1, 1, lvt_4_1_, 14, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, lvt_4_1_, 1, 9, lvt_4_1_, 14, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, lvt_4_1_, 1, 8, lvt_4_1_, 2, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, lvt_4_1_, 14, 8, lvt_4_1_, 14, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 1, 2, 1, 4, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 1, 1, 9, 1, 4, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 1, 1, 1, 3, Blocks.FLOWING_LAVA.getDefaultState(), Blocks.FLOWING_LAVA.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 1, 1, 9, 1, 3, Blocks.FLOWING_LAVA.getDefaultState(), Blocks.FLOWING_LAVA.getDefaultState(), false);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 8, 7, 1, 12, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 9, 6, 1, 11, Blocks.FLOWING_LAVA.getDefaultState(), Blocks.FLOWING_LAVA.getDefaultState(), false);
            for (int lvt_5_1_ = 3; lvt_5_1_ < 14; lvt_5_1_ += 2) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, lvt_5_1_, 0, 4, lvt_5_1_, Blocks.IRON_BARS.getDefaultState(), Blocks.IRON_BARS.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 10, 3, lvt_5_1_, 10, 4, lvt_5_1_, Blocks.IRON_BARS.getDefaultState(), Blocks.IRON_BARS.getDefaultState(), false);
            }
            for (int lvt_5_2_ = 2; lvt_5_2_ < 9; lvt_5_2_ += 2) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, lvt_5_2_, 3, 15, lvt_5_2_, 4, 15, Blocks.IRON_BARS.getDefaultState(), Blocks.IRON_BARS.getDefaultState(), false);
            }
            IBlockState lvt_5_3_ = Blocks.STONE_BRICK_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.NORTH);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 5, 6, 1, 7, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 2, 6, 6, 2, 7, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 3, 7, 6, 3, 7, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            for (int lvt_6_1_ = 4; lvt_6_1_ <= 6; ++lvt_6_1_) {
                this.setBlockState(p_addComponentParts_1_, lvt_5_3_, lvt_6_1_, 1, 4, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_5_3_, lvt_6_1_, 2, 5, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_5_3_, lvt_6_1_, 3, 6, p_addComponentParts_3_);
            }
            IBlockState lvt_6_2_ = Blocks.END_PORTAL_FRAME.getDefaultState().withProperty(BlockEndPortalFrame.FACING, EnumFacing.NORTH);
            IBlockState lvt_7_1_ = Blocks.END_PORTAL_FRAME.getDefaultState().withProperty(BlockEndPortalFrame.FACING, EnumFacing.SOUTH);
            IBlockState lvt_8_1_ = Blocks.END_PORTAL_FRAME.getDefaultState().withProperty(BlockEndPortalFrame.FACING, EnumFacing.EAST);
            IBlockState lvt_9_1_ = Blocks.END_PORTAL_FRAME.getDefaultState().withProperty(BlockEndPortalFrame.FACING, EnumFacing.WEST);
            boolean lvt_10_1_ = true;
            boolean[] lvt_11_1_ = new boolean[12];
            for (int lvt_12_1_ = 0; lvt_12_1_ < lvt_11_1_.length; ++lvt_12_1_) {
                lvt_11_1_[lvt_12_1_] = p_addComponentParts_2_.nextFloat() > 0.9f;
                lvt_10_1_ &= lvt_11_1_[lvt_12_1_];
            }
            this.setBlockState(p_addComponentParts_1_, lvt_6_2_.withProperty(BlockEndPortalFrame.EYE, lvt_11_1_[0]), 4, 3, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_6_2_.withProperty(BlockEndPortalFrame.EYE, lvt_11_1_[1]), 5, 3, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_6_2_.withProperty(BlockEndPortalFrame.EYE, lvt_11_1_[2]), 6, 3, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_7_1_.withProperty(BlockEndPortalFrame.EYE, lvt_11_1_[3]), 4, 3, 12, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_7_1_.withProperty(BlockEndPortalFrame.EYE, lvt_11_1_[4]), 5, 3, 12, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_7_1_.withProperty(BlockEndPortalFrame.EYE, lvt_11_1_[5]), 6, 3, 12, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_8_1_.withProperty(BlockEndPortalFrame.EYE, lvt_11_1_[6]), 3, 3, 9, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_8_1_.withProperty(BlockEndPortalFrame.EYE, lvt_11_1_[7]), 3, 3, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_8_1_.withProperty(BlockEndPortalFrame.EYE, lvt_11_1_[8]), 3, 3, 11, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_9_1_.withProperty(BlockEndPortalFrame.EYE, lvt_11_1_[9]), 7, 3, 9, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_9_1_.withProperty(BlockEndPortalFrame.EYE, lvt_11_1_[10]), 7, 3, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_9_1_.withProperty(BlockEndPortalFrame.EYE, lvt_11_1_[11]), 7, 3, 11, p_addComponentParts_3_);
            if (lvt_10_1_) {
                IBlockState lvt_12_2_ = Blocks.END_PORTAL.getDefaultState();
                this.setBlockState(p_addComponentParts_1_, lvt_12_2_, 4, 3, 9, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_12_2_, 5, 3, 9, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_12_2_, 6, 3, 9, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_12_2_, 4, 3, 10, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_12_2_, 5, 3, 10, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_12_2_, 6, 3, 10, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_12_2_, 4, 3, 11, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_12_2_, 5, 3, 11, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_12_2_, 6, 3, 11, p_addComponentParts_3_);
            }
            if (!this.hasSpawner) {
                lvt_4_1_ = this.getYWithOffset(3);
                BlockPos lvt_12_3_ = new BlockPos(this.getXWithOffset(5, 6), lvt_4_1_, this.getZWithOffset(5, 6));
                if (p_addComponentParts_3_.isVecInside(lvt_12_3_)) {
                    this.hasSpawner = true;
                    p_addComponentParts_1_.setBlockState(lvt_12_3_, Blocks.MOB_SPAWNER.getDefaultState(), 2);
                    TileEntity lvt_13_1_ = p_addComponentParts_1_.getTileEntity(lvt_12_3_);
                    if (lvt_13_1_ instanceof TileEntityMobSpawner) {
                        ((TileEntityMobSpawner)lvt_13_1_).getSpawnerBaseLogic().setEntityId(EntityList.getKey(EntitySilverfish.class));
                    }
                }
            }
            return true;
        }
    }

    public static class Crossing
    extends Stronghold {
        private boolean leftLow;
        private boolean leftHigh;
        private boolean rightLow;
        private boolean rightHigh;

        public Crossing() {
        }

        public Crossing(int p_i45580_1_, Random p_i45580_2_, StructureBoundingBox p_i45580_3_, EnumFacing p_i45580_4_) {
            super(p_i45580_1_);
            this.setCoordBaseMode(p_i45580_4_);
            this.entryDoor = this.getRandomDoor(p_i45580_2_);
            this.boundingBox = p_i45580_3_;
            this.leftLow = p_i45580_2_.nextBoolean();
            this.leftHigh = p_i45580_2_.nextBoolean();
            this.rightLow = p_i45580_2_.nextBoolean();
            this.rightHigh = p_i45580_2_.nextInt(3) > 0;
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setBoolean("leftLow", this.leftLow);
            p_writeStructureToNBT_1_.setBoolean("leftHigh", this.leftHigh);
            p_writeStructureToNBT_1_.setBoolean("rightLow", this.rightLow);
            p_writeStructureToNBT_1_.setBoolean("rightHigh", this.rightHigh);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.leftLow = p_readStructureFromNBT_1_.getBoolean("leftLow");
            this.leftHigh = p_readStructureFromNBT_1_.getBoolean("leftHigh");
            this.rightLow = p_readStructureFromNBT_1_.getBoolean("rightLow");
            this.rightHigh = p_readStructureFromNBT_1_.getBoolean("rightHigh");
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            int lvt_4_1_ = 3;
            int lvt_5_1_ = 5;
            EnumFacing lvt_6_1_ = this.getCoordBaseMode();
            if (lvt_6_1_ == EnumFacing.WEST || lvt_6_1_ == EnumFacing.NORTH) {
                lvt_4_1_ = 8 - lvt_4_1_;
                lvt_5_1_ = 8 - lvt_5_1_;
            }
            this.getNextComponentNormal((Stairs2)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 5, 1);
            if (this.leftLow) {
                this.getNextComponentX((Stairs2)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, lvt_4_1_, 1);
            }
            if (this.leftHigh) {
                this.getNextComponentX((Stairs2)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, lvt_5_1_, 7);
            }
            if (this.rightLow) {
                this.getNextComponentZ((Stairs2)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, lvt_4_1_, 1);
            }
            if (this.rightHigh) {
                this.getNextComponentZ((Stairs2)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, lvt_5_1_, 7);
            }
        }

        public static Crossing createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -4, -3, 0, 10, 9, 11, p_createPiece_5_);
            if (!Crossing.canStrongholdGoDeeper(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new Crossing(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.isLiquidInStructureBoundingBox(p_addComponentParts_1_, p_addComponentParts_3_)) {
                return false;
            }
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 9, 8, 10, true, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.placeDoor(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_, this.entryDoor, 4, 3, 0);
            if (this.leftLow) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 3, 1, 0, 5, 3, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            }
            if (this.rightLow) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 3, 1, 9, 5, 3, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            }
            if (this.leftHigh) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5, 7, 0, 7, 9, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            }
            if (this.rightHigh) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 5, 7, 9, 7, 9, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 1, 10, 7, 3, 10, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 1, 8, 2, 6, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 5, 4, 4, 9, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 1, 5, 8, 4, 9, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 4, 7, 3, 4, 9, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 5, 3, 3, 6, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 4, 3, 3, 4, Blocks.STONE_SLAB.getDefaultState(), Blocks.STONE_SLAB.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 4, 6, 3, 4, 6, Blocks.STONE_SLAB.getDefaultState(), Blocks.STONE_SLAB.getDefaultState(), false);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 1, 7, 7, 1, 8, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 1, 9, 7, 1, 9, Blocks.STONE_SLAB.getDefaultState(), Blocks.STONE_SLAB.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 2, 7, 7, 2, 7, Blocks.STONE_SLAB.getDefaultState(), Blocks.STONE_SLAB.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 5, 7, 4, 5, 9, Blocks.STONE_SLAB.getDefaultState(), Blocks.STONE_SLAB.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 5, 7, 8, 5, 9, Blocks.STONE_SLAB.getDefaultState(), Blocks.STONE_SLAB.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 5, 7, 7, 5, 9, Blocks.DOUBLE_STONE_SLAB.getDefaultState(), Blocks.DOUBLE_STONE_SLAB.getDefaultState(), false);
            this.setBlockState(p_addComponentParts_1_, Blocks.TORCH.getDefaultState().withProperty(BlockTorch.FACING, EnumFacing.SOUTH), 6, 5, 6, p_addComponentParts_3_);
            return true;
        }
    }

    public static class Library
    extends Stronghold {
        private boolean isLargeRoom;

        public Library() {
        }

        public Library(int p_i45578_1_, Random p_i45578_2_, StructureBoundingBox p_i45578_3_, EnumFacing p_i45578_4_) {
            super(p_i45578_1_);
            this.setCoordBaseMode(p_i45578_4_);
            this.entryDoor = this.getRandomDoor(p_i45578_2_);
            this.boundingBox = p_i45578_3_;
            this.isLargeRoom = p_i45578_3_.getYSize() > 6;
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setBoolean("Tall", this.isLargeRoom);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.isLargeRoom = p_readStructureFromNBT_1_.getBoolean("Tall");
        }

        public static Library createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -4, -1, 0, 14, 11, 15, p_createPiece_5_);
            if (!(Library.canStrongholdGoDeeper(lvt_7_1_) && StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) == null || Library.canStrongholdGoDeeper(lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -4, -1, 0, 14, 6, 15, p_createPiece_5_)) && StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) == null)) {
                return null;
            }
            return new Library(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.isLiquidInStructureBoundingBox(p_addComponentParts_1_, p_addComponentParts_3_)) {
                return false;
            }
            int lvt_4_1_ = 11;
            if (!this.isLargeRoom) {
                lvt_4_1_ = 6;
            }
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 13, lvt_4_1_ - 1, 14, true, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.placeDoor(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_, this.entryDoor, 4, 1, 0);
            this.generateMaybeBox(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 0.07f, 2, 1, 1, 11, 4, 13, Blocks.WEB.getDefaultState(), Blocks.WEB.getDefaultState(), false, 0);
            boolean lvt_5_1_ = true;
            int lvt_6_1_ = 12;
            for (int lvt_7_1_ = 1; lvt_7_1_ <= 13; ++lvt_7_1_) {
                if ((lvt_7_1_ - 1) % 4 == 0) {
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, lvt_7_1_, 1, 4, lvt_7_1_, Blocks.PLANKS.getDefaultState(), Blocks.PLANKS.getDefaultState(), false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 12, 1, lvt_7_1_, 12, 4, lvt_7_1_, Blocks.PLANKS.getDefaultState(), Blocks.PLANKS.getDefaultState(), false);
                    this.setBlockState(p_addComponentParts_1_, Blocks.TORCH.getDefaultState().withProperty(BlockTorch.FACING, EnumFacing.EAST), 2, 3, lvt_7_1_, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.TORCH.getDefaultState().withProperty(BlockTorch.FACING, EnumFacing.WEST), 11, 3, lvt_7_1_, p_addComponentParts_3_);
                    if (!this.isLargeRoom) continue;
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 6, lvt_7_1_, 1, 9, lvt_7_1_, Blocks.PLANKS.getDefaultState(), Blocks.PLANKS.getDefaultState(), false);
                    this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 12, 6, lvt_7_1_, 12, 9, lvt_7_1_, Blocks.PLANKS.getDefaultState(), Blocks.PLANKS.getDefaultState(), false);
                    continue;
                }
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, lvt_7_1_, 1, 4, lvt_7_1_, Blocks.BOOKSHELF.getDefaultState(), Blocks.BOOKSHELF.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 12, 1, lvt_7_1_, 12, 4, lvt_7_1_, Blocks.BOOKSHELF.getDefaultState(), Blocks.BOOKSHELF.getDefaultState(), false);
                if (!this.isLargeRoom) continue;
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 6, lvt_7_1_, 1, 9, lvt_7_1_, Blocks.BOOKSHELF.getDefaultState(), Blocks.BOOKSHELF.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 12, 6, lvt_7_1_, 12, 9, lvt_7_1_, Blocks.BOOKSHELF.getDefaultState(), Blocks.BOOKSHELF.getDefaultState(), false);
            }
            for (int lvt_7_2_ = 3; lvt_7_2_ < 12; lvt_7_2_ += 2) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, lvt_7_2_, 4, 3, lvt_7_2_, Blocks.BOOKSHELF.getDefaultState(), Blocks.BOOKSHELF.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 1, lvt_7_2_, 7, 3, lvt_7_2_, Blocks.BOOKSHELF.getDefaultState(), Blocks.BOOKSHELF.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 1, lvt_7_2_, 10, 3, lvt_7_2_, Blocks.BOOKSHELF.getDefaultState(), Blocks.BOOKSHELF.getDefaultState(), false);
            }
            if (this.isLargeRoom) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 5, 1, 3, 5, 13, Blocks.PLANKS.getDefaultState(), Blocks.PLANKS.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 10, 5, 1, 12, 5, 13, Blocks.PLANKS.getDefaultState(), Blocks.PLANKS.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 5, 1, 9, 5, 2, Blocks.PLANKS.getDefaultState(), Blocks.PLANKS.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 5, 12, 9, 5, 13, Blocks.PLANKS.getDefaultState(), Blocks.PLANKS.getDefaultState(), false);
                this.setBlockState(p_addComponentParts_1_, Blocks.PLANKS.getDefaultState(), 9, 5, 11, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.PLANKS.getDefaultState(), 8, 5, 11, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.PLANKS.getDefaultState(), 9, 5, 10, p_addComponentParts_3_);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 6, 2, 3, 6, 12, Blocks.OAK_FENCE.getDefaultState(), Blocks.OAK_FENCE.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 10, 6, 2, 10, 6, 10, Blocks.OAK_FENCE.getDefaultState(), Blocks.OAK_FENCE.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 6, 2, 9, 6, 2, Blocks.OAK_FENCE.getDefaultState(), Blocks.OAK_FENCE.getDefaultState(), false);
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 6, 12, 8, 6, 12, Blocks.OAK_FENCE.getDefaultState(), Blocks.OAK_FENCE.getDefaultState(), false);
                this.setBlockState(p_addComponentParts_1_, Blocks.OAK_FENCE.getDefaultState(), 9, 6, 11, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.OAK_FENCE.getDefaultState(), 8, 6, 11, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.OAK_FENCE.getDefaultState(), 9, 6, 10, p_addComponentParts_3_);
                IBlockState lvt_7_3_ = Blocks.LADDER.getDefaultState().withProperty(BlockLadder.FACING, EnumFacing.SOUTH);
                this.setBlockState(p_addComponentParts_1_, lvt_7_3_, 10, 1, 13, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_7_3_, 10, 2, 13, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_7_3_, 10, 3, 13, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_7_3_, 10, 4, 13, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_7_3_, 10, 5, 13, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_7_3_, 10, 6, 13, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_7_3_, 10, 7, 13, p_addComponentParts_3_);
                int lvt_8_1_ = 7;
                int lvt_9_1_ = 7;
                this.setBlockState(p_addComponentParts_1_, Blocks.OAK_FENCE.getDefaultState(), 6, 9, 7, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.OAK_FENCE.getDefaultState(), 7, 9, 7, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.OAK_FENCE.getDefaultState(), 6, 8, 7, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.OAK_FENCE.getDefaultState(), 7, 8, 7, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.OAK_FENCE.getDefaultState(), 6, 7, 7, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.OAK_FENCE.getDefaultState(), 7, 7, 7, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.OAK_FENCE.getDefaultState(), 5, 7, 7, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.OAK_FENCE.getDefaultState(), 8, 7, 7, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.OAK_FENCE.getDefaultState(), 6, 7, 6, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.OAK_FENCE.getDefaultState(), 6, 7, 8, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.OAK_FENCE.getDefaultState(), 7, 7, 6, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.OAK_FENCE.getDefaultState(), 7, 7, 8, p_addComponentParts_3_);
                IBlockState lvt_10_1_ = Blocks.TORCH.getDefaultState().withProperty(BlockTorch.FACING, EnumFacing.UP);
                this.setBlockState(p_addComponentParts_1_, lvt_10_1_, 5, 8, 7, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_10_1_, 8, 8, 7, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_10_1_, 6, 8, 6, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_10_1_, 6, 8, 8, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_10_1_, 7, 8, 6, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_10_1_, 7, 8, 8, p_addComponentParts_3_);
            }
            this.generateChest(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 3, 3, 5, LootTableList.CHESTS_STRONGHOLD_LIBRARY);
            if (this.isLargeRoom) {
                this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 12, 9, 1, p_addComponentParts_3_);
                this.generateChest(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 12, 8, 1, LootTableList.CHESTS_STRONGHOLD_LIBRARY);
            }
            return true;
        }
    }

    public static class Prison
    extends Stronghold {
        public Prison() {
        }

        public Prison(int p_i45576_1_, Random p_i45576_2_, StructureBoundingBox p_i45576_3_, EnumFacing p_i45576_4_) {
            super(p_i45576_1_);
            this.setCoordBaseMode(p_i45576_4_);
            this.entryDoor = this.getRandomDoor(p_i45576_2_);
            this.boundingBox = p_i45576_3_;
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            this.getNextComponentNormal((Stairs2)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 1, 1);
        }

        public static Prison createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -1, -1, 0, 9, 5, 11, p_createPiece_5_);
            if (!Prison.canStrongholdGoDeeper(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new Prison(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.isLiquidInStructureBoundingBox(p_addComponentParts_1_, p_addComponentParts_3_)) {
                return false;
            }
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 8, 4, 10, true, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.placeDoor(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_, this.entryDoor, 1, 1, 0);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 10, 3, 3, 10, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 1, 4, 3, 1, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 3, 4, 3, 3, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 7, 4, 3, 7, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 9, 4, 3, 9, false, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 4, 4, 3, 6, Blocks.IRON_BARS.getDefaultState(), Blocks.IRON_BARS.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 1, 5, 7, 3, 5, Blocks.IRON_BARS.getDefaultState(), Blocks.IRON_BARS.getDefaultState(), false);
            this.setBlockState(p_addComponentParts_1_, Blocks.IRON_BARS.getDefaultState(), 4, 3, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.IRON_BARS.getDefaultState(), 4, 3, 8, p_addComponentParts_3_);
            IBlockState lvt_4_1_ = Blocks.IRON_DOOR.getDefaultState().withProperty(BlockDoor.FACING, EnumFacing.WEST);
            IBlockState lvt_5_1_ = Blocks.IRON_DOOR.getDefaultState().withProperty(BlockDoor.FACING, EnumFacing.WEST).withProperty(BlockDoor.HALF, BlockDoor.EnumDoorHalf.UPPER);
            this.setBlockState(p_addComponentParts_1_, lvt_4_1_, 4, 1, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_5_1_, 4, 2, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_4_1_, 4, 1, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, lvt_5_1_, 4, 2, 8, p_addComponentParts_3_);
            return true;
        }
    }

    public static class RoomCrossing
    extends Stronghold {
        protected int roomType;

        public RoomCrossing() {
        }

        public RoomCrossing(int p_i45575_1_, Random p_i45575_2_, StructureBoundingBox p_i45575_3_, EnumFacing p_i45575_4_) {
            super(p_i45575_1_);
            this.setCoordBaseMode(p_i45575_4_);
            this.entryDoor = this.getRandomDoor(p_i45575_2_);
            this.boundingBox = p_i45575_3_;
            this.roomType = p_i45575_2_.nextInt(5);
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setInteger("Type", this.roomType);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.roomType = p_readStructureFromNBT_1_.getInteger("Type");
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            this.getNextComponentNormal((Stairs2)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 4, 1);
            this.getNextComponentX((Stairs2)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 1, 4);
            this.getNextComponentZ((Stairs2)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 1, 4);
        }

        public static RoomCrossing createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -4, -1, 0, 11, 7, 11, p_createPiece_5_);
            if (!RoomCrossing.canStrongholdGoDeeper(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new RoomCrossing(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.isLiquidInStructureBoundingBox(p_addComponentParts_1_, p_addComponentParts_3_)) {
                return false;
            }
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 10, 6, 10, true, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.placeDoor(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_, this.entryDoor, 4, 1, 0);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 10, 6, 3, 10, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 4, 0, 3, 6, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 10, 1, 4, 10, 3, 6, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            switch (this.roomType) {
                default: {
                    break;
                }
                case 0: {
                    this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 5, 1, 5, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 5, 2, 5, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 5, 3, 5, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.TORCH.getDefaultState().withProperty(BlockTorch.FACING, EnumFacing.WEST), 4, 3, 5, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.TORCH.getDefaultState().withProperty(BlockTorch.FACING, EnumFacing.EAST), 6, 3, 5, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.TORCH.getDefaultState().withProperty(BlockTorch.FACING, EnumFacing.SOUTH), 5, 3, 4, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.TORCH.getDefaultState().withProperty(BlockTorch.FACING, EnumFacing.NORTH), 5, 3, 6, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getDefaultState(), 4, 1, 4, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getDefaultState(), 4, 1, 5, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getDefaultState(), 4, 1, 6, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getDefaultState(), 6, 1, 4, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getDefaultState(), 6, 1, 5, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getDefaultState(), 6, 1, 6, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getDefaultState(), 5, 1, 4, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getDefaultState(), 5, 1, 6, p_addComponentParts_3_);
                    break;
                }
                case 1: {
                    for (int lvt_4_1_ = 0; lvt_4_1_ < 5; ++lvt_4_1_) {
                        this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 3, 1, 3 + lvt_4_1_, p_addComponentParts_3_);
                        this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 7, 1, 3 + lvt_4_1_, p_addComponentParts_3_);
                        this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 3 + lvt_4_1_, 1, 3, p_addComponentParts_3_);
                        this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 3 + lvt_4_1_, 1, 7, p_addComponentParts_3_);
                    }
                    this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 5, 1, 5, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 5, 2, 5, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 5, 3, 5, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.FLOWING_WATER.getDefaultState(), 5, 4, 5, p_addComponentParts_3_);
                    break;
                }
                case 2: {
                    for (int lvt_4_2_ = 1; lvt_4_2_ <= 9; ++lvt_4_2_) {
                        this.setBlockState(p_addComponentParts_1_, Blocks.COBBLESTONE.getDefaultState(), 1, 3, lvt_4_2_, p_addComponentParts_3_);
                        this.setBlockState(p_addComponentParts_1_, Blocks.COBBLESTONE.getDefaultState(), 9, 3, lvt_4_2_, p_addComponentParts_3_);
                    }
                    for (int lvt_4_3_ = 1; lvt_4_3_ <= 9; ++lvt_4_3_) {
                        this.setBlockState(p_addComponentParts_1_, Blocks.COBBLESTONE.getDefaultState(), lvt_4_3_, 3, 1, p_addComponentParts_3_);
                        this.setBlockState(p_addComponentParts_1_, Blocks.COBBLESTONE.getDefaultState(), lvt_4_3_, 3, 9, p_addComponentParts_3_);
                    }
                    this.setBlockState(p_addComponentParts_1_, Blocks.COBBLESTONE.getDefaultState(), 5, 1, 4, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.COBBLESTONE.getDefaultState(), 5, 1, 6, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.COBBLESTONE.getDefaultState(), 5, 3, 4, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.COBBLESTONE.getDefaultState(), 5, 3, 6, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.COBBLESTONE.getDefaultState(), 4, 1, 5, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.COBBLESTONE.getDefaultState(), 6, 1, 5, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.COBBLESTONE.getDefaultState(), 4, 3, 5, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.COBBLESTONE.getDefaultState(), 6, 3, 5, p_addComponentParts_3_);
                    for (int lvt_4_4_ = 1; lvt_4_4_ <= 3; ++lvt_4_4_) {
                        this.setBlockState(p_addComponentParts_1_, Blocks.COBBLESTONE.getDefaultState(), 4, lvt_4_4_, 4, p_addComponentParts_3_);
                        this.setBlockState(p_addComponentParts_1_, Blocks.COBBLESTONE.getDefaultState(), 6, lvt_4_4_, 4, p_addComponentParts_3_);
                        this.setBlockState(p_addComponentParts_1_, Blocks.COBBLESTONE.getDefaultState(), 4, lvt_4_4_, 6, p_addComponentParts_3_);
                        this.setBlockState(p_addComponentParts_1_, Blocks.COBBLESTONE.getDefaultState(), 6, lvt_4_4_, 6, p_addComponentParts_3_);
                    }
                    this.setBlockState(p_addComponentParts_1_, Blocks.TORCH.getDefaultState(), 5, 3, 5, p_addComponentParts_3_);
                    for (int lvt_4_5_ = 2; lvt_4_5_ <= 8; ++lvt_4_5_) {
                        this.setBlockState(p_addComponentParts_1_, Blocks.PLANKS.getDefaultState(), 2, 3, lvt_4_5_, p_addComponentParts_3_);
                        this.setBlockState(p_addComponentParts_1_, Blocks.PLANKS.getDefaultState(), 3, 3, lvt_4_5_, p_addComponentParts_3_);
                        if (lvt_4_5_ <= 3 || lvt_4_5_ >= 7) {
                            this.setBlockState(p_addComponentParts_1_, Blocks.PLANKS.getDefaultState(), 4, 3, lvt_4_5_, p_addComponentParts_3_);
                            this.setBlockState(p_addComponentParts_1_, Blocks.PLANKS.getDefaultState(), 5, 3, lvt_4_5_, p_addComponentParts_3_);
                            this.setBlockState(p_addComponentParts_1_, Blocks.PLANKS.getDefaultState(), 6, 3, lvt_4_5_, p_addComponentParts_3_);
                        }
                        this.setBlockState(p_addComponentParts_1_, Blocks.PLANKS.getDefaultState(), 7, 3, lvt_4_5_, p_addComponentParts_3_);
                        this.setBlockState(p_addComponentParts_1_, Blocks.PLANKS.getDefaultState(), 8, 3, lvt_4_5_, p_addComponentParts_3_);
                    }
                    IBlockState lvt_4_6_ = Blocks.LADDER.getDefaultState().withProperty(BlockLadder.FACING, EnumFacing.WEST);
                    this.setBlockState(p_addComponentParts_1_, lvt_4_6_, 9, 1, 3, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, lvt_4_6_, 9, 2, 3, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, lvt_4_6_, 9, 3, 3, p_addComponentParts_3_);
                    this.generateChest(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 3, 4, 8, LootTableList.CHESTS_STRONGHOLD_CROSSING);
                }
            }
            return true;
        }
    }

    public static class RightTurn
    extends LeftTurn {
        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            EnumFacing lvt_4_1_ = this.getCoordBaseMode();
            if (lvt_4_1_ == EnumFacing.NORTH || lvt_4_1_ == EnumFacing.EAST) {
                this.getNextComponentZ((Stairs2)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 1, 1);
            } else {
                this.getNextComponentX((Stairs2)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 1, 1);
            }
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.isLiquidInStructureBoundingBox(p_addComponentParts_1_, p_addComponentParts_3_)) {
                return false;
            }
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 4, 4, 4, true, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.placeDoor(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_, this.entryDoor, 1, 1, 0);
            EnumFacing lvt_4_1_ = this.getCoordBaseMode();
            if (lvt_4_1_ == EnumFacing.NORTH || lvt_4_1_ == EnumFacing.EAST) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 1, 4, 3, 3, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            } else {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 1, 0, 3, 3, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            }
            return true;
        }
    }

    public static class LeftTurn
    extends Stronghold {
        public LeftTurn() {
        }

        public LeftTurn(int p_i45579_1_, Random p_i45579_2_, StructureBoundingBox p_i45579_3_, EnumFacing p_i45579_4_) {
            super(p_i45579_1_);
            this.setCoordBaseMode(p_i45579_4_);
            this.entryDoor = this.getRandomDoor(p_i45579_2_);
            this.boundingBox = p_i45579_3_;
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            EnumFacing lvt_4_1_ = this.getCoordBaseMode();
            if (lvt_4_1_ == EnumFacing.NORTH || lvt_4_1_ == EnumFacing.EAST) {
                this.getNextComponentX((Stairs2)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 1, 1);
            } else {
                this.getNextComponentZ((Stairs2)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 1, 1);
            }
        }

        public static LeftTurn createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -1, -1, 0, 5, 5, 5, p_createPiece_5_);
            if (!LeftTurn.canStrongholdGoDeeper(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new LeftTurn(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.isLiquidInStructureBoundingBox(p_addComponentParts_1_, p_addComponentParts_3_)) {
                return false;
            }
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 4, 4, 4, true, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.placeDoor(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_, this.entryDoor, 1, 1, 0);
            EnumFacing lvt_4_1_ = this.getCoordBaseMode();
            if (lvt_4_1_ == EnumFacing.NORTH || lvt_4_1_ == EnumFacing.EAST) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 1, 0, 3, 3, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            } else {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 1, 4, 3, 3, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            }
            return true;
        }
    }

    public static class StairsStraight
    extends Stronghold {
        public StairsStraight() {
        }

        public StairsStraight(int p_i45572_1_, Random p_i45572_2_, StructureBoundingBox p_i45572_3_, EnumFacing p_i45572_4_) {
            super(p_i45572_1_);
            this.setCoordBaseMode(p_i45572_4_);
            this.entryDoor = this.getRandomDoor(p_i45572_2_);
            this.boundingBox = p_i45572_3_;
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            this.getNextComponentNormal((Stairs2)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 1, 1);
        }

        public static StairsStraight createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -1, -7, 0, 5, 11, 8, p_createPiece_5_);
            if (!StairsStraight.canStrongholdGoDeeper(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new StairsStraight(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.isLiquidInStructureBoundingBox(p_addComponentParts_1_, p_addComponentParts_3_)) {
                return false;
            }
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 4, 10, 7, true, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.placeDoor(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_, this.entryDoor, 1, 7, 0);
            this.placeDoor(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_, Stronghold.Door.OPENING, 1, 1, 7);
            IBlockState lvt_4_1_ = Blocks.STONE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.SOUTH);
            for (int lvt_5_1_ = 0; lvt_5_1_ < 6; ++lvt_5_1_) {
                this.setBlockState(p_addComponentParts_1_, lvt_4_1_, 1, 6 - lvt_5_1_, 1 + lvt_5_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_4_1_, 2, 6 - lvt_5_1_, 1 + lvt_5_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, lvt_4_1_, 3, 6 - lvt_5_1_, 1 + lvt_5_1_, p_addComponentParts_3_);
                if (lvt_5_1_ >= 5) continue;
                this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 1, 5 - lvt_5_1_, 1 + lvt_5_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 2, 5 - lvt_5_1_, 1 + lvt_5_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 3, 5 - lvt_5_1_, 1 + lvt_5_1_, p_addComponentParts_3_);
            }
            return true;
        }
    }

    public static class ChestCorridor
    extends Stronghold {
        private boolean hasMadeChest;

        public ChestCorridor() {
        }

        public ChestCorridor(int p_i45582_1_, Random p_i45582_2_, StructureBoundingBox p_i45582_3_, EnumFacing p_i45582_4_) {
            super(p_i45582_1_);
            this.setCoordBaseMode(p_i45582_4_);
            this.entryDoor = this.getRandomDoor(p_i45582_2_);
            this.boundingBox = p_i45582_3_;
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setBoolean("Chest", this.hasMadeChest);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.hasMadeChest = p_readStructureFromNBT_1_.getBoolean("Chest");
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            this.getNextComponentNormal((Stairs2)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 1, 1);
        }

        public static ChestCorridor createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -1, -1, 0, 5, 5, 7, p_createPiece_5_);
            if (!ChestCorridor.canStrongholdGoDeeper(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new ChestCorridor(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.isLiquidInStructureBoundingBox(p_addComponentParts_1_, p_addComponentParts_3_)) {
                return false;
            }
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 4, 4, 6, true, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.placeDoor(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_, this.entryDoor, 1, 1, 0);
            this.placeDoor(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_, Stronghold.Door.OPENING, 1, 1, 6);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 2, 3, 1, 4, Blocks.STONEBRICK.getDefaultState(), Blocks.STONEBRICK.getDefaultState(), false);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getStateFromMeta(BlockStoneSlab.EnumType.SMOOTHBRICK.getMetadata()), 3, 1, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getStateFromMeta(BlockStoneSlab.EnumType.SMOOTHBRICK.getMetadata()), 3, 1, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getStateFromMeta(BlockStoneSlab.EnumType.SMOOTHBRICK.getMetadata()), 3, 2, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getStateFromMeta(BlockStoneSlab.EnumType.SMOOTHBRICK.getMetadata()), 3, 2, 4, p_addComponentParts_3_);
            for (int lvt_4_1_ = 2; lvt_4_1_ <= 4; ++lvt_4_1_) {
                this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getStateFromMeta(BlockStoneSlab.EnumType.SMOOTHBRICK.getMetadata()), 2, 1, lvt_4_1_, p_addComponentParts_3_);
            }
            if (!this.hasMadeChest && p_addComponentParts_3_.isVecInside(new BlockPos(this.getXWithOffset(3, 3), this.getYWithOffset(2), this.getZWithOffset(3, 3)))) {
                this.hasMadeChest = true;
                this.generateChest(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 3, 2, 3, LootTableList.CHESTS_STRONGHOLD_CORRIDOR);
            }
            return true;
        }
    }

    public static class Straight
    extends Stronghold {
        private boolean expandsX;
        private boolean expandsZ;

        public Straight() {
        }

        public Straight(int p_i45573_1_, Random p_i45573_2_, StructureBoundingBox p_i45573_3_, EnumFacing p_i45573_4_) {
            super(p_i45573_1_);
            this.setCoordBaseMode(p_i45573_4_);
            this.entryDoor = this.getRandomDoor(p_i45573_2_);
            this.boundingBox = p_i45573_3_;
            this.expandsX = p_i45573_2_.nextInt(2) == 0;
            this.expandsZ = p_i45573_2_.nextInt(2) == 0;
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setBoolean("Left", this.expandsX);
            p_writeStructureToNBT_1_.setBoolean("Right", this.expandsZ);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.expandsX = p_readStructureFromNBT_1_.getBoolean("Left");
            this.expandsZ = p_readStructureFromNBT_1_.getBoolean("Right");
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            this.getNextComponentNormal((Stairs2)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 1, 1);
            if (this.expandsX) {
                this.getNextComponentX((Stairs2)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 1, 2);
            }
            if (this.expandsZ) {
                this.getNextComponentZ((Stairs2)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 1, 2);
            }
        }

        public static Straight createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -1, -1, 0, 5, 5, 7, p_createPiece_5_);
            if (!Straight.canStrongholdGoDeeper(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new Straight(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.isLiquidInStructureBoundingBox(p_addComponentParts_1_, p_addComponentParts_3_)) {
                return false;
            }
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 4, 4, 6, true, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.placeDoor(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_, this.entryDoor, 1, 1, 0);
            this.placeDoor(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_, Stronghold.Door.OPENING, 1, 1, 6);
            IBlockState lvt_4_1_ = Blocks.TORCH.getDefaultState().withProperty(BlockTorch.FACING, EnumFacing.EAST);
            IBlockState lvt_5_1_ = Blocks.TORCH.getDefaultState().withProperty(BlockTorch.FACING, EnumFacing.WEST);
            this.randomlyPlaceBlock(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 0.1f, 1, 2, 1, lvt_4_1_);
            this.randomlyPlaceBlock(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 0.1f, 3, 2, 1, lvt_5_1_);
            this.randomlyPlaceBlock(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 0.1f, 1, 2, 5, lvt_4_1_);
            this.randomlyPlaceBlock(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 0.1f, 3, 2, 5, lvt_5_1_);
            if (this.expandsX) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 2, 0, 3, 4, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            }
            if (this.expandsZ) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 2, 4, 3, 4, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            }
            return true;
        }
    }

    public static class Stairs2
    extends Stairs {
        public PieceWeight strongholdPieceWeight;
        public PortalRoom strongholdPortalRoom;
        public List<StructureComponent> pendingChildren = Lists.newArrayList();

        public Stairs2() {
        }

        public Stairs2(int p_i2083_1_, Random p_i2083_2_, int p_i2083_3_, int p_i2083_4_) {
            super(0, p_i2083_2_, p_i2083_3_, p_i2083_4_);
        }
    }

    public static class Stairs
    extends Stronghold {
        private boolean source;

        public Stairs() {
        }

        public Stairs(int p_i2081_1_, Random p_i2081_2_, int p_i2081_3_, int p_i2081_4_) {
            super(p_i2081_1_);
            this.source = true;
            this.setCoordBaseMode(EnumFacing.Plane.HORIZONTAL.random(p_i2081_2_));
            this.entryDoor = Stronghold.Door.OPENING;
            this.boundingBox = this.getCoordBaseMode().getAxis() == EnumFacing.Axis.Z ? new StructureBoundingBox(p_i2081_3_, 64, p_i2081_4_, p_i2081_3_ + 5 - 1, 74, p_i2081_4_ + 5 - 1) : new StructureBoundingBox(p_i2081_3_, 64, p_i2081_4_, p_i2081_3_ + 5 - 1, 74, p_i2081_4_ + 5 - 1);
        }

        public Stairs(int p_i45574_1_, Random p_i45574_2_, StructureBoundingBox p_i45574_3_, EnumFacing p_i45574_4_) {
            super(p_i45574_1_);
            this.source = false;
            this.setCoordBaseMode(p_i45574_4_);
            this.entryDoor = this.getRandomDoor(p_i45574_2_);
            this.boundingBox = p_i45574_3_;
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setBoolean("Source", this.source);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.source = p_readStructureFromNBT_1_.getBoolean("Source");
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            if (this.source) {
                strongComponentType = Crossing.class;
            }
            this.getNextComponentNormal((Stairs2)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 1, 1);
        }

        public static Stairs createPiece(List<StructureComponent> p_createPiece_0_, Random p_createPiece_1_, int p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, EnumFacing p_createPiece_5_, int p_createPiece_6_) {
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_2_, p_createPiece_3_, p_createPiece_4_, -1, -7, 0, 5, 11, 5, p_createPiece_5_);
            if (!Stairs.canStrongholdGoDeeper(lvt_7_1_) || StructureComponent.findIntersecting(p_createPiece_0_, lvt_7_1_) != null) {
                return null;
            }
            return new Stairs(p_createPiece_6_, p_createPiece_1_, lvt_7_1_, p_createPiece_5_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.isLiquidInStructureBoundingBox(p_addComponentParts_1_, p_addComponentParts_3_)) {
                return false;
            }
            this.fillWithRandomizedBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 4, 10, 4, true, p_addComponentParts_2_, STRONGHOLD_STONES);
            this.placeDoor(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_, this.entryDoor, 1, 7, 0);
            this.placeDoor(p_addComponentParts_1_, p_addComponentParts_2_, p_addComponentParts_3_, Stronghold.Door.OPENING, 1, 1, 4);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 2, 6, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 1, 5, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getStateFromMeta(BlockStoneSlab.EnumType.STONE.getMetadata()), 1, 6, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 1, 5, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 1, 4, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getStateFromMeta(BlockStoneSlab.EnumType.STONE.getMetadata()), 1, 5, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 2, 4, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 3, 3, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getStateFromMeta(BlockStoneSlab.EnumType.STONE.getMetadata()), 3, 4, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 3, 3, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 3, 2, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getStateFromMeta(BlockStoneSlab.EnumType.STONE.getMetadata()), 3, 3, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 2, 2, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 1, 1, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getStateFromMeta(BlockStoneSlab.EnumType.STONE.getMetadata()), 1, 2, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 1, 1, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.STONE_SLAB.getStateFromMeta(BlockStoneSlab.EnumType.STONE.getMetadata()), 1, 1, 3, p_addComponentParts_3_);
            return true;
        }
    }

    public static class Corridor
    extends Stronghold {
        private int steps;

        public Corridor() {
        }

        public Corridor(int p_i45581_1_, Random p_i45581_2_, StructureBoundingBox p_i45581_3_, EnumFacing p_i45581_4_) {
            super(p_i45581_1_);
            this.setCoordBaseMode(p_i45581_4_);
            this.boundingBox = p_i45581_3_;
            this.steps = p_i45581_4_ == EnumFacing.NORTH || p_i45581_4_ == EnumFacing.SOUTH ? p_i45581_3_.getZSize() : p_i45581_3_.getXSize();
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setInteger("Steps", this.steps);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.steps = p_readStructureFromNBT_1_.getInteger("Steps");
        }

        public static StructureBoundingBox findPieceBox(List<StructureComponent> p_findPieceBox_0_, Random p_findPieceBox_1_, int p_findPieceBox_2_, int p_findPieceBox_3_, int p_findPieceBox_4_, EnumFacing p_findPieceBox_5_) {
            int lvt_6_1_ = 3;
            StructureBoundingBox lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_findPieceBox_2_, p_findPieceBox_3_, p_findPieceBox_4_, -1, -1, 0, 5, 5, 4, p_findPieceBox_5_);
            StructureComponent lvt_8_1_ = StructureComponent.findIntersecting(p_findPieceBox_0_, lvt_7_1_);
            if (lvt_8_1_ == null) {
                return null;
            }
            if (lvt_8_1_.getBoundingBox().minY == lvt_7_1_.minY) {
                for (int lvt_9_1_ = 3; lvt_9_1_ >= 1; --lvt_9_1_) {
                    lvt_7_1_ = StructureBoundingBox.getComponentToAddBoundingBox(p_findPieceBox_2_, p_findPieceBox_3_, p_findPieceBox_4_, -1, -1, 0, 5, 5, lvt_9_1_ - 1, p_findPieceBox_5_);
                    if (lvt_8_1_.getBoundingBox().intersectsWith(lvt_7_1_)) continue;
                    return StructureBoundingBox.getComponentToAddBoundingBox(p_findPieceBox_2_, p_findPieceBox_3_, p_findPieceBox_4_, -1, -1, 0, 5, 5, lvt_9_1_, p_findPieceBox_5_);
                }
            }
            return null;
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.isLiquidInStructureBoundingBox(p_addComponentParts_1_, p_addComponentParts_3_)) {
                return false;
            }
            for (int lvt_4_1_ = 0; lvt_4_1_ < this.steps; ++lvt_4_1_) {
                this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 0, 0, lvt_4_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 1, 0, lvt_4_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 2, 0, lvt_4_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 3, 0, lvt_4_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 4, 0, lvt_4_1_, p_addComponentParts_3_);
                for (int lvt_5_1_ = 1; lvt_5_1_ <= 3; ++lvt_5_1_) {
                    this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 0, lvt_5_1_, lvt_4_1_, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 1, lvt_5_1_, lvt_4_1_, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 2, lvt_5_1_, lvt_4_1_, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 3, lvt_5_1_, lvt_4_1_, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 4, lvt_5_1_, lvt_4_1_, p_addComponentParts_3_);
                }
                this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 0, 4, lvt_4_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 1, 4, lvt_4_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 2, 4, lvt_4_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 3, 4, lvt_4_1_, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.STONEBRICK.getDefaultState(), 4, 4, lvt_4_1_, p_addComponentParts_3_);
            }
            return true;
        }
    }

    public static abstract class Stronghold
    extends StructureComponent {
        protected Door entryDoor = Door.OPENING;

        public Stronghold() {
        }

        protected Stronghold(int p_i2087_1_) {
            super(p_i2087_1_);
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            p_writeStructureToNBT_1_.setString("EntryDoor", this.entryDoor.name());
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            this.entryDoor = Door.valueOf(p_readStructureFromNBT_1_.getString("EntryDoor"));
        }

        protected void placeDoor(World p_placeDoor_1_, Random p_placeDoor_2_, StructureBoundingBox p_placeDoor_3_, Door p_placeDoor_4_, int p_placeDoor_5_, int p_placeDoor_6_, int p_placeDoor_7_) {
            switch (p_placeDoor_4_) {
                case OPENING: {
                    this.fillWithBlocks(p_placeDoor_1_, p_placeDoor_3_, p_placeDoor_5_, p_placeDoor_6_, p_placeDoor_7_, p_placeDoor_5_ + 3 - 1, p_placeDoor_6_ + 3 - 1, p_placeDoor_7_, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
                    break;
                }
                case WOOD_DOOR: {
                    this.setBlockState(p_placeDoor_1_, Blocks.STONEBRICK.getDefaultState(), p_placeDoor_5_, p_placeDoor_6_, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.STONEBRICK.getDefaultState(), p_placeDoor_5_, p_placeDoor_6_ + 1, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.STONEBRICK.getDefaultState(), p_placeDoor_5_, p_placeDoor_6_ + 2, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.STONEBRICK.getDefaultState(), p_placeDoor_5_ + 1, p_placeDoor_6_ + 2, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.STONEBRICK.getDefaultState(), p_placeDoor_5_ + 2, p_placeDoor_6_ + 2, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.STONEBRICK.getDefaultState(), p_placeDoor_5_ + 2, p_placeDoor_6_ + 1, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.STONEBRICK.getDefaultState(), p_placeDoor_5_ + 2, p_placeDoor_6_, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.OAK_DOOR.getDefaultState(), p_placeDoor_5_ + 1, p_placeDoor_6_, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.OAK_DOOR.getDefaultState().withProperty(BlockDoor.HALF, BlockDoor.EnumDoorHalf.UPPER), p_placeDoor_5_ + 1, p_placeDoor_6_ + 1, p_placeDoor_7_, p_placeDoor_3_);
                    break;
                }
                case GRATES: {
                    this.setBlockState(p_placeDoor_1_, Blocks.AIR.getDefaultState(), p_placeDoor_5_ + 1, p_placeDoor_6_, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.AIR.getDefaultState(), p_placeDoor_5_ + 1, p_placeDoor_6_ + 1, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.IRON_BARS.getDefaultState(), p_placeDoor_5_, p_placeDoor_6_, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.IRON_BARS.getDefaultState(), p_placeDoor_5_, p_placeDoor_6_ + 1, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.IRON_BARS.getDefaultState(), p_placeDoor_5_, p_placeDoor_6_ + 2, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.IRON_BARS.getDefaultState(), p_placeDoor_5_ + 1, p_placeDoor_6_ + 2, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.IRON_BARS.getDefaultState(), p_placeDoor_5_ + 2, p_placeDoor_6_ + 2, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.IRON_BARS.getDefaultState(), p_placeDoor_5_ + 2, p_placeDoor_6_ + 1, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.IRON_BARS.getDefaultState(), p_placeDoor_5_ + 2, p_placeDoor_6_, p_placeDoor_7_, p_placeDoor_3_);
                    break;
                }
                case IRON_DOOR: {
                    this.setBlockState(p_placeDoor_1_, Blocks.STONEBRICK.getDefaultState(), p_placeDoor_5_, p_placeDoor_6_, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.STONEBRICK.getDefaultState(), p_placeDoor_5_, p_placeDoor_6_ + 1, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.STONEBRICK.getDefaultState(), p_placeDoor_5_, p_placeDoor_6_ + 2, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.STONEBRICK.getDefaultState(), p_placeDoor_5_ + 1, p_placeDoor_6_ + 2, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.STONEBRICK.getDefaultState(), p_placeDoor_5_ + 2, p_placeDoor_6_ + 2, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.STONEBRICK.getDefaultState(), p_placeDoor_5_ + 2, p_placeDoor_6_ + 1, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.STONEBRICK.getDefaultState(), p_placeDoor_5_ + 2, p_placeDoor_6_, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.IRON_DOOR.getDefaultState(), p_placeDoor_5_ + 1, p_placeDoor_6_, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.IRON_DOOR.getDefaultState().withProperty(BlockDoor.HALF, BlockDoor.EnumDoorHalf.UPPER), p_placeDoor_5_ + 1, p_placeDoor_6_ + 1, p_placeDoor_7_, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.STONE_BUTTON.getDefaultState().withProperty(BlockButton.FACING, EnumFacing.NORTH), p_placeDoor_5_ + 2, p_placeDoor_6_ + 1, p_placeDoor_7_ + 1, p_placeDoor_3_);
                    this.setBlockState(p_placeDoor_1_, Blocks.STONE_BUTTON.getDefaultState().withProperty(BlockButton.FACING, EnumFacing.SOUTH), p_placeDoor_5_ + 2, p_placeDoor_6_ + 1, p_placeDoor_7_ - 1, p_placeDoor_3_);
                }
            }
        }

        protected Door getRandomDoor(Random p_getRandomDoor_1_) {
            int lvt_2_1_ = p_getRandomDoor_1_.nextInt(5);
            switch (lvt_2_1_) {
                default: {
                    return Door.OPENING;
                }
                case 2: {
                    return Door.WOOD_DOOR;
                }
                case 3: {
                    return Door.GRATES;
                }
                case 4: 
            }
            return Door.IRON_DOOR;
        }

        @Nullable
        protected StructureComponent getNextComponentNormal(Stairs2 p_getNextComponentNormal_1_, List<StructureComponent> p_getNextComponentNormal_2_, Random p_getNextComponentNormal_3_, int p_getNextComponentNormal_4_, int p_getNextComponentNormal_5_) {
            EnumFacing lvt_6_1_ = this.getCoordBaseMode();
            if (lvt_6_1_ != null) {
                switch (lvt_6_1_) {
                    case NORTH: {
                        return StructureStrongholdPieces.generateAndAddPiece(p_getNextComponentNormal_1_, p_getNextComponentNormal_2_, p_getNextComponentNormal_3_, this.boundingBox.minX + p_getNextComponentNormal_4_, this.boundingBox.minY + p_getNextComponentNormal_5_, this.boundingBox.minZ - 1, lvt_6_1_, this.getComponentType());
                    }
                    case SOUTH: {
                        return StructureStrongholdPieces.generateAndAddPiece(p_getNextComponentNormal_1_, p_getNextComponentNormal_2_, p_getNextComponentNormal_3_, this.boundingBox.minX + p_getNextComponentNormal_4_, this.boundingBox.minY + p_getNextComponentNormal_5_, this.boundingBox.maxZ + 1, lvt_6_1_, this.getComponentType());
                    }
                    case WEST: {
                        return StructureStrongholdPieces.generateAndAddPiece(p_getNextComponentNormal_1_, p_getNextComponentNormal_2_, p_getNextComponentNormal_3_, this.boundingBox.minX - 1, this.boundingBox.minY + p_getNextComponentNormal_5_, this.boundingBox.minZ + p_getNextComponentNormal_4_, lvt_6_1_, this.getComponentType());
                    }
                    case EAST: {
                        return StructureStrongholdPieces.generateAndAddPiece(p_getNextComponentNormal_1_, p_getNextComponentNormal_2_, p_getNextComponentNormal_3_, this.boundingBox.maxX + 1, this.boundingBox.minY + p_getNextComponentNormal_5_, this.boundingBox.minZ + p_getNextComponentNormal_4_, lvt_6_1_, this.getComponentType());
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructureComponent getNextComponentX(Stairs2 p_getNextComponentX_1_, List<StructureComponent> p_getNextComponentX_2_, Random p_getNextComponentX_3_, int p_getNextComponentX_4_, int p_getNextComponentX_5_) {
            EnumFacing lvt_6_1_ = this.getCoordBaseMode();
            if (lvt_6_1_ != null) {
                switch (lvt_6_1_) {
                    case NORTH: {
                        return StructureStrongholdPieces.generateAndAddPiece(p_getNextComponentX_1_, p_getNextComponentX_2_, p_getNextComponentX_3_, this.boundingBox.minX - 1, this.boundingBox.minY + p_getNextComponentX_4_, this.boundingBox.minZ + p_getNextComponentX_5_, EnumFacing.WEST, this.getComponentType());
                    }
                    case SOUTH: {
                        return StructureStrongholdPieces.generateAndAddPiece(p_getNextComponentX_1_, p_getNextComponentX_2_, p_getNextComponentX_3_, this.boundingBox.minX - 1, this.boundingBox.minY + p_getNextComponentX_4_, this.boundingBox.minZ + p_getNextComponentX_5_, EnumFacing.WEST, this.getComponentType());
                    }
                    case WEST: {
                        return StructureStrongholdPieces.generateAndAddPiece(p_getNextComponentX_1_, p_getNextComponentX_2_, p_getNextComponentX_3_, this.boundingBox.minX + p_getNextComponentX_5_, this.boundingBox.minY + p_getNextComponentX_4_, this.boundingBox.minZ - 1, EnumFacing.NORTH, this.getComponentType());
                    }
                    case EAST: {
                        return StructureStrongholdPieces.generateAndAddPiece(p_getNextComponentX_1_, p_getNextComponentX_2_, p_getNextComponentX_3_, this.boundingBox.minX + p_getNextComponentX_5_, this.boundingBox.minY + p_getNextComponentX_4_, this.boundingBox.minZ - 1, EnumFacing.NORTH, this.getComponentType());
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructureComponent getNextComponentZ(Stairs2 p_getNextComponentZ_1_, List<StructureComponent> p_getNextComponentZ_2_, Random p_getNextComponentZ_3_, int p_getNextComponentZ_4_, int p_getNextComponentZ_5_) {
            EnumFacing lvt_6_1_ = this.getCoordBaseMode();
            if (lvt_6_1_ != null) {
                switch (lvt_6_1_) {
                    case NORTH: {
                        return StructureStrongholdPieces.generateAndAddPiece(p_getNextComponentZ_1_, p_getNextComponentZ_2_, p_getNextComponentZ_3_, this.boundingBox.maxX + 1, this.boundingBox.minY + p_getNextComponentZ_4_, this.boundingBox.minZ + p_getNextComponentZ_5_, EnumFacing.EAST, this.getComponentType());
                    }
                    case SOUTH: {
                        return StructureStrongholdPieces.generateAndAddPiece(p_getNextComponentZ_1_, p_getNextComponentZ_2_, p_getNextComponentZ_3_, this.boundingBox.maxX + 1, this.boundingBox.minY + p_getNextComponentZ_4_, this.boundingBox.minZ + p_getNextComponentZ_5_, EnumFacing.EAST, this.getComponentType());
                    }
                    case WEST: {
                        return StructureStrongholdPieces.generateAndAddPiece(p_getNextComponentZ_1_, p_getNextComponentZ_2_, p_getNextComponentZ_3_, this.boundingBox.minX + p_getNextComponentZ_5_, this.boundingBox.minY + p_getNextComponentZ_4_, this.boundingBox.maxZ + 1, EnumFacing.SOUTH, this.getComponentType());
                    }
                    case EAST: {
                        return StructureStrongholdPieces.generateAndAddPiece(p_getNextComponentZ_1_, p_getNextComponentZ_2_, p_getNextComponentZ_3_, this.boundingBox.minX + p_getNextComponentZ_5_, this.boundingBox.minY + p_getNextComponentZ_4_, this.boundingBox.maxZ + 1, EnumFacing.SOUTH, this.getComponentType());
                    }
                }
            }
            return null;
        }

        protected static boolean canStrongholdGoDeeper(StructureBoundingBox p_canStrongholdGoDeeper_0_) {
            return p_canStrongholdGoDeeper_0_ != null && p_canStrongholdGoDeeper_0_.minY > 10;
        }

        public static enum Door {
            OPENING,
            WOOD_DOOR,
            GRATES,
            IRON_DOOR;

        }
    }

    static class PieceWeight {
        public Class<? extends Stronghold> pieceClass;
        public final int pieceWeight;
        public int instancesSpawned;
        public int instancesLimit;

        public PieceWeight(Class<? extends Stronghold> p_i2076_1_, int p_i2076_2_, int p_i2076_3_) {
            this.pieceClass = p_i2076_1_;
            this.pieceWeight = p_i2076_2_;
            this.instancesLimit = p_i2076_3_;
        }

        public boolean canSpawnMoreStructuresOfType(int p_canSpawnMoreStructuresOfType_1_) {
            return this.instancesLimit == 0 || this.instancesSpawned < this.instancesLimit;
        }

        public boolean canSpawnMoreStructures() {
            return this.instancesLimit == 0 || this.instancesSpawned < this.instancesLimit;
        }
    }
}

