/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDesert;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.biome.BiomeSavanna;
import net.minecraft.world.biome.BiomeTaiga;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class StructureVillagePieces {
    public static void registerVillagePieces() {
        MapGenStructureIO.registerStructureComponent(House1.class, "ViBH");
        MapGenStructureIO.registerStructureComponent(Field1.class, "ViDF");
        MapGenStructureIO.registerStructureComponent(Field2.class, "ViF");
        MapGenStructureIO.registerStructureComponent(Torch.class, "ViL");
        MapGenStructureIO.registerStructureComponent(Hall.class, "ViPH");
        MapGenStructureIO.registerStructureComponent(House4Garden.class, "ViSH");
        MapGenStructureIO.registerStructureComponent(WoodHut.class, "ViSmH");
        MapGenStructureIO.registerStructureComponent(Church.class, "ViST");
        MapGenStructureIO.registerStructureComponent(House2.class, "ViS");
        MapGenStructureIO.registerStructureComponent(Start.class, "ViStart");
        MapGenStructureIO.registerStructureComponent(Path.class, "ViSR");
        MapGenStructureIO.registerStructureComponent(House3.class, "ViTRH");
        MapGenStructureIO.registerStructureComponent(Well.class, "ViW");
    }

    public static List<PieceWeight> getStructureVillageWeightedPieceList(Random p_getStructureVillageWeightedPieceList_0_, int p_getStructureVillageWeightedPieceList_1_) {
        ArrayList list = Lists.newArrayList();
        list.add(new PieceWeight(House4Garden.class, 4, MathHelper.getInt(p_getStructureVillageWeightedPieceList_0_, 2 + p_getStructureVillageWeightedPieceList_1_, 4 + p_getStructureVillageWeightedPieceList_1_ * 2)));
        list.add(new PieceWeight(Church.class, 20, MathHelper.getInt(p_getStructureVillageWeightedPieceList_0_, 0 + p_getStructureVillageWeightedPieceList_1_, 1 + p_getStructureVillageWeightedPieceList_1_)));
        list.add(new PieceWeight(House1.class, 20, MathHelper.getInt(p_getStructureVillageWeightedPieceList_0_, 0 + p_getStructureVillageWeightedPieceList_1_, 2 + p_getStructureVillageWeightedPieceList_1_)));
        list.add(new PieceWeight(WoodHut.class, 3, MathHelper.getInt(p_getStructureVillageWeightedPieceList_0_, 2 + p_getStructureVillageWeightedPieceList_1_, 5 + p_getStructureVillageWeightedPieceList_1_ * 3)));
        list.add(new PieceWeight(Hall.class, 15, MathHelper.getInt(p_getStructureVillageWeightedPieceList_0_, 0 + p_getStructureVillageWeightedPieceList_1_, 2 + p_getStructureVillageWeightedPieceList_1_)));
        list.add(new PieceWeight(Field1.class, 3, MathHelper.getInt(p_getStructureVillageWeightedPieceList_0_, 1 + p_getStructureVillageWeightedPieceList_1_, 4 + p_getStructureVillageWeightedPieceList_1_)));
        list.add(new PieceWeight(Field2.class, 3, MathHelper.getInt(p_getStructureVillageWeightedPieceList_0_, 2 + p_getStructureVillageWeightedPieceList_1_, 4 + p_getStructureVillageWeightedPieceList_1_ * 2)));
        list.add(new PieceWeight(House2.class, 15, MathHelper.getInt(p_getStructureVillageWeightedPieceList_0_, 0, 1 + p_getStructureVillageWeightedPieceList_1_)));
        list.add(new PieceWeight(House3.class, 8, MathHelper.getInt(p_getStructureVillageWeightedPieceList_0_, 0 + p_getStructureVillageWeightedPieceList_1_, 3 + p_getStructureVillageWeightedPieceList_1_ * 2)));
        VillagerRegistry.addExtraVillageComponents(list, p_getStructureVillageWeightedPieceList_0_, p_getStructureVillageWeightedPieceList_1_);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (((PieceWeight)iterator.next()).villagePiecesLimit != 0) continue;
            iterator.remove();
        }
        return list;
    }

    private static int updatePieceWeight(List<PieceWeight> p_updatePieceWeight_0_) {
        boolean flag = false;
        int i = 0;
        for (PieceWeight structurevillagepieces$pieceweight : p_updatePieceWeight_0_) {
            if (structurevillagepieces$pieceweight.villagePiecesLimit > 0 && structurevillagepieces$pieceweight.villagePiecesSpawned < structurevillagepieces$pieceweight.villagePiecesLimit) {
                flag = true;
            }
            i += structurevillagepieces$pieceweight.villagePieceWeight;
        }
        return flag ? i : -1;
    }

    private static Village findAndCreateComponentFactory(Start p_findAndCreateComponentFactory_0_, PieceWeight p_findAndCreateComponentFactory_1_, List<StructureComponent> p_findAndCreateComponentFactory_2_, Random p_findAndCreateComponentFactory_3_, int p_findAndCreateComponentFactory_4_, int p_findAndCreateComponentFactory_5_, int p_findAndCreateComponentFactory_6_, EnumFacing p_findAndCreateComponentFactory_7_, int p_findAndCreateComponentFactory_8_) {
        Class<? extends Village> oclass = p_findAndCreateComponentFactory_1_.villagePieceClass;
        Village structurevillagepieces$village = null;
        structurevillagepieces$village = oclass == House4Garden.class ? House4Garden.createPiece(p_findAndCreateComponentFactory_0_, p_findAndCreateComponentFactory_2_, p_findAndCreateComponentFactory_3_, p_findAndCreateComponentFactory_4_, p_findAndCreateComponentFactory_5_, p_findAndCreateComponentFactory_6_, p_findAndCreateComponentFactory_7_, p_findAndCreateComponentFactory_8_) : (oclass == Church.class ? Church.createPiece(p_findAndCreateComponentFactory_0_, p_findAndCreateComponentFactory_2_, p_findAndCreateComponentFactory_3_, p_findAndCreateComponentFactory_4_, p_findAndCreateComponentFactory_5_, p_findAndCreateComponentFactory_6_, p_findAndCreateComponentFactory_7_, p_findAndCreateComponentFactory_8_) : (oclass == House1.class ? House1.createPiece(p_findAndCreateComponentFactory_0_, p_findAndCreateComponentFactory_2_, p_findAndCreateComponentFactory_3_, p_findAndCreateComponentFactory_4_, p_findAndCreateComponentFactory_5_, p_findAndCreateComponentFactory_6_, p_findAndCreateComponentFactory_7_, p_findAndCreateComponentFactory_8_) : (oclass == WoodHut.class ? WoodHut.createPiece(p_findAndCreateComponentFactory_0_, p_findAndCreateComponentFactory_2_, p_findAndCreateComponentFactory_3_, p_findAndCreateComponentFactory_4_, p_findAndCreateComponentFactory_5_, p_findAndCreateComponentFactory_6_, p_findAndCreateComponentFactory_7_, p_findAndCreateComponentFactory_8_) : (oclass == Hall.class ? Hall.createPiece(p_findAndCreateComponentFactory_0_, p_findAndCreateComponentFactory_2_, p_findAndCreateComponentFactory_3_, p_findAndCreateComponentFactory_4_, p_findAndCreateComponentFactory_5_, p_findAndCreateComponentFactory_6_, p_findAndCreateComponentFactory_7_, p_findAndCreateComponentFactory_8_) : (oclass == Field1.class ? Field1.createPiece(p_findAndCreateComponentFactory_0_, p_findAndCreateComponentFactory_2_, p_findAndCreateComponentFactory_3_, p_findAndCreateComponentFactory_4_, p_findAndCreateComponentFactory_5_, p_findAndCreateComponentFactory_6_, p_findAndCreateComponentFactory_7_, p_findAndCreateComponentFactory_8_) : (oclass == Field2.class ? Field2.createPiece(p_findAndCreateComponentFactory_0_, p_findAndCreateComponentFactory_2_, p_findAndCreateComponentFactory_3_, p_findAndCreateComponentFactory_4_, p_findAndCreateComponentFactory_5_, p_findAndCreateComponentFactory_6_, p_findAndCreateComponentFactory_7_, p_findAndCreateComponentFactory_8_) : (oclass == House2.class ? House2.createPiece(p_findAndCreateComponentFactory_0_, p_findAndCreateComponentFactory_2_, p_findAndCreateComponentFactory_3_, p_findAndCreateComponentFactory_4_, p_findAndCreateComponentFactory_5_, p_findAndCreateComponentFactory_6_, p_findAndCreateComponentFactory_7_, p_findAndCreateComponentFactory_8_) : (oclass == House3.class ? House3.createPiece(p_findAndCreateComponentFactory_0_, p_findAndCreateComponentFactory_2_, p_findAndCreateComponentFactory_3_, p_findAndCreateComponentFactory_4_, p_findAndCreateComponentFactory_5_, p_findAndCreateComponentFactory_6_, p_findAndCreateComponentFactory_7_, p_findAndCreateComponentFactory_8_) : VillagerRegistry.getVillageComponent(p_findAndCreateComponentFactory_1_, p_findAndCreateComponentFactory_0_, p_findAndCreateComponentFactory_2_, p_findAndCreateComponentFactory_3_, p_findAndCreateComponentFactory_4_, p_findAndCreateComponentFactory_5_, p_findAndCreateComponentFactory_6_, p_findAndCreateComponentFactory_7_, p_findAndCreateComponentFactory_8_)))))))));
        return structurevillagepieces$village;
    }

    private static Village generateComponent(Start p_generateComponent_0_, List<StructureComponent> p_generateComponent_1_, Random p_generateComponent_2_, int p_generateComponent_3_, int p_generateComponent_4_, int p_generateComponent_5_, EnumFacing p_generateComponent_6_, int p_generateComponent_7_) {
        int i = StructureVillagePieces.updatePieceWeight(p_generateComponent_0_.structureVillageWeightedPieceList);
        if (i <= 0) {
            return null;
        }
        int j = 0;
        block0: while (j < 5) {
            ++j;
            int k = p_generateComponent_2_.nextInt(i);
            for (PieceWeight structurevillagepieces$pieceweight : p_generateComponent_0_.structureVillageWeightedPieceList) {
                if ((k -= structurevillagepieces$pieceweight.villagePieceWeight) >= 0) continue;
                if (!structurevillagepieces$pieceweight.canSpawnMoreVillagePiecesOfType(p_generateComponent_7_) || structurevillagepieces$pieceweight == p_generateComponent_0_.structVillagePieceWeight && p_generateComponent_0_.structureVillageWeightedPieceList.size() > 1) continue block0;
                Village structurevillagepieces$village = StructureVillagePieces.findAndCreateComponentFactory(p_generateComponent_0_, structurevillagepieces$pieceweight, p_generateComponent_1_, p_generateComponent_2_, p_generateComponent_3_, p_generateComponent_4_, p_generateComponent_5_, p_generateComponent_6_, p_generateComponent_7_);
                if (structurevillagepieces$village == null) continue;
                ++structurevillagepieces$pieceweight.villagePiecesSpawned;
                p_generateComponent_0_.structVillagePieceWeight = structurevillagepieces$pieceweight;
                if (!structurevillagepieces$pieceweight.canSpawnMoreVillagePieces()) {
                    p_generateComponent_0_.structureVillageWeightedPieceList.remove(structurevillagepieces$pieceweight);
                }
                return structurevillagepieces$village;
            }
        }
        StructureBoundingBox structureboundingbox = Torch.findPieceBox(p_generateComponent_0_, p_generateComponent_1_, p_generateComponent_2_, p_generateComponent_3_, p_generateComponent_4_, p_generateComponent_5_, p_generateComponent_6_);
        if (structureboundingbox != null) {
            return new Torch(p_generateComponent_0_, p_generateComponent_7_, p_generateComponent_2_, structureboundingbox, p_generateComponent_6_);
        }
        return null;
    }

    private static StructureComponent generateAndAddComponent(Start p_generateAndAddComponent_0_, List<StructureComponent> p_generateAndAddComponent_1_, Random p_generateAndAddComponent_2_, int p_generateAndAddComponent_3_, int p_generateAndAddComponent_4_, int p_generateAndAddComponent_5_, EnumFacing p_generateAndAddComponent_6_, int p_generateAndAddComponent_7_) {
        if (p_generateAndAddComponent_7_ > 50) {
            return null;
        }
        if (Math.abs(p_generateAndAddComponent_3_ - p_generateAndAddComponent_0_.getBoundingBox().minX) <= 112 && Math.abs(p_generateAndAddComponent_5_ - p_generateAndAddComponent_0_.getBoundingBox().minZ) <= 112) {
            Village structurecomponent = StructureVillagePieces.generateComponent(p_generateAndAddComponent_0_, p_generateAndAddComponent_1_, p_generateAndAddComponent_2_, p_generateAndAddComponent_3_, p_generateAndAddComponent_4_, p_generateAndAddComponent_5_, p_generateAndAddComponent_6_, p_generateAndAddComponent_7_ + 1);
            if (structurecomponent != null) {
                p_generateAndAddComponent_1_.add(structurecomponent);
                p_generateAndAddComponent_0_.pendingHouses.add(structurecomponent);
                return structurecomponent;
            }
            return null;
        }
        return null;
    }

    private static StructureComponent generateAndAddRoadPiece(Start p_generateAndAddRoadPiece_0_, List<StructureComponent> p_generateAndAddRoadPiece_1_, Random p_generateAndAddRoadPiece_2_, int p_generateAndAddRoadPiece_3_, int p_generateAndAddRoadPiece_4_, int p_generateAndAddRoadPiece_5_, EnumFacing p_generateAndAddRoadPiece_6_, int p_generateAndAddRoadPiece_7_) {
        if (p_generateAndAddRoadPiece_7_ > 3 + p_generateAndAddRoadPiece_0_.terrainType) {
            return null;
        }
        if (Math.abs(p_generateAndAddRoadPiece_3_ - p_generateAndAddRoadPiece_0_.getBoundingBox().minX) <= 112 && Math.abs(p_generateAndAddRoadPiece_5_ - p_generateAndAddRoadPiece_0_.getBoundingBox().minZ) <= 112) {
            StructureBoundingBox structureboundingbox = Path.findPieceBox(p_generateAndAddRoadPiece_0_, p_generateAndAddRoadPiece_1_, p_generateAndAddRoadPiece_2_, p_generateAndAddRoadPiece_3_, p_generateAndAddRoadPiece_4_, p_generateAndAddRoadPiece_5_, p_generateAndAddRoadPiece_6_);
            if (structureboundingbox != null && structureboundingbox.minY > 10) {
                Path structurecomponent = new Path(p_generateAndAddRoadPiece_0_, p_generateAndAddRoadPiece_7_, p_generateAndAddRoadPiece_2_, structureboundingbox, p_generateAndAddRoadPiece_6_);
                p_generateAndAddRoadPiece_1_.add(structurecomponent);
                p_generateAndAddRoadPiece_0_.pendingRoads.add(structurecomponent);
                return structurecomponent;
            }
            return null;
        }
        return null;
    }

    public static class WoodHut
    extends Village {
        private boolean isTallHouse;
        private int tablePosition;

        public WoodHut() {
        }

        public WoodHut(Start p_i45565_1_, int p_i45565_2_, Random p_i45565_3_, StructureBoundingBox p_i45565_4_, EnumFacing p_i45565_5_) {
            super(p_i45565_1_, p_i45565_2_);
            this.setCoordBaseMode(p_i45565_5_);
            this.boundingBox = p_i45565_4_;
            this.isTallHouse = p_i45565_3_.nextBoolean();
            this.tablePosition = p_i45565_3_.nextInt(3);
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setInteger("T", this.tablePosition);
            p_writeStructureToNBT_1_.setBoolean("C", this.isTallHouse);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.tablePosition = p_readStructureFromNBT_1_.getInteger("T");
            this.isTallHouse = p_readStructureFromNBT_1_.getBoolean("C");
        }

        public static WoodHut createPiece(Start p_createPiece_0_, List<StructureComponent> p_createPiece_1_, Random p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, int p_createPiece_5_, EnumFacing p_createPiece_6_, int p_createPiece_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_3_, p_createPiece_4_, p_createPiece_5_, 0, 0, 0, 4, 6, 5, p_createPiece_6_);
            return WoodHut.canVillageGoDeeper(structureboundingbox) && StructureComponent.findIntersecting(p_createPiece_1_, structureboundingbox) == null ? new WoodHut(p_createPiece_0_, p_createPiece_7_, p_createPiece_2_, structureboundingbox, p_createPiece_6_) : null;
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(p_addComponentParts_1_, p_addComponentParts_3_);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.boundingBox.offset(0, this.averageGroundLvl - this.boundingBox.maxY + 6 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.COBBLESTONE.getDefaultState());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.PLANKS.getDefaultState());
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.STONE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.NORTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.LOG.getDefaultState());
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(Blocks.OAK_FENCE.getDefaultState());
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 1, 3, 5, 4, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 3, 0, 4, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, 1, 2, 0, 3, Blocks.DIRT.getDefaultState(), Blocks.DIRT.getDefaultState(), false);
            if (this.isTallHouse) {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 4, 1, 2, 4, 3, iblockstate3, iblockstate3, false);
            } else {
                this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 5, 1, 2, 5, 3, iblockstate3, iblockstate3, false);
            }
            this.setBlockState(p_addComponentParts_1_, iblockstate3, 1, 4, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate3, 2, 4, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate3, 1, 4, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate3, 2, 4, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate3, 0, 4, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate3, 0, 4, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate3, 0, 4, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate3, 3, 4, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate3, 3, 4, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate3, 3, 4, 3, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 0, 0, 3, 0, iblockstate3, iblockstate3, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 0, 3, 3, 0, iblockstate3, iblockstate3, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 4, 0, 3, 4, iblockstate3, iblockstate3, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 4, 3, 3, 4, iblockstate3, iblockstate3, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 1, 0, 3, 3, iblockstate1, iblockstate1, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 1, 3, 3, 3, iblockstate1, iblockstate1, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 0, 2, 3, 0, iblockstate1, iblockstate1, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 4, 2, 3, 4, iblockstate1, iblockstate1, false);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 0, 2, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 3, 2, 2, p_addComponentParts_3_);
            if (this.tablePosition > 0) {
                this.setBlockState(p_addComponentParts_1_, iblockstate4, this.tablePosition, 1, 3, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, Blocks.WOODEN_PRESSURE_PLATE.getDefaultState(), this.tablePosition, 2, 3, p_addComponentParts_3_);
            }
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 1, 1, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 1, 2, 0, p_addComponentParts_3_);
            this.createVillageDoor(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 1, 1, 0, EnumFacing.NORTH);
            if (this.getBlockStateFromPos(p_addComponentParts_1_, 1, 0, -1, p_addComponentParts_3_).getMaterial() == Material.AIR && this.getBlockStateFromPos(p_addComponentParts_1_, 1, -1, -1, p_addComponentParts_3_).getMaterial() != Material.AIR) {
                this.setBlockState(p_addComponentParts_1_, iblockstate2, 1, 0, -1, p_addComponentParts_3_);
                if (this.getBlockStateFromPos(p_addComponentParts_1_, 1, -1, -1, p_addComponentParts_3_).getBlock() == Blocks.GRASS_PATH) {
                    this.setBlockState(p_addComponentParts_1_, Blocks.GRASS.getDefaultState(), 1, -1, -1, p_addComponentParts_3_);
                }
            }
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.clearCurrentPositionBlocksUpwards(p_addComponentParts_1_, j, 6, i, p_addComponentParts_3_);
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, iblockstate, j, -1, i, p_addComponentParts_3_);
                }
            }
            this.spawnVillagers(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 2, 1);
            return true;
        }
    }

    public static class Well
    extends Village {
        public Well() {
        }

        public Well(Start p_i2109_1_, int p_i2109_2_, Random p_i2109_3_, int p_i2109_4_, int p_i2109_5_) {
            super(p_i2109_1_, p_i2109_2_);
            this.setCoordBaseMode(EnumFacing.Plane.HORIZONTAL.random(p_i2109_3_));
            this.boundingBox = this.getCoordBaseMode().getAxis() == EnumFacing.Axis.Z ? new StructureBoundingBox(p_i2109_4_, 64, p_i2109_5_, p_i2109_4_ + 6 - 1, 78, p_i2109_5_ + 6 - 1) : new StructureBoundingBox(p_i2109_4_, 64, p_i2109_5_, p_i2109_4_ + 6 - 1, 78, p_i2109_5_ + 6 - 1);
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            StructureVillagePieces.generateAndAddRoadPiece((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX - 1, this.boundingBox.maxY - 4, this.boundingBox.minZ + 1, EnumFacing.WEST, this.getComponentType());
            StructureVillagePieces.generateAndAddRoadPiece((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.maxX + 1, this.boundingBox.maxY - 4, this.boundingBox.minZ + 1, EnumFacing.EAST, this.getComponentType());
            StructureVillagePieces.generateAndAddRoadPiece((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX + 1, this.boundingBox.maxY - 4, this.boundingBox.minZ - 1, EnumFacing.NORTH, this.getComponentType());
            StructureVillagePieces.generateAndAddRoadPiece((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX + 1, this.boundingBox.maxY - 4, this.boundingBox.maxZ + 1, EnumFacing.SOUTH, this.getComponentType());
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(p_addComponentParts_1_, p_addComponentParts_3_);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.boundingBox.offset(0, this.averageGroundLvl - this.boundingBox.maxY + 3, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.COBBLESTONE.getDefaultState());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.OAK_FENCE.getDefaultState());
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, 1, 4, 12, 4, iblockstate, Blocks.FLOWING_WATER.getDefaultState(), false);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 2, 12, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 3, 12, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 2, 12, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 3, 12, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 1, 13, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 1, 14, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 4, 13, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 4, 14, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 1, 13, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 1, 14, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 4, 13, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 4, 14, 4, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 15, 1, 4, 15, 4, iblockstate, iblockstate, false);
            for (int i = 0; i <= 5; ++i) {
                for (int j = 0; j <= 5; ++j) {
                    if (j != 0 && j != 5 && i != 0 && i != 5) continue;
                    this.setBlockState(p_addComponentParts_1_, iblockstate, j, 11, i, p_addComponentParts_3_);
                    this.clearCurrentPositionBlocksUpwards(p_addComponentParts_1_, j, 12, i, p_addComponentParts_3_);
                }
            }
            return true;
        }
    }

    public static abstract class Village
    extends StructureComponent {
        protected int averageGroundLvl = -1;
        private int villagersSpawned;
        protected int structureType;
        protected boolean isZombieInfested;
        protected Start startPiece;

        public Village() {
        }

        protected Village(Start p_i2107_1_, int p_i2107_2_) {
            super(p_i2107_2_);
            if (p_i2107_1_ != null) {
                this.structureType = p_i2107_1_.structureType;
                this.isZombieInfested = p_i2107_1_.isZombieInfested;
                this.startPiece = p_i2107_1_;
            }
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            p_writeStructureToNBT_1_.setInteger("HPos", this.averageGroundLvl);
            p_writeStructureToNBT_1_.setInteger("VCount", this.villagersSpawned);
            p_writeStructureToNBT_1_.setByte("Type", (byte)this.structureType);
            p_writeStructureToNBT_1_.setBoolean("Zombie", this.isZombieInfested);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            this.averageGroundLvl = p_readStructureFromNBT_1_.getInteger("HPos");
            this.villagersSpawned = p_readStructureFromNBT_1_.getInteger("VCount");
            this.structureType = p_readStructureFromNBT_1_.getByte("Type");
            if (p_readStructureFromNBT_1_.getBoolean("Desert")) {
                this.structureType = 1;
            }
            this.isZombieInfested = p_readStructureFromNBT_1_.getBoolean("Zombie");
        }

        @Nullable
        protected StructureComponent getNextComponentNN(Start p_getNextComponentNN_1_, List<StructureComponent> p_getNextComponentNN_2_, Random p_getNextComponentNN_3_, int p_getNextComponentNN_4_, int p_getNextComponentNN_5_) {
            EnumFacing enumfacing = this.getCoordBaseMode();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        return StructureVillagePieces.generateAndAddComponent(p_getNextComponentNN_1_, p_getNextComponentNN_2_, p_getNextComponentNN_3_, this.boundingBox.minX - 1, this.boundingBox.minY + p_getNextComponentNN_4_, this.boundingBox.minZ + p_getNextComponentNN_5_, EnumFacing.WEST, this.getComponentType());
                    }
                    case SOUTH: {
                        return StructureVillagePieces.generateAndAddComponent(p_getNextComponentNN_1_, p_getNextComponentNN_2_, p_getNextComponentNN_3_, this.boundingBox.minX - 1, this.boundingBox.minY + p_getNextComponentNN_4_, this.boundingBox.minZ + p_getNextComponentNN_5_, EnumFacing.WEST, this.getComponentType());
                    }
                    case WEST: {
                        return StructureVillagePieces.generateAndAddComponent(p_getNextComponentNN_1_, p_getNextComponentNN_2_, p_getNextComponentNN_3_, this.boundingBox.minX + p_getNextComponentNN_5_, this.boundingBox.minY + p_getNextComponentNN_4_, this.boundingBox.minZ - 1, EnumFacing.NORTH, this.getComponentType());
                    }
                    case EAST: 
                }
                return StructureVillagePieces.generateAndAddComponent(p_getNextComponentNN_1_, p_getNextComponentNN_2_, p_getNextComponentNN_3_, this.boundingBox.minX + p_getNextComponentNN_5_, this.boundingBox.minY + p_getNextComponentNN_4_, this.boundingBox.minZ - 1, EnumFacing.NORTH, this.getComponentType());
            }
            return null;
        }

        @Nullable
        protected StructureComponent getNextComponentPP(Start p_getNextComponentPP_1_, List<StructureComponent> p_getNextComponentPP_2_, Random p_getNextComponentPP_3_, int p_getNextComponentPP_4_, int p_getNextComponentPP_5_) {
            EnumFacing enumfacing = this.getCoordBaseMode();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        return StructureVillagePieces.generateAndAddComponent(p_getNextComponentPP_1_, p_getNextComponentPP_2_, p_getNextComponentPP_3_, this.boundingBox.maxX + 1, this.boundingBox.minY + p_getNextComponentPP_4_, this.boundingBox.minZ + p_getNextComponentPP_5_, EnumFacing.EAST, this.getComponentType());
                    }
                    case SOUTH: {
                        return StructureVillagePieces.generateAndAddComponent(p_getNextComponentPP_1_, p_getNextComponentPP_2_, p_getNextComponentPP_3_, this.boundingBox.maxX + 1, this.boundingBox.minY + p_getNextComponentPP_4_, this.boundingBox.minZ + p_getNextComponentPP_5_, EnumFacing.EAST, this.getComponentType());
                    }
                    case WEST: {
                        return StructureVillagePieces.generateAndAddComponent(p_getNextComponentPP_1_, p_getNextComponentPP_2_, p_getNextComponentPP_3_, this.boundingBox.minX + p_getNextComponentPP_5_, this.boundingBox.minY + p_getNextComponentPP_4_, this.boundingBox.maxZ + 1, EnumFacing.SOUTH, this.getComponentType());
                    }
                    case EAST: 
                }
                return StructureVillagePieces.generateAndAddComponent(p_getNextComponentPP_1_, p_getNextComponentPP_2_, p_getNextComponentPP_3_, this.boundingBox.minX + p_getNextComponentPP_5_, this.boundingBox.minY + p_getNextComponentPP_4_, this.boundingBox.maxZ + 1, EnumFacing.SOUTH, this.getComponentType());
            }
            return null;
        }

        protected int getAverageGroundLevel(World p_getAverageGroundLevel_1_, StructureBoundingBox p_getAverageGroundLevel_2_) {
            int i = 0;
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = this.boundingBox.minZ; k <= this.boundingBox.maxZ; ++k) {
                for (int l = this.boundingBox.minX; l <= this.boundingBox.maxX; ++l) {
                    blockpos$mutableblockpos.setPos(l, 64, k);
                    if (!p_getAverageGroundLevel_2_.isVecInside(blockpos$mutableblockpos)) continue;
                    i += Math.max(p_getAverageGroundLevel_1_.getTopSolidOrLiquidBlock(blockpos$mutableblockpos).getY(), p_getAverageGroundLevel_1_.provider.getAverageGroundLevel() - 1);
                    ++j;
                }
            }
            if (j == 0) {
                return -1;
            }
            return i / j;
        }

        protected static boolean canVillageGoDeeper(StructureBoundingBox p_canVillageGoDeeper_0_) {
            return p_canVillageGoDeeper_0_ != null && p_canVillageGoDeeper_0_.minY > 10;
        }

        protected void spawnVillagers(World p_spawnVillagers_1_, StructureBoundingBox p_spawnVillagers_2_, int p_spawnVillagers_3_, int p_spawnVillagers_4_, int p_spawnVillagers_5_, int p_spawnVillagers_6_) {
            if (this.villagersSpawned < p_spawnVillagers_6_) {
                int l;
                int k;
                int j;
                for (int i = this.villagersSpawned; i < p_spawnVillagers_6_ && p_spawnVillagers_2_.isVecInside(new BlockPos(j = this.getXWithOffset(p_spawnVillagers_3_ + i, p_spawnVillagers_5_), k = this.getYWithOffset(p_spawnVillagers_4_), l = this.getZWithOffset(p_spawnVillagers_3_ + i, p_spawnVillagers_5_))); ++i) {
                    ++this.villagersSpawned;
                    if (this.isZombieInfested) {
                        EntityZombieVillager entityzombievillager = new EntityZombieVillager(p_spawnVillagers_1_);
                        entityzombievillager.setLocationAndAngles((double)j + 0.5, k, (double)l + 0.5, 0.0f, 0.0f);
                        entityzombievillager.onInitialSpawn(p_spawnVillagers_1_.getDifficultyForLocation(new BlockPos(entityzombievillager)), null);
                        entityzombievillager.enablePersistence();
                        p_spawnVillagers_1_.spawnEntity(entityzombievillager);
                        continue;
                    }
                    EntityVillager entityvillager = new EntityVillager(p_spawnVillagers_1_);
                    entityvillager.setLocationAndAngles((double)j + 0.5, k, (double)l + 0.5, 0.0f, 0.0f);
                    entityvillager.setProfession(this.chooseForgeProfession(i, entityvillager.getProfessionForge()));
                    entityvillager.finalizeMobSpawn(p_spawnVillagers_1_.getDifficultyForLocation(new BlockPos(entityvillager)), null, false);
                    p_spawnVillagers_1_.spawnEntity(entityvillager);
                }
            }
        }

        @Deprecated
        protected int chooseProfession(int p_chooseProfession_1_, int p_chooseProfession_2_) {
            return p_chooseProfession_2_;
        }

        protected VillagerRegistry.VillagerProfession chooseForgeProfession(int p_chooseForgeProfession_1_, VillagerRegistry.VillagerProfession p_chooseForgeProfession_2_) {
            return VillagerRegistry.getById(this.chooseProfession(p_chooseForgeProfession_1_, VillagerRegistry.getId(p_chooseForgeProfession_2_)));
        }

        protected IBlockState getBiomeSpecificBlockState(IBlockState p_getBiomeSpecificBlockState_1_) {
            BiomeEvent.GetVillageBlockID event = new BiomeEvent.GetVillageBlockID(this.startPiece == null ? null : this.startPiece.biome, p_getBiomeSpecificBlockState_1_);
            MinecraftForge.TERRAIN_GEN_BUS.post(event);
            if (event.getResult() == Event.Result.DENY) {
                return event.getReplacement();
            }
            if (this.structureType == 1) {
                if (p_getBiomeSpecificBlockState_1_.getBlock() == Blocks.LOG || p_getBiomeSpecificBlockState_1_.getBlock() == Blocks.LOG2) {
                    return Blocks.SANDSTONE.getDefaultState();
                }
                if (p_getBiomeSpecificBlockState_1_.getBlock() == Blocks.COBBLESTONE) {
                    return Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.DEFAULT.getMetadata());
                }
                if (p_getBiomeSpecificBlockState_1_.getBlock() == Blocks.PLANKS) {
                    return Blocks.SANDSTONE.getStateFromMeta(BlockSandStone.EnumType.SMOOTH.getMetadata());
                }
                if (p_getBiomeSpecificBlockState_1_.getBlock() == Blocks.OAK_STAIRS) {
                    return Blocks.SANDSTONE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, p_getBiomeSpecificBlockState_1_.getValue(BlockStairs.FACING));
                }
                if (p_getBiomeSpecificBlockState_1_.getBlock() == Blocks.STONE_STAIRS) {
                    return Blocks.SANDSTONE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, p_getBiomeSpecificBlockState_1_.getValue(BlockStairs.FACING));
                }
                if (p_getBiomeSpecificBlockState_1_.getBlock() == Blocks.GRAVEL) {
                    return Blocks.SANDSTONE.getDefaultState();
                }
            } else if (this.structureType == 3) {
                if (p_getBiomeSpecificBlockState_1_.getBlock() == Blocks.LOG || p_getBiomeSpecificBlockState_1_.getBlock() == Blocks.LOG2) {
                    return Blocks.LOG.getDefaultState().withProperty(BlockOldLog.VARIANT, BlockPlanks.EnumType.SPRUCE).withProperty(BlockLog.LOG_AXIS, p_getBiomeSpecificBlockState_1_.getValue(BlockLog.LOG_AXIS));
                }
                if (p_getBiomeSpecificBlockState_1_.getBlock() == Blocks.PLANKS) {
                    return Blocks.PLANKS.getDefaultState().withProperty(BlockPlanks.VARIANT, BlockPlanks.EnumType.SPRUCE);
                }
                if (p_getBiomeSpecificBlockState_1_.getBlock() == Blocks.OAK_STAIRS) {
                    return Blocks.SPRUCE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, p_getBiomeSpecificBlockState_1_.getValue(BlockStairs.FACING));
                }
                if (p_getBiomeSpecificBlockState_1_.getBlock() == Blocks.OAK_FENCE) {
                    return Blocks.SPRUCE_FENCE.getDefaultState();
                }
            } else if (this.structureType == 2) {
                if (p_getBiomeSpecificBlockState_1_.getBlock() == Blocks.LOG || p_getBiomeSpecificBlockState_1_.getBlock() == Blocks.LOG2) {
                    return Blocks.LOG2.getDefaultState().withProperty(BlockNewLog.VARIANT, BlockPlanks.EnumType.ACACIA).withProperty(BlockLog.LOG_AXIS, p_getBiomeSpecificBlockState_1_.getValue(BlockLog.LOG_AXIS));
                }
                if (p_getBiomeSpecificBlockState_1_.getBlock() == Blocks.PLANKS) {
                    return Blocks.PLANKS.getDefaultState().withProperty(BlockPlanks.VARIANT, BlockPlanks.EnumType.ACACIA);
                }
                if (p_getBiomeSpecificBlockState_1_.getBlock() == Blocks.OAK_STAIRS) {
                    return Blocks.ACACIA_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, p_getBiomeSpecificBlockState_1_.getValue(BlockStairs.FACING));
                }
                if (p_getBiomeSpecificBlockState_1_.getBlock() == Blocks.COBBLESTONE) {
                    return Blocks.LOG2.getDefaultState().withProperty(BlockNewLog.VARIANT, BlockPlanks.EnumType.ACACIA).withProperty(BlockLog.LOG_AXIS, BlockLog.EnumAxis.Y);
                }
                if (p_getBiomeSpecificBlockState_1_.getBlock() == Blocks.OAK_FENCE) {
                    return Blocks.ACACIA_FENCE.getDefaultState();
                }
            }
            return p_getBiomeSpecificBlockState_1_;
        }

        protected BlockDoor biomeDoor() {
            switch (this.structureType) {
                case 2: {
                    return Blocks.ACACIA_DOOR;
                }
                case 3: {
                    return Blocks.SPRUCE_DOOR;
                }
            }
            return Blocks.OAK_DOOR;
        }

        protected void createVillageDoor(World p_createVillageDoor_1_, StructureBoundingBox p_createVillageDoor_2_, Random p_createVillageDoor_3_, int p_createVillageDoor_4_, int p_createVillageDoor_5_, int p_createVillageDoor_6_, EnumFacing p_createVillageDoor_7_) {
            if (!this.isZombieInfested) {
                this.generateDoor(p_createVillageDoor_1_, p_createVillageDoor_2_, p_createVillageDoor_3_, p_createVillageDoor_4_, p_createVillageDoor_5_, p_createVillageDoor_6_, EnumFacing.NORTH, this.biomeDoor());
            }
        }

        protected void placeTorch(World p_placeTorch_1_, EnumFacing p_placeTorch_2_, int p_placeTorch_3_, int p_placeTorch_4_, int p_placeTorch_5_, StructureBoundingBox p_placeTorch_6_) {
            if (!this.isZombieInfested) {
                this.setBlockState(p_placeTorch_1_, Blocks.TORCH.getDefaultState().withProperty(BlockTorch.FACING, p_placeTorch_2_), p_placeTorch_3_, p_placeTorch_4_, p_placeTorch_5_, p_placeTorch_6_);
            }
        }

        @Override
        protected void replaceAirAndLiquidDownwards(World p_replaceAirAndLiquidDownwards_1_, IBlockState p_replaceAirAndLiquidDownwards_2_, int p_replaceAirAndLiquidDownwards_3_, int p_replaceAirAndLiquidDownwards_4_, int p_replaceAirAndLiquidDownwards_5_, StructureBoundingBox p_replaceAirAndLiquidDownwards_6_) {
            IBlockState iblockstate = this.getBiomeSpecificBlockState(p_replaceAirAndLiquidDownwards_2_);
            super.replaceAirAndLiquidDownwards(p_replaceAirAndLiquidDownwards_1_, iblockstate, p_replaceAirAndLiquidDownwards_3_, p_replaceAirAndLiquidDownwards_4_, p_replaceAirAndLiquidDownwards_5_, p_replaceAirAndLiquidDownwards_6_);
        }

        protected void setStructureType(int p_setStructureType_1_) {
            this.structureType = p_setStructureType_1_;
        }
    }

    public static class Torch
    extends Village {
        public Torch() {
        }

        public Torch(Start p_i45568_1_, int p_i45568_2_, Random p_i45568_3_, StructureBoundingBox p_i45568_4_, EnumFacing p_i45568_5_) {
            super(p_i45568_1_, p_i45568_2_);
            this.setCoordBaseMode(p_i45568_5_);
            this.boundingBox = p_i45568_4_;
        }

        public static StructureBoundingBox findPieceBox(Start p_findPieceBox_0_, List<StructureComponent> p_findPieceBox_1_, Random p_findPieceBox_2_, int p_findPieceBox_3_, int p_findPieceBox_4_, int p_findPieceBox_5_, EnumFacing p_findPieceBox_6_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.getComponentToAddBoundingBox(p_findPieceBox_3_, p_findPieceBox_4_, p_findPieceBox_5_, 0, 0, 0, 3, 4, 2, p_findPieceBox_6_);
            return StructureComponent.findIntersecting(p_findPieceBox_1_, structureboundingbox) != null ? null : structureboundingbox;
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(p_addComponentParts_1_, p_addComponentParts_3_);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.boundingBox.offset(0, this.averageGroundLvl - this.boundingBox.maxY + 4 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.OAK_FENCE.getDefaultState());
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 2, 3, 1, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 1, 0, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 1, 1, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 1, 2, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.WOOL.getStateFromMeta(EnumDyeColor.WHITE.getDyeDamage()), 1, 3, 0, p_addComponentParts_3_);
            this.placeTorch(p_addComponentParts_1_, EnumFacing.EAST, 2, 3, 0, p_addComponentParts_3_);
            this.placeTorch(p_addComponentParts_1_, EnumFacing.NORTH, 1, 3, 1, p_addComponentParts_3_);
            this.placeTorch(p_addComponentParts_1_, EnumFacing.WEST, 0, 3, 0, p_addComponentParts_3_);
            this.placeTorch(p_addComponentParts_1_, EnumFacing.SOUTH, 1, 3, -1, p_addComponentParts_3_);
            return true;
        }
    }

    public static class Start
    extends Well {
        public BiomeProvider worldChunkMngr;
        public int terrainType;
        public PieceWeight structVillagePieceWeight;
        public List<PieceWeight> structureVillageWeightedPieceList;
        public List<StructureComponent> pendingHouses = Lists.newArrayList();
        public List<StructureComponent> pendingRoads = Lists.newArrayList();
        public Biome biome;

        public Start() {
        }

        public Start(BiomeProvider p_i2104_1_, int p_i2104_2_, Random p_i2104_3_, int p_i2104_4_, int p_i2104_5_, List<PieceWeight> p_i2104_6_, int p_i2104_7_) {
            super(null, 0, p_i2104_3_, p_i2104_4_, p_i2104_5_);
            Biome biome;
            this.worldChunkMngr = p_i2104_1_;
            this.structureVillageWeightedPieceList = p_i2104_6_;
            this.terrainType = p_i2104_7_;
            this.biome = biome = p_i2104_1_.getBiome(new BlockPos(p_i2104_4_, 0, p_i2104_5_), Biomes.DEFAULT);
            this.startPiece = this;
            if (biome instanceof BiomeDesert) {
                this.structureType = 1;
            } else if (biome instanceof BiomeSavanna) {
                this.structureType = 2;
            } else if (biome instanceof BiomeTaiga) {
                this.structureType = 3;
            }
            this.setStructureType(this.structureType);
            this.isZombieInfested = p_i2104_3_.nextInt(50) == 0;
        }
    }

    public static abstract class Road
    extends Village {
        public Road() {
        }

        protected Road(Start p_i2108_1_, int p_i2108_2_) {
            super(p_i2108_1_, p_i2108_2_);
        }
    }

    public static class PieceWeight {
        public Class<? extends Village> villagePieceClass;
        public final int villagePieceWeight;
        public int villagePiecesSpawned;
        public int villagePiecesLimit;

        public PieceWeight(Class<? extends Village> p_i2098_1_, int p_i2098_2_, int p_i2098_3_) {
            this.villagePieceClass = p_i2098_1_;
            this.villagePieceWeight = p_i2098_2_;
            this.villagePiecesLimit = p_i2098_3_;
        }

        public boolean canSpawnMoreVillagePiecesOfType(int p_canSpawnMoreVillagePiecesOfType_1_) {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }

        public boolean canSpawnMoreVillagePieces() {
            return this.villagePiecesLimit == 0 || this.villagePiecesSpawned < this.villagePiecesLimit;
        }
    }

    public static class Path
    extends Road {
        private int length;

        public Path() {
        }

        public Path(Start p_i45562_1_, int p_i45562_2_, Random p_i45562_3_, StructureBoundingBox p_i45562_4_, EnumFacing p_i45562_5_) {
            super(p_i45562_1_, p_i45562_2_);
            this.setCoordBaseMode(p_i45562_5_);
            this.boundingBox = p_i45562_4_;
            this.length = Math.max(p_i45562_4_.getXSize(), p_i45562_4_.getZSize());
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setInteger("Length", this.length);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.length = p_readStructureFromNBT_1_.getInteger("Length");
        }

        @Override
        public void buildComponent(StructureComponent p_buildComponent_1_, List<StructureComponent> p_buildComponent_2_, Random p_buildComponent_3_) {
            boolean flag = false;
            for (int i = p_buildComponent_3_.nextInt(5); i < this.length - 8; i += 2 + p_buildComponent_3_.nextInt(5)) {
                StructureComponent structurecomponent = this.getNextComponentNN((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 0, i);
                if (structurecomponent == null) continue;
                i += Math.max(structurecomponent.boundingBox.getXSize(), structurecomponent.boundingBox.getZSize());
                flag = true;
            }
            for (int j = p_buildComponent_3_.nextInt(5); j < this.length - 8; j += 2 + p_buildComponent_3_.nextInt(5)) {
                StructureComponent structurecomponent1 = this.getNextComponentPP((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, 0, j);
                if (structurecomponent1 == null) continue;
                j += Math.max(structurecomponent1.boundingBox.getXSize(), structurecomponent1.boundingBox.getZSize());
                flag = true;
            }
            EnumFacing enumfacing = this.getCoordBaseMode();
            if (flag && p_buildComponent_3_.nextInt(3) > 0 && enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        StructureVillagePieces.generateAndAddRoadPiece((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX - 1, this.boundingBox.minY, this.boundingBox.minZ, EnumFacing.WEST, this.getComponentType());
                        break;
                    }
                    case SOUTH: {
                        StructureVillagePieces.generateAndAddRoadPiece((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX - 1, this.boundingBox.minY, this.boundingBox.maxZ - 2, EnumFacing.WEST, this.getComponentType());
                        break;
                    }
                    case WEST: {
                        StructureVillagePieces.generateAndAddRoadPiece((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX, this.boundingBox.minY, this.boundingBox.minZ - 1, EnumFacing.NORTH, this.getComponentType());
                        break;
                    }
                    case EAST: {
                        StructureVillagePieces.generateAndAddRoadPiece((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.maxX - 2, this.boundingBox.minY, this.boundingBox.minZ - 1, EnumFacing.NORTH, this.getComponentType());
                    }
                }
            }
            if (flag && p_buildComponent_3_.nextInt(3) > 0 && enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        StructureVillagePieces.generateAndAddRoadPiece((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.maxX + 1, this.boundingBox.minY, this.boundingBox.minZ, EnumFacing.EAST, this.getComponentType());
                        break;
                    }
                    case SOUTH: {
                        StructureVillagePieces.generateAndAddRoadPiece((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.maxX + 1, this.boundingBox.minY, this.boundingBox.maxZ - 2, EnumFacing.EAST, this.getComponentType());
                        break;
                    }
                    case WEST: {
                        StructureVillagePieces.generateAndAddRoadPiece((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.minX, this.boundingBox.minY, this.boundingBox.maxZ + 1, EnumFacing.SOUTH, this.getComponentType());
                        break;
                    }
                    case EAST: {
                        StructureVillagePieces.generateAndAddRoadPiece((Start)p_buildComponent_1_, p_buildComponent_2_, p_buildComponent_3_, this.boundingBox.maxX - 2, this.boundingBox.minY, this.boundingBox.maxZ + 1, EnumFacing.SOUTH, this.getComponentType());
                    }
                }
            }
        }

        public static StructureBoundingBox findPieceBox(Start p_findPieceBox_0_, List<StructureComponent> p_findPieceBox_1_, Random p_findPieceBox_2_, int p_findPieceBox_3_, int p_findPieceBox_4_, int p_findPieceBox_5_, EnumFacing p_findPieceBox_6_) {
            for (int i = 7 * MathHelper.getInt(p_findPieceBox_2_, 3, 5); i >= 7; i -= 7) {
                StructureBoundingBox structureboundingbox = StructureBoundingBox.getComponentToAddBoundingBox(p_findPieceBox_3_, p_findPieceBox_4_, p_findPieceBox_5_, 0, 0, 0, 3, 3, i, p_findPieceBox_6_);
                if (StructureComponent.findIntersecting(p_findPieceBox_1_, structureboundingbox) != null) continue;
                return structureboundingbox;
            }
            return null;
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.GRASS_PATH.getDefaultState());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.PLANKS.getDefaultState());
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.GRAVEL.getDefaultState());
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.COBBLESTONE.getDefaultState());
            for (int i = this.boundingBox.minX; i <= this.boundingBox.maxX; ++i) {
                block1: for (int j = this.boundingBox.minZ; j <= this.boundingBox.maxZ; ++j) {
                    BlockPos blockpos = new BlockPos(i, 64, j);
                    if (!p_addComponentParts_3_.isVecInside(blockpos)) continue;
                    if ((blockpos = p_addComponentParts_1_.getTopSolidOrLiquidBlock(blockpos).down()).getY() < p_addComponentParts_1_.getSeaLevel()) {
                        blockpos = new BlockPos(blockpos.getX(), p_addComponentParts_1_.getSeaLevel() - 1, blockpos.getZ());
                    }
                    while (blockpos.getY() >= p_addComponentParts_1_.getSeaLevel() - 1) {
                        IBlockState iblockstate4 = p_addComponentParts_1_.getBlockState(blockpos);
                        if (iblockstate4.getBlock() == Blocks.GRASS && p_addComponentParts_1_.isAirBlock(blockpos.up())) {
                            p_addComponentParts_1_.setBlockState(blockpos, iblockstate, 2);
                            continue block1;
                        }
                        if (iblockstate4.getMaterial().isLiquid()) {
                            p_addComponentParts_1_.setBlockState(blockpos, iblockstate1, 2);
                            continue block1;
                        }
                        if (iblockstate4.getBlock() == Blocks.SAND || iblockstate4.getBlock() == Blocks.SANDSTONE || iblockstate4.getBlock() == Blocks.RED_SANDSTONE) {
                            p_addComponentParts_1_.setBlockState(blockpos, iblockstate2, 2);
                            p_addComponentParts_1_.setBlockState(blockpos.down(), iblockstate3, 2);
                            continue block1;
                        }
                        blockpos = blockpos.down();
                    }
                }
            }
            return true;
        }
    }

    public static class House4Garden
    extends Village {
        private boolean isRoofAccessible;

        public House4Garden() {
        }

        public House4Garden(Start p_i45566_1_, int p_i45566_2_, Random p_i45566_3_, StructureBoundingBox p_i45566_4_, EnumFacing p_i45566_5_) {
            super(p_i45566_1_, p_i45566_2_);
            this.setCoordBaseMode(p_i45566_5_);
            this.boundingBox = p_i45566_4_;
            this.isRoofAccessible = p_i45566_3_.nextBoolean();
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setBoolean("Terrace", this.isRoofAccessible);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.isRoofAccessible = p_readStructureFromNBT_1_.getBoolean("Terrace");
        }

        public static House4Garden createPiece(Start p_createPiece_0_, List<StructureComponent> p_createPiece_1_, Random p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, int p_createPiece_5_, EnumFacing p_createPiece_6_, int p_createPiece_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_3_, p_createPiece_4_, p_createPiece_5_, 0, 0, 0, 5, 6, 5, p_createPiece_6_);
            return StructureComponent.findIntersecting(p_createPiece_1_, structureboundingbox) != null ? null : new House4Garden(p_createPiece_0_, p_createPiece_7_, p_createPiece_2_, structureboundingbox, p_createPiece_6_);
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(p_addComponentParts_1_, p_addComponentParts_3_);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.boundingBox.offset(0, this.averageGroundLvl - this.boundingBox.maxY + 6 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.COBBLESTONE.getDefaultState());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.PLANKS.getDefaultState());
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.STONE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.NORTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.LOG.getDefaultState());
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(Blocks.OAK_FENCE.getDefaultState());
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 4, 0, 4, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 4, 0, 4, 4, 4, iblockstate3, iblockstate3, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 4, 1, 3, 4, 3, iblockstate1, iblockstate1, false);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 0, 1, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 0, 2, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 0, 3, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 4, 1, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 4, 2, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 4, 3, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 0, 1, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 0, 2, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 0, 3, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 4, 1, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 4, 2, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 4, 3, 4, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 1, 0, 3, 3, iblockstate1, iblockstate1, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 1, 4, 3, 3, iblockstate1, iblockstate1, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 4, 3, 3, 4, iblockstate1, iblockstate1, false);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 0, 2, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 2, 2, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 4, 2, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 1, 1, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 1, 2, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 1, 3, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 2, 3, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 3, 3, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 3, 2, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 3, 1, 0, p_addComponentParts_3_);
            if (this.getBlockStateFromPos(p_addComponentParts_1_, 2, 0, -1, p_addComponentParts_3_).getMaterial() == Material.AIR && this.getBlockStateFromPos(p_addComponentParts_1_, 2, -1, -1, p_addComponentParts_3_).getMaterial() != Material.AIR) {
                this.setBlockState(p_addComponentParts_1_, iblockstate2, 2, 0, -1, p_addComponentParts_3_);
                if (this.getBlockStateFromPos(p_addComponentParts_1_, 2, -1, -1, p_addComponentParts_3_).getBlock() == Blocks.GRASS_PATH) {
                    this.setBlockState(p_addComponentParts_1_, Blocks.GRASS.getDefaultState(), 2, -1, -1, p_addComponentParts_3_);
                }
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 1, 3, 3, 3, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            if (this.isRoofAccessible) {
                this.setBlockState(p_addComponentParts_1_, iblockstate4, 0, 5, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, iblockstate4, 1, 5, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, iblockstate4, 2, 5, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, iblockstate4, 3, 5, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, iblockstate4, 4, 5, 0, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, iblockstate4, 0, 5, 4, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, iblockstate4, 1, 5, 4, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, iblockstate4, 2, 5, 4, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, iblockstate4, 3, 5, 4, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, iblockstate4, 4, 5, 4, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, iblockstate4, 4, 5, 1, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, iblockstate4, 4, 5, 2, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, iblockstate4, 4, 5, 3, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, iblockstate4, 0, 5, 1, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, iblockstate4, 0, 5, 2, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, iblockstate4, 0, 5, 3, p_addComponentParts_3_);
            }
            if (this.isRoofAccessible) {
                IBlockState iblockstate5 = Blocks.LADDER.getDefaultState().withProperty(BlockLadder.FACING, EnumFacing.SOUTH);
                this.setBlockState(p_addComponentParts_1_, iblockstate5, 3, 1, 3, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, iblockstate5, 3, 2, 3, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, iblockstate5, 3, 3, 3, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, iblockstate5, 3, 4, 3, p_addComponentParts_3_);
            }
            this.placeTorch(p_addComponentParts_1_, EnumFacing.NORTH, 2, 3, 1, p_addComponentParts_3_);
            for (int j = 0; j < 5; ++j) {
                for (int i = 0; i < 5; ++i) {
                    this.clearCurrentPositionBlocksUpwards(p_addComponentParts_1_, i, 6, j, p_addComponentParts_3_);
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, iblockstate, i, -1, j, p_addComponentParts_3_);
                }
            }
            this.spawnVillagers(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 2, 1);
            return true;
        }
    }

    public static class House3
    extends Village {
        public House3() {
        }

        public House3(Start p_i45561_1_, int p_i45561_2_, Random p_i45561_3_, StructureBoundingBox p_i45561_4_, EnumFacing p_i45561_5_) {
            super(p_i45561_1_, p_i45561_2_);
            this.setCoordBaseMode(p_i45561_5_);
            this.boundingBox = p_i45561_4_;
        }

        public static House3 createPiece(Start p_createPiece_0_, List<StructureComponent> p_createPiece_1_, Random p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, int p_createPiece_5_, EnumFacing p_createPiece_6_, int p_createPiece_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_3_, p_createPiece_4_, p_createPiece_5_, 0, 0, 0, 9, 7, 12, p_createPiece_6_);
            return House3.canVillageGoDeeper(structureboundingbox) && StructureComponent.findIntersecting(p_createPiece_1_, structureboundingbox) == null ? new House3(p_createPiece_0_, p_createPiece_7_, p_createPiece_2_, structureboundingbox, p_createPiece_6_) : null;
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(p_addComponentParts_1_, p_addComponentParts_3_);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.boundingBox.offset(0, this.averageGroundLvl - this.boundingBox.maxY + 7 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.COBBLESTONE.getDefaultState());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.OAK_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.OAK_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.SOUTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.OAK_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.EAST));
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(Blocks.OAK_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.WEST));
            IBlockState iblockstate5 = this.getBiomeSpecificBlockState(Blocks.PLANKS.getDefaultState());
            IBlockState iblockstate6 = this.getBiomeSpecificBlockState(Blocks.LOG.getDefaultState());
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 1, 7, 4, 4, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 1, 6, 8, 4, 10, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 0, 5, 8, 0, 10, iblockstate5, iblockstate5, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, 1, 7, 0, 4, iblockstate5, iblockstate5, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 0, 3, 5, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 0, 0, 8, 3, 10, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, 0, 7, 2, 0, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, 5, 2, 1, 5, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 0, 6, 2, 3, 10, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 0, 10, 7, 3, 10, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 0, 7, 3, 0, iblockstate5, iblockstate5, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 5, 2, 3, 5, iblockstate5, iblockstate5, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 4, 1, 8, 4, 1, iblockstate5, iblockstate5, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 4, 4, 3, 4, 4, iblockstate5, iblockstate5, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5, 2, 8, 5, 3, iblockstate5, iblockstate5, false);
            this.setBlockState(p_addComponentParts_1_, iblockstate5, 0, 4, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate5, 0, 4, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate5, 8, 4, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate5, 8, 4, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate5, 8, 4, 4, p_addComponentParts_3_);
            IBlockState iblockstate7 = iblockstate1;
            IBlockState iblockstate8 = iblockstate2;
            IBlockState iblockstate9 = iblockstate4;
            IBlockState iblockstate10 = iblockstate3;
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.setBlockState(p_addComponentParts_1_, iblockstate7, j, 4 + i, i, p_addComponentParts_3_);
                    if (i <= -1 && j > 1 || i <= 0 && j > 3 || i <= 1 && j > 4 && j < 6) continue;
                    this.setBlockState(p_addComponentParts_1_, iblockstate8, j, 4 + i, 5 - i, p_addComponentParts_3_);
                }
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 4, 5, 3, 4, 10, iblockstate5, iblockstate5, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 4, 2, 7, 4, 10, iblockstate5, iblockstate5, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 5, 4, 4, 5, 10, iblockstate5, iblockstate5, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 5, 4, 6, 5, 10, iblockstate5, iblockstate5, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 6, 3, 5, 6, 10, iblockstate5, iblockstate5, false);
            for (int k = 4; k >= 1; --k) {
                this.setBlockState(p_addComponentParts_1_, iblockstate5, k, 2 + k, 7 - k, p_addComponentParts_3_);
                for (int k1 = 8 - k; k1 <= 10; ++k1) {
                    this.setBlockState(p_addComponentParts_1_, iblockstate10, k, 2 + k, k1, p_addComponentParts_3_);
                }
            }
            this.setBlockState(p_addComponentParts_1_, iblockstate5, 6, 6, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate5, 7, 5, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate4, 6, 6, 4, p_addComponentParts_3_);
            for (int l = 6; l <= 8; ++l) {
                for (int l1 = 5; l1 <= 10; ++l1) {
                    this.setBlockState(p_addComponentParts_1_, iblockstate9, l, 12 - l, l1, p_addComponentParts_3_);
                }
            }
            this.setBlockState(p_addComponentParts_1_, iblockstate6, 0, 2, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate6, 0, 2, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 0, 2, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 0, 2, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate6, 4, 2, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 5, 2, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate6, 6, 2, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate6, 8, 2, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 8, 2, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 8, 2, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate6, 8, 2, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate5, 8, 2, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate6, 8, 2, 6, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 8, 2, 7, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 8, 2, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate6, 8, 2, 9, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate6, 2, 2, 6, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 2, 2, 7, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 2, 2, 8, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate6, 2, 2, 9, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate6, 4, 4, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 5, 4, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate6, 6, 4, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate5, 5, 5, 10, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 2, 1, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 2, 2, 0, p_addComponentParts_3_);
            this.placeTorch(p_addComponentParts_1_, EnumFacing.NORTH, 2, 3, 1, p_addComponentParts_3_);
            this.createVillageDoor(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 2, 1, 0, EnumFacing.NORTH);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, -1, 3, 2, -1, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            if (this.getBlockStateFromPos(p_addComponentParts_1_, 2, 0, -1, p_addComponentParts_3_).getMaterial() == Material.AIR && this.getBlockStateFromPos(p_addComponentParts_1_, 2, -1, -1, p_addComponentParts_3_).getMaterial() != Material.AIR) {
                this.setBlockState(p_addComponentParts_1_, iblockstate7, 2, 0, -1, p_addComponentParts_3_);
                if (this.getBlockStateFromPos(p_addComponentParts_1_, 2, -1, -1, p_addComponentParts_3_).getBlock() == Blocks.GRASS_PATH) {
                    this.setBlockState(p_addComponentParts_1_, Blocks.GRASS.getDefaultState(), 2, -1, -1, p_addComponentParts_3_);
                }
            }
            for (int i1 = 0; i1 < 5; ++i1) {
                for (int i2 = 0; i2 < 9; ++i2) {
                    this.clearCurrentPositionBlocksUpwards(p_addComponentParts_1_, i2, 7, i1, p_addComponentParts_3_);
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, iblockstate, i2, -1, i1, p_addComponentParts_3_);
                }
            }
            for (int j1 = 5; j1 < 11; ++j1) {
                for (int j2 = 2; j2 < 9; ++j2) {
                    this.clearCurrentPositionBlocksUpwards(p_addComponentParts_1_, j2, 7, j1, p_addComponentParts_3_);
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, iblockstate, j2, -1, j1, p_addComponentParts_3_);
                }
            }
            this.spawnVillagers(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 2, 2);
            return true;
        }
    }

    public static class House2
    extends Village {
        private boolean hasMadeChest;

        public House2() {
        }

        public House2(Start p_i45563_1_, int p_i45563_2_, Random p_i45563_3_, StructureBoundingBox p_i45563_4_, EnumFacing p_i45563_5_) {
            super(p_i45563_1_, p_i45563_2_);
            this.setCoordBaseMode(p_i45563_5_);
            this.boundingBox = p_i45563_4_;
        }

        public static House2 createPiece(Start p_createPiece_0_, List<StructureComponent> p_createPiece_1_, Random p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, int p_createPiece_5_, EnumFacing p_createPiece_6_, int p_createPiece_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_3_, p_createPiece_4_, p_createPiece_5_, 0, 0, 0, 10, 6, 7, p_createPiece_6_);
            return House2.canVillageGoDeeper(structureboundingbox) && StructureComponent.findIntersecting(p_createPiece_1_, structureboundingbox) == null ? new House2(p_createPiece_0_, p_createPiece_7_, p_createPiece_2_, structureboundingbox, p_createPiece_6_) : null;
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setBoolean("Chest", this.hasMadeChest);
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.hasMadeChest = p_readStructureFromNBT_1_.getBoolean("Chest");
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(p_addComponentParts_1_, p_addComponentParts_3_);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.boundingBox.offset(0, this.averageGroundLvl - this.boundingBox.maxY + 6 - 1, 0);
            }
            IBlockState iblockstate = Blocks.COBBLESTONE.getDefaultState();
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.OAK_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.OAK_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.WEST));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.PLANKS.getDefaultState());
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(Blocks.STONE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.NORTH));
            IBlockState iblockstate5 = this.getBiomeSpecificBlockState(Blocks.LOG.getDefaultState());
            IBlockState iblockstate6 = this.getBiomeSpecificBlockState(Blocks.OAK_FENCE.getDefaultState());
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 0, 9, 4, 6, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 9, 0, 6, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 4, 0, 9, 4, 6, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5, 0, 9, 5, 6, Blocks.STONE_SLAB.getDefaultState(), Blocks.STONE_SLAB.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 5, 1, 8, 5, 5, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 0, 2, 3, 0, iblockstate3, iblockstate3, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 0, 0, 4, 0, iblockstate5, iblockstate5, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 0, 3, 4, 0, iblockstate5, iblockstate5, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 6, 0, 4, 6, iblockstate5, iblockstate5, false);
            this.setBlockState(p_addComponentParts_1_, iblockstate3, 3, 3, 1, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 2, 3, 3, 2, iblockstate3, iblockstate3, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 3, 5, 3, 3, iblockstate3, iblockstate3, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 1, 0, 3, 5, iblockstate3, iblockstate3, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 6, 5, 3, 6, iblockstate3, iblockstate3, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 1, 0, 5, 3, 0, iblockstate6, iblockstate6, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 1, 0, 9, 3, 0, iblockstate6, iblockstate6, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 1, 4, 9, 4, 6, iblockstate, iblockstate, false);
            this.setBlockState(p_addComponentParts_1_, Blocks.FLOWING_LAVA.getDefaultState(), 7, 1, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.FLOWING_LAVA.getDefaultState(), 8, 1, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.IRON_BARS.getDefaultState(), 9, 2, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.IRON_BARS.getDefaultState(), 9, 2, 4, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 2, 4, 8, 2, 5, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 6, 1, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.FURNACE.getDefaultState(), 6, 2, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.FURNACE.getDefaultState(), 6, 3, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.DOUBLE_STONE_SLAB.getDefaultState(), 8, 1, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 0, 2, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 0, 2, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 2, 2, 6, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 4, 2, 6, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate6, 2, 1, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.WOODEN_PRESSURE_PLATE.getDefaultState(), 2, 2, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate3, 1, 1, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 2, 1, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate2, 1, 1, 4, p_addComponentParts_3_);
            if (!this.hasMadeChest && p_addComponentParts_3_.isVecInside(new BlockPos(this.getXWithOffset(5, 5), this.getYWithOffset(1), this.getZWithOffset(5, 5)))) {
                this.hasMadeChest = true;
                this.generateChest(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 5, 1, 5, LootTableList.CHESTS_VILLAGE_BLACKSMITH);
            }
            for (int i = 6; i <= 8; ++i) {
                if (this.getBlockStateFromPos(p_addComponentParts_1_, i, 0, -1, p_addComponentParts_3_).getMaterial() != Material.AIR || this.getBlockStateFromPos(p_addComponentParts_1_, i, -1, -1, p_addComponentParts_3_).getMaterial() == Material.AIR) continue;
                this.setBlockState(p_addComponentParts_1_, iblockstate4, i, 0, -1, p_addComponentParts_3_);
                if (this.getBlockStateFromPos(p_addComponentParts_1_, i, -1, -1, p_addComponentParts_3_).getBlock() != Blocks.GRASS_PATH) continue;
                this.setBlockState(p_addComponentParts_1_, Blocks.GRASS.getDefaultState(), i, -1, -1, p_addComponentParts_3_);
            }
            for (int k = 0; k < 7; ++k) {
                for (int j = 0; j < 10; ++j) {
                    this.clearCurrentPositionBlocksUpwards(p_addComponentParts_1_, j, 6, k, p_addComponentParts_3_);
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, iblockstate, j, -1, k, p_addComponentParts_3_);
                }
            }
            this.spawnVillagers(p_addComponentParts_1_, p_addComponentParts_3_, 7, 1, 1, 1);
            return true;
        }

        @Override
        protected int chooseProfession(int p_chooseProfession_1_, int p_chooseProfession_2_) {
            return 3;
        }
    }

    public static class House1
    extends Village {
        public House1() {
        }

        public House1(Start p_i45571_1_, int p_i45571_2_, Random p_i45571_3_, StructureBoundingBox p_i45571_4_, EnumFacing p_i45571_5_) {
            super(p_i45571_1_, p_i45571_2_);
            this.setCoordBaseMode(p_i45571_5_);
            this.boundingBox = p_i45571_4_;
        }

        public static House1 createPiece(Start p_createPiece_0_, List<StructureComponent> p_createPiece_1_, Random p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, int p_createPiece_5_, EnumFacing p_createPiece_6_, int p_createPiece_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_3_, p_createPiece_4_, p_createPiece_5_, 0, 0, 0, 9, 9, 6, p_createPiece_6_);
            return House1.canVillageGoDeeper(structureboundingbox) && StructureComponent.findIntersecting(p_createPiece_1_, structureboundingbox) == null ? new House1(p_createPiece_0_, p_createPiece_7_, p_createPiece_2_, structureboundingbox, p_createPiece_6_) : null;
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(p_addComponentParts_1_, p_addComponentParts_3_);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.boundingBox.offset(0, this.averageGroundLvl - this.boundingBox.maxY + 9 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.COBBLESTONE.getDefaultState());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.OAK_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.OAK_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.SOUTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.OAK_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.EAST));
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(Blocks.PLANKS.getDefaultState());
            IBlockState iblockstate5 = this.getBiomeSpecificBlockState(Blocks.STONE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.NORTH));
            IBlockState iblockstate6 = this.getBiomeSpecificBlockState(Blocks.OAK_FENCE.getDefaultState());
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 1, 7, 5, 4, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 8, 0, 5, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5, 0, 8, 5, 5, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 6, 1, 8, 6, 4, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 7, 2, 8, 7, 3, iblockstate, iblockstate, false);
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.setBlockState(p_addComponentParts_1_, iblockstate1, j, 6 + i, i, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, iblockstate2, j, 6 + i, 5 - i, p_addComponentParts_3_);
                }
            }
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 0, 0, 1, 5, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 5, 8, 1, 5, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 1, 0, 8, 1, 4, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 1, 0, 7, 1, 0, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 0, 0, 4, 0, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 5, 0, 4, 5, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 2, 5, 8, 4, 5, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 2, 0, 8, 4, 0, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 2, 1, 0, 4, 4, iblockstate4, iblockstate4, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 5, 7, 4, 5, iblockstate4, iblockstate4, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 2, 1, 8, 4, 4, iblockstate4, iblockstate4, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 0, 7, 4, 0, iblockstate4, iblockstate4, false);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 4, 2, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 5, 2, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 6, 2, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 4, 3, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 5, 3, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 6, 3, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 0, 2, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 0, 2, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 0, 3, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 0, 3, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 8, 2, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 8, 2, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 8, 3, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 8, 3, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 2, 2, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 3, 2, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 5, 2, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 6, 2, 5, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 4, 1, 7, 4, 1, iblockstate4, iblockstate4, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 4, 4, 7, 4, 4, iblockstate4, iblockstate4, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 3, 4, 7, 3, 4, Blocks.BOOKSHELF.getDefaultState(), Blocks.BOOKSHELF.getDefaultState(), false);
            this.setBlockState(p_addComponentParts_1_, iblockstate4, 7, 1, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate3, 7, 1, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 6, 1, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 5, 1, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 4, 1, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 3, 1, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate6, 6, 1, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.WOODEN_PRESSURE_PLATE.getDefaultState(), 6, 2, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate6, 4, 1, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.WOODEN_PRESSURE_PLATE.getDefaultState(), 4, 2, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.CRAFTING_TABLE.getDefaultState(), 7, 1, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 1, 1, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 1, 2, 0, p_addComponentParts_3_);
            this.createVillageDoor(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 1, 1, 0, EnumFacing.NORTH);
            if (this.getBlockStateFromPos(p_addComponentParts_1_, 1, 0, -1, p_addComponentParts_3_).getMaterial() == Material.AIR && this.getBlockStateFromPos(p_addComponentParts_1_, 1, -1, -1, p_addComponentParts_3_).getMaterial() != Material.AIR) {
                this.setBlockState(p_addComponentParts_1_, iblockstate5, 1, 0, -1, p_addComponentParts_3_);
                if (this.getBlockStateFromPos(p_addComponentParts_1_, 1, -1, -1, p_addComponentParts_3_).getBlock() == Blocks.GRASS_PATH) {
                    this.setBlockState(p_addComponentParts_1_, Blocks.GRASS.getDefaultState(), 1, -1, -1, p_addComponentParts_3_);
                }
            }
            for (int l = 0; l < 6; ++l) {
                for (int k = 0; k < 9; ++k) {
                    this.clearCurrentPositionBlocksUpwards(p_addComponentParts_1_, k, 9, l, p_addComponentParts_3_);
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, iblockstate, k, -1, l, p_addComponentParts_3_);
                }
            }
            this.spawnVillagers(p_addComponentParts_1_, p_addComponentParts_3_, 2, 1, 2, 1);
            return true;
        }

        @Override
        protected int chooseProfession(int p_chooseProfession_1_, int p_chooseProfession_2_) {
            return 1;
        }
    }

    public static class Hall
    extends Village {
        public Hall() {
        }

        public Hall(Start p_i45567_1_, int p_i45567_2_, Random p_i45567_3_, StructureBoundingBox p_i45567_4_, EnumFacing p_i45567_5_) {
            super(p_i45567_1_, p_i45567_2_);
            this.setCoordBaseMode(p_i45567_5_);
            this.boundingBox = p_i45567_4_;
        }

        public static Hall createPiece(Start p_createPiece_0_, List<StructureComponent> p_createPiece_1_, Random p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, int p_createPiece_5_, EnumFacing p_createPiece_6_, int p_createPiece_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_3_, p_createPiece_4_, p_createPiece_5_, 0, 0, 0, 9, 7, 11, p_createPiece_6_);
            return Hall.canVillageGoDeeper(structureboundingbox) && StructureComponent.findIntersecting(p_createPiece_1_, structureboundingbox) == null ? new Hall(p_createPiece_0_, p_createPiece_7_, p_createPiece_2_, structureboundingbox, p_createPiece_6_) : null;
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(p_addComponentParts_1_, p_addComponentParts_3_);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.boundingBox.offset(0, this.averageGroundLvl - this.boundingBox.maxY + 7 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.COBBLESTONE.getDefaultState());
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.OAK_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.OAK_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.SOUTH));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.OAK_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.WEST));
            IBlockState iblockstate4 = this.getBiomeSpecificBlockState(Blocks.PLANKS.getDefaultState());
            IBlockState iblockstate5 = this.getBiomeSpecificBlockState(Blocks.LOG.getDefaultState());
            IBlockState iblockstate6 = this.getBiomeSpecificBlockState(Blocks.OAK_FENCE.getDefaultState());
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 1, 7, 4, 4, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 1, 6, 8, 4, 10, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 0, 6, 8, 0, 10, Blocks.DIRT.getDefaultState(), Blocks.DIRT.getDefaultState(), false);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 6, 0, 6, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 2, 1, 6, 2, 1, 10, iblockstate6, iblockstate6, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 1, 6, 8, 1, 10, iblockstate6, iblockstate6, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 1, 10, 7, 1, 10, iblockstate6, iblockstate6, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, 1, 7, 0, 4, iblockstate4, iblockstate4, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 0, 3, 5, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 8, 0, 0, 8, 3, 5, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, 0, 7, 1, 0, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, 5, 7, 1, 5, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 0, 7, 3, 0, iblockstate4, iblockstate4, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 2, 5, 7, 3, 5, iblockstate4, iblockstate4, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 4, 1, 8, 4, 1, iblockstate4, iblockstate4, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 4, 4, 8, 4, 4, iblockstate4, iblockstate4, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 5, 2, 8, 5, 3, iblockstate4, iblockstate4, false);
            this.setBlockState(p_addComponentParts_1_, iblockstate4, 0, 4, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate4, 0, 4, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate4, 8, 4, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate4, 8, 4, 3, p_addComponentParts_3_);
            IBlockState iblockstate7 = iblockstate1;
            IBlockState iblockstate8 = iblockstate2;
            for (int i = -1; i <= 2; ++i) {
                for (int j = 0; j <= 8; ++j) {
                    this.setBlockState(p_addComponentParts_1_, iblockstate7, j, 4 + i, i, p_addComponentParts_3_);
                    this.setBlockState(p_addComponentParts_1_, iblockstate8, j, 4 + i, 5 - i, p_addComponentParts_3_);
                }
            }
            this.setBlockState(p_addComponentParts_1_, iblockstate5, 0, 2, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate5, 0, 2, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate5, 8, 2, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate5, 8, 2, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 0, 2, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 0, 2, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 8, 2, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 8, 2, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 2, 2, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 3, 2, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 5, 2, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 6, 2, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate6, 2, 1, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.WOODEN_PRESSURE_PLATE.getDefaultState(), 2, 2, 3, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate4, 1, 1, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate7, 2, 1, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate3, 1, 1, 3, p_addComponentParts_3_);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 5, 0, 1, 7, 0, 3, Blocks.DOUBLE_STONE_SLAB.getDefaultState(), Blocks.DOUBLE_STONE_SLAB.getDefaultState(), false);
            this.setBlockState(p_addComponentParts_1_, Blocks.DOUBLE_STONE_SLAB.getDefaultState(), 6, 1, 1, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.DOUBLE_STONE_SLAB.getDefaultState(), 6, 1, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 2, 1, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 2, 2, 0, p_addComponentParts_3_);
            this.placeTorch(p_addComponentParts_1_, EnumFacing.NORTH, 2, 3, 1, p_addComponentParts_3_);
            this.createVillageDoor(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 2, 1, 0, EnumFacing.NORTH);
            if (this.getBlockStateFromPos(p_addComponentParts_1_, 2, 0, -1, p_addComponentParts_3_).getMaterial() == Material.AIR && this.getBlockStateFromPos(p_addComponentParts_1_, 2, -1, -1, p_addComponentParts_3_).getMaterial() != Material.AIR) {
                this.setBlockState(p_addComponentParts_1_, iblockstate7, 2, 0, -1, p_addComponentParts_3_);
                if (this.getBlockStateFromPos(p_addComponentParts_1_, 2, -1, -1, p_addComponentParts_3_).getBlock() == Blocks.GRASS_PATH) {
                    this.setBlockState(p_addComponentParts_1_, Blocks.GRASS.getDefaultState(), 2, -1, -1, p_addComponentParts_3_);
                }
            }
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 6, 1, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 6, 2, 5, p_addComponentParts_3_);
            this.placeTorch(p_addComponentParts_1_, EnumFacing.SOUTH, 6, 3, 4, p_addComponentParts_3_);
            this.createVillageDoor(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 6, 1, 5, EnumFacing.SOUTH);
            for (int k = 0; k < 5; ++k) {
                for (int l = 0; l < 9; ++l) {
                    this.clearCurrentPositionBlocksUpwards(p_addComponentParts_1_, l, 7, k, p_addComponentParts_3_);
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, iblockstate, l, -1, k, p_addComponentParts_3_);
                }
            }
            this.spawnVillagers(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 2, 2);
            return true;
        }

        @Override
        protected int chooseProfession(int p_chooseProfession_1_, int p_chooseProfession_2_) {
            return p_chooseProfession_1_ == 0 ? 4 : super.chooseProfession(p_chooseProfession_1_, p_chooseProfession_2_);
        }
    }

    public static class Field2
    extends Village {
        private Block cropTypeA;
        private Block cropTypeB;

        public Field2() {
        }

        public Field2(Start p_i45569_1_, int p_i45569_2_, Random p_i45569_3_, StructureBoundingBox p_i45569_4_, EnumFacing p_i45569_5_) {
            super(p_i45569_1_, p_i45569_2_);
            this.setCoordBaseMode(p_i45569_5_);
            this.boundingBox = p_i45569_4_;
            this.cropTypeA = this.getRandomCropType(p_i45569_3_);
            this.cropTypeB = this.getRandomCropType(p_i45569_3_);
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setInteger("CA", Block.REGISTRY.getIDForObject(this.cropTypeA));
            p_writeStructureToNBT_1_.setInteger("CB", Block.REGISTRY.getIDForObject(this.cropTypeB));
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.cropTypeA = Block.getBlockById(p_readStructureFromNBT_1_.getInteger("CA"));
            this.cropTypeB = Block.getBlockById(p_readStructureFromNBT_1_.getInteger("CB"));
        }

        private Block getRandomCropType(Random p_getRandomCropType_1_) {
            switch (p_getRandomCropType_1_.nextInt(10)) {
                case 0: 
                case 1: {
                    return Blocks.CARROTS;
                }
                case 2: 
                case 3: {
                    return Blocks.POTATOES;
                }
                case 4: {
                    return Blocks.BEETROOTS;
                }
            }
            return Blocks.WHEAT;
        }

        public static Field2 createPiece(Start p_createPiece_0_, List<StructureComponent> p_createPiece_1_, Random p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, int p_createPiece_5_, EnumFacing p_createPiece_6_, int p_createPiece_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_3_, p_createPiece_4_, p_createPiece_5_, 0, 0, 0, 7, 4, 9, p_createPiece_6_);
            return Field2.canVillageGoDeeper(structureboundingbox) && StructureComponent.findIntersecting(p_createPiece_1_, structureboundingbox) == null ? new Field2(p_createPiece_0_, p_createPiece_7_, p_createPiece_2_, structureboundingbox, p_createPiece_6_) : null;
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(p_addComponentParts_1_, p_addComponentParts_3_);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.boundingBox.offset(0, this.averageGroundLvl - this.boundingBox.maxY + 4 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.LOG.getDefaultState());
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 0, 6, 4, 8, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, 1, 2, 0, 7, Blocks.FARMLAND.getDefaultState(), Blocks.FARMLAND.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 0, 1, 5, 0, 7, Blocks.FARMLAND.getDefaultState(), Blocks.FARMLAND.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 0, 0, 8, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 0, 0, 6, 0, 8, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, 0, 5, 0, 0, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, 8, 5, 0, 8, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 0, 1, 3, 0, 7, Blocks.WATER.getDefaultState(), Blocks.WATER.getDefaultState(), false);
            for (int i = 1; i <= 7; ++i) {
                int j = ((BlockCrops)this.cropTypeA).getMaxAge();
                int k = j / 3;
                this.setBlockState(p_addComponentParts_1_, this.cropTypeA.getStateFromMeta(MathHelper.getInt(p_addComponentParts_2_, k, j)), 1, 1, i, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, this.cropTypeA.getStateFromMeta(MathHelper.getInt(p_addComponentParts_2_, k, j)), 2, 1, i, p_addComponentParts_3_);
                int l = ((BlockCrops)this.cropTypeB).getMaxAge();
                int i1 = l / 3;
                this.setBlockState(p_addComponentParts_1_, this.cropTypeB.getStateFromMeta(MathHelper.getInt(p_addComponentParts_2_, i1, l)), 4, 1, i, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, this.cropTypeB.getStateFromMeta(MathHelper.getInt(p_addComponentParts_2_, i1, l)), 5, 1, i, p_addComponentParts_3_);
            }
            for (int j1 = 0; j1 < 9; ++j1) {
                for (int k1 = 0; k1 < 7; ++k1) {
                    this.clearCurrentPositionBlocksUpwards(p_addComponentParts_1_, k1, 4, j1, p_addComponentParts_3_);
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.DIRT.getDefaultState(), k1, -1, j1, p_addComponentParts_3_);
                }
            }
            return true;
        }
    }

    public static class Field1
    extends Village {
        private Block cropTypeA;
        private Block cropTypeB;
        private Block cropTypeC;
        private Block cropTypeD;

        public Field1() {
        }

        public Field1(Start p_i45570_1_, int p_i45570_2_, Random p_i45570_3_, StructureBoundingBox p_i45570_4_, EnumFacing p_i45570_5_) {
            super(p_i45570_1_, p_i45570_2_);
            this.setCoordBaseMode(p_i45570_5_);
            this.boundingBox = p_i45570_4_;
            this.cropTypeA = this.getRandomCropType(p_i45570_3_);
            this.cropTypeB = this.getRandomCropType(p_i45570_3_);
            this.cropTypeC = this.getRandomCropType(p_i45570_3_);
            this.cropTypeD = this.getRandomCropType(p_i45570_3_);
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setInteger("CA", Block.REGISTRY.getIDForObject(this.cropTypeA));
            p_writeStructureToNBT_1_.setInteger("CB", Block.REGISTRY.getIDForObject(this.cropTypeB));
            p_writeStructureToNBT_1_.setInteger("CC", Block.REGISTRY.getIDForObject(this.cropTypeC));
            p_writeStructureToNBT_1_.setInteger("CD", Block.REGISTRY.getIDForObject(this.cropTypeD));
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.cropTypeA = Block.getBlockById(p_readStructureFromNBT_1_.getInteger("CA"));
            this.cropTypeB = Block.getBlockById(p_readStructureFromNBT_1_.getInteger("CB"));
            this.cropTypeC = Block.getBlockById(p_readStructureFromNBT_1_.getInteger("CC"));
            this.cropTypeD = Block.getBlockById(p_readStructureFromNBT_1_.getInteger("CD"));
            if (!(this.cropTypeA instanceof BlockCrops)) {
                this.cropTypeA = Blocks.WHEAT;
            }
            if (!(this.cropTypeB instanceof BlockCrops)) {
                this.cropTypeB = Blocks.CARROTS;
            }
            if (!(this.cropTypeC instanceof BlockCrops)) {
                this.cropTypeC = Blocks.POTATOES;
            }
            if (!(this.cropTypeD instanceof BlockCrops)) {
                this.cropTypeD = Blocks.BEETROOTS;
            }
        }

        private Block getRandomCropType(Random p_getRandomCropType_1_) {
            switch (p_getRandomCropType_1_.nextInt(10)) {
                case 0: 
                case 1: {
                    return Blocks.CARROTS;
                }
                case 2: 
                case 3: {
                    return Blocks.POTATOES;
                }
                case 4: {
                    return Blocks.BEETROOTS;
                }
            }
            return Blocks.WHEAT;
        }

        public static Field1 createPiece(Start p_createPiece_0_, List<StructureComponent> p_createPiece_1_, Random p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, int p_createPiece_5_, EnumFacing p_createPiece_6_, int p_createPiece_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_3_, p_createPiece_4_, p_createPiece_5_, 0, 0, 0, 13, 4, 9, p_createPiece_6_);
            return Field1.canVillageGoDeeper(structureboundingbox) && StructureComponent.findIntersecting(p_createPiece_1_, structureboundingbox) == null ? new Field1(p_createPiece_0_, p_createPiece_7_, p_createPiece_2_, structureboundingbox, p_createPiece_6_) : null;
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(p_addComponentParts_1_, p_addComponentParts_3_);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.boundingBox.offset(0, this.averageGroundLvl - this.boundingBox.maxY + 4 - 1, 0);
            }
            IBlockState iblockstate = this.getBiomeSpecificBlockState(Blocks.LOG.getDefaultState());
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 0, 12, 4, 8, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, 1, 2, 0, 7, Blocks.FARMLAND.getDefaultState(), Blocks.FARMLAND.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 0, 1, 5, 0, 7, Blocks.FARMLAND.getDefaultState(), Blocks.FARMLAND.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 7, 0, 1, 8, 0, 7, Blocks.FARMLAND.getDefaultState(), Blocks.FARMLAND.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 10, 0, 1, 11, 0, 7, Blocks.FARMLAND.getDefaultState(), Blocks.FARMLAND.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 0, 0, 0, 8, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 6, 0, 0, 6, 0, 8, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 12, 0, 0, 12, 0, 8, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, 0, 11, 0, 0, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, 8, 11, 0, 8, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 3, 0, 1, 3, 0, 7, Blocks.WATER.getDefaultState(), Blocks.WATER.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 9, 0, 1, 9, 0, 7, Blocks.WATER.getDefaultState(), Blocks.WATER.getDefaultState(), false);
            for (int i = 1; i <= 7; ++i) {
                int j = ((BlockCrops)this.cropTypeA).getMaxAge();
                int k = j / 3;
                this.setBlockState(p_addComponentParts_1_, this.cropTypeA.getStateFromMeta(MathHelper.getInt(p_addComponentParts_2_, k, j)), 1, 1, i, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, this.cropTypeA.getStateFromMeta(MathHelper.getInt(p_addComponentParts_2_, k, j)), 2, 1, i, p_addComponentParts_3_);
                int l = ((BlockCrops)this.cropTypeB).getMaxAge();
                int i1 = l / 3;
                this.setBlockState(p_addComponentParts_1_, this.cropTypeB.getStateFromMeta(MathHelper.getInt(p_addComponentParts_2_, i1, l)), 4, 1, i, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, this.cropTypeB.getStateFromMeta(MathHelper.getInt(p_addComponentParts_2_, i1, l)), 5, 1, i, p_addComponentParts_3_);
                int j1 = ((BlockCrops)this.cropTypeC).getMaxAge();
                int k1 = j1 / 3;
                this.setBlockState(p_addComponentParts_1_, this.cropTypeC.getStateFromMeta(MathHelper.getInt(p_addComponentParts_2_, k1, j1)), 7, 1, i, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, this.cropTypeC.getStateFromMeta(MathHelper.getInt(p_addComponentParts_2_, k1, j1)), 8, 1, i, p_addComponentParts_3_);
                int l1 = ((BlockCrops)this.cropTypeD).getMaxAge();
                int i2 = l1 / 3;
                this.setBlockState(p_addComponentParts_1_, this.cropTypeD.getStateFromMeta(MathHelper.getInt(p_addComponentParts_2_, i2, l1)), 10, 1, i, p_addComponentParts_3_);
                this.setBlockState(p_addComponentParts_1_, this.cropTypeD.getStateFromMeta(MathHelper.getInt(p_addComponentParts_2_, i2, l1)), 11, 1, i, p_addComponentParts_3_);
            }
            for (int j2 = 0; j2 < 9; ++j2) {
                for (int k2 = 0; k2 < 13; ++k2) {
                    this.clearCurrentPositionBlocksUpwards(p_addComponentParts_1_, k2, 4, j2, p_addComponentParts_3_);
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, Blocks.DIRT.getDefaultState(), k2, -1, j2, p_addComponentParts_3_);
                }
            }
            return true;
        }
    }

    public static class Church
    extends Village {
        public Church() {
        }

        public Church(Start p_i45564_1_, int p_i45564_2_, Random p_i45564_3_, StructureBoundingBox p_i45564_4_, EnumFacing p_i45564_5_) {
            super(p_i45564_1_, p_i45564_2_);
            this.setCoordBaseMode(p_i45564_5_);
            this.boundingBox = p_i45564_4_;
        }

        public static Church createPiece(Start p_createPiece_0_, List<StructureComponent> p_createPiece_1_, Random p_createPiece_2_, int p_createPiece_3_, int p_createPiece_4_, int p_createPiece_5_, EnumFacing p_createPiece_6_, int p_createPiece_7_) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.getComponentToAddBoundingBox(p_createPiece_3_, p_createPiece_4_, p_createPiece_5_, 0, 0, 0, 5, 12, 9, p_createPiece_6_);
            return Church.canVillageGoDeeper(structureboundingbox) && StructureComponent.findIntersecting(p_createPiece_1_, structureboundingbox) == null ? new Church(p_createPiece_0_, p_createPiece_7_, p_createPiece_2_, structureboundingbox, p_createPiece_6_) : null;
        }

        @Override
        public boolean addComponentParts(World p_addComponentParts_1_, Random p_addComponentParts_2_, StructureBoundingBox p_addComponentParts_3_) {
            if (this.averageGroundLvl < 0) {
                this.averageGroundLvl = this.getAverageGroundLevel(p_addComponentParts_1_, p_addComponentParts_3_);
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.boundingBox.offset(0, this.averageGroundLvl - this.boundingBox.maxY + 12 - 1, 0);
            }
            IBlockState iblockstate = Blocks.COBBLESTONE.getDefaultState();
            IBlockState iblockstate1 = this.getBiomeSpecificBlockState(Blocks.STONE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.NORTH));
            IBlockState iblockstate2 = this.getBiomeSpecificBlockState(Blocks.STONE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.WEST));
            IBlockState iblockstate3 = this.getBiomeSpecificBlockState(Blocks.STONE_STAIRS.getDefaultState().withProperty(BlockStairs.FACING, EnumFacing.EAST));
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 1, 3, 3, 7, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 5, 1, 3, 9, 3, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 0, 0, 3, 0, 8, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 0, 3, 10, 0, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 1, 1, 0, 10, 3, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 1, 1, 4, 10, 3, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 0, 4, 0, 4, 7, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 4, 0, 4, 4, 4, 7, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 1, 8, 3, 4, 8, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 5, 4, 3, 10, 4, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 1, 5, 5, 3, 5, 7, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 9, 0, 4, 9, 4, iblockstate, iblockstate, false);
            this.fillWithBlocks(p_addComponentParts_1_, p_addComponentParts_3_, 0, 4, 0, 4, 4, 4, iblockstate, iblockstate, false);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 0, 11, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 4, 11, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 2, 11, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 2, 11, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 1, 1, 6, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 1, 1, 7, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 2, 1, 7, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 3, 1, 6, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate, 3, 1, 7, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 1, 1, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 2, 1, 6, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate1, 3, 1, 5, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate2, 1, 2, 7, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, iblockstate3, 3, 2, 7, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 0, 2, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 0, 3, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 4, 2, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 4, 3, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 0, 6, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 0, 7, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 4, 6, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 4, 7, 2, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 2, 6, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 2, 7, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 2, 6, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 2, 7, 4, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 0, 3, 6, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 4, 3, 6, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.GLASS_PANE.getDefaultState(), 2, 3, 8, p_addComponentParts_3_);
            this.placeTorch(p_addComponentParts_1_, EnumFacing.SOUTH, 2, 4, 7, p_addComponentParts_3_);
            this.placeTorch(p_addComponentParts_1_, EnumFacing.EAST, 1, 4, 6, p_addComponentParts_3_);
            this.placeTorch(p_addComponentParts_1_, EnumFacing.WEST, 3, 4, 6, p_addComponentParts_3_);
            this.placeTorch(p_addComponentParts_1_, EnumFacing.NORTH, 2, 4, 5, p_addComponentParts_3_);
            IBlockState iblockstate4 = Blocks.LADDER.getDefaultState().withProperty(BlockLadder.FACING, EnumFacing.WEST);
            for (int i = 1; i <= 9; ++i) {
                this.setBlockState(p_addComponentParts_1_, iblockstate4, 3, i, 3, p_addComponentParts_3_);
            }
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 2, 1, 0, p_addComponentParts_3_);
            this.setBlockState(p_addComponentParts_1_, Blocks.AIR.getDefaultState(), 2, 2, 0, p_addComponentParts_3_);
            this.createVillageDoor(p_addComponentParts_1_, p_addComponentParts_3_, p_addComponentParts_2_, 2, 1, 0, EnumFacing.NORTH);
            if (this.getBlockStateFromPos(p_addComponentParts_1_, 2, 0, -1, p_addComponentParts_3_).getMaterial() == Material.AIR && this.getBlockStateFromPos(p_addComponentParts_1_, 2, -1, -1, p_addComponentParts_3_).getMaterial() != Material.AIR) {
                this.setBlockState(p_addComponentParts_1_, iblockstate1, 2, 0, -1, p_addComponentParts_3_);
                if (this.getBlockStateFromPos(p_addComponentParts_1_, 2, -1, -1, p_addComponentParts_3_).getBlock() == Blocks.GRASS_PATH) {
                    this.setBlockState(p_addComponentParts_1_, Blocks.GRASS.getDefaultState(), 2, -1, -1, p_addComponentParts_3_);
                }
            }
            for (int k = 0; k < 9; ++k) {
                for (int j = 0; j < 5; ++j) {
                    this.clearCurrentPositionBlocksUpwards(p_addComponentParts_1_, j, 12, k, p_addComponentParts_3_);
                    this.replaceAirAndLiquidDownwards(p_addComponentParts_1_, iblockstate, j, -1, k, p_addComponentParts_3_);
                }
            }
            this.spawnVillagers(p_addComponentParts_1_, p_addComponentParts_3_, 2, 1, 2, 1);
            return true;
        }

        @Override
        protected int chooseProfession(int p_chooseProfession_1_, int p_chooseProfession_2_) {
            return 2;
        }
    }
}

