/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkProviderOverworld;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.WoodlandMansionPieces;

public class WoodlandMansion
extends MapGenStructure {
    private final int featureSpacing = 80;
    private final int minFeatureSeparation = 20;
    public static final List<Biome> ALLOWED_BIOMES = Arrays.asList(Biomes.ROOFED_FOREST, Biomes.MUTATED_ROOFED_FOREST);
    private final ChunkProviderOverworld provider;

    public WoodlandMansion(ChunkProviderOverworld p_i47240_1_) {
        this.provider = p_i47240_1_;
    }

    @Override
    public String getStructureName() {
        return "Mansion";
    }

    @Override
    protected boolean canSpawnStructureAtCoords(int p_canSpawnStructureAtCoords_1_, int p_canSpawnStructureAtCoords_2_) {
        boolean lvt_8_1_;
        int lvt_3_1_ = p_canSpawnStructureAtCoords_1_;
        int lvt_4_1_ = p_canSpawnStructureAtCoords_2_;
        if (lvt_3_1_ < 0) {
            lvt_3_1_ -= 79;
        }
        if (lvt_4_1_ < 0) {
            lvt_4_1_ -= 79;
        }
        int lvt_5_1_ = lvt_3_1_ / 80;
        int lvt_6_1_ = lvt_4_1_ / 80;
        Random lvt_7_1_ = this.world.setRandomSeed(lvt_5_1_, lvt_6_1_, 10387319);
        lvt_5_1_ *= 80;
        lvt_6_1_ *= 80;
        return p_canSpawnStructureAtCoords_1_ == (lvt_5_1_ += (lvt_7_1_.nextInt(60) + lvt_7_1_.nextInt(60)) / 2) && p_canSpawnStructureAtCoords_2_ == (lvt_6_1_ += (lvt_7_1_.nextInt(60) + lvt_7_1_.nextInt(60)) / 2) && (lvt_8_1_ = this.world.getBiomeProvider().areBiomesViable(p_canSpawnStructureAtCoords_1_ * 16 + 8, p_canSpawnStructureAtCoords_2_ * 16 + 8, 32, ALLOWED_BIOMES));
    }

    @Override
    public BlockPos getClosestStrongholdPos(World p_getClosestStrongholdPos_1_, BlockPos p_getClosestStrongholdPos_2_, boolean p_getClosestStrongholdPos_3_) {
        this.world = p_getClosestStrongholdPos_1_;
        BiomeProvider lvt_4_1_ = p_getClosestStrongholdPos_1_.getBiomeProvider();
        if (lvt_4_1_.isFixedBiome() && lvt_4_1_.getFixedBiome() != Biomes.ROOFED_FOREST) {
            return null;
        }
        return WoodlandMansion.findNearestStructurePosBySpacing(p_getClosestStrongholdPos_1_, this, p_getClosestStrongholdPos_2_, 80, 20, 10387319, true, 100, p_getClosestStrongholdPos_3_);
    }

    @Override
    protected StructureStart getStructureStart(int p_getStructureStart_1_, int p_getStructureStart_2_) {
        return new Start(this.world, this.provider, this.rand, p_getStructureStart_1_, p_getStructureStart_2_);
    }

    public static class Start
    extends StructureStart {
        private boolean isValid;

        public Start() {
        }

        public Start(World p_i47235_1_, ChunkProviderOverworld p_i47235_2_, Random p_i47235_3_, int p_i47235_4_, int p_i47235_5_) {
            super(p_i47235_4_, p_i47235_5_);
            this.create(p_i47235_1_, p_i47235_2_, p_i47235_3_, p_i47235_4_, p_i47235_5_);
        }

        private void create(World p_create_1_, ChunkProviderOverworld p_create_2_, Random p_create_3_, int p_create_4_, int p_create_5_) {
            Rotation lvt_6_1_ = Rotation.values()[p_create_3_.nextInt(Rotation.values().length)];
            ChunkPrimer lvt_7_1_ = new ChunkPrimer();
            p_create_2_.setBlocksInChunk(p_create_4_, p_create_5_, lvt_7_1_);
            int lvt_8_1_ = 5;
            int lvt_9_1_ = 5;
            if (lvt_6_1_ == Rotation.CLOCKWISE_90) {
                lvt_8_1_ = -5;
            } else if (lvt_6_1_ == Rotation.CLOCKWISE_180) {
                lvt_8_1_ = -5;
                lvt_9_1_ = -5;
            } else if (lvt_6_1_ == Rotation.COUNTERCLOCKWISE_90) {
                lvt_9_1_ = -5;
            }
            int lvt_10_1_ = lvt_7_1_.findGroundBlockIdx(7, 7);
            int lvt_11_1_ = lvt_7_1_.findGroundBlockIdx(7, 7 + lvt_9_1_);
            int lvt_12_1_ = lvt_7_1_.findGroundBlockIdx(7 + lvt_8_1_, 7);
            int lvt_13_1_ = lvt_7_1_.findGroundBlockIdx(7 + lvt_8_1_, 7 + lvt_9_1_);
            int lvt_14_1_ = Math.min(Math.min(lvt_10_1_, lvt_11_1_), Math.min(lvt_12_1_, lvt_13_1_));
            if (lvt_14_1_ < 60) {
                this.isValid = false;
                return;
            }
            BlockPos lvt_15_1_ = new BlockPos(p_create_4_ * 16 + 8, lvt_14_1_ + 1, p_create_5_ * 16 + 8);
            LinkedList lvt_16_1_ = Lists.newLinkedList();
            WoodlandMansionPieces.generateMansion(p_create_1_.getSaveHandler().getStructureTemplateManager(), lvt_15_1_, lvt_6_1_, lvt_16_1_, p_create_3_);
            this.components.addAll(lvt_16_1_);
            this.updateBoundingBox();
            this.isValid = true;
        }

        @Override
        public void generateStructure(World p_generateStructure_1_, Random p_generateStructure_2_, StructureBoundingBox p_generateStructure_3_) {
            super.generateStructure(p_generateStructure_1_, p_generateStructure_2_, p_generateStructure_3_);
            int lvt_4_1_ = this.boundingBox.minY;
            for (int lvt_5_1_ = p_generateStructure_3_.minX; lvt_5_1_ <= p_generateStructure_3_.maxX; ++lvt_5_1_) {
                for (int lvt_6_1_ = p_generateStructure_3_.minZ; lvt_6_1_ <= p_generateStructure_3_.maxZ; ++lvt_6_1_) {
                    BlockPos lvt_10_2_;
                    BlockPos lvt_7_1_ = new BlockPos(lvt_5_1_, lvt_4_1_, lvt_6_1_);
                    if (p_generateStructure_1_.isAirBlock(lvt_7_1_) || !this.boundingBox.isVecInside(lvt_7_1_)) continue;
                    boolean lvt_8_1_ = false;
                    for (StructureComponent lvt_10_1_ : this.components) {
                        if (!lvt_10_1_.boundingBox.isVecInside(lvt_7_1_)) continue;
                        lvt_8_1_ = true;
                        break;
                    }
                    if (!lvt_8_1_) continue;
                    for (int lvt_9_1_ = lvt_4_1_ - 1; lvt_9_1_ > 1 && (p_generateStructure_1_.isAirBlock(lvt_10_2_ = new BlockPos(lvt_5_1_, lvt_9_1_, lvt_6_1_)) || p_generateStructure_1_.getBlockState(lvt_10_2_).getMaterial().isLiquid()); --lvt_9_1_) {
                        p_generateStructure_1_.setBlockState(lvt_10_2_, Blocks.COBBLESTONE.getDefaultState(), 2);
                    }
                }
            }
        }

        @Override
        public boolean isSizeableStructure() {
            return this.isValid;
        }
    }
}

