/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponentTemplate;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class WoodlandMansionPieces {
    public static void registerWoodlandMansionPieces() {
        MapGenStructureIO.registerStructureComponent(MansionTemplate.class, "WMP");
    }

    public static void generateMansion(TemplateManager p_generateMansion_0_, BlockPos p_generateMansion_1_, Rotation p_generateMansion_2_, List<MansionTemplate> p_generateMansion_3_, Random p_generateMansion_4_) {
        Grid lvt_5_1_ = new Grid(p_generateMansion_4_);
        Placer lvt_6_1_ = new Placer(p_generateMansion_0_, p_generateMansion_4_);
        lvt_6_1_.createMansion(p_generateMansion_1_, p_generateMansion_2_, p_generateMansion_3_, lvt_5_1_);
    }

    static class ThirdFloor
    extends SecondFloor {
        private ThirdFloor() {
        }
    }

    static class SecondFloor
    extends RoomCollection {
        private SecondFloor() {
        }

        @Override
        public String get1x1(Random p_get1x1_1_) {
            return "1x1_b" + (p_get1x1_1_.nextInt(4) + 1);
        }

        @Override
        public String get1x1Secret(Random p_get1x1Secret_1_) {
            return "1x1_as" + (p_get1x1Secret_1_.nextInt(4) + 1);
        }

        @Override
        public String get1x2SideEntrance(Random p_get1x2SideEntrance_1_, boolean p_get1x2SideEntrance_2_) {
            if (p_get1x2SideEntrance_2_) {
                return "1x2_c_stairs";
            }
            return "1x2_c" + (p_get1x2SideEntrance_1_.nextInt(4) + 1);
        }

        @Override
        public String get1x2FrontEntrance(Random p_get1x2FrontEntrance_1_, boolean p_get1x2FrontEntrance_2_) {
            if (p_get1x2FrontEntrance_2_) {
                return "1x2_d_stairs";
            }
            return "1x2_d" + (p_get1x2FrontEntrance_1_.nextInt(5) + 1);
        }

        @Override
        public String get1x2Secret(Random p_get1x2Secret_1_) {
            return "1x2_se" + (p_get1x2Secret_1_.nextInt(1) + 1);
        }

        @Override
        public String get2x2(Random p_get2x2_1_) {
            return "2x2_b" + (p_get2x2_1_.nextInt(5) + 1);
        }

        @Override
        public String get2x2Secret(Random p_get2x2Secret_1_) {
            return "2x2_s1";
        }
    }

    static class FirstFloor
    extends RoomCollection {
        private FirstFloor() {
        }

        @Override
        public String get1x1(Random p_get1x1_1_) {
            return "1x1_a" + (p_get1x1_1_.nextInt(5) + 1);
        }

        @Override
        public String get1x1Secret(Random p_get1x1Secret_1_) {
            return "1x1_as" + (p_get1x1Secret_1_.nextInt(4) + 1);
        }

        @Override
        public String get1x2SideEntrance(Random p_get1x2SideEntrance_1_, boolean p_get1x2SideEntrance_2_) {
            return "1x2_a" + (p_get1x2SideEntrance_1_.nextInt(9) + 1);
        }

        @Override
        public String get1x2FrontEntrance(Random p_get1x2FrontEntrance_1_, boolean p_get1x2FrontEntrance_2_) {
            return "1x2_b" + (p_get1x2FrontEntrance_1_.nextInt(5) + 1);
        }

        @Override
        public String get1x2Secret(Random p_get1x2Secret_1_) {
            return "1x2_s" + (p_get1x2Secret_1_.nextInt(2) + 1);
        }

        @Override
        public String get2x2(Random p_get2x2_1_) {
            return "2x2_a" + (p_get2x2_1_.nextInt(4) + 1);
        }

        @Override
        public String get2x2Secret(Random p_get2x2Secret_1_) {
            return "2x2_s1";
        }
    }

    static abstract class RoomCollection {
        private RoomCollection() {
        }

        public abstract String get1x1(Random var1);

        public abstract String get1x1Secret(Random var1);

        public abstract String get1x2SideEntrance(Random var1, boolean var2);

        public abstract String get1x2FrontEntrance(Random var1, boolean var2);

        public abstract String get1x2Secret(Random var1);

        public abstract String get2x2(Random var1);

        public abstract String get2x2Secret(Random var1);
    }

    static class SimpleGrid {
        private final int[][] grid;
        private final int width;
        private final int height;
        private final int valueIfOutside;

        public SimpleGrid(int p_i47358_1_, int p_i47358_2_, int p_i47358_3_) {
            this.width = p_i47358_1_;
            this.height = p_i47358_2_;
            this.valueIfOutside = p_i47358_3_;
            this.grid = new int[p_i47358_1_][p_i47358_2_];
        }

        public void set(int p_set_1_, int p_set_2_, int p_set_3_) {
            if (p_set_1_ >= 0 && p_set_1_ < this.width && p_set_2_ >= 0 && p_set_2_ < this.height) {
                this.grid[p_set_1_][p_set_2_] = p_set_3_;
            }
        }

        public void set(int p_set_1_, int p_set_2_, int p_set_3_, int p_set_4_, int p_set_5_) {
            for (int lvt_6_1_ = p_set_2_; lvt_6_1_ <= p_set_4_; ++lvt_6_1_) {
                for (int lvt_7_1_ = p_set_1_; lvt_7_1_ <= p_set_3_; ++lvt_7_1_) {
                    this.set(lvt_7_1_, lvt_6_1_, p_set_5_);
                }
            }
        }

        public int get(int p_get_1_, int p_get_2_) {
            if (p_get_1_ >= 0 && p_get_1_ < this.width && p_get_2_ >= 0 && p_get_2_ < this.height) {
                return this.grid[p_get_1_][p_get_2_];
            }
            return this.valueIfOutside;
        }

        public void setIf(int p_setIf_1_, int p_setIf_2_, int p_setIf_3_, int p_setIf_4_) {
            if (this.get(p_setIf_1_, p_setIf_2_) == p_setIf_3_) {
                this.set(p_setIf_1_, p_setIf_2_, p_setIf_4_);
            }
        }

        public boolean edgesTo(int p_edgesTo_1_, int p_edgesTo_2_, int p_edgesTo_3_) {
            return this.get(p_edgesTo_1_ - 1, p_edgesTo_2_) == p_edgesTo_3_ || this.get(p_edgesTo_1_ + 1, p_edgesTo_2_) == p_edgesTo_3_ || this.get(p_edgesTo_1_, p_edgesTo_2_ + 1) == p_edgesTo_3_ || this.get(p_edgesTo_1_, p_edgesTo_2_ - 1) == p_edgesTo_3_;
        }
    }

    static class Grid {
        private final Random random;
        private final SimpleGrid baseGrid;
        private final SimpleGrid thirdFloorGrid;
        private final SimpleGrid[] floorRooms;
        private final int entranceX;
        private final int entranceY;

        public Grid(Random p_i47362_1_) {
            this.random = p_i47362_1_;
            int lvt_2_1_ = 11;
            this.entranceX = 7;
            this.entranceY = 4;
            this.baseGrid = new SimpleGrid(11, 11, 5);
            this.baseGrid.set(this.entranceX, this.entranceY, this.entranceX + 1, this.entranceY + 1, 3);
            this.baseGrid.set(this.entranceX - 1, this.entranceY, this.entranceX - 1, this.entranceY + 1, 2);
            this.baseGrid.set(this.entranceX + 2, this.entranceY - 2, this.entranceX + 3, this.entranceY + 3, 5);
            this.baseGrid.set(this.entranceX + 1, this.entranceY - 2, this.entranceX + 1, this.entranceY - 1, 1);
            this.baseGrid.set(this.entranceX + 1, this.entranceY + 2, this.entranceX + 1, this.entranceY + 3, 1);
            this.baseGrid.set(this.entranceX - 1, this.entranceY - 1, 1);
            this.baseGrid.set(this.entranceX - 1, this.entranceY + 2, 1);
            this.baseGrid.set(0, 0, 11, 1, 5);
            this.baseGrid.set(0, 9, 11, 11, 5);
            this.recursiveCorridor(this.baseGrid, this.entranceX, this.entranceY - 2, EnumFacing.WEST, 6);
            this.recursiveCorridor(this.baseGrid, this.entranceX, this.entranceY + 3, EnumFacing.WEST, 6);
            this.recursiveCorridor(this.baseGrid, this.entranceX - 2, this.entranceY - 1, EnumFacing.WEST, 3);
            this.recursiveCorridor(this.baseGrid, this.entranceX - 2, this.entranceY + 2, EnumFacing.WEST, 3);
            while (this.cleanEdges(this.baseGrid)) {
            }
            this.floorRooms = new SimpleGrid[3];
            this.floorRooms[0] = new SimpleGrid(11, 11, 5);
            this.floorRooms[1] = new SimpleGrid(11, 11, 5);
            this.floorRooms[2] = new SimpleGrid(11, 11, 5);
            this.identifyRooms(this.baseGrid, this.floorRooms[0]);
            this.identifyRooms(this.baseGrid, this.floorRooms[1]);
            this.floorRooms[0].set(this.entranceX + 1, this.entranceY, this.entranceX + 1, this.entranceY + 1, 0x800000);
            this.floorRooms[1].set(this.entranceX + 1, this.entranceY, this.entranceX + 1, this.entranceY + 1, 0x800000);
            this.thirdFloorGrid = new SimpleGrid(this.baseGrid.width, this.baseGrid.height, 5);
            this.setupThirdFloor();
            this.identifyRooms(this.thirdFloorGrid, this.floorRooms[2]);
        }

        public static boolean isHouse(SimpleGrid p_isHouse_0_, int p_isHouse_1_, int p_isHouse_2_) {
            int lvt_3_1_ = p_isHouse_0_.get(p_isHouse_1_, p_isHouse_2_);
            return lvt_3_1_ == 1 || lvt_3_1_ == 2 || lvt_3_1_ == 3 || lvt_3_1_ == 4;
        }

        public boolean isRoomId(SimpleGrid p_isRoomId_1_, int p_isRoomId_2_, int p_isRoomId_3_, int p_isRoomId_4_, int p_isRoomId_5_) {
            return (this.floorRooms[p_isRoomId_4_].get(p_isRoomId_2_, p_isRoomId_3_) & 0xFFFF) == p_isRoomId_5_;
        }

        @Nullable
        public EnumFacing get1x2RoomDirection(SimpleGrid p_get1x2RoomDirection_1_, int p_get1x2RoomDirection_2_, int p_get1x2RoomDirection_3_, int p_get1x2RoomDirection_4_, int p_get1x2RoomDirection_5_) {
            for (EnumFacing lvt_9_1_ : EnumFacing.Plane.HORIZONTAL.facings()) {
                if (!this.isRoomId(p_get1x2RoomDirection_1_, p_get1x2RoomDirection_2_ + lvt_9_1_.getFrontOffsetX(), p_get1x2RoomDirection_3_ + lvt_9_1_.getFrontOffsetZ(), p_get1x2RoomDirection_4_, p_get1x2RoomDirection_5_)) continue;
                return lvt_9_1_;
            }
            return null;
        }

        private void recursiveCorridor(SimpleGrid p_recursiveCorridor_1_, int p_recursiveCorridor_2_, int p_recursiveCorridor_3_, EnumFacing p_recursiveCorridor_4_, int p_recursiveCorridor_5_) {
            if (p_recursiveCorridor_5_ <= 0) {
                return;
            }
            p_recursiveCorridor_1_.set(p_recursiveCorridor_2_, p_recursiveCorridor_3_, 1);
            p_recursiveCorridor_1_.setIf(p_recursiveCorridor_2_ + p_recursiveCorridor_4_.getFrontOffsetX(), p_recursiveCorridor_3_ + p_recursiveCorridor_4_.getFrontOffsetZ(), 0, 1);
            for (int lvt_6_1_ = 0; lvt_6_1_ < 8; ++lvt_6_1_) {
                EnumFacing lvt_7_1_ = EnumFacing.getHorizontal(this.random.nextInt(4));
                if (lvt_7_1_ == p_recursiveCorridor_4_.getOpposite() || lvt_7_1_ == EnumFacing.EAST && this.random.nextBoolean()) continue;
                int lvt_8_1_ = p_recursiveCorridor_2_ + p_recursiveCorridor_4_.getFrontOffsetX();
                int lvt_9_1_ = p_recursiveCorridor_3_ + p_recursiveCorridor_4_.getFrontOffsetZ();
                if (p_recursiveCorridor_1_.get(lvt_8_1_ + lvt_7_1_.getFrontOffsetX(), lvt_9_1_ + lvt_7_1_.getFrontOffsetZ()) != 0 || p_recursiveCorridor_1_.get(lvt_8_1_ + lvt_7_1_.getFrontOffsetX() * 2, lvt_9_1_ + lvt_7_1_.getFrontOffsetZ() * 2) != 0) continue;
                this.recursiveCorridor(p_recursiveCorridor_1_, p_recursiveCorridor_2_ + p_recursiveCorridor_4_.getFrontOffsetX() + lvt_7_1_.getFrontOffsetX(), p_recursiveCorridor_3_ + p_recursiveCorridor_4_.getFrontOffsetZ() + lvt_7_1_.getFrontOffsetZ(), lvt_7_1_, p_recursiveCorridor_5_ - 1);
                break;
            }
            EnumFacing lvt_6_2_ = p_recursiveCorridor_4_.rotateY();
            EnumFacing lvt_7_2_ = p_recursiveCorridor_4_.rotateYCCW();
            p_recursiveCorridor_1_.setIf(p_recursiveCorridor_2_ + lvt_6_2_.getFrontOffsetX(), p_recursiveCorridor_3_ + lvt_6_2_.getFrontOffsetZ(), 0, 2);
            p_recursiveCorridor_1_.setIf(p_recursiveCorridor_2_ + lvt_7_2_.getFrontOffsetX(), p_recursiveCorridor_3_ + lvt_7_2_.getFrontOffsetZ(), 0, 2);
            p_recursiveCorridor_1_.setIf(p_recursiveCorridor_2_ + p_recursiveCorridor_4_.getFrontOffsetX() + lvt_6_2_.getFrontOffsetX(), p_recursiveCorridor_3_ + p_recursiveCorridor_4_.getFrontOffsetZ() + lvt_6_2_.getFrontOffsetZ(), 0, 2);
            p_recursiveCorridor_1_.setIf(p_recursiveCorridor_2_ + p_recursiveCorridor_4_.getFrontOffsetX() + lvt_7_2_.getFrontOffsetX(), p_recursiveCorridor_3_ + p_recursiveCorridor_4_.getFrontOffsetZ() + lvt_7_2_.getFrontOffsetZ(), 0, 2);
            p_recursiveCorridor_1_.setIf(p_recursiveCorridor_2_ + p_recursiveCorridor_4_.getFrontOffsetX() * 2, p_recursiveCorridor_3_ + p_recursiveCorridor_4_.getFrontOffsetZ() * 2, 0, 2);
            p_recursiveCorridor_1_.setIf(p_recursiveCorridor_2_ + lvt_6_2_.getFrontOffsetX() * 2, p_recursiveCorridor_3_ + lvt_6_2_.getFrontOffsetZ() * 2, 0, 2);
            p_recursiveCorridor_1_.setIf(p_recursiveCorridor_2_ + lvt_7_2_.getFrontOffsetX() * 2, p_recursiveCorridor_3_ + lvt_7_2_.getFrontOffsetZ() * 2, 0, 2);
        }

        private boolean cleanEdges(SimpleGrid p_cleanEdges_1_) {
            boolean lvt_2_1_ = false;
            for (int lvt_3_1_ = 0; lvt_3_1_ < p_cleanEdges_1_.height; ++lvt_3_1_) {
                for (int lvt_4_1_ = 0; lvt_4_1_ < p_cleanEdges_1_.width; ++lvt_4_1_) {
                    if (p_cleanEdges_1_.get(lvt_4_1_, lvt_3_1_) != 0) continue;
                    int lvt_5_1_ = 0;
                    lvt_5_1_ += Grid.isHouse(p_cleanEdges_1_, lvt_4_1_ + 1, lvt_3_1_) ? 1 : 0;
                    lvt_5_1_ += Grid.isHouse(p_cleanEdges_1_, lvt_4_1_ - 1, lvt_3_1_) ? 1 : 0;
                    lvt_5_1_ += Grid.isHouse(p_cleanEdges_1_, lvt_4_1_, lvt_3_1_ + 1) ? 1 : 0;
                    if ((lvt_5_1_ += Grid.isHouse(p_cleanEdges_1_, lvt_4_1_, lvt_3_1_ - 1) ? 1 : 0) >= 3) {
                        p_cleanEdges_1_.set(lvt_4_1_, lvt_3_1_, 2);
                        lvt_2_1_ = true;
                        continue;
                    }
                    if (lvt_5_1_ != 2) continue;
                    int lvt_6_1_ = 0;
                    lvt_6_1_ += Grid.isHouse(p_cleanEdges_1_, lvt_4_1_ + 1, lvt_3_1_ + 1) ? 1 : 0;
                    lvt_6_1_ += Grid.isHouse(p_cleanEdges_1_, lvt_4_1_ - 1, lvt_3_1_ + 1) ? 1 : 0;
                    lvt_6_1_ += Grid.isHouse(p_cleanEdges_1_, lvt_4_1_ + 1, lvt_3_1_ - 1) ? 1 : 0;
                    if ((lvt_6_1_ += Grid.isHouse(p_cleanEdges_1_, lvt_4_1_ - 1, lvt_3_1_ - 1) ? 1 : 0) > 1) continue;
                    p_cleanEdges_1_.set(lvt_4_1_, lvt_3_1_, 2);
                    lvt_2_1_ = true;
                }
            }
            return lvt_2_1_;
        }

        private void setupThirdFloor() {
            ArrayList lvt_1_1_ = Lists.newArrayList();
            SimpleGrid lvt_2_1_ = this.floorRooms[1];
            for (int lvt_3_1_ = 0; lvt_3_1_ < this.thirdFloorGrid.height; ++lvt_3_1_) {
                for (int lvt_4_1_ = 0; lvt_4_1_ < this.thirdFloorGrid.width; ++lvt_4_1_) {
                    int lvt_5_1_ = lvt_2_1_.get(lvt_4_1_, lvt_3_1_);
                    int lvt_6_1_ = lvt_5_1_ & 0xF0000;
                    if (lvt_6_1_ != 131072 || (lvt_5_1_ & 0x200000) != 0x200000) continue;
                    lvt_1_1_.add(new Tuple<Integer, Integer>(lvt_4_1_, lvt_3_1_));
                }
            }
            if (lvt_1_1_.isEmpty()) {
                this.thirdFloorGrid.set(0, 0, this.thirdFloorGrid.width, this.thirdFloorGrid.height, 5);
                return;
            }
            Tuple lvt_3_2_ = (Tuple)lvt_1_1_.get(this.random.nextInt(lvt_1_1_.size()));
            int lvt_4_2_ = lvt_2_1_.get((Integer)lvt_3_2_.getFirst(), (Integer)lvt_3_2_.getSecond());
            lvt_2_1_.set((Integer)lvt_3_2_.getFirst(), (Integer)lvt_3_2_.getSecond(), lvt_4_2_ | 0x400000);
            EnumFacing lvt_5_2_ = this.get1x2RoomDirection(this.baseGrid, (Integer)lvt_3_2_.getFirst(), (Integer)lvt_3_2_.getSecond(), 1, lvt_4_2_ & 0xFFFF);
            int lvt_6_2_ = (Integer)lvt_3_2_.getFirst() + lvt_5_2_.getFrontOffsetX();
            int lvt_7_1_ = (Integer)lvt_3_2_.getSecond() + lvt_5_2_.getFrontOffsetZ();
            for (int lvt_8_1_ = 0; lvt_8_1_ < this.thirdFloorGrid.height; ++lvt_8_1_) {
                for (int lvt_9_1_ = 0; lvt_9_1_ < this.thirdFloorGrid.width; ++lvt_9_1_) {
                    if (!Grid.isHouse(this.baseGrid, lvt_9_1_, lvt_8_1_)) {
                        this.thirdFloorGrid.set(lvt_9_1_, lvt_8_1_, 5);
                        continue;
                    }
                    if (lvt_9_1_ == (Integer)lvt_3_2_.getFirst() && lvt_8_1_ == (Integer)lvt_3_2_.getSecond()) {
                        this.thirdFloorGrid.set(lvt_9_1_, lvt_8_1_, 3);
                        continue;
                    }
                    if (lvt_9_1_ != lvt_6_2_ || lvt_8_1_ != lvt_7_1_) continue;
                    this.thirdFloorGrid.set(lvt_9_1_, lvt_8_1_, 3);
                    this.floorRooms[2].set(lvt_9_1_, lvt_8_1_, 0x800000);
                }
            }
            ArrayList lvt_8_2_ = Lists.newArrayList();
            for (EnumFacing lvt_12_1_ : EnumFacing.Plane.HORIZONTAL.facings()) {
                if (this.thirdFloorGrid.get(lvt_6_2_ + lvt_12_1_.getFrontOffsetX(), lvt_7_1_ + lvt_12_1_.getFrontOffsetZ()) != 0) continue;
                lvt_8_2_.add(lvt_12_1_);
            }
            if (lvt_8_2_.isEmpty()) {
                this.thirdFloorGrid.set(0, 0, this.thirdFloorGrid.width, this.thirdFloorGrid.height, 5);
                lvt_2_1_.set((Integer)lvt_3_2_.getFirst(), (Integer)lvt_3_2_.getSecond(), lvt_4_2_);
                return;
            }
            EnumFacing lvt_9_2_ = (EnumFacing)lvt_8_2_.get(this.random.nextInt(lvt_8_2_.size()));
            this.recursiveCorridor(this.thirdFloorGrid, lvt_6_2_ + lvt_9_2_.getFrontOffsetX(), lvt_7_1_ + lvt_9_2_.getFrontOffsetZ(), lvt_9_2_, 4);
            while (this.cleanEdges(this.thirdFloorGrid)) {
            }
        }

        private void identifyRooms(SimpleGrid p_identifyRooms_1_, SimpleGrid p_identifyRooms_2_) {
            ArrayList lvt_3_1_ = Lists.newArrayList();
            for (int lvt_4_1_ = 0; lvt_4_1_ < p_identifyRooms_1_.height; ++lvt_4_1_) {
                for (int lvt_5_1_ = 0; lvt_5_1_ < p_identifyRooms_1_.width; ++lvt_5_1_) {
                    if (p_identifyRooms_1_.get(lvt_5_1_, lvt_4_1_) != 2) continue;
                    lvt_3_1_.add(new Tuple<Integer, Integer>(lvt_5_1_, lvt_4_1_));
                }
            }
            Collections.shuffle(lvt_3_1_, this.random);
            int lvt_4_2_ = 10;
            for (Tuple lvt_6_1_ : lvt_3_1_) {
                int lvt_8_1_;
                int lvt_7_1_ = (Integer)lvt_6_1_.getFirst();
                if (p_identifyRooms_2_.get(lvt_7_1_, lvt_8_1_ = ((Integer)lvt_6_1_.getSecond()).intValue()) != 0) continue;
                int lvt_9_1_ = lvt_7_1_;
                int lvt_10_1_ = lvt_7_1_;
                int lvt_11_1_ = lvt_8_1_;
                int lvt_12_1_ = lvt_8_1_;
                int lvt_13_1_ = 65536;
                if (p_identifyRooms_2_.get(lvt_7_1_ + 1, lvt_8_1_) == 0 && p_identifyRooms_2_.get(lvt_7_1_, lvt_8_1_ + 1) == 0 && p_identifyRooms_2_.get(lvt_7_1_ + 1, lvt_8_1_ + 1) == 0 && p_identifyRooms_1_.get(lvt_7_1_ + 1, lvt_8_1_) == 2 && p_identifyRooms_1_.get(lvt_7_1_, lvt_8_1_ + 1) == 2 && p_identifyRooms_1_.get(lvt_7_1_ + 1, lvt_8_1_ + 1) == 2) {
                    ++lvt_10_1_;
                    ++lvt_12_1_;
                    lvt_13_1_ = 262144;
                } else if (p_identifyRooms_2_.get(lvt_7_1_ - 1, lvt_8_1_) == 0 && p_identifyRooms_2_.get(lvt_7_1_, lvt_8_1_ + 1) == 0 && p_identifyRooms_2_.get(lvt_7_1_ - 1, lvt_8_1_ + 1) == 0 && p_identifyRooms_1_.get(lvt_7_1_ - 1, lvt_8_1_) == 2 && p_identifyRooms_1_.get(lvt_7_1_, lvt_8_1_ + 1) == 2 && p_identifyRooms_1_.get(lvt_7_1_ - 1, lvt_8_1_ + 1) == 2) {
                    --lvt_9_1_;
                    ++lvt_12_1_;
                    lvt_13_1_ = 262144;
                } else if (p_identifyRooms_2_.get(lvt_7_1_ - 1, lvt_8_1_) == 0 && p_identifyRooms_2_.get(lvt_7_1_, lvt_8_1_ - 1) == 0 && p_identifyRooms_2_.get(lvt_7_1_ - 1, lvt_8_1_ - 1) == 0 && p_identifyRooms_1_.get(lvt_7_1_ - 1, lvt_8_1_) == 2 && p_identifyRooms_1_.get(lvt_7_1_, lvt_8_1_ - 1) == 2 && p_identifyRooms_1_.get(lvt_7_1_ - 1, lvt_8_1_ - 1) == 2) {
                    --lvt_9_1_;
                    --lvt_11_1_;
                    lvt_13_1_ = 262144;
                } else if (p_identifyRooms_2_.get(lvt_7_1_ + 1, lvt_8_1_) == 0 && p_identifyRooms_1_.get(lvt_7_1_ + 1, lvt_8_1_) == 2) {
                    ++lvt_10_1_;
                    lvt_13_1_ = 131072;
                } else if (p_identifyRooms_2_.get(lvt_7_1_, lvt_8_1_ + 1) == 0 && p_identifyRooms_1_.get(lvt_7_1_, lvt_8_1_ + 1) == 2) {
                    ++lvt_12_1_;
                    lvt_13_1_ = 131072;
                } else if (p_identifyRooms_2_.get(lvt_7_1_ - 1, lvt_8_1_) == 0 && p_identifyRooms_1_.get(lvt_7_1_ - 1, lvt_8_1_) == 2) {
                    --lvt_9_1_;
                    lvt_13_1_ = 131072;
                } else if (p_identifyRooms_2_.get(lvt_7_1_, lvt_8_1_ - 1) == 0 && p_identifyRooms_1_.get(lvt_7_1_, lvt_8_1_ - 1) == 2) {
                    --lvt_11_1_;
                    lvt_13_1_ = 131072;
                }
                int lvt_14_1_ = this.random.nextBoolean() ? lvt_9_1_ : lvt_10_1_;
                int lvt_15_1_ = this.random.nextBoolean() ? lvt_11_1_ : lvt_12_1_;
                int lvt_16_1_ = 0x200000;
                if (!p_identifyRooms_1_.edgesTo(lvt_14_1_, lvt_15_1_, 1)) {
                    lvt_14_1_ = lvt_14_1_ == lvt_9_1_ ? lvt_10_1_ : lvt_9_1_;
                    int n = lvt_15_1_ = lvt_15_1_ == lvt_11_1_ ? lvt_12_1_ : lvt_11_1_;
                    if (!p_identifyRooms_1_.edgesTo(lvt_14_1_, lvt_15_1_, 1)) {
                        int n2 = lvt_15_1_ = lvt_15_1_ == lvt_11_1_ ? lvt_12_1_ : lvt_11_1_;
                        if (!p_identifyRooms_1_.edgesTo(lvt_14_1_, lvt_15_1_, 1)) {
                            lvt_14_1_ = lvt_14_1_ == lvt_9_1_ ? lvt_10_1_ : lvt_9_1_;
                            int n3 = lvt_15_1_ = lvt_15_1_ == lvt_11_1_ ? lvt_12_1_ : lvt_11_1_;
                            if (!p_identifyRooms_1_.edgesTo(lvt_14_1_, lvt_15_1_, 1)) {
                                lvt_16_1_ = 0;
                                lvt_14_1_ = lvt_9_1_;
                                lvt_15_1_ = lvt_11_1_;
                            }
                        }
                    }
                }
                for (int lvt_17_1_ = lvt_11_1_; lvt_17_1_ <= lvt_12_1_; ++lvt_17_1_) {
                    for (int lvt_18_1_ = lvt_9_1_; lvt_18_1_ <= lvt_10_1_; ++lvt_18_1_) {
                        if (lvt_18_1_ == lvt_14_1_ && lvt_17_1_ == lvt_15_1_) {
                            p_identifyRooms_2_.set(lvt_18_1_, lvt_17_1_, 0x100000 | lvt_16_1_ | lvt_13_1_ | lvt_4_2_);
                            continue;
                        }
                        p_identifyRooms_2_.set(lvt_18_1_, lvt_17_1_, lvt_13_1_ | lvt_4_2_);
                    }
                }
                ++lvt_4_2_;
            }
        }
    }

    static class Placer {
        private final TemplateManager templateManager;
        private final Random random;
        private int startX;
        private int startY;

        public Placer(TemplateManager p_i47361_1_, Random p_i47361_2_) {
            this.templateManager = p_i47361_1_;
            this.random = p_i47361_2_;
        }

        public void createMansion(BlockPos p_createMansion_1_, Rotation p_createMansion_2_, List<MansionTemplate> p_createMansion_3_, Grid p_createMansion_4_) {
            PlacementData lvt_5_1_ = new PlacementData();
            lvt_5_1_.position = p_createMansion_1_;
            lvt_5_1_.rotation = p_createMansion_2_;
            lvt_5_1_.wallType = "wall_flat";
            PlacementData lvt_6_1_ = new PlacementData();
            this.entrance(p_createMansion_3_, lvt_5_1_);
            lvt_6_1_.position = lvt_5_1_.position.up(8);
            lvt_6_1_.rotation = lvt_5_1_.rotation;
            lvt_6_1_.wallType = "wall_window";
            if (!p_createMansion_3_.isEmpty()) {
                // empty if block
            }
            SimpleGrid lvt_7_1_ = p_createMansion_4_.baseGrid;
            SimpleGrid lvt_8_1_ = p_createMansion_4_.thirdFloorGrid;
            this.startX = p_createMansion_4_.entranceX + 1;
            this.startY = p_createMansion_4_.entranceY + 1;
            int lvt_9_1_ = p_createMansion_4_.entranceX + 1;
            int lvt_10_1_ = p_createMansion_4_.entranceY;
            this.traverseOuterWalls(p_createMansion_3_, lvt_5_1_, lvt_7_1_, EnumFacing.SOUTH, this.startX, this.startY, lvt_9_1_, lvt_10_1_);
            this.traverseOuterWalls(p_createMansion_3_, lvt_6_1_, lvt_7_1_, EnumFacing.SOUTH, this.startX, this.startY, lvt_9_1_, lvt_10_1_);
            PlacementData lvt_11_1_ = new PlacementData();
            lvt_11_1_.position = lvt_5_1_.position.up(19);
            lvt_11_1_.rotation = lvt_5_1_.rotation;
            lvt_11_1_.wallType = "wall_window";
            boolean lvt_12_1_ = false;
            for (int lvt_13_1_ = 0; lvt_13_1_ < lvt_8_1_.height && !lvt_12_1_; ++lvt_13_1_) {
                for (int lvt_14_1_ = lvt_8_1_.width - 1; lvt_14_1_ >= 0 && !lvt_12_1_; --lvt_14_1_) {
                    if (!Grid.isHouse(lvt_8_1_, lvt_14_1_, lvt_13_1_)) continue;
                    lvt_11_1_.position = lvt_11_1_.position.offset(p_createMansion_2_.rotate(EnumFacing.SOUTH), 8 + (lvt_13_1_ - this.startY) * 8);
                    lvt_11_1_.position = lvt_11_1_.position.offset(p_createMansion_2_.rotate(EnumFacing.EAST), (lvt_14_1_ - this.startX) * 8);
                    this.traverseWallPiece(p_createMansion_3_, lvt_11_1_);
                    this.traverseOuterWalls(p_createMansion_3_, lvt_11_1_, lvt_8_1_, EnumFacing.SOUTH, lvt_14_1_, lvt_13_1_, lvt_14_1_, lvt_13_1_);
                    lvt_12_1_ = true;
                }
            }
            this.createRoof(p_createMansion_3_, p_createMansion_1_.up(16), p_createMansion_2_, lvt_7_1_, lvt_8_1_);
            this.createRoof(p_createMansion_3_, p_createMansion_1_.up(27), p_createMansion_2_, lvt_8_1_, null);
            if (!p_createMansion_3_.isEmpty()) {
                // empty if block
            }
            RoomCollection[] lvt_13_2_ = new RoomCollection[]{new FirstFloor(), new SecondFloor(), new ThirdFloor()};
            for (int lvt_14_2_ = 0; lvt_14_2_ < 3; ++lvt_14_2_) {
                BlockPos lvt_15_1_ = p_createMansion_1_.up(8 * lvt_14_2_ + (lvt_14_2_ == 2 ? 3 : 0));
                SimpleGrid lvt_16_1_ = p_createMansion_4_.floorRooms[lvt_14_2_];
                SimpleGrid lvt_17_1_ = lvt_14_2_ == 2 ? lvt_8_1_ : lvt_7_1_;
                String lvt_18_1_ = lvt_14_2_ == 0 ? "carpet_south" : "carpet_south_2";
                String lvt_19_1_ = lvt_14_2_ == 0 ? "carpet_west" : "carpet_west_2";
                for (int lvt_20_1_ = 0; lvt_20_1_ < lvt_17_1_.height; ++lvt_20_1_) {
                    for (int lvt_21_1_ = 0; lvt_21_1_ < lvt_17_1_.width; ++lvt_21_1_) {
                        if (lvt_17_1_.get(lvt_21_1_, lvt_20_1_) != 1) continue;
                        BlockPos lvt_22_1_ = lvt_15_1_.offset(p_createMansion_2_.rotate(EnumFacing.SOUTH), 8 + (lvt_20_1_ - this.startY) * 8);
                        lvt_22_1_ = lvt_22_1_.offset(p_createMansion_2_.rotate(EnumFacing.EAST), (lvt_21_1_ - this.startX) * 8);
                        p_createMansion_3_.add(new MansionTemplate(this.templateManager, "corridor_floor", lvt_22_1_, p_createMansion_2_));
                        if (lvt_17_1_.get(lvt_21_1_, lvt_20_1_ - 1) == 1 || (lvt_16_1_.get(lvt_21_1_, lvt_20_1_ - 1) & 0x800000) == 0x800000) {
                            p_createMansion_3_.add(new MansionTemplate(this.templateManager, "carpet_north", lvt_22_1_.offset(p_createMansion_2_.rotate(EnumFacing.EAST), 1).up(), p_createMansion_2_));
                        }
                        if (lvt_17_1_.get(lvt_21_1_ + 1, lvt_20_1_) == 1 || (lvt_16_1_.get(lvt_21_1_ + 1, lvt_20_1_) & 0x800000) == 0x800000) {
                            p_createMansion_3_.add(new MansionTemplate(this.templateManager, "carpet_east", lvt_22_1_.offset(p_createMansion_2_.rotate(EnumFacing.SOUTH), 1).offset(p_createMansion_2_.rotate(EnumFacing.EAST), 5).up(), p_createMansion_2_));
                        }
                        if (lvt_17_1_.get(lvt_21_1_, lvt_20_1_ + 1) == 1 || (lvt_16_1_.get(lvt_21_1_, lvt_20_1_ + 1) & 0x800000) == 0x800000) {
                            p_createMansion_3_.add(new MansionTemplate(this.templateManager, lvt_18_1_, lvt_22_1_.offset(p_createMansion_2_.rotate(EnumFacing.SOUTH), 5).offset(p_createMansion_2_.rotate(EnumFacing.WEST), 1), p_createMansion_2_));
                        }
                        if (lvt_17_1_.get(lvt_21_1_ - 1, lvt_20_1_) != 1 && (lvt_16_1_.get(lvt_21_1_ - 1, lvt_20_1_) & 0x800000) != 0x800000) continue;
                        p_createMansion_3_.add(new MansionTemplate(this.templateManager, lvt_19_1_, lvt_22_1_.offset(p_createMansion_2_.rotate(EnumFacing.WEST), 1).offset(p_createMansion_2_.rotate(EnumFacing.NORTH), 1), p_createMansion_2_));
                    }
                }
                String lvt_20_2_ = lvt_14_2_ == 0 ? "indoors_wall" : "indoors_wall_2";
                String lvt_21_2_ = lvt_14_2_ == 0 ? "indoors_door" : "indoors_door_2";
                ArrayList lvt_22_2_ = Lists.newArrayList();
                for (int lvt_23_1_ = 0; lvt_23_1_ < lvt_17_1_.height; ++lvt_23_1_) {
                    for (int lvt_24_1_ = 0; lvt_24_1_ < lvt_17_1_.width; ++lvt_24_1_) {
                        boolean lvt_25_1_;
                        boolean bl = lvt_25_1_ = lvt_14_2_ == 2 && lvt_17_1_.get(lvt_24_1_, lvt_23_1_) == 3;
                        if (lvt_17_1_.get(lvt_24_1_, lvt_23_1_) != 2 && !lvt_25_1_) continue;
                        int lvt_26_1_ = lvt_16_1_.get(lvt_24_1_, lvt_23_1_);
                        int lvt_27_1_ = lvt_26_1_ & 0xF0000;
                        int lvt_28_1_ = lvt_26_1_ & 0xFFFF;
                        lvt_25_1_ = lvt_25_1_ && (lvt_26_1_ & 0x800000) == 0x800000;
                        lvt_22_2_.clear();
                        if ((lvt_26_1_ & 0x200000) == 0x200000) {
                            for (EnumFacing lvt_32_1_ : EnumFacing.Plane.HORIZONTAL.facings()) {
                                if (lvt_17_1_.get(lvt_24_1_ + lvt_32_1_.getFrontOffsetX(), lvt_23_1_ + lvt_32_1_.getFrontOffsetZ()) != 1) continue;
                                lvt_22_2_.add(lvt_32_1_);
                            }
                        }
                        EnumFacing lvt_29_1_ = null;
                        if (!lvt_22_2_.isEmpty()) {
                            lvt_29_1_ = (EnumFacing)lvt_22_2_.get(this.random.nextInt(lvt_22_2_.size()));
                        } else if ((lvt_26_1_ & 0x100000) == 0x100000) {
                            lvt_29_1_ = EnumFacing.UP;
                        }
                        BlockPos lvt_30_1_ = lvt_15_1_.offset(p_createMansion_2_.rotate(EnumFacing.SOUTH), 8 + (lvt_23_1_ - this.startY) * 8);
                        lvt_30_1_ = lvt_30_1_.offset(p_createMansion_2_.rotate(EnumFacing.EAST), -1 + (lvt_24_1_ - this.startX) * 8);
                        if (Grid.isHouse(lvt_17_1_, lvt_24_1_ - 1, lvt_23_1_) && !p_createMansion_4_.isRoomId(lvt_17_1_, lvt_24_1_ - 1, lvt_23_1_, lvt_14_2_, lvt_28_1_)) {
                            p_createMansion_3_.add(new MansionTemplate(this.templateManager, lvt_29_1_ == EnumFacing.WEST ? lvt_21_2_ : lvt_20_2_, lvt_30_1_, p_createMansion_2_));
                        }
                        if (lvt_17_1_.get(lvt_24_1_ + 1, lvt_23_1_) == 1 && !lvt_25_1_) {
                            BlockPos lvt_31_1_ = lvt_30_1_.offset(p_createMansion_2_.rotate(EnumFacing.EAST), 8);
                            p_createMansion_3_.add(new MansionTemplate(this.templateManager, lvt_29_1_ == EnumFacing.EAST ? lvt_21_2_ : lvt_20_2_, lvt_31_1_, p_createMansion_2_));
                        }
                        if (Grid.isHouse(lvt_17_1_, lvt_24_1_, lvt_23_1_ + 1) && !p_createMansion_4_.isRoomId(lvt_17_1_, lvt_24_1_, lvt_23_1_ + 1, lvt_14_2_, lvt_28_1_)) {
                            BlockPos lvt_31_2_ = lvt_30_1_.offset(p_createMansion_2_.rotate(EnumFacing.SOUTH), 7);
                            lvt_31_2_ = lvt_31_2_.offset(p_createMansion_2_.rotate(EnumFacing.EAST), 7);
                            p_createMansion_3_.add(new MansionTemplate(this.templateManager, lvt_29_1_ == EnumFacing.SOUTH ? lvt_21_2_ : lvt_20_2_, lvt_31_2_, p_createMansion_2_.add(Rotation.CLOCKWISE_90)));
                        }
                        if (lvt_17_1_.get(lvt_24_1_, lvt_23_1_ - 1) == 1 && !lvt_25_1_) {
                            BlockPos lvt_31_3_ = lvt_30_1_.offset(p_createMansion_2_.rotate(EnumFacing.NORTH), 1);
                            lvt_31_3_ = lvt_31_3_.offset(p_createMansion_2_.rotate(EnumFacing.EAST), 7);
                            p_createMansion_3_.add(new MansionTemplate(this.templateManager, lvt_29_1_ == EnumFacing.NORTH ? lvt_21_2_ : lvt_20_2_, lvt_31_3_, p_createMansion_2_.add(Rotation.CLOCKWISE_90)));
                        }
                        if (lvt_27_1_ == 65536) {
                            this.addRoom1x1(p_createMansion_3_, lvt_30_1_, p_createMansion_2_, lvt_29_1_, lvt_13_2_[lvt_14_2_]);
                            continue;
                        }
                        if (lvt_27_1_ == 131072 && lvt_29_1_ != null) {
                            EnumFacing lvt_31_4_ = p_createMansion_4_.get1x2RoomDirection(lvt_17_1_, lvt_24_1_, lvt_23_1_, lvt_14_2_, lvt_28_1_);
                            boolean lvt_32_2_ = (lvt_26_1_ & 0x400000) == 0x400000;
                            this.addRoom1x2(p_createMansion_3_, lvt_30_1_, p_createMansion_2_, lvt_31_4_, lvt_29_1_, lvt_13_2_[lvt_14_2_], lvt_32_2_);
                            continue;
                        }
                        if (lvt_27_1_ == 262144 && lvt_29_1_ != null && lvt_29_1_ != EnumFacing.UP) {
                            EnumFacing lvt_31_5_ = lvt_29_1_.rotateY();
                            if (!p_createMansion_4_.isRoomId(lvt_17_1_, lvt_24_1_ + lvt_31_5_.getFrontOffsetX(), lvt_23_1_ + lvt_31_5_.getFrontOffsetZ(), lvt_14_2_, lvt_28_1_)) {
                                lvt_31_5_ = lvt_31_5_.getOpposite();
                            }
                            this.addRoom2x2(p_createMansion_3_, lvt_30_1_, p_createMansion_2_, lvt_31_5_, lvt_29_1_, lvt_13_2_[lvt_14_2_]);
                            continue;
                        }
                        if (lvt_27_1_ != 262144 || lvt_29_1_ != EnumFacing.UP) continue;
                        this.addRoom2x2Secret(p_createMansion_3_, lvt_30_1_, p_createMansion_2_, lvt_13_2_[lvt_14_2_]);
                    }
                }
            }
        }

        private void traverseOuterWalls(List<MansionTemplate> p_traverseOuterWalls_1_, PlacementData p_traverseOuterWalls_2_, SimpleGrid p_traverseOuterWalls_3_, EnumFacing p_traverseOuterWalls_4_, int p_traverseOuterWalls_5_, int p_traverseOuterWalls_6_, int p_traverseOuterWalls_7_, int p_traverseOuterWalls_8_) {
            int lvt_9_1_ = p_traverseOuterWalls_5_;
            int lvt_10_1_ = p_traverseOuterWalls_6_;
            EnumFacing lvt_11_1_ = p_traverseOuterWalls_4_;
            do {
                if (!Grid.isHouse(p_traverseOuterWalls_3_, lvt_9_1_ + p_traverseOuterWalls_4_.getFrontOffsetX(), lvt_10_1_ + p_traverseOuterWalls_4_.getFrontOffsetZ())) {
                    this.traverseTurn(p_traverseOuterWalls_1_, p_traverseOuterWalls_2_);
                    p_traverseOuterWalls_4_ = p_traverseOuterWalls_4_.rotateY();
                    if (lvt_9_1_ == p_traverseOuterWalls_7_ && lvt_10_1_ == p_traverseOuterWalls_8_ && lvt_11_1_ == p_traverseOuterWalls_4_) continue;
                    this.traverseWallPiece(p_traverseOuterWalls_1_, p_traverseOuterWalls_2_);
                    continue;
                }
                if (Grid.isHouse(p_traverseOuterWalls_3_, lvt_9_1_ + p_traverseOuterWalls_4_.getFrontOffsetX(), lvt_10_1_ + p_traverseOuterWalls_4_.getFrontOffsetZ()) && Grid.isHouse(p_traverseOuterWalls_3_, lvt_9_1_ + p_traverseOuterWalls_4_.getFrontOffsetX() + p_traverseOuterWalls_4_.rotateYCCW().getFrontOffsetX(), lvt_10_1_ + p_traverseOuterWalls_4_.getFrontOffsetZ() + p_traverseOuterWalls_4_.rotateYCCW().getFrontOffsetZ())) {
                    this.traverseInnerTurn(p_traverseOuterWalls_1_, p_traverseOuterWalls_2_);
                    lvt_9_1_ += p_traverseOuterWalls_4_.getFrontOffsetX();
                    lvt_10_1_ += p_traverseOuterWalls_4_.getFrontOffsetZ();
                    p_traverseOuterWalls_4_ = p_traverseOuterWalls_4_.rotateYCCW();
                    continue;
                }
                if ((lvt_9_1_ += p_traverseOuterWalls_4_.getFrontOffsetX()) == p_traverseOuterWalls_7_ && (lvt_10_1_ += p_traverseOuterWalls_4_.getFrontOffsetZ()) == p_traverseOuterWalls_8_ && lvt_11_1_ == p_traverseOuterWalls_4_) continue;
                this.traverseWallPiece(p_traverseOuterWalls_1_, p_traverseOuterWalls_2_);
            } while (lvt_9_1_ != p_traverseOuterWalls_7_ || lvt_10_1_ != p_traverseOuterWalls_8_ || lvt_11_1_ != p_traverseOuterWalls_4_);
        }

        private void createRoof(List<MansionTemplate> p_createRoof_1_, BlockPos p_createRoof_2_, Rotation p_createRoof_3_, SimpleGrid p_createRoof_4_, SimpleGrid p_createRoof_5_) {
            for (int lvt_6_1_ = 0; lvt_6_1_ < p_createRoof_4_.height; ++lvt_6_1_) {
                for (int lvt_7_1_ = 0; lvt_7_1_ < p_createRoof_4_.width; ++lvt_7_1_) {
                    boolean lvt_9_1_;
                    BlockPos lvt_8_1_ = p_createRoof_2_;
                    lvt_8_1_ = lvt_8_1_.offset(p_createRoof_3_.rotate(EnumFacing.SOUTH), 8 + (lvt_6_1_ - this.startY) * 8);
                    lvt_8_1_ = lvt_8_1_.offset(p_createRoof_3_.rotate(EnumFacing.EAST), (lvt_7_1_ - this.startX) * 8);
                    boolean bl = lvt_9_1_ = p_createRoof_5_ != null && Grid.isHouse(p_createRoof_5_, lvt_7_1_, lvt_6_1_);
                    if (!Grid.isHouse(p_createRoof_4_, lvt_7_1_, lvt_6_1_) || lvt_9_1_) continue;
                    p_createRoof_1_.add(new MansionTemplate(this.templateManager, "roof", lvt_8_1_.up(3), p_createRoof_3_));
                    if (!Grid.isHouse(p_createRoof_4_, lvt_7_1_ + 1, lvt_6_1_)) {
                        BlockPos lvt_10_1_ = lvt_8_1_.offset(p_createRoof_3_.rotate(EnumFacing.EAST), 6);
                        p_createRoof_1_.add(new MansionTemplate(this.templateManager, "roof_front", lvt_10_1_, p_createRoof_3_));
                    }
                    if (!Grid.isHouse(p_createRoof_4_, lvt_7_1_ - 1, lvt_6_1_)) {
                        BlockPos lvt_10_2_ = lvt_8_1_.offset(p_createRoof_3_.rotate(EnumFacing.EAST), 0);
                        lvt_10_2_ = lvt_10_2_.offset(p_createRoof_3_.rotate(EnumFacing.SOUTH), 7);
                        p_createRoof_1_.add(new MansionTemplate(this.templateManager, "roof_front", lvt_10_2_, p_createRoof_3_.add(Rotation.CLOCKWISE_180)));
                    }
                    if (!Grid.isHouse(p_createRoof_4_, lvt_7_1_, lvt_6_1_ - 1)) {
                        BlockPos lvt_10_3_ = lvt_8_1_.offset(p_createRoof_3_.rotate(EnumFacing.WEST), 1);
                        p_createRoof_1_.add(new MansionTemplate(this.templateManager, "roof_front", lvt_10_3_, p_createRoof_3_.add(Rotation.COUNTERCLOCKWISE_90)));
                    }
                    if (Grid.isHouse(p_createRoof_4_, lvt_7_1_, lvt_6_1_ + 1)) continue;
                    BlockPos lvt_10_4_ = lvt_8_1_.offset(p_createRoof_3_.rotate(EnumFacing.EAST), 6);
                    lvt_10_4_ = lvt_10_4_.offset(p_createRoof_3_.rotate(EnumFacing.SOUTH), 6);
                    p_createRoof_1_.add(new MansionTemplate(this.templateManager, "roof_front", lvt_10_4_, p_createRoof_3_.add(Rotation.CLOCKWISE_90)));
                }
            }
            if (p_createRoof_5_ != null) {
                for (int lvt_6_2_ = 0; lvt_6_2_ < p_createRoof_4_.height; ++lvt_6_2_) {
                    for (int lvt_7_2_ = 0; lvt_7_2_ < p_createRoof_4_.width; ++lvt_7_2_) {
                        BlockPos lvt_8_2_ = p_createRoof_2_;
                        lvt_8_2_ = lvt_8_2_.offset(p_createRoof_3_.rotate(EnumFacing.SOUTH), 8 + (lvt_6_2_ - this.startY) * 8);
                        lvt_8_2_ = lvt_8_2_.offset(p_createRoof_3_.rotate(EnumFacing.EAST), (lvt_7_2_ - this.startX) * 8);
                        boolean lvt_9_2_ = Grid.isHouse(p_createRoof_5_, lvt_7_2_, lvt_6_2_);
                        if (!Grid.isHouse(p_createRoof_4_, lvt_7_2_, lvt_6_2_) || !lvt_9_2_) continue;
                        if (!Grid.isHouse(p_createRoof_4_, lvt_7_2_ + 1, lvt_6_2_)) {
                            BlockPos lvt_10_5_ = lvt_8_2_.offset(p_createRoof_3_.rotate(EnumFacing.EAST), 7);
                            p_createRoof_1_.add(new MansionTemplate(this.templateManager, "small_wall", lvt_10_5_, p_createRoof_3_));
                        }
                        if (!Grid.isHouse(p_createRoof_4_, lvt_7_2_ - 1, lvt_6_2_)) {
                            BlockPos lvt_10_6_ = lvt_8_2_.offset(p_createRoof_3_.rotate(EnumFacing.WEST), 1);
                            lvt_10_6_ = lvt_10_6_.offset(p_createRoof_3_.rotate(EnumFacing.SOUTH), 6);
                            p_createRoof_1_.add(new MansionTemplate(this.templateManager, "small_wall", lvt_10_6_, p_createRoof_3_.add(Rotation.CLOCKWISE_180)));
                        }
                        if (!Grid.isHouse(p_createRoof_4_, lvt_7_2_, lvt_6_2_ - 1)) {
                            BlockPos lvt_10_7_ = lvt_8_2_.offset(p_createRoof_3_.rotate(EnumFacing.WEST), 0);
                            lvt_10_7_ = lvt_10_7_.offset(p_createRoof_3_.rotate(EnumFacing.NORTH), 1);
                            p_createRoof_1_.add(new MansionTemplate(this.templateManager, "small_wall", lvt_10_7_, p_createRoof_3_.add(Rotation.COUNTERCLOCKWISE_90)));
                        }
                        if (!Grid.isHouse(p_createRoof_4_, lvt_7_2_, lvt_6_2_ + 1)) {
                            BlockPos lvt_10_8_ = lvt_8_2_.offset(p_createRoof_3_.rotate(EnumFacing.EAST), 6);
                            lvt_10_8_ = lvt_10_8_.offset(p_createRoof_3_.rotate(EnumFacing.SOUTH), 7);
                            p_createRoof_1_.add(new MansionTemplate(this.templateManager, "small_wall", lvt_10_8_, p_createRoof_3_.add(Rotation.CLOCKWISE_90)));
                        }
                        if (!Grid.isHouse(p_createRoof_4_, lvt_7_2_ + 1, lvt_6_2_)) {
                            if (!Grid.isHouse(p_createRoof_4_, lvt_7_2_, lvt_6_2_ - 1)) {
                                BlockPos lvt_10_9_ = lvt_8_2_.offset(p_createRoof_3_.rotate(EnumFacing.EAST), 7);
                                lvt_10_9_ = lvt_10_9_.offset(p_createRoof_3_.rotate(EnumFacing.NORTH), 2);
                                p_createRoof_1_.add(new MansionTemplate(this.templateManager, "small_wall_corner", lvt_10_9_, p_createRoof_3_));
                            }
                            if (!Grid.isHouse(p_createRoof_4_, lvt_7_2_, lvt_6_2_ + 1)) {
                                BlockPos lvt_10_10_ = lvt_8_2_.offset(p_createRoof_3_.rotate(EnumFacing.EAST), 8);
                                lvt_10_10_ = lvt_10_10_.offset(p_createRoof_3_.rotate(EnumFacing.SOUTH), 7);
                                p_createRoof_1_.add(new MansionTemplate(this.templateManager, "small_wall_corner", lvt_10_10_, p_createRoof_3_.add(Rotation.CLOCKWISE_90)));
                            }
                        }
                        if (Grid.isHouse(p_createRoof_4_, lvt_7_2_ - 1, lvt_6_2_)) continue;
                        if (!Grid.isHouse(p_createRoof_4_, lvt_7_2_, lvt_6_2_ - 1)) {
                            BlockPos lvt_10_11_ = lvt_8_2_.offset(p_createRoof_3_.rotate(EnumFacing.WEST), 2);
                            lvt_10_11_ = lvt_10_11_.offset(p_createRoof_3_.rotate(EnumFacing.NORTH), 1);
                            p_createRoof_1_.add(new MansionTemplate(this.templateManager, "small_wall_corner", lvt_10_11_, p_createRoof_3_.add(Rotation.COUNTERCLOCKWISE_90)));
                        }
                        if (Grid.isHouse(p_createRoof_4_, lvt_7_2_, lvt_6_2_ + 1)) continue;
                        BlockPos lvt_10_12_ = lvt_8_2_.offset(p_createRoof_3_.rotate(EnumFacing.WEST), 1);
                        lvt_10_12_ = lvt_10_12_.offset(p_createRoof_3_.rotate(EnumFacing.SOUTH), 8);
                        p_createRoof_1_.add(new MansionTemplate(this.templateManager, "small_wall_corner", lvt_10_12_, p_createRoof_3_.add(Rotation.CLOCKWISE_180)));
                    }
                }
            }
            for (int lvt_6_3_ = 0; lvt_6_3_ < p_createRoof_4_.height; ++lvt_6_3_) {
                for (int lvt_7_3_ = 0; lvt_7_3_ < p_createRoof_4_.width; ++lvt_7_3_) {
                    boolean lvt_9_3_;
                    BlockPos lvt_8_3_ = p_createRoof_2_;
                    lvt_8_3_ = lvt_8_3_.offset(p_createRoof_3_.rotate(EnumFacing.SOUTH), 8 + (lvt_6_3_ - this.startY) * 8);
                    lvt_8_3_ = lvt_8_3_.offset(p_createRoof_3_.rotate(EnumFacing.EAST), (lvt_7_3_ - this.startX) * 8);
                    boolean bl = lvt_9_3_ = p_createRoof_5_ != null && Grid.isHouse(p_createRoof_5_, lvt_7_3_, lvt_6_3_);
                    if (!Grid.isHouse(p_createRoof_4_, lvt_7_3_, lvt_6_3_) || lvt_9_3_) continue;
                    if (!Grid.isHouse(p_createRoof_4_, lvt_7_3_ + 1, lvt_6_3_)) {
                        BlockPos lvt_10_13_ = lvt_8_3_.offset(p_createRoof_3_.rotate(EnumFacing.EAST), 6);
                        if (!Grid.isHouse(p_createRoof_4_, lvt_7_3_, lvt_6_3_ + 1)) {
                            BlockPos lvt_11_1_ = lvt_10_13_.offset(p_createRoof_3_.rotate(EnumFacing.SOUTH), 6);
                            p_createRoof_1_.add(new MansionTemplate(this.templateManager, "roof_corner", lvt_11_1_, p_createRoof_3_));
                        } else if (Grid.isHouse(p_createRoof_4_, lvt_7_3_ + 1, lvt_6_3_ + 1)) {
                            BlockPos lvt_11_2_ = lvt_10_13_.offset(p_createRoof_3_.rotate(EnumFacing.SOUTH), 5);
                            p_createRoof_1_.add(new MansionTemplate(this.templateManager, "roof_inner_corner", lvt_11_2_, p_createRoof_3_));
                        }
                        if (!Grid.isHouse(p_createRoof_4_, lvt_7_3_, lvt_6_3_ - 1)) {
                            BlockPos lvt_11_3_ = lvt_10_13_;
                            p_createRoof_1_.add(new MansionTemplate(this.templateManager, "roof_corner", lvt_11_3_, p_createRoof_3_.add(Rotation.COUNTERCLOCKWISE_90)));
                        } else if (Grid.isHouse(p_createRoof_4_, lvt_7_3_ + 1, lvt_6_3_ - 1)) {
                            BlockPos lvt_11_4_ = lvt_8_3_.offset(p_createRoof_3_.rotate(EnumFacing.EAST), 9);
                            lvt_11_4_ = lvt_11_4_.offset(p_createRoof_3_.rotate(EnumFacing.NORTH), 2);
                            p_createRoof_1_.add(new MansionTemplate(this.templateManager, "roof_inner_corner", lvt_11_4_, p_createRoof_3_.add(Rotation.CLOCKWISE_90)));
                        }
                    }
                    if (Grid.isHouse(p_createRoof_4_, lvt_7_3_ - 1, lvt_6_3_)) continue;
                    BlockPos lvt_10_14_ = lvt_8_3_.offset(p_createRoof_3_.rotate(EnumFacing.EAST), 0);
                    lvt_10_14_ = lvt_10_14_.offset(p_createRoof_3_.rotate(EnumFacing.SOUTH), 0);
                    if (!Grid.isHouse(p_createRoof_4_, lvt_7_3_, lvt_6_3_ + 1)) {
                        BlockPos lvt_11_5_ = lvt_10_14_.offset(p_createRoof_3_.rotate(EnumFacing.SOUTH), 6);
                        p_createRoof_1_.add(new MansionTemplate(this.templateManager, "roof_corner", lvt_11_5_, p_createRoof_3_.add(Rotation.CLOCKWISE_90)));
                    } else if (Grid.isHouse(p_createRoof_4_, lvt_7_3_ - 1, lvt_6_3_ + 1)) {
                        BlockPos lvt_11_6_ = lvt_10_14_.offset(p_createRoof_3_.rotate(EnumFacing.SOUTH), 8);
                        lvt_11_6_ = lvt_11_6_.offset(p_createRoof_3_.rotate(EnumFacing.WEST), 3);
                        p_createRoof_1_.add(new MansionTemplate(this.templateManager, "roof_inner_corner", lvt_11_6_, p_createRoof_3_.add(Rotation.COUNTERCLOCKWISE_90)));
                    }
                    if (!Grid.isHouse(p_createRoof_4_, lvt_7_3_, lvt_6_3_ - 1)) {
                        BlockPos lvt_11_7_ = lvt_10_14_;
                        p_createRoof_1_.add(new MansionTemplate(this.templateManager, "roof_corner", lvt_11_7_, p_createRoof_3_.add(Rotation.CLOCKWISE_180)));
                        continue;
                    }
                    if (!Grid.isHouse(p_createRoof_4_, lvt_7_3_ - 1, lvt_6_3_ - 1)) continue;
                    BlockPos lvt_11_8_ = lvt_10_14_.offset(p_createRoof_3_.rotate(EnumFacing.SOUTH), 1);
                    p_createRoof_1_.add(new MansionTemplate(this.templateManager, "roof_inner_corner", lvt_11_8_, p_createRoof_3_.add(Rotation.CLOCKWISE_180)));
                }
            }
        }

        private void entrance(List<MansionTemplate> p_entrance_1_, PlacementData p_entrance_2_) {
            EnumFacing lvt_3_1_ = p_entrance_2_.rotation.rotate(EnumFacing.WEST);
            p_entrance_1_.add(new MansionTemplate(this.templateManager, "entrance", p_entrance_2_.position.offset(lvt_3_1_, 9), p_entrance_2_.rotation));
            p_entrance_2_.position = p_entrance_2_.position.offset(p_entrance_2_.rotation.rotate(EnumFacing.SOUTH), 16);
        }

        private void traverseWallPiece(List<MansionTemplate> p_traverseWallPiece_1_, PlacementData p_traverseWallPiece_2_) {
            p_traverseWallPiece_1_.add(new MansionTemplate(this.templateManager, p_traverseWallPiece_2_.wallType, p_traverseWallPiece_2_.position.offset(p_traverseWallPiece_2_.rotation.rotate(EnumFacing.EAST), 7), p_traverseWallPiece_2_.rotation));
            p_traverseWallPiece_2_.position = p_traverseWallPiece_2_.position.offset(p_traverseWallPiece_2_.rotation.rotate(EnumFacing.SOUTH), 8);
        }

        private void traverseTurn(List<MansionTemplate> p_traverseTurn_1_, PlacementData p_traverseTurn_2_) {
            p_traverseTurn_2_.position = p_traverseTurn_2_.position.offset(p_traverseTurn_2_.rotation.rotate(EnumFacing.SOUTH), -1);
            p_traverseTurn_1_.add(new MansionTemplate(this.templateManager, "wall_corner", p_traverseTurn_2_.position, p_traverseTurn_2_.rotation));
            p_traverseTurn_2_.position = p_traverseTurn_2_.position.offset(p_traverseTurn_2_.rotation.rotate(EnumFacing.SOUTH), -7);
            p_traverseTurn_2_.position = p_traverseTurn_2_.position.offset(p_traverseTurn_2_.rotation.rotate(EnumFacing.WEST), -6);
            p_traverseTurn_2_.rotation = p_traverseTurn_2_.rotation.add(Rotation.CLOCKWISE_90);
        }

        private void traverseInnerTurn(List<MansionTemplate> p_traverseInnerTurn_1_, PlacementData p_traverseInnerTurn_2_) {
            p_traverseInnerTurn_2_.position = p_traverseInnerTurn_2_.position.offset(p_traverseInnerTurn_2_.rotation.rotate(EnumFacing.SOUTH), 6);
            p_traverseInnerTurn_2_.position = p_traverseInnerTurn_2_.position.offset(p_traverseInnerTurn_2_.rotation.rotate(EnumFacing.EAST), 8);
            p_traverseInnerTurn_2_.rotation = p_traverseInnerTurn_2_.rotation.add(Rotation.COUNTERCLOCKWISE_90);
        }

        private void addRoom1x1(List<MansionTemplate> p_addRoom1x1_1_, BlockPos p_addRoom1x1_2_, Rotation p_addRoom1x1_3_, EnumFacing p_addRoom1x1_4_, RoomCollection p_addRoom1x1_5_) {
            Rotation lvt_6_1_ = Rotation.NONE;
            String lvt_7_1_ = p_addRoom1x1_5_.get1x1(this.random);
            if (p_addRoom1x1_4_ != EnumFacing.EAST) {
                if (p_addRoom1x1_4_ == EnumFacing.NORTH) {
                    lvt_6_1_ = lvt_6_1_.add(Rotation.COUNTERCLOCKWISE_90);
                } else if (p_addRoom1x1_4_ == EnumFacing.WEST) {
                    lvt_6_1_ = lvt_6_1_.add(Rotation.CLOCKWISE_180);
                } else if (p_addRoom1x1_4_ == EnumFacing.SOUTH) {
                    lvt_6_1_ = lvt_6_1_.add(Rotation.CLOCKWISE_90);
                } else {
                    lvt_7_1_ = p_addRoom1x1_5_.get1x1Secret(this.random);
                }
            }
            BlockPos lvt_8_1_ = Template.getZeroPositionWithTransform(new BlockPos(1, 0, 0), Mirror.NONE, lvt_6_1_, 7, 7);
            lvt_6_1_ = lvt_6_1_.add(p_addRoom1x1_3_);
            lvt_8_1_ = lvt_8_1_.rotate(p_addRoom1x1_3_);
            BlockPos lvt_9_1_ = p_addRoom1x1_2_.add(lvt_8_1_.getX(), 0, lvt_8_1_.getZ());
            p_addRoom1x1_1_.add(new MansionTemplate(this.templateManager, lvt_7_1_, lvt_9_1_, lvt_6_1_));
        }

        private void addRoom1x2(List<MansionTemplate> p_addRoom1x2_1_, BlockPos p_addRoom1x2_2_, Rotation p_addRoom1x2_3_, EnumFacing p_addRoom1x2_4_, EnumFacing p_addRoom1x2_5_, RoomCollection p_addRoom1x2_6_, boolean p_addRoom1x2_7_) {
            if (p_addRoom1x2_5_ == EnumFacing.EAST && p_addRoom1x2_4_ == EnumFacing.SOUTH) {
                BlockPos lvt_8_1_ = p_addRoom1x2_2_.offset(p_addRoom1x2_3_.rotate(EnumFacing.EAST), 1);
                p_addRoom1x2_1_.add(new MansionTemplate(this.templateManager, p_addRoom1x2_6_.get1x2SideEntrance(this.random, p_addRoom1x2_7_), lvt_8_1_, p_addRoom1x2_3_));
            } else if (p_addRoom1x2_5_ == EnumFacing.EAST && p_addRoom1x2_4_ == EnumFacing.NORTH) {
                BlockPos lvt_8_2_ = p_addRoom1x2_2_.offset(p_addRoom1x2_3_.rotate(EnumFacing.EAST), 1);
                lvt_8_2_ = lvt_8_2_.offset(p_addRoom1x2_3_.rotate(EnumFacing.SOUTH), 6);
                p_addRoom1x2_1_.add(new MansionTemplate(this.templateManager, p_addRoom1x2_6_.get1x2SideEntrance(this.random, p_addRoom1x2_7_), lvt_8_2_, p_addRoom1x2_3_, Mirror.LEFT_RIGHT));
            } else if (p_addRoom1x2_5_ == EnumFacing.WEST && p_addRoom1x2_4_ == EnumFacing.NORTH) {
                BlockPos lvt_8_3_ = p_addRoom1x2_2_.offset(p_addRoom1x2_3_.rotate(EnumFacing.EAST), 7);
                lvt_8_3_ = lvt_8_3_.offset(p_addRoom1x2_3_.rotate(EnumFacing.SOUTH), 6);
                p_addRoom1x2_1_.add(new MansionTemplate(this.templateManager, p_addRoom1x2_6_.get1x2SideEntrance(this.random, p_addRoom1x2_7_), lvt_8_3_, p_addRoom1x2_3_.add(Rotation.CLOCKWISE_180)));
            } else if (p_addRoom1x2_5_ == EnumFacing.WEST && p_addRoom1x2_4_ == EnumFacing.SOUTH) {
                BlockPos lvt_8_4_ = p_addRoom1x2_2_.offset(p_addRoom1x2_3_.rotate(EnumFacing.EAST), 7);
                p_addRoom1x2_1_.add(new MansionTemplate(this.templateManager, p_addRoom1x2_6_.get1x2SideEntrance(this.random, p_addRoom1x2_7_), lvt_8_4_, p_addRoom1x2_3_, Mirror.FRONT_BACK));
            } else if (p_addRoom1x2_5_ == EnumFacing.SOUTH && p_addRoom1x2_4_ == EnumFacing.EAST) {
                BlockPos lvt_8_5_ = p_addRoom1x2_2_.offset(p_addRoom1x2_3_.rotate(EnumFacing.EAST), 1);
                p_addRoom1x2_1_.add(new MansionTemplate(this.templateManager, p_addRoom1x2_6_.get1x2SideEntrance(this.random, p_addRoom1x2_7_), lvt_8_5_, p_addRoom1x2_3_.add(Rotation.CLOCKWISE_90), Mirror.LEFT_RIGHT));
            } else if (p_addRoom1x2_5_ == EnumFacing.SOUTH && p_addRoom1x2_4_ == EnumFacing.WEST) {
                BlockPos lvt_8_6_ = p_addRoom1x2_2_.offset(p_addRoom1x2_3_.rotate(EnumFacing.EAST), 7);
                p_addRoom1x2_1_.add(new MansionTemplate(this.templateManager, p_addRoom1x2_6_.get1x2SideEntrance(this.random, p_addRoom1x2_7_), lvt_8_6_, p_addRoom1x2_3_.add(Rotation.CLOCKWISE_90)));
            } else if (p_addRoom1x2_5_ == EnumFacing.NORTH && p_addRoom1x2_4_ == EnumFacing.WEST) {
                BlockPos lvt_8_7_ = p_addRoom1x2_2_.offset(p_addRoom1x2_3_.rotate(EnumFacing.EAST), 7);
                lvt_8_7_ = lvt_8_7_.offset(p_addRoom1x2_3_.rotate(EnumFacing.SOUTH), 6);
                p_addRoom1x2_1_.add(new MansionTemplate(this.templateManager, p_addRoom1x2_6_.get1x2SideEntrance(this.random, p_addRoom1x2_7_), lvt_8_7_, p_addRoom1x2_3_.add(Rotation.CLOCKWISE_90), Mirror.FRONT_BACK));
            } else if (p_addRoom1x2_5_ == EnumFacing.NORTH && p_addRoom1x2_4_ == EnumFacing.EAST) {
                BlockPos lvt_8_8_ = p_addRoom1x2_2_.offset(p_addRoom1x2_3_.rotate(EnumFacing.EAST), 1);
                lvt_8_8_ = lvt_8_8_.offset(p_addRoom1x2_3_.rotate(EnumFacing.SOUTH), 6);
                p_addRoom1x2_1_.add(new MansionTemplate(this.templateManager, p_addRoom1x2_6_.get1x2SideEntrance(this.random, p_addRoom1x2_7_), lvt_8_8_, p_addRoom1x2_3_.add(Rotation.COUNTERCLOCKWISE_90)));
            } else if (p_addRoom1x2_5_ == EnumFacing.SOUTH && p_addRoom1x2_4_ == EnumFacing.NORTH) {
                BlockPos lvt_8_9_ = p_addRoom1x2_2_.offset(p_addRoom1x2_3_.rotate(EnumFacing.EAST), 1);
                lvt_8_9_ = lvt_8_9_.offset(p_addRoom1x2_3_.rotate(EnumFacing.NORTH), 8);
                p_addRoom1x2_1_.add(new MansionTemplate(this.templateManager, p_addRoom1x2_6_.get1x2FrontEntrance(this.random, p_addRoom1x2_7_), lvt_8_9_, p_addRoom1x2_3_));
            } else if (p_addRoom1x2_5_ == EnumFacing.NORTH && p_addRoom1x2_4_ == EnumFacing.SOUTH) {
                BlockPos lvt_8_10_ = p_addRoom1x2_2_.offset(p_addRoom1x2_3_.rotate(EnumFacing.EAST), 7);
                lvt_8_10_ = lvt_8_10_.offset(p_addRoom1x2_3_.rotate(EnumFacing.SOUTH), 14);
                p_addRoom1x2_1_.add(new MansionTemplate(this.templateManager, p_addRoom1x2_6_.get1x2FrontEntrance(this.random, p_addRoom1x2_7_), lvt_8_10_, p_addRoom1x2_3_.add(Rotation.CLOCKWISE_180)));
            } else if (p_addRoom1x2_5_ == EnumFacing.WEST && p_addRoom1x2_4_ == EnumFacing.EAST) {
                BlockPos lvt_8_11_ = p_addRoom1x2_2_.offset(p_addRoom1x2_3_.rotate(EnumFacing.EAST), 15);
                p_addRoom1x2_1_.add(new MansionTemplate(this.templateManager, p_addRoom1x2_6_.get1x2FrontEntrance(this.random, p_addRoom1x2_7_), lvt_8_11_, p_addRoom1x2_3_.add(Rotation.CLOCKWISE_90)));
            } else if (p_addRoom1x2_5_ == EnumFacing.EAST && p_addRoom1x2_4_ == EnumFacing.WEST) {
                BlockPos lvt_8_12_ = p_addRoom1x2_2_.offset(p_addRoom1x2_3_.rotate(EnumFacing.WEST), 7);
                lvt_8_12_ = lvt_8_12_.offset(p_addRoom1x2_3_.rotate(EnumFacing.SOUTH), 6);
                p_addRoom1x2_1_.add(new MansionTemplate(this.templateManager, p_addRoom1x2_6_.get1x2FrontEntrance(this.random, p_addRoom1x2_7_), lvt_8_12_, p_addRoom1x2_3_.add(Rotation.COUNTERCLOCKWISE_90)));
            } else if (p_addRoom1x2_5_ == EnumFacing.UP && p_addRoom1x2_4_ == EnumFacing.EAST) {
                BlockPos lvt_8_13_ = p_addRoom1x2_2_.offset(p_addRoom1x2_3_.rotate(EnumFacing.EAST), 15);
                p_addRoom1x2_1_.add(new MansionTemplate(this.templateManager, p_addRoom1x2_6_.get1x2Secret(this.random), lvt_8_13_, p_addRoom1x2_3_.add(Rotation.CLOCKWISE_90)));
            } else if (p_addRoom1x2_5_ == EnumFacing.UP && p_addRoom1x2_4_ == EnumFacing.SOUTH) {
                BlockPos lvt_8_14_ = p_addRoom1x2_2_.offset(p_addRoom1x2_3_.rotate(EnumFacing.EAST), 1);
                lvt_8_14_ = lvt_8_14_.offset(p_addRoom1x2_3_.rotate(EnumFacing.NORTH), 0);
                p_addRoom1x2_1_.add(new MansionTemplate(this.templateManager, p_addRoom1x2_6_.get1x2Secret(this.random), lvt_8_14_, p_addRoom1x2_3_));
            }
        }

        private void addRoom2x2(List<MansionTemplate> p_addRoom2x2_1_, BlockPos p_addRoom2x2_2_, Rotation p_addRoom2x2_3_, EnumFacing p_addRoom2x2_4_, EnumFacing p_addRoom2x2_5_, RoomCollection p_addRoom2x2_6_) {
            int lvt_7_1_ = 0;
            int lvt_8_1_ = 0;
            Rotation lvt_9_1_ = p_addRoom2x2_3_;
            Mirror lvt_10_1_ = Mirror.NONE;
            if (p_addRoom2x2_5_ == EnumFacing.EAST && p_addRoom2x2_4_ == EnumFacing.SOUTH) {
                lvt_7_1_ = -7;
            } else if (p_addRoom2x2_5_ == EnumFacing.EAST && p_addRoom2x2_4_ == EnumFacing.NORTH) {
                lvt_7_1_ = -7;
                lvt_8_1_ = 6;
                lvt_10_1_ = Mirror.LEFT_RIGHT;
            } else if (p_addRoom2x2_5_ == EnumFacing.NORTH && p_addRoom2x2_4_ == EnumFacing.EAST) {
                lvt_7_1_ = 1;
                lvt_8_1_ = 14;
                lvt_9_1_ = p_addRoom2x2_3_.add(Rotation.COUNTERCLOCKWISE_90);
            } else if (p_addRoom2x2_5_ == EnumFacing.NORTH && p_addRoom2x2_4_ == EnumFacing.WEST) {
                lvt_7_1_ = 7;
                lvt_8_1_ = 14;
                lvt_9_1_ = p_addRoom2x2_3_.add(Rotation.COUNTERCLOCKWISE_90);
                lvt_10_1_ = Mirror.LEFT_RIGHT;
            } else if (p_addRoom2x2_5_ == EnumFacing.SOUTH && p_addRoom2x2_4_ == EnumFacing.WEST) {
                lvt_7_1_ = 7;
                lvt_8_1_ = -8;
                lvt_9_1_ = p_addRoom2x2_3_.add(Rotation.CLOCKWISE_90);
            } else if (p_addRoom2x2_5_ == EnumFacing.SOUTH && p_addRoom2x2_4_ == EnumFacing.EAST) {
                lvt_7_1_ = 1;
                lvt_8_1_ = -8;
                lvt_9_1_ = p_addRoom2x2_3_.add(Rotation.CLOCKWISE_90);
                lvt_10_1_ = Mirror.LEFT_RIGHT;
            } else if (p_addRoom2x2_5_ == EnumFacing.WEST && p_addRoom2x2_4_ == EnumFacing.NORTH) {
                lvt_7_1_ = 15;
                lvt_8_1_ = 6;
                lvt_9_1_ = p_addRoom2x2_3_.add(Rotation.CLOCKWISE_180);
            } else if (p_addRoom2x2_5_ == EnumFacing.WEST && p_addRoom2x2_4_ == EnumFacing.SOUTH) {
                lvt_7_1_ = 15;
                lvt_10_1_ = Mirror.FRONT_BACK;
            }
            BlockPos lvt_11_1_ = p_addRoom2x2_2_.offset(p_addRoom2x2_3_.rotate(EnumFacing.EAST), lvt_7_1_);
            lvt_11_1_ = lvt_11_1_.offset(p_addRoom2x2_3_.rotate(EnumFacing.SOUTH), lvt_8_1_);
            p_addRoom2x2_1_.add(new MansionTemplate(this.templateManager, p_addRoom2x2_6_.get2x2(this.random), lvt_11_1_, lvt_9_1_, lvt_10_1_));
        }

        private void addRoom2x2Secret(List<MansionTemplate> p_addRoom2x2Secret_1_, BlockPos p_addRoom2x2Secret_2_, Rotation p_addRoom2x2Secret_3_, RoomCollection p_addRoom2x2Secret_4_) {
            BlockPos lvt_5_1_ = p_addRoom2x2Secret_2_.offset(p_addRoom2x2Secret_3_.rotate(EnumFacing.EAST), 1);
            p_addRoom2x2Secret_1_.add(new MansionTemplate(this.templateManager, p_addRoom2x2Secret_4_.get2x2Secret(this.random), lvt_5_1_, p_addRoom2x2Secret_3_, Mirror.NONE));
        }
    }

    static class PlacementData {
        public Rotation rotation;
        public BlockPos position;
        public String wallType;

        private PlacementData() {
        }
    }

    public static class MansionTemplate
    extends StructureComponentTemplate {
        private String templateName;
        private Rotation rotation;
        private Mirror mirror;

        public MansionTemplate() {
        }

        public MansionTemplate(TemplateManager p_i47355_1_, String p_i47355_2_, BlockPos p_i47355_3_, Rotation p_i47355_4_) {
            this(p_i47355_1_, p_i47355_2_, p_i47355_3_, p_i47355_4_, Mirror.NONE);
        }

        public MansionTemplate(TemplateManager p_i47356_1_, String p_i47356_2_, BlockPos p_i47356_3_, Rotation p_i47356_4_, Mirror p_i47356_5_) {
            super(0);
            this.templateName = p_i47356_2_;
            this.templatePosition = p_i47356_3_;
            this.rotation = p_i47356_4_;
            this.mirror = p_i47356_5_;
            this.loadTemplate(p_i47356_1_);
        }

        private void loadTemplate(TemplateManager p_loadTemplate_1_) {
            Template lvt_2_1_ = p_loadTemplate_1_.getTemplate(null, new ResourceLocation("mansion/" + this.templateName));
            PlacementSettings lvt_3_1_ = new PlacementSettings().setIgnoreEntities(true).setRotation(this.rotation).setMirror(this.mirror);
            this.setup(lvt_2_1_, this.templatePosition, lvt_3_1_);
        }

        @Override
        protected void writeStructureToNBT(NBTTagCompound p_writeStructureToNBT_1_) {
            super.writeStructureToNBT(p_writeStructureToNBT_1_);
            p_writeStructureToNBT_1_.setString("Template", this.templateName);
            p_writeStructureToNBT_1_.setString("Rot", this.placeSettings.getRotation().name());
            p_writeStructureToNBT_1_.setString("Mi", this.placeSettings.getMirror().name());
        }

        @Override
        protected void readStructureFromNBT(NBTTagCompound p_readStructureFromNBT_1_, TemplateManager p_readStructureFromNBT_2_) {
            super.readStructureFromNBT(p_readStructureFromNBT_1_, p_readStructureFromNBT_2_);
            this.templateName = p_readStructureFromNBT_1_.getString("Template");
            this.rotation = Rotation.valueOf(p_readStructureFromNBT_1_.getString("Rot"));
            this.mirror = Mirror.valueOf(p_readStructureFromNBT_1_.getString("Mi"));
            this.loadTemplate(p_readStructureFromNBT_2_);
        }

        @Override
        protected void handleDataMarker(String p_handleDataMarker_1_, BlockPos p_handleDataMarker_2_, World p_handleDataMarker_3_, Random p_handleDataMarker_4_, StructureBoundingBox p_handleDataMarker_5_) {
            if (p_handleDataMarker_1_.startsWith("Chest")) {
                Rotation lvt_6_1_ = this.placeSettings.getRotation();
                IBlockState lvt_7_1_ = Blocks.CHEST.getDefaultState();
                if ("ChestWest".equals(p_handleDataMarker_1_)) {
                    lvt_7_1_ = lvt_7_1_.withProperty(BlockChest.FACING, lvt_6_1_.rotate(EnumFacing.WEST));
                } else if ("ChestEast".equals(p_handleDataMarker_1_)) {
                    lvt_7_1_ = lvt_7_1_.withProperty(BlockChest.FACING, lvt_6_1_.rotate(EnumFacing.EAST));
                } else if ("ChestSouth".equals(p_handleDataMarker_1_)) {
                    lvt_7_1_ = lvt_7_1_.withProperty(BlockChest.FACING, lvt_6_1_.rotate(EnumFacing.SOUTH));
                } else if ("ChestNorth".equals(p_handleDataMarker_1_)) {
                    lvt_7_1_ = lvt_7_1_.withProperty(BlockChest.FACING, lvt_6_1_.rotate(EnumFacing.NORTH));
                }
                this.generateChest(p_handleDataMarker_3_, p_handleDataMarker_5_, p_handleDataMarker_4_, p_handleDataMarker_2_, LootTableList.CHESTS_WOODLAND_MANSION, lvt_7_1_);
            } else if ("Mage".equals(p_handleDataMarker_1_)) {
                EntityEvoker lvt_6_2_ = new EntityEvoker(p_handleDataMarker_3_);
                lvt_6_2_.enablePersistence();
                lvt_6_2_.moveToBlockPosAndAngles(p_handleDataMarker_2_, 0.0f, 0.0f);
                p_handleDataMarker_3_.spawnEntity(lvt_6_2_);
                p_handleDataMarker_3_.setBlockState(p_handleDataMarker_2_, Blocks.AIR.getDefaultState(), 2);
            } else if ("Warrior".equals(p_handleDataMarker_1_)) {
                EntityVindicator lvt_6_3_ = new EntityVindicator(p_handleDataMarker_3_);
                lvt_6_3_.enablePersistence();
                lvt_6_3_.moveToBlockPosAndAngles(p_handleDataMarker_2_, 0.0f, 0.0f);
                lvt_6_3_.onInitialSpawn(p_handleDataMarker_3_.getDifficultyForLocation(new BlockPos(lvt_6_3_)), null);
                p_handleDataMarker_3_.spawnEntity(lvt_6_3_);
                p_handleDataMarker_3_.setBlockState(p_handleDataMarker_2_, Blocks.AIR.getDefaultState(), 2);
            }
        }
    }
}

