/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure.template;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class PlacementSettings {
    private Mirror mirror = Mirror.NONE;
    private Rotation rotation = Rotation.NONE;
    private boolean ignoreEntities;
    @Nullable
    private Block replacedBlock;
    @Nullable
    private ChunkPos chunk;
    @Nullable
    private StructureBoundingBox boundingBox;
    private boolean ignoreStructureBlock = true;
    private float integrity = 1.0f;
    @Nullable
    private Random random;
    @Nullable
    private Long setSeed;

    public PlacementSettings copy() {
        PlacementSettings lvt_1_1_ = new PlacementSettings();
        lvt_1_1_.mirror = this.mirror;
        lvt_1_1_.rotation = this.rotation;
        lvt_1_1_.ignoreEntities = this.ignoreEntities;
        lvt_1_1_.replacedBlock = this.replacedBlock;
        lvt_1_1_.chunk = this.chunk;
        lvt_1_1_.boundingBox = this.boundingBox;
        lvt_1_1_.ignoreStructureBlock = this.ignoreStructureBlock;
        lvt_1_1_.integrity = this.integrity;
        lvt_1_1_.random = this.random;
        lvt_1_1_.setSeed = this.setSeed;
        return lvt_1_1_;
    }

    public PlacementSettings setMirror(Mirror p_setMirror_1_) {
        this.mirror = p_setMirror_1_;
        return this;
    }

    public PlacementSettings setRotation(Rotation p_setRotation_1_) {
        this.rotation = p_setRotation_1_;
        return this;
    }

    public PlacementSettings setIgnoreEntities(boolean p_setIgnoreEntities_1_) {
        this.ignoreEntities = p_setIgnoreEntities_1_;
        return this;
    }

    public PlacementSettings setReplacedBlock(Block p_setReplacedBlock_1_) {
        this.replacedBlock = p_setReplacedBlock_1_;
        return this;
    }

    public PlacementSettings setChunk(ChunkPos p_setChunk_1_) {
        this.chunk = p_setChunk_1_;
        return this;
    }

    public PlacementSettings setBoundingBox(StructureBoundingBox p_setBoundingBox_1_) {
        this.boundingBox = p_setBoundingBox_1_;
        return this;
    }

    public PlacementSettings setSeed(Long p_setSeed_1_) {
        this.setSeed = p_setSeed_1_;
        return this;
    }

    public PlacementSettings setRandom(Random p_setRandom_1_) {
        this.random = p_setRandom_1_;
        return this;
    }

    public PlacementSettings setIntegrity(float p_setIntegrity_1_) {
        this.integrity = p_setIntegrity_1_;
        return this;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public PlacementSettings setIgnoreStructureBlock(boolean p_setIgnoreStructureBlock_1_) {
        this.ignoreStructureBlock = p_setIgnoreStructureBlock_1_;
        return this;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public Random getRandom(BlockPos p_getRandom_1_) {
        if (this.random != null) {
            return this.random;
        }
        if (this.setSeed != null) {
            if (this.setSeed == 0L) {
                return new Random(System.currentTimeMillis());
            }
            return new Random(this.setSeed);
        }
        if (p_getRandom_1_ == null) {
            return new Random(System.currentTimeMillis());
        }
        int lvt_2_1_ = p_getRandom_1_.getX();
        int lvt_3_1_ = p_getRandom_1_.getZ();
        return new Random((long)(lvt_2_1_ * lvt_2_1_ * 4987142 + lvt_2_1_ * 5947611) + (long)(lvt_3_1_ * lvt_3_1_) * 4392871L + (long)(lvt_3_1_ * 389711) ^ 0x3AD8025FL);
    }

    public float getIntegrity() {
        return this.integrity;
    }

    public boolean getIgnoreEntities() {
        return this.ignoreEntities;
    }

    @Nullable
    public Block getReplacedBlock() {
        return this.replacedBlock;
    }

    @Nullable
    public StructureBoundingBox getBoundingBox() {
        if (this.boundingBox == null && this.chunk != null) {
            this.setBoundingBoxFromChunk();
        }
        return this.boundingBox;
    }

    public boolean getIgnoreStructureBlock() {
        return this.ignoreStructureBlock;
    }

    void setBoundingBoxFromChunk() {
        this.boundingBox = this.getBoundingBoxFromChunk(this.chunk);
    }

    @Nullable
    private StructureBoundingBox getBoundingBoxFromChunk(ChunkPos p_getBoundingBoxFromChunk_1_) {
        if (p_getBoundingBoxFromChunk_1_ == null) {
            return null;
        }
        int lvt_2_1_ = p_getBoundingBoxFromChunk_1_.chunkXPos * 16;
        int lvt_3_1_ = p_getBoundingBoxFromChunk_1_.chunkZPos * 16;
        return new StructureBoundingBox(lvt_2_1_, 0, lvt_3_1_, lvt_2_1_ + 16 - 1, 255, lvt_3_1_ + 16 - 1);
    }
}

