/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure.template;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.Mirror;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.Rotation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataFixer;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.BlockRotationProcessor;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class Template {
    private final List<BlockInfo> blocks = Lists.newArrayList();
    private final List<EntityInfo> entities = Lists.newArrayList();
    private BlockPos size = BlockPos.ORIGIN;
    private String author = "?";

    public BlockPos getSize() {
        return this.size;
    }

    public void setAuthor(String p_setAuthor_1_) {
        this.author = p_setAuthor_1_;
    }

    public String getAuthor() {
        return this.author;
    }

    public void takeBlocksFromWorld(World p_takeBlocksFromWorld_1_, BlockPos p_takeBlocksFromWorld_2_, BlockPos p_takeBlocksFromWorld_3_, boolean p_takeBlocksFromWorld_4_, Block p_takeBlocksFromWorld_5_) {
        if (p_takeBlocksFromWorld_3_.getX() >= 1 && p_takeBlocksFromWorld_3_.getY() >= 1 && p_takeBlocksFromWorld_3_.getZ() >= 1) {
            BlockPos blockpos = p_takeBlocksFromWorld_2_.add(p_takeBlocksFromWorld_3_).add(-1, -1, -1);
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            BlockPos blockpos1 = new BlockPos(Math.min(p_takeBlocksFromWorld_2_.getX(), blockpos.getX()), Math.min(p_takeBlocksFromWorld_2_.getY(), blockpos.getY()), Math.min(p_takeBlocksFromWorld_2_.getZ(), blockpos.getZ()));
            BlockPos blockpos2 = new BlockPos(Math.max(p_takeBlocksFromWorld_2_.getX(), blockpos.getX()), Math.max(p_takeBlocksFromWorld_2_.getY(), blockpos.getY()), Math.max(p_takeBlocksFromWorld_2_.getZ(), blockpos.getZ()));
            this.size = p_takeBlocksFromWorld_3_;
            for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.getAllInBoxMutable(blockpos1, blockpos2)) {
                BlockPos blockpos3 = blockpos$mutableblockpos.subtract(blockpos1);
                IBlockState iblockstate = p_takeBlocksFromWorld_1_.getBlockState(blockpos$mutableblockpos);
                if (p_takeBlocksFromWorld_5_ != null && p_takeBlocksFromWorld_5_ == iblockstate.getBlock()) continue;
                TileEntity tileentity = p_takeBlocksFromWorld_1_.getTileEntity(blockpos$mutableblockpos);
                if (tileentity != null) {
                    NBTTagCompound nbttagcompound = tileentity.writeToNBT(new NBTTagCompound());
                    nbttagcompound.removeTag("x");
                    nbttagcompound.removeTag("y");
                    nbttagcompound.removeTag("z");
                    list1.add(new BlockInfo(blockpos3, iblockstate, nbttagcompound));
                    continue;
                }
                if (!iblockstate.isFullBlock() && !iblockstate.isFullCube()) {
                    list2.add(new BlockInfo(blockpos3, iblockstate, null));
                    continue;
                }
                list.add(new BlockInfo(blockpos3, iblockstate, null));
            }
            this.blocks.clear();
            this.blocks.addAll(list);
            this.blocks.addAll(list1);
            this.blocks.addAll(list2);
            if (p_takeBlocksFromWorld_4_) {
                this.takeEntitiesFromWorld(p_takeBlocksFromWorld_1_, blockpos1, blockpos2.add(1, 1, 1));
            } else {
                this.entities.clear();
            }
        }
    }

    private void takeEntitiesFromWorld(World p_takeEntitiesFromWorld_1_, BlockPos p_takeEntitiesFromWorld_2_, BlockPos p_takeEntitiesFromWorld_3_) {
        List<Entity> list = p_takeEntitiesFromWorld_1_.getEntitiesWithinAABB(Entity.class, new AxisAlignedBB(p_takeEntitiesFromWorld_2_, p_takeEntitiesFromWorld_3_), new Predicate<Entity>(){

            public boolean apply(Entity p_apply_1_) {
                return !(p_apply_1_ instanceof EntityPlayer);
            }
        });
        this.entities.clear();
        for (Entity entity : list) {
            Vec3d vec3d = new Vec3d(entity.posX - (double)p_takeEntitiesFromWorld_2_.getX(), entity.posY - (double)p_takeEntitiesFromWorld_2_.getY(), entity.posZ - (double)p_takeEntitiesFromWorld_2_.getZ());
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            entity.writeToNBTOptional(nbttagcompound);
            BlockPos blockpos = entity instanceof EntityPainting ? ((EntityPainting)entity).getHangingPosition().subtract(p_takeEntitiesFromWorld_2_) : new BlockPos(vec3d);
            this.entities.add(new EntityInfo(vec3d, blockpos, nbttagcompound));
        }
    }

    public Map<BlockPos, String> getDataBlocks(BlockPos p_getDataBlocks_1_, PlacementSettings p_getDataBlocks_2_) {
        HashMap map = Maps.newHashMap();
        StructureBoundingBox structureboundingbox = p_getDataBlocks_2_.getBoundingBox();
        for (BlockInfo template$blockinfo : this.blocks) {
            TileEntityStructure.Mode tileentitystructure$mode;
            IBlockState iblockstate;
            BlockPos blockpos = Template.transformedBlockPos(p_getDataBlocks_2_, template$blockinfo.pos).add(p_getDataBlocks_1_);
            if (structureboundingbox != null && !structureboundingbox.isVecInside(blockpos) || (iblockstate = template$blockinfo.blockState).getBlock() != Blocks.STRUCTURE_BLOCK || template$blockinfo.tileentityData == null || (tileentitystructure$mode = TileEntityStructure.Mode.valueOf(template$blockinfo.tileentityData.getString("mode"))) != TileEntityStructure.Mode.DATA) continue;
            map.put(blockpos, template$blockinfo.tileentityData.getString("metadata"));
        }
        return map;
    }

    public BlockPos calculateConnectedPos(PlacementSettings p_calculateConnectedPos_1_, BlockPos p_calculateConnectedPos_2_, PlacementSettings p_calculateConnectedPos_3_, BlockPos p_calculateConnectedPos_4_) {
        BlockPos blockpos = Template.transformedBlockPos(p_calculateConnectedPos_1_, p_calculateConnectedPos_2_);
        BlockPos blockpos1 = Template.transformedBlockPos(p_calculateConnectedPos_3_, p_calculateConnectedPos_4_);
        return blockpos.subtract(blockpos1);
    }

    public static BlockPos transformedBlockPos(PlacementSettings p_transformedBlockPos_0_, BlockPos p_transformedBlockPos_1_) {
        return Template.transformedBlockPos(p_transformedBlockPos_1_, p_transformedBlockPos_0_.getMirror(), p_transformedBlockPos_0_.getRotation());
    }

    public void addBlocksToWorldChunk(World p_addBlocksToWorldChunk_1_, BlockPos p_addBlocksToWorldChunk_2_, PlacementSettings p_addBlocksToWorldChunk_3_) {
        p_addBlocksToWorldChunk_3_.setBoundingBoxFromChunk();
        this.addBlocksToWorld(p_addBlocksToWorldChunk_1_, p_addBlocksToWorldChunk_2_, p_addBlocksToWorldChunk_3_);
    }

    public void addBlocksToWorld(World p_addBlocksToWorld_1_, BlockPos p_addBlocksToWorld_2_, PlacementSettings p_addBlocksToWorld_3_) {
        this.addBlocksToWorld(p_addBlocksToWorld_1_, p_addBlocksToWorld_2_, new BlockRotationProcessor(p_addBlocksToWorld_2_, p_addBlocksToWorld_3_), p_addBlocksToWorld_3_, 2);
    }

    public void addBlocksToWorld(World p_addBlocksToWorld_1_, BlockPos p_addBlocksToWorld_2_, PlacementSettings p_addBlocksToWorld_3_, int p_addBlocksToWorld_4_) {
        this.addBlocksToWorld(p_addBlocksToWorld_1_, p_addBlocksToWorld_2_, new BlockRotationProcessor(p_addBlocksToWorld_2_, p_addBlocksToWorld_3_), p_addBlocksToWorld_3_, p_addBlocksToWorld_4_);
    }

    public void addBlocksToWorld(World p_addBlocksToWorld_1_, BlockPos p_addBlocksToWorld_2_, ITemplateProcessor p_addBlocksToWorld_3_, PlacementSettings p_addBlocksToWorld_4_, int p_addBlocksToWorld_5_) {
        if (!(this.blocks.isEmpty() && (p_addBlocksToWorld_4_.getIgnoreEntities() || this.entities.isEmpty()) || this.size.getX() < 1 || this.size.getY() < 1 || this.size.getZ() < 1)) {
            Block block = p_addBlocksToWorld_4_.getReplacedBlock();
            StructureBoundingBox structureboundingbox = p_addBlocksToWorld_4_.getBoundingBox();
            for (BlockInfo template$blockinfo : this.blocks) {
                TileEntity tileentity2;
                TileEntity tileentity;
                BlockPos blockpos = Template.transformedBlockPos(p_addBlocksToWorld_4_, template$blockinfo.pos).add(p_addBlocksToWorld_2_);
                BlockInfo template$blockinfo1 = p_addBlocksToWorld_3_ != null ? p_addBlocksToWorld_3_.processBlock(p_addBlocksToWorld_1_, blockpos, template$blockinfo) : template$blockinfo;
                if (template$blockinfo1 == null) continue;
                Block block1 = template$blockinfo1.blockState.getBlock();
                if (block != null && block == block1 || p_addBlocksToWorld_4_.getIgnoreStructureBlock() && block1 == Blocks.STRUCTURE_BLOCK || structureboundingbox != null && !structureboundingbox.isVecInside(blockpos)) continue;
                IBlockState iblockstate = template$blockinfo1.blockState.withMirror(p_addBlocksToWorld_4_.getMirror());
                IBlockState iblockstate1 = iblockstate.withRotation(p_addBlocksToWorld_4_.getRotation());
                if (template$blockinfo1.tileentityData != null && (tileentity = p_addBlocksToWorld_1_.getTileEntity(blockpos)) != null) {
                    if (tileentity instanceof IInventory) {
                        ((IInventory)((Object)tileentity)).clear();
                    }
                    p_addBlocksToWorld_1_.setBlockState(blockpos, Blocks.BARRIER.getDefaultState(), 4);
                }
                if (!p_addBlocksToWorld_1_.setBlockState(blockpos, iblockstate1, p_addBlocksToWorld_5_) || template$blockinfo1.tileentityData == null || (tileentity2 = p_addBlocksToWorld_1_.getTileEntity(blockpos)) == null) continue;
                template$blockinfo1.tileentityData.setInteger("x", blockpos.getX());
                template$blockinfo1.tileentityData.setInteger("y", blockpos.getY());
                template$blockinfo1.tileentityData.setInteger("z", blockpos.getZ());
                tileentity2.readFromNBT(template$blockinfo1.tileentityData);
                tileentity2.mirror(p_addBlocksToWorld_4_.getMirror());
                tileentity2.rotate(p_addBlocksToWorld_4_.getRotation());
            }
            for (BlockInfo template$blockinfo2 : this.blocks) {
                TileEntity tileentity1;
                if (block != null && block == template$blockinfo2.blockState.getBlock()) continue;
                BlockPos blockpos1 = Template.transformedBlockPos(p_addBlocksToWorld_4_, template$blockinfo2.pos).add(p_addBlocksToWorld_2_);
                if (structureboundingbox != null && !structureboundingbox.isVecInside(blockpos1)) continue;
                p_addBlocksToWorld_1_.notifyNeighborsRespectDebug(blockpos1, template$blockinfo2.blockState.getBlock(), false);
                if (template$blockinfo2.tileentityData == null || (tileentity1 = p_addBlocksToWorld_1_.getTileEntity(blockpos1)) == null) continue;
                tileentity1.markDirty();
            }
            if (!p_addBlocksToWorld_4_.getIgnoreEntities()) {
                this.addEntitiesToWorld(p_addBlocksToWorld_1_, p_addBlocksToWorld_2_, p_addBlocksToWorld_4_.getMirror(), p_addBlocksToWorld_4_.getRotation(), structureboundingbox);
            }
        }
    }

    private void addEntitiesToWorld(World p_addEntitiesToWorld_1_, BlockPos p_addEntitiesToWorld_2_, Mirror p_addEntitiesToWorld_3_, Rotation p_addEntitiesToWorld_4_, StructureBoundingBox p_addEntitiesToWorld_5_) {
        for (EntityInfo template$entityinfo : this.entities) {
            Entity entity;
            BlockPos blockpos = Template.transformedBlockPos(template$entityinfo.blockPos, p_addEntitiesToWorld_3_, p_addEntitiesToWorld_4_).add(p_addEntitiesToWorld_2_);
            if (p_addEntitiesToWorld_5_ != null && !p_addEntitiesToWorld_5_.isVecInside(blockpos)) continue;
            NBTTagCompound nbttagcompound = template$entityinfo.entityData;
            Vec3d vec3d = Template.transformedVec3d(template$entityinfo.pos, p_addEntitiesToWorld_3_, p_addEntitiesToWorld_4_);
            Vec3d vec3d1 = vec3d.addVector(p_addEntitiesToWorld_2_.getX(), p_addEntitiesToWorld_2_.getY(), p_addEntitiesToWorld_2_.getZ());
            NBTTagList nbttaglist = new NBTTagList();
            nbttaglist.appendTag(new NBTTagDouble(vec3d1.xCoord));
            nbttaglist.appendTag(new NBTTagDouble(vec3d1.yCoord));
            nbttaglist.appendTag(new NBTTagDouble(vec3d1.zCoord));
            nbttagcompound.setTag("Pos", nbttaglist);
            nbttagcompound.setUniqueId("UUID", UUID.randomUUID());
            try {
                entity = EntityList.createEntityFromNBT(nbttagcompound, p_addEntitiesToWorld_1_);
            }
            catch (Exception var15) {
                entity = null;
            }
            if (entity == null) continue;
            float f = entity.getMirroredYaw(p_addEntitiesToWorld_3_);
            entity.setLocationAndAngles(vec3d1.xCoord, vec3d1.yCoord, vec3d1.zCoord, f += entity.rotationYaw - entity.getRotatedYaw(p_addEntitiesToWorld_4_), entity.rotationPitch);
            p_addEntitiesToWorld_1_.spawnEntity(entity);
        }
    }

    public BlockPos transformedSize(Rotation p_transformedSize_1_) {
        switch (p_transformedSize_1_) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new BlockPos(this.size.getZ(), this.size.getY(), this.size.getX());
            }
        }
        return this.size;
    }

    private static BlockPos transformedBlockPos(BlockPos p_transformedBlockPos_0_, Mirror p_transformedBlockPos_1_, Rotation p_transformedBlockPos_2_) {
        int i = p_transformedBlockPos_0_.getX();
        int j = p_transformedBlockPos_0_.getY();
        int k = p_transformedBlockPos_0_.getZ();
        boolean flag = true;
        switch (p_transformedBlockPos_1_) {
            case LEFT_RIGHT: {
                k = -k;
                break;
            }
            case FRONT_BACK: {
                i = -i;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (p_transformedBlockPos_2_) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(k, j, -i);
            }
            case CLOCKWISE_90: {
                return new BlockPos(-k, j, i);
            }
            case CLOCKWISE_180: {
                return new BlockPos(-i, j, -k);
            }
        }
        return flag ? new BlockPos(i, j, k) : p_transformedBlockPos_0_;
    }

    private static Vec3d transformedVec3d(Vec3d p_transformedVec3d_0_, Mirror p_transformedVec3d_1_, Rotation p_transformedVec3d_2_) {
        double d0 = p_transformedVec3d_0_.xCoord;
        double d1 = p_transformedVec3d_0_.yCoord;
        double d2 = p_transformedVec3d_0_.zCoord;
        boolean flag = true;
        switch (p_transformedVec3d_1_) {
            case LEFT_RIGHT: {
                d2 = 1.0 - d2;
                break;
            }
            case FRONT_BACK: {
                d0 = 1.0 - d0;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (p_transformedVec3d_2_) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3d(d2, d1, 1.0 - d0);
            }
            case CLOCKWISE_90: {
                return new Vec3d(1.0 - d2, d1, d0);
            }
            case CLOCKWISE_180: {
                return new Vec3d(1.0 - d0, d1, 1.0 - d2);
            }
        }
        return flag ? new Vec3d(d0, d1, d2) : p_transformedVec3d_0_;
    }

    public BlockPos getZeroPositionWithTransform(BlockPos p_getZeroPositionWithTransform_1_, Mirror p_getZeroPositionWithTransform_2_, Rotation p_getZeroPositionWithTransform_3_) {
        return Template.getZeroPositionWithTransform(p_getZeroPositionWithTransform_1_, p_getZeroPositionWithTransform_2_, p_getZeroPositionWithTransform_3_, this.getSize().getX(), this.getSize().getZ());
    }

    public static BlockPos getZeroPositionWithTransform(BlockPos p_getZeroPositionWithTransform_0_, Mirror p_getZeroPositionWithTransform_1_, Rotation p_getZeroPositionWithTransform_2_, int p_getZeroPositionWithTransform_3_, int p_getZeroPositionWithTransform_4_) {
        int i = p_getZeroPositionWithTransform_1_ == Mirror.FRONT_BACK ? --p_getZeroPositionWithTransform_3_ : 0;
        int j = p_getZeroPositionWithTransform_1_ == Mirror.LEFT_RIGHT ? --p_getZeroPositionWithTransform_4_ : 0;
        BlockPos blockpos = p_getZeroPositionWithTransform_0_;
        switch (p_getZeroPositionWithTransform_2_) {
            case COUNTERCLOCKWISE_90: {
                blockpos = p_getZeroPositionWithTransform_0_.add(j, 0, p_getZeroPositionWithTransform_3_ - i);
                break;
            }
            case CLOCKWISE_90: {
                blockpos = p_getZeroPositionWithTransform_0_.add(p_getZeroPositionWithTransform_4_ - j, 0, i);
                break;
            }
            case CLOCKWISE_180: {
                blockpos = p_getZeroPositionWithTransform_0_.add(p_getZeroPositionWithTransform_3_ - i, 0, p_getZeroPositionWithTransform_4_ - j);
                break;
            }
            case NONE: {
                blockpos = p_getZeroPositionWithTransform_0_.add(i, 0, j);
            }
        }
        return blockpos;
    }

    public static void registerFixes(DataFixer p_registerFixes_0_) {
        p_registerFixes_0_.registerWalker(FixTypes.STRUCTURE, new IDataWalker(){

            @Override
            public NBTTagCompound process(IDataFixer p_process_1_, NBTTagCompound p_process_2_, int p_process_3_) {
                if (p_process_2_.hasKey("entities", 9)) {
                    NBTTagList nbttaglist = p_process_2_.getTagList("entities", 10);
                    for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                        NBTTagCompound nbttagcompound = (NBTTagCompound)nbttaglist.get(i);
                        if (!nbttagcompound.hasKey("nbt", 10)) continue;
                        nbttagcompound.setTag("nbt", p_process_1_.process(FixTypes.ENTITY, nbttagcompound.getCompoundTag("nbt"), p_process_3_));
                    }
                }
                if (p_process_2_.hasKey("blocks", 9)) {
                    NBTTagList nbttaglist1 = p_process_2_.getTagList("blocks", 10);
                    for (int j = 0; j < nbttaglist1.tagCount(); ++j) {
                        NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist1.get(j);
                        if (!nbttagcompound1.hasKey("nbt", 10)) continue;
                        nbttagcompound1.setTag("nbt", p_process_1_.process(FixTypes.BLOCK_ENTITY, nbttagcompound1.getCompoundTag("nbt"), p_process_3_));
                    }
                }
                return p_process_2_;
            }
        });
    }

    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        BasicPalette template$basicpalette = new BasicPalette();
        NBTTagList nbttaglist = new NBTTagList();
        for (BlockInfo blockInfo : this.blocks) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.setTag("pos", this.writeInts(blockInfo.pos.getX(), blockInfo.pos.getY(), blockInfo.pos.getZ()));
            nbttagcompound.setInteger("state", template$basicpalette.idFor(blockInfo.blockState));
            if (blockInfo.tileentityData != null) {
                nbttagcompound.setTag("nbt", blockInfo.tileentityData);
            }
            nbttaglist.appendTag(nbttagcompound);
        }
        NBTTagList nbttaglist1 = new NBTTagList();
        for (EntityInfo template$entityinfo : this.entities) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setTag("pos", this.writeDoubles(template$entityinfo.pos.xCoord, template$entityinfo.pos.yCoord, template$entityinfo.pos.zCoord));
            nbttagcompound1.setTag("blockPos", this.writeInts(template$entityinfo.blockPos.getX(), template$entityinfo.blockPos.getY(), template$entityinfo.blockPos.getZ()));
            if (template$entityinfo.entityData != null) {
                nbttagcompound1.setTag("nbt", template$entityinfo.entityData);
            }
            nbttaglist1.appendTag(nbttagcompound1);
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (IBlockState iblockstate : template$basicpalette) {
            nBTTagList.appendTag(NBTUtil.writeBlockState(new NBTTagCompound(), iblockstate));
        }
        p_writeToNBT_1_.setTag("palette", nBTTagList);
        p_writeToNBT_1_.setTag("blocks", nbttaglist);
        p_writeToNBT_1_.setTag("entities", nbttaglist1);
        p_writeToNBT_1_.setTag("size", this.writeInts(this.size.getX(), this.size.getY(), this.size.getZ()));
        p_writeToNBT_1_.setString("author", this.author);
        p_writeToNBT_1_.setInteger("DataVersion", 922);
        FMLCommonHandler.instance().getDataFixer().writeVersionData(p_writeToNBT_1_);
        return p_writeToNBT_1_;
    }

    public void read(NBTTagCompound p_read_1_) {
        this.blocks.clear();
        this.entities.clear();
        NBTTagList nbttaglist = p_read_1_.getTagList("size", 3);
        this.size = new BlockPos(nbttaglist.getIntAt(0), nbttaglist.getIntAt(1), nbttaglist.getIntAt(2));
        this.author = p_read_1_.getString("author");
        BasicPalette template$basicpalette = new BasicPalette();
        NBTTagList nbttaglist1 = p_read_1_.getTagList("palette", 10);
        for (int i = 0; i < nbttaglist1.tagCount(); ++i) {
            template$basicpalette.addMapping(NBTUtil.readBlockState(nbttaglist1.getCompoundTagAt(i)), i);
        }
        NBTTagList nbttaglist3 = p_read_1_.getTagList("blocks", 10);
        for (int j = 0; j < nbttaglist3.tagCount(); ++j) {
            NBTTagCompound nbttagcompound = nbttaglist3.getCompoundTagAt(j);
            NBTTagList nbttaglist2 = nbttagcompound.getTagList("pos", 3);
            BlockPos blockpos = new BlockPos(nbttaglist2.getIntAt(0), nbttaglist2.getIntAt(1), nbttaglist2.getIntAt(2));
            IBlockState iblockstate = template$basicpalette.stateFor(nbttagcompound.getInteger("state"));
            NBTTagCompound nbttagcompound1 = nbttagcompound.hasKey("nbt") ? nbttagcompound.getCompoundTag("nbt") : null;
            this.blocks.add(new BlockInfo(blockpos, iblockstate, nbttagcompound1));
        }
        NBTTagList nbttaglist4 = p_read_1_.getTagList("entities", 10);
        for (int k = 0; k < nbttaglist4.tagCount(); ++k) {
            NBTTagCompound nbttagcompound3 = nbttaglist4.getCompoundTagAt(k);
            NBTTagList nbttaglist5 = nbttagcompound3.getTagList("pos", 6);
            Vec3d vec3d = new Vec3d(nbttaglist5.getDoubleAt(0), nbttaglist5.getDoubleAt(1), nbttaglist5.getDoubleAt(2));
            NBTTagList nbttaglist6 = nbttagcompound3.getTagList("blockPos", 3);
            BlockPos blockpos1 = new BlockPos(nbttaglist6.getIntAt(0), nbttaglist6.getIntAt(1), nbttaglist6.getIntAt(2));
            if (!nbttagcompound3.hasKey("nbt")) continue;
            NBTTagCompound nbttagcompound2 = nbttagcompound3.getCompoundTag("nbt");
            this.entities.add(new EntityInfo(vec3d, blockpos1, nbttagcompound2));
        }
    }

    private NBTTagList writeInts(int ... p_writeInts_1_) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i : p_writeInts_1_) {
            nbttaglist.appendTag(new NBTTagInt(i));
        }
        return nbttaglist;
    }

    private NBTTagList writeDoubles(double ... p_writeDoubles_1_) {
        NBTTagList nbttaglist = new NBTTagList();
        for (double d0 : p_writeDoubles_1_) {
            nbttaglist.appendTag(new NBTTagDouble(d0));
        }
        return nbttaglist;
    }

    public static class EntityInfo {
        public final Vec3d pos;
        public final BlockPos blockPos;
        public final NBTTagCompound entityData;

        public EntityInfo(Vec3d p_i47101_1_, BlockPos p_i47101_2_, NBTTagCompound p_i47101_3_) {
            this.pos = p_i47101_1_;
            this.blockPos = p_i47101_2_;
            this.entityData = p_i47101_3_;
        }
    }

    public static class BlockInfo {
        public final BlockPos pos;
        public final IBlockState blockState;
        public final NBTTagCompound tileentityData;

        public BlockInfo(BlockPos p_i47042_1_, IBlockState p_i47042_2_, NBTTagCompound p_i47042_3_) {
            this.pos = p_i47042_1_;
            this.blockState = p_i47042_2_;
            this.tileentityData = p_i47042_3_;
        }
    }

    static class BasicPalette
    implements Iterable<IBlockState> {
        public static final IBlockState DEFAULT_BLOCK_STATE = Blocks.AIR.getDefaultState();
        final ObjectIntIdentityMap<IBlockState> ids = new ObjectIntIdentityMap(16);
        private int lastId;

        private BasicPalette() {
        }

        public int idFor(IBlockState p_idFor_1_) {
            int i = this.ids.get(p_idFor_1_);
            if (i == -1) {
                i = this.lastId++;
                this.ids.put(p_idFor_1_, i);
            }
            return i;
        }

        @Nullable
        public IBlockState stateFor(int p_stateFor_1_) {
            IBlockState iblockstate = this.ids.getByValue(p_stateFor_1_);
            return iblockstate == null ? DEFAULT_BLOCK_STATE : iblockstate;
        }

        @Override
        public Iterator<IBlockState> iterator() {
            return this.ids.iterator();
        }

        public void addMapping(IBlockState p_addMapping_1_, int p_addMapping_2_) {
            this.ids.put(p_addMapping_1_, p_addMapping_2_);
        }
    }
}

