/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.structure.template;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.world.gen.structure.template.Template;
import org.apache.commons.io.IOUtils;

public class TemplateManager {
    private final Map<String, Template> templates = Maps.newHashMap();
    private final String baseFolder;
    private final DataFixer fixer;

    public TemplateManager(String p_i47239_1_, DataFixer p_i47239_2_) {
        this.baseFolder = p_i47239_1_;
        this.fixer = p_i47239_2_;
    }

    public Template getTemplate(MinecraftServer p_getTemplate_1_, ResourceLocation p_getTemplate_2_) {
        Template lvt_3_1_ = this.get(p_getTemplate_1_, p_getTemplate_2_);
        if (lvt_3_1_ == null) {
            lvt_3_1_ = new Template();
            this.templates.put(p_getTemplate_2_.getResourcePath(), lvt_3_1_);
        }
        return lvt_3_1_;
    }

    @Nullable
    public Template get(MinecraftServer p_get_1_, ResourceLocation p_get_2_) {
        String lvt_3_1_ = p_get_2_.getResourcePath();
        if (this.templates.containsKey(lvt_3_1_)) {
            return this.templates.get(lvt_3_1_);
        }
        if (p_get_1_ == null) {
            this.readTemplateFromJar(p_get_2_);
        } else {
            this.readTemplate(p_get_2_);
        }
        if (this.templates.containsKey(lvt_3_1_)) {
            return this.templates.get(lvt_3_1_);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readTemplate(ResourceLocation p_readTemplate_1_) {
        String lvt_2_1_ = p_readTemplate_1_.getResourcePath();
        File lvt_3_1_ = new File(this.baseFolder, lvt_2_1_ + ".nbt");
        if (!lvt_3_1_.exists()) {
            return this.readTemplateFromJar(p_readTemplate_1_);
        }
        FileInputStream lvt_4_1_ = null;
        try {
            lvt_4_1_ = new FileInputStream(lvt_3_1_);
            this.readTemplateFromStream(lvt_2_1_, lvt_4_1_);
        }
        catch (Throwable lvt_5_1_) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(lvt_4_1_);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)lvt_4_1_);
            return bl;
        }
        IOUtils.closeQuietly((InputStream)lvt_4_1_);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readTemplateFromJar(ResourceLocation p_readTemplateFromJar_1_) {
        String lvt_2_1_ = p_readTemplateFromJar_1_.getResourceDomain();
        String lvt_3_1_ = p_readTemplateFromJar_1_.getResourcePath();
        InputStream lvt_4_1_ = null;
        try {
            lvt_4_1_ = MinecraftServer.class.getResourceAsStream("/assets/" + lvt_2_1_ + "/structures/" + lvt_3_1_ + ".nbt");
            this.readTemplateFromStream(lvt_3_1_, lvt_4_1_);
        }
        catch (Throwable lvt_5_1_) {
            try {
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(lvt_4_1_);
            }
        }
        IOUtils.closeQuietly((InputStream)lvt_4_1_);
        return true;
    }

    private void readTemplateFromStream(String p_readTemplateFromStream_1_, InputStream p_readTemplateFromStream_2_) throws IOException {
        NBTTagCompound lvt_3_1_ = CompressedStreamTools.readCompressed(p_readTemplateFromStream_2_);
        if (!lvt_3_1_.hasKey("DataVersion", 99)) {
            lvt_3_1_.setInteger("DataVersion", 500);
        }
        Template lvt_4_1_ = new Template();
        lvt_4_1_.read(this.fixer.process(FixTypes.STRUCTURE, lvt_3_1_));
        this.templates.put(p_readTemplateFromStream_1_, lvt_4_1_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeTemplate(MinecraftServer p_writeTemplate_1_, ResourceLocation p_writeTemplate_2_) {
        String lvt_3_1_ = p_writeTemplate_2_.getResourcePath();
        if (p_writeTemplate_1_ == null || !this.templates.containsKey(lvt_3_1_)) {
            return false;
        }
        File lvt_4_1_ = new File(this.baseFolder);
        if (!lvt_4_1_.exists() ? !lvt_4_1_.mkdirs() : !lvt_4_1_.isDirectory()) {
            return false;
        }
        File lvt_5_1_ = new File(lvt_4_1_, lvt_3_1_ + ".nbt");
        Template lvt_6_1_ = this.templates.get(lvt_3_1_);
        FileOutputStream lvt_7_1_ = null;
        try {
            NBTTagCompound lvt_8_1_ = lvt_6_1_.writeToNBT(new NBTTagCompound());
            lvt_7_1_ = new FileOutputStream(lvt_5_1_);
            CompressedStreamTools.writeCompressed(lvt_8_1_, lvt_7_1_);
        }
        catch (Throwable lvt_8_2_) {
            try {
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(lvt_7_1_);
            }
        }
        IOUtils.closeQuietly((OutputStream)lvt_7_1_);
        return true;
    }

    public void remove(ResourceLocation p_remove_1_) {
        this.templates.remove(p_remove_1_.getResourcePath());
    }
}

