/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketMaps;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapDecoration;

public class MapData
extends WorldSavedData {
    public int xCenter;
    public int zCenter;
    public int dimension;
    public boolean trackingPosition;
    public boolean unlimitedTracking;
    public byte scale;
    public byte[] colors = new byte[16384];
    public List<MapInfo> playersArrayList = Lists.newArrayList();
    private final Map<EntityPlayer, MapInfo> playersHashMap = Maps.newHashMap();
    public Map<String, MapDecoration> mapDecorations = Maps.newLinkedHashMap();

    public MapData(String p_i2140_1_) {
        super(p_i2140_1_);
    }

    public void calculateMapCenter(double p_calculateMapCenter_1_, double p_calculateMapCenter_3_, int p_calculateMapCenter_5_) {
        int i = 128 * (1 << p_calculateMapCenter_5_);
        int j = MathHelper.floor((p_calculateMapCenter_1_ + 64.0) / (double)i);
        int k = MathHelper.floor((p_calculateMapCenter_3_ + 64.0) / (double)i);
        this.xCenter = j * i + i / 2 - 64;
        this.zCenter = k * i + i / 2 - 64;
    }

    @Override
    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
        NBTBase dimension = p_readFromNBT_1_.getTag("dimension");
        this.dimension = dimension instanceof NBTTagByte ? (int)((NBTTagByte)dimension).getByte() : ((NBTTagInt)dimension).getInt();
        this.xCenter = p_readFromNBT_1_.getInteger("xCenter");
        this.zCenter = p_readFromNBT_1_.getInteger("zCenter");
        this.scale = p_readFromNBT_1_.getByte("scale");
        this.scale = (byte)MathHelper.clamp(this.scale, 0, 4);
        this.trackingPosition = p_readFromNBT_1_.hasKey("trackingPosition", 1) ? p_readFromNBT_1_.getBoolean("trackingPosition") : true;
        this.unlimitedTracking = p_readFromNBT_1_.getBoolean("unlimitedTracking");
        int i = p_readFromNBT_1_.getShort("width");
        int j = p_readFromNBT_1_.getShort("height");
        if (i == 128 && j == 128) {
            this.colors = p_readFromNBT_1_.getByteArray("colors");
        } else {
            byte[] abyte = p_readFromNBT_1_.getByteArray("colors");
            this.colors = new byte[16384];
            int k = (128 - i) / 2;
            int l = (128 - j) / 2;
            for (int i1 = 0; i1 < j; ++i1) {
                int j1 = i1 + l;
                if (j1 < 0 && j1 >= 128) continue;
                for (int k1 = 0; k1 < i; ++k1) {
                    int l1 = k1 + k;
                    if (l1 < 0 && l1 >= 128) continue;
                    this.colors[l1 + j1 * 128] = abyte[k1 + i1 * i];
                }
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        p_writeToNBT_1_.setInteger("dimension", this.dimension);
        p_writeToNBT_1_.setInteger("xCenter", this.xCenter);
        p_writeToNBT_1_.setInteger("zCenter", this.zCenter);
        p_writeToNBT_1_.setByte("scale", this.scale);
        p_writeToNBT_1_.setShort("width", (short)128);
        p_writeToNBT_1_.setShort("height", (short)128);
        p_writeToNBT_1_.setByteArray("colors", this.colors);
        p_writeToNBT_1_.setBoolean("trackingPosition", this.trackingPosition);
        p_writeToNBT_1_.setBoolean("unlimitedTracking", this.unlimitedTracking);
        return p_writeToNBT_1_;
    }

    public void updateVisiblePlayers(EntityPlayer p_updateVisiblePlayers_1_, ItemStack p_updateVisiblePlayers_2_) {
        if (!this.playersHashMap.containsKey(p_updateVisiblePlayers_1_)) {
            MapInfo mapdata$mapinfo = new MapInfo(p_updateVisiblePlayers_1_);
            this.playersHashMap.put(p_updateVisiblePlayers_1_, mapdata$mapinfo);
            this.playersArrayList.add(mapdata$mapinfo);
        }
        if (!p_updateVisiblePlayers_1_.inventory.hasItemStack(p_updateVisiblePlayers_2_)) {
            this.mapDecorations.remove(p_updateVisiblePlayers_1_.getName());
        }
        for (int i = 0; i < this.playersArrayList.size(); ++i) {
            MapInfo mapdata$mapinfo1 = this.playersArrayList.get(i);
            if (!mapdata$mapinfo1.entityplayerObj.isDead && (mapdata$mapinfo1.entityplayerObj.inventory.hasItemStack(p_updateVisiblePlayers_2_) || p_updateVisiblePlayers_2_.isOnItemFrame())) {
                if (p_updateVisiblePlayers_2_.isOnItemFrame() || mapdata$mapinfo1.entityplayerObj.dimension != this.dimension || !this.trackingPosition) continue;
                this.addDecoration(MapDecoration.Type.PLAYER, mapdata$mapinfo1.entityplayerObj.world, mapdata$mapinfo1.entityplayerObj.getName(), mapdata$mapinfo1.entityplayerObj.posX, mapdata$mapinfo1.entityplayerObj.posZ, mapdata$mapinfo1.entityplayerObj.rotationYaw);
                continue;
            }
            this.playersHashMap.remove(mapdata$mapinfo1.entityplayerObj);
            this.playersArrayList.remove(mapdata$mapinfo1);
        }
        if (p_updateVisiblePlayers_2_.isOnItemFrame() && this.trackingPosition) {
            EntityItemFrame entityitemframe = p_updateVisiblePlayers_2_.getItemFrame();
            BlockPos blockpos = entityitemframe.getHangingPosition();
            this.addDecoration(MapDecoration.Type.FRAME, p_updateVisiblePlayers_1_.world, "frame-" + entityitemframe.getEntityId(), blockpos.getX(), blockpos.getZ(), entityitemframe.facingDirection.getHorizontalIndex() * 90);
        }
        if (p_updateVisiblePlayers_2_.hasTagCompound() && p_updateVisiblePlayers_2_.getTagCompound().hasKey("Decorations", 9)) {
            NBTTagList nbttaglist = p_updateVisiblePlayers_2_.getTagCompound().getTagList("Decorations", 10);
            for (int j = 0; j < nbttaglist.tagCount(); ++j) {
                NBTTagCompound nbttagcompound = nbttaglist.getCompoundTagAt(j);
                if (this.mapDecorations.containsKey(nbttagcompound.getString("id"))) continue;
                this.addDecoration(MapDecoration.Type.byIcon(nbttagcompound.getByte("type")), p_updateVisiblePlayers_1_.world, nbttagcompound.getString("id"), nbttagcompound.getDouble("x"), nbttagcompound.getDouble("z"), nbttagcompound.getDouble("rot"));
            }
        }
    }

    public static void addTargetDecoration(ItemStack p_addTargetDecoration_0_, BlockPos p_addTargetDecoration_1_, String p_addTargetDecoration_2_, MapDecoration.Type p_addTargetDecoration_3_) {
        NBTTagList nbttaglist;
        if (p_addTargetDecoration_0_.hasTagCompound() && p_addTargetDecoration_0_.getTagCompound().hasKey("Decorations", 9)) {
            nbttaglist = p_addTargetDecoration_0_.getTagCompound().getTagList("Decorations", 10);
        } else {
            nbttaglist = new NBTTagList();
            p_addTargetDecoration_0_.setTagInfo("Decorations", nbttaglist);
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.setByte("type", p_addTargetDecoration_3_.getIcon());
        nbttagcompound.setString("id", p_addTargetDecoration_2_);
        nbttagcompound.setDouble("x", p_addTargetDecoration_1_.getX());
        nbttagcompound.setDouble("z", p_addTargetDecoration_1_.getZ());
        nbttagcompound.setDouble("rot", 180.0);
        nbttaglist.appendTag(nbttagcompound);
        if (p_addTargetDecoration_3_.hasMapColor()) {
            NBTTagCompound nbttagcompound1 = p_addTargetDecoration_0_.getOrCreateSubCompound("display");
            nbttagcompound1.setInteger("MapColor", p_addTargetDecoration_3_.getMapColor());
        }
    }

    private void addDecoration(MapDecoration.Type p_addDecoration_1_, World p_addDecoration_2_, String p_addDecoration_3_, double p_addDecoration_4_, double p_addDecoration_6_, double p_addDecoration_8_) {
        byte b2;
        int i = 1 << this.scale;
        float f = (float)(p_addDecoration_4_ - (double)this.xCenter) / (float)i;
        float f1 = (float)(p_addDecoration_6_ - (double)this.zCenter) / (float)i;
        byte b0 = (byte)((double)(f * 2.0f) + 0.5);
        byte b1 = (byte)((double)(f1 * 2.0f) + 0.5);
        int j = 63;
        if (f >= -63.0f && f1 >= -63.0f && f <= 63.0f && f1 <= 63.0f) {
            b2 = (byte)((p_addDecoration_8_ += p_addDecoration_8_ < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            if (p_addDecoration_2_.provider.shouldMapSpin(p_addDecoration_3_, p_addDecoration_4_, p_addDecoration_6_, p_addDecoration_8_)) {
                int l = (int)(p_addDecoration_2_.getWorldTime() / 10L);
                b2 = (byte)(l * l * 34187121 + l * 121 >> 15 & 0xF);
            }
        } else {
            if (p_addDecoration_1_ != MapDecoration.Type.PLAYER) {
                this.mapDecorations.remove(p_addDecoration_3_);
                return;
            }
            int k = 320;
            if (Math.abs(f) < 320.0f && Math.abs(f1) < 320.0f) {
                p_addDecoration_1_ = MapDecoration.Type.PLAYER_OFF_MAP;
            } else {
                if (!this.unlimitedTracking) {
                    this.mapDecorations.remove(p_addDecoration_3_);
                    return;
                }
                p_addDecoration_1_ = MapDecoration.Type.PLAYER_OFF_LIMITS;
            }
            b2 = 0;
            if (f <= -63.0f) {
                b0 = -128;
            }
            if (f1 <= -63.0f) {
                b1 = -128;
            }
            if (f >= 63.0f) {
                b0 = 127;
            }
            if (f1 >= 63.0f) {
                b1 = 127;
            }
        }
        this.mapDecorations.put(p_addDecoration_3_, new MapDecoration(p_addDecoration_1_, b0, b1, b2));
    }

    @Nullable
    public Packet<?> getMapPacket(ItemStack p_getMapPacket_1_, World p_getMapPacket_2_, EntityPlayer p_getMapPacket_3_) {
        MapInfo mapdata$mapinfo = this.playersHashMap.get(p_getMapPacket_3_);
        return mapdata$mapinfo == null ? null : mapdata$mapinfo.getPacket(p_getMapPacket_1_);
    }

    public void updateMapData(int p_updateMapData_1_, int p_updateMapData_2_) {
        super.markDirty();
        for (MapInfo mapdata$mapinfo : this.playersArrayList) {
            mapdata$mapinfo.update(p_updateMapData_1_, p_updateMapData_2_);
        }
    }

    public MapInfo getMapInfo(EntityPlayer p_getMapInfo_1_) {
        MapInfo mapdata$mapinfo = this.playersHashMap.get(p_getMapInfo_1_);
        if (mapdata$mapinfo == null) {
            mapdata$mapinfo = new MapInfo(p_getMapInfo_1_);
            this.playersHashMap.put(p_getMapInfo_1_, mapdata$mapinfo);
            this.playersArrayList.add(mapdata$mapinfo);
        }
        return mapdata$mapinfo;
    }

    public class MapInfo {
        public final EntityPlayer entityplayerObj;
        private boolean isDirty = true;
        private int minX;
        private int minY;
        private int maxX = 127;
        private int maxY = 127;
        private int tick;
        public int step;

        public MapInfo(EntityPlayer p_i2138_2_) {
            this.entityplayerObj = p_i2138_2_;
        }

        @Nullable
        public Packet<?> getPacket(ItemStack p_getPacket_1_) {
            if (this.isDirty) {
                this.isDirty = false;
                return new SPacketMaps(p_getPacket_1_.getMetadata(), MapData.this.scale, MapData.this.trackingPosition, MapData.this.mapDecorations.values(), MapData.this.colors, this.minX, this.minY, this.maxX + 1 - this.minX, this.maxY + 1 - this.minY);
            }
            return this.tick++ % 5 == 0 ? new SPacketMaps(p_getPacket_1_.getMetadata(), MapData.this.scale, MapData.this.trackingPosition, MapData.this.mapDecorations.values(), MapData.this.colors, 0, 0, 0, 0) : null;
        }

        public void update(int p_update_1_, int p_update_2_) {
            if (this.isDirty) {
                this.minX = Math.min(this.minX, p_update_1_);
                this.minY = Math.min(this.minY, p_update_2_);
                this.maxX = Math.max(this.maxX, p_update_1_);
                this.maxY = Math.max(this.maxY, p_update_2_);
            } else {
                this.isDirty = true;
                this.minX = p_update_1_;
                this.minY = p_update_2_;
                this.maxX = p_update_1_;
                this.maxY = p_update_2_;
            }
        }
    }
}

