/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MapDecoration {
    private final Type type;
    private byte x;
    private byte y;
    private byte rotation;

    public MapDecoration(Type p_i47236_1_, byte p_i47236_2_, byte p_i47236_3_, byte p_i47236_4_) {
        this.type = p_i47236_1_;
        this.x = p_i47236_2_;
        this.y = p_i47236_3_;
        this.rotation = p_i47236_4_;
    }

    public byte getImage() {
        return this.type.getIcon();
    }

    public Type getType() {
        return this.type;
    }

    public byte getX() {
        return this.x;
    }

    public byte getY() {
        return this.y;
    }

    public byte getRotation() {
        return this.rotation;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderOnFrame() {
        return this.type.isRenderedOnFrame();
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof MapDecoration)) {
            return false;
        }
        MapDecoration lvt_2_1_ = (MapDecoration)p_equals_1_;
        if (this.type != lvt_2_1_.type) {
            return false;
        }
        if (this.rotation != lvt_2_1_.rotation) {
            return false;
        }
        if (this.x != lvt_2_1_.x) {
            return false;
        }
        return this.y == lvt_2_1_.y;
    }

    public int hashCode() {
        int lvt_1_1_ = this.type.getIcon();
        lvt_1_1_ = 31 * lvt_1_1_ + this.x;
        lvt_1_1_ = 31 * lvt_1_1_ + this.y;
        lvt_1_1_ = 31 * lvt_1_1_ + this.rotation;
        return lvt_1_1_;
    }

    public static enum Type {
        PLAYER(false),
        FRAME(true),
        RED_MARKER(false),
        BLUE_MARKER(false),
        TARGET_X(true),
        TARGET_POINT(true),
        PLAYER_OFF_MAP(false),
        PLAYER_OFF_LIMITS(false),
        MANSION(true, 5393476),
        MONUMENT(true, 3830373);

        private final byte icon = (byte)this.ordinal();
        private final boolean renderedOnFrame;
        private final int mapColor;

        private Type(boolean p_i47343_3_) {
            this(p_i47343_3_, -1);
        }

        private Type(boolean p_i47344_3_, int p_i47344_4_) {
            this.renderedOnFrame = p_i47344_3_;
            this.mapColor = p_i47344_4_;
        }

        public byte getIcon() {
            return this.icon;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean isRenderedOnFrame() {
            return this.renderedOnFrame;
        }

        public boolean hasMapColor() {
            return this.mapColor >= 0;
        }

        public int getMapColor() {
            return this.mapColor;
        }

        public static Type byIcon(byte p_byIcon_0_) {
            return Type.values()[p_byIcon_0_];
        }
    }
}

