/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.ISaveHandler;

public class MapStorage {
    private final ISaveHandler saveHandler;
    protected Map<String, WorldSavedData> loadedDataMap = Maps.newHashMap();
    private final List<WorldSavedData> loadedDataList = Lists.newArrayList();
    private final Map<String, Short> idCounts = Maps.newHashMap();

    public MapStorage(ISaveHandler p_i2162_1_) {
        this.saveHandler = p_i2162_1_;
        this.loadIdCounts();
    }

    @Nullable
    public WorldSavedData getOrLoadData(Class<? extends WorldSavedData> p_getOrLoadData_1_, String p_getOrLoadData_2_) {
        WorldSavedData lvt_3_1_;
        block7: {
            lvt_3_1_ = this.loadedDataMap.get(p_getOrLoadData_2_);
            if (lvt_3_1_ != null) {
                return lvt_3_1_;
            }
            if (this.saveHandler != null) {
                try {
                    File lvt_4_1_ = this.saveHandler.getMapFileFromName(p_getOrLoadData_2_);
                    if (lvt_4_1_ == null || !lvt_4_1_.exists()) break block7;
                    try {
                        lvt_3_1_ = p_getOrLoadData_1_.getConstructor(String.class).newInstance(p_getOrLoadData_2_);
                    }
                    catch (Exception lvt_5_1_) {
                        throw new RuntimeException("Failed to instantiate " + p_getOrLoadData_1_, lvt_5_1_);
                    }
                    FileInputStream lvt_5_2_ = new FileInputStream(lvt_4_1_);
                    NBTTagCompound lvt_6_1_ = CompressedStreamTools.readCompressed(lvt_5_2_);
                    lvt_5_2_.close();
                    lvt_3_1_.readFromNBT(lvt_6_1_.getCompoundTag("data"));
                }
                catch (Exception lvt_4_2_) {
                    lvt_4_2_.printStackTrace();
                }
            }
        }
        if (lvt_3_1_ != null) {
            this.loadedDataMap.put(p_getOrLoadData_2_, lvt_3_1_);
            this.loadedDataList.add(lvt_3_1_);
        }
        return lvt_3_1_;
    }

    public void setData(String p_setData_1_, WorldSavedData p_setData_2_) {
        if (this.loadedDataMap.containsKey(p_setData_1_)) {
            this.loadedDataList.remove(this.loadedDataMap.remove(p_setData_1_));
        }
        this.loadedDataMap.put(p_setData_1_, p_setData_2_);
        this.loadedDataList.add(p_setData_2_);
    }

    public void saveAllData() {
        for (int lvt_1_1_ = 0; lvt_1_1_ < this.loadedDataList.size(); ++lvt_1_1_) {
            WorldSavedData lvt_2_1_ = this.loadedDataList.get(lvt_1_1_);
            if (!lvt_2_1_.isDirty()) continue;
            this.saveData(lvt_2_1_);
            lvt_2_1_.setDirty(false);
        }
    }

    private void saveData(WorldSavedData p_saveData_1_) {
        if (this.saveHandler == null) {
            return;
        }
        try {
            File lvt_2_1_ = this.saveHandler.getMapFileFromName(p_saveData_1_.mapName);
            if (lvt_2_1_ != null) {
                NBTTagCompound lvt_3_1_ = new NBTTagCompound();
                lvt_3_1_.setTag("data", p_saveData_1_.writeToNBT(new NBTTagCompound()));
                FileOutputStream lvt_4_1_ = new FileOutputStream(lvt_2_1_);
                CompressedStreamTools.writeCompressed(lvt_3_1_, lvt_4_1_);
                lvt_4_1_.close();
            }
        }
        catch (Exception lvt_2_2_) {
            lvt_2_2_.printStackTrace();
        }
    }

    private void loadIdCounts() {
        try {
            this.idCounts.clear();
            if (this.saveHandler == null) {
                return;
            }
            File lvt_1_1_ = this.saveHandler.getMapFileFromName("idcounts");
            if (lvt_1_1_ != null && lvt_1_1_.exists()) {
                DataInputStream lvt_2_1_ = new DataInputStream(new FileInputStream(lvt_1_1_));
                NBTTagCompound lvt_3_1_ = CompressedStreamTools.read(lvt_2_1_);
                lvt_2_1_.close();
                for (String lvt_5_1_ : lvt_3_1_.getKeySet()) {
                    NBTBase lvt_6_1_ = lvt_3_1_.getTag(lvt_5_1_);
                    if (!(lvt_6_1_ instanceof NBTTagShort)) continue;
                    NBTTagShort lvt_7_1_ = (NBTTagShort)lvt_6_1_;
                    short lvt_8_1_ = lvt_7_1_.getShort();
                    this.idCounts.put(lvt_5_1_, lvt_8_1_);
                }
            }
        }
        catch (Exception lvt_1_2_) {
            lvt_1_2_.printStackTrace();
        }
    }

    public int getUniqueDataId(String p_getUniqueDataId_1_) {
        Short lvt_2_1_ = this.idCounts.get(p_getUniqueDataId_1_);
        if (lvt_2_1_ == null) {
            lvt_2_1_ = 0;
        } else {
            Short s = lvt_2_1_;
            Short s2 = lvt_2_1_ = Short.valueOf((short)(lvt_2_1_ + 1));
        }
        this.idCounts.put(p_getUniqueDataId_1_, lvt_2_1_);
        if (this.saveHandler == null) {
            return lvt_2_1_.shortValue();
        }
        try {
            File lvt_3_1_ = this.saveHandler.getMapFileFromName("idcounts");
            if (lvt_3_1_ != null) {
                NBTTagCompound lvt_4_1_ = new NBTTagCompound();
                for (String lvt_6_1_ : this.idCounts.keySet()) {
                    lvt_4_1_.setShort(lvt_6_1_, this.idCounts.get(lvt_6_1_));
                }
                DataOutputStream lvt_5_1_ = new DataOutputStream(new FileOutputStream(lvt_3_1_));
                CompressedStreamTools.write(lvt_4_1_, lvt_5_1_);
                lvt_5_1_.close();
            }
        }
        catch (Exception lvt_3_2_) {
            lvt_3_2_.printStackTrace();
        }
        return lvt_2_1_.shortValue();
    }
}

