/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaveFormatOld
implements ISaveFormat {
    private static final Logger LOGGER = LogManager.getLogger();
    public final File savesDirectory;
    protected final DataFixer dataFixer;

    public SaveFormatOld(File p_i46647_1_, DataFixer p_i46647_2_) {
        this.dataFixer = p_i46647_2_;
        if (!p_i46647_1_.exists()) {
            p_i46647_1_.mkdirs();
        }
        this.savesDirectory = p_i46647_1_;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return "Old Format";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<WorldSummary> getSaveList() throws AnvilConverterException {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < 5; ++i) {
            String s = "World" + (i + 1);
            WorldInfo worldinfo = this.getWorldInfo(s);
            if (worldinfo == null) continue;
            list.add(new WorldSummary(worldinfo, s, "", worldinfo.getSizeOnDisk(), false));
        }
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void flushCache() {
    }

    @Override
    @Nullable
    public WorldInfo getWorldInfo(String p_getWorldInfo_1_) {
        WorldInfo worldinfo;
        File file1 = new File(this.savesDirectory, p_getWorldInfo_1_);
        if (!file1.exists()) {
            return null;
        }
        File file2 = new File(file1, "level.dat");
        if (file2.exists() && (worldinfo = SaveFormatOld.getWorldData(file2, this.dataFixer)) != null) {
            return worldinfo;
        }
        file2 = new File(file1, "level.dat_old");
        return file2.exists() ? SaveFormatOld.getWorldData(file2, this.dataFixer) : null;
    }

    @Nullable
    public static WorldInfo getWorldData(File p_getWorldData_0_, DataFixer p_getWorldData_1_) {
        try {
            NBTTagCompound nbttagcompound = CompressedStreamTools.readCompressed(new FileInputStream(p_getWorldData_0_));
            NBTTagCompound nbttagcompound1 = nbttagcompound.getCompoundTag("Data");
            return new WorldInfo(p_getWorldData_1_.process(FixTypes.LEVEL, nbttagcompound1));
        }
        catch (Exception exception) {
            LOGGER.error("Exception reading {}", new Object[]{p_getWorldData_0_, exception});
            return null;
        }
    }

    public static WorldInfo loadAndFix(File p_loadAndFix_0_, DataFixer p_loadAndFix_1_, SaveHandler p_loadAndFix_2_) {
        try {
            NBTTagCompound nbt = CompressedStreamTools.readCompressed(new FileInputStream(p_loadAndFix_0_));
            WorldInfo info = new WorldInfo(p_loadAndFix_1_.process(FixTypes.LEVEL, nbt.getCompoundTag("Data")));
            FMLCommonHandler.instance().handleWorldDataLoad(p_loadAndFix_2_, info, nbt);
            return info;
        }
        catch (StartupQuery.AbortedException e) {
            throw e;
        }
        catch (Exception exception) {
            LOGGER.error("Exception reading " + p_loadAndFix_0_, (Throwable)exception);
            return null;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renameWorld(String p_renameWorld_1_, String p_renameWorld_2_) {
        File file2;
        File file1 = new File(this.savesDirectory, p_renameWorld_1_);
        if (file1.exists() && (file2 = new File(file1, "level.dat")).exists()) {
            try {
                NBTTagCompound nbttagcompound = CompressedStreamTools.readCompressed(new FileInputStream(file2));
                NBTTagCompound nbttagcompound1 = nbttagcompound.getCompoundTag("Data");
                nbttagcompound1.setString("LevelName", p_renameWorld_2_);
                CompressedStreamTools.writeCompressed(nbttagcompound, new FileOutputStream(file2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public ISaveHandler getSaveLoader(String p_getSaveLoader_1_, boolean p_getSaveLoader_2_) {
        return new SaveHandler(this.savesDirectory, p_getSaveLoader_1_, p_getSaveLoader_2_, this.dataFixer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isNewLevelIdAcceptable(String p_isNewLevelIdAcceptable_1_) {
        File file1 = new File(this.savesDirectory, p_isNewLevelIdAcceptable_1_);
        if (file1.exists()) {
            return false;
        }
        try {
            file1.mkdir();
            file1.delete();
            return true;
        }
        catch (Throwable throwable) {
            LOGGER.warn("Couldn't make new level", throwable);
            return false;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean deleteWorldDirectory(String p_deleteWorldDirectory_1_) {
        File file1 = new File(this.savesDirectory, p_deleteWorldDirectory_1_);
        if (!file1.exists()) {
            return true;
        }
        LOGGER.info("Deleting level {}", new Object[]{p_deleteWorldDirectory_1_});
        for (int i = 1; i <= 5; ++i) {
            LOGGER.info("Attempt {}...", new Object[]{i});
            if (SaveFormatOld.deleteFiles(file1.listFiles())) break;
            LOGGER.warn("Unsuccessful in deleting contents.");
            if (i >= 5) continue;
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return file1.delete();
    }

    @SideOnly(value=Side.CLIENT)
    protected static boolean deleteFiles(File[] p_deleteFiles_0_) {
        for (File file1 : p_deleteFiles_0_) {
            LOGGER.debug("Deleting {}", new Object[]{file1});
            if (file1.isDirectory() && !SaveFormatOld.deleteFiles(file1.listFiles())) {
                LOGGER.warn("Couldn't delete directory {}", new Object[]{file1});
                return false;
            }
            if (file1.delete()) continue;
            LOGGER.warn("Couldn't delete file {}", new Object[]{file1});
            return false;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isConvertible(String p_isConvertible_1_) {
        return false;
    }

    @Override
    public boolean isOldMapFormat(String p_isOldMapFormat_1_) {
        return false;
    }

    @Override
    public boolean convertMapFormat(String p_convertMapFormat_1_, IProgressUpdate p_convertMapFormat_2_) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canLoadWorld(String p_canLoadWorld_1_) {
        File file1 = new File(this.savesDirectory, p_canLoadWorld_1_);
        return file1.isDirectory();
    }

    @Override
    public File getFile(String p_getFile_1_, String p_getFile_2_) {
        return new File(new File(this.savesDirectory, p_getFile_1_), p_getFile_2_);
    }
}

