/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveFormatOld;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaveHandler
implements ISaveHandler,
IPlayerFileData {
    private static final Logger LOGGER = LogManager.getLogger();
    private final File worldDirectory;
    private final File playersDirectory;
    private final File mapDataDir;
    private final long initializationTime = MinecraftServer.getCurrentTimeMillis();
    private final String saveDirectoryName;
    private final TemplateManager structureTemplateManager;
    protected final DataFixer dataFixer;

    public SaveHandler(File p_i46648_1_, String p_i46648_2_, boolean p_i46648_3_, DataFixer p_i46648_4_) {
        this.dataFixer = p_i46648_4_;
        this.worldDirectory = new File(p_i46648_1_, p_i46648_2_);
        this.worldDirectory.mkdirs();
        this.playersDirectory = new File(this.worldDirectory, "playerdata");
        this.mapDataDir = new File(this.worldDirectory, "data");
        this.mapDataDir.mkdirs();
        this.saveDirectoryName = p_i46648_2_;
        if (p_i46648_3_) {
            this.playersDirectory.mkdirs();
            this.structureTemplateManager = new TemplateManager(new File(this.worldDirectory, "structures").toString(), p_i46648_4_);
        } else {
            this.structureTemplateManager = null;
        }
        this.setSessionLock();
    }

    private void setSessionLock() {
        try {
            File file1 = new File(this.worldDirectory, "session.lock");
            DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(file1));
            try {
                dataoutputstream.writeLong(this.initializationTime);
            }
            finally {
                dataoutputstream.close();
            }
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            throw new RuntimeException("Failed to check session lock, aborting");
        }
    }

    @Override
    public File getWorldDirectory() {
        return this.worldDirectory;
    }

    @Override
    public void checkSessionLock() throws MinecraftException {
        try {
            File file1 = new File(this.worldDirectory, "session.lock");
            DataInputStream datainputstream = new DataInputStream(new FileInputStream(file1));
            try {
                if (datainputstream.readLong() != this.initializationTime) {
                    throw new MinecraftException("The save is being accessed from another location, aborting");
                }
            }
            finally {
                datainputstream.close();
            }
        }
        catch (IOException var7) {
            throw new MinecraftException("Failed to check session lock, aborting");
        }
    }

    @Override
    public IChunkLoader getChunkLoader(WorldProvider p_getChunkLoader_1_) {
        throw new RuntimeException("Old Chunk Storage is no longer supported.");
    }

    @Override
    @Nullable
    public WorldInfo loadWorldInfo() {
        WorldInfo worldinfo;
        File file1 = new File(this.worldDirectory, "level.dat");
        if (file1.exists() && (worldinfo = SaveFormatOld.loadAndFix(file1, this.dataFixer, this)) != null) {
            return worldinfo;
        }
        FMLCommonHandler.instance().confirmBackupLevelDatUse(this);
        file1 = new File(this.worldDirectory, "level.dat_old");
        return file1.exists() ? SaveFormatOld.loadAndFix(file1, this.dataFixer, this) : null;
    }

    @Override
    public void saveWorldInfoWithPlayer(WorldInfo p_saveWorldInfoWithPlayer_1_, NBTTagCompound p_saveWorldInfoWithPlayer_2_) {
        NBTTagCompound nbttagcompound = p_saveWorldInfoWithPlayer_1_.cloneNBTCompound(p_saveWorldInfoWithPlayer_2_);
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.setTag("Data", nbttagcompound);
        FMLCommonHandler.instance().handleWorldDataSave(this, p_saveWorldInfoWithPlayer_1_, nbttagcompound1);
        try {
            File file1 = new File(this.worldDirectory, "level.dat_new");
            File file2 = new File(this.worldDirectory, "level.dat_old");
            File file3 = new File(this.worldDirectory, "level.dat");
            CompressedStreamTools.writeCompressed(nbttagcompound1, new FileOutputStream(file1));
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
            if (file3.exists()) {
                file3.delete();
            }
            file1.renameTo(file3);
            if (file1.exists()) {
                file1.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void saveWorldInfo(WorldInfo p_saveWorldInfo_1_) {
        this.saveWorldInfoWithPlayer(p_saveWorldInfo_1_, null);
    }

    @Override
    public void writePlayerData(EntityPlayer p_writePlayerData_1_) {
        try {
            NBTTagCompound nbttagcompound = p_writePlayerData_1_.writeToNBT(new NBTTagCompound());
            File file1 = new File(this.playersDirectory, p_writePlayerData_1_.getCachedUniqueIdString() + ".dat.tmp");
            File file2 = new File(this.playersDirectory, p_writePlayerData_1_.getCachedUniqueIdString() + ".dat");
            CompressedStreamTools.writeCompressed(nbttagcompound, new FileOutputStream(file1));
            if (file2.exists()) {
                file2.delete();
            }
            file1.renameTo(file2);
            ForgeEventFactory.firePlayerSavingEvent(p_writePlayerData_1_, this.playersDirectory, p_writePlayerData_1_.getUniqueID().toString());
        }
        catch (Exception var5) {
            LOGGER.warn("Failed to save player data for {}", new Object[]{p_writePlayerData_1_.getName()});
        }
    }

    @Override
    @Nullable
    public NBTTagCompound readPlayerData(EntityPlayer p_readPlayerData_1_) {
        NBTTagCompound nbttagcompound = null;
        try {
            File file1 = new File(this.playersDirectory, p_readPlayerData_1_.getCachedUniqueIdString() + ".dat");
            if (file1.exists() && file1.isFile()) {
                nbttagcompound = CompressedStreamTools.readCompressed(new FileInputStream(file1));
            }
        }
        catch (Exception var4) {
            LOGGER.warn("Failed to load player data for {}", new Object[]{p_readPlayerData_1_.getName()});
        }
        if (nbttagcompound != null) {
            p_readPlayerData_1_.readFromNBT(this.dataFixer.process(FixTypes.PLAYER, nbttagcompound));
        }
        ForgeEventFactory.firePlayerLoadingEvent(p_readPlayerData_1_, this.playersDirectory, p_readPlayerData_1_.getUniqueID().toString());
        return nbttagcompound;
    }

    @Override
    public IPlayerFileData getPlayerNBTManager() {
        return this;
    }

    @Override
    public String[] getAvailablePlayerDat() {
        String[] astring = this.playersDirectory.list();
        if (astring == null) {
            astring = new String[]{};
        }
        for (int i = 0; i < astring.length; ++i) {
            if (!astring[i].endsWith(".dat")) continue;
            astring[i] = astring[i].substring(0, astring[i].length() - 4);
        }
        return astring;
    }

    @Override
    public void flush() {
    }

    @Override
    public File getMapFileFromName(String p_getMapFileFromName_1_) {
        return new File(this.mapDataDir, p_getMapFileFromName_1_ + ".dat");
    }

    @Override
    public TemplateManager getStructureTemplateManager() {
        return this.structureTemplateManager;
    }

    public NBTTagCompound getPlayerNBT(EntityPlayerMP p_getPlayerNBT_1_) {
        try {
            File file1 = new File(this.playersDirectory, p_getPlayerNBT_1_.getUniqueID().toString() + ".dat");
            if (file1.exists() && file1.isFile()) {
                return CompressedStreamTools.readCompressed(new FileInputStream(file1));
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to load player data for " + p_getPlayerNBT_1_.getName());
        }
        return null;
    }
}

