/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.storage.IThreadedFileIO;

public class ThreadedFileIOBase
implements Runnable {
    private static final ThreadedFileIOBase INSTANCE = new ThreadedFileIOBase();
    private final List<IThreadedFileIO> threadedIOQueue = Collections.synchronizedList(Lists.newArrayList());
    private volatile long writeQueuedCounter;
    private volatile long savedIOCounter;
    private volatile boolean isThreadWaiting;

    private ThreadedFileIOBase() {
        Thread lvt_1_1_ = new Thread((Runnable)this, "File IO Thread");
        lvt_1_1_.setPriority(1);
        lvt_1_1_.start();
    }

    public static ThreadedFileIOBase getThreadedIOInstance() {
        return INSTANCE;
    }

    @Override
    public void run() {
        while (true) {
            this.processQueue();
        }
    }

    private void processQueue() {
        for (int lvt_1_1_ = 0; lvt_1_1_ < this.threadedIOQueue.size(); ++lvt_1_1_) {
            IThreadedFileIO lvt_2_1_ = this.threadedIOQueue.get(lvt_1_1_);
            boolean lvt_3_1_ = lvt_2_1_.writeNextIO();
            if (!lvt_3_1_) {
                this.threadedIOQueue.remove(lvt_1_1_--);
                ++this.savedIOCounter;
            }
            try {
                Thread.sleep(this.isThreadWaiting ? 0L : 10L);
                continue;
            }
            catch (InterruptedException lvt_4_1_) {
                lvt_4_1_.printStackTrace();
            }
        }
        if (this.threadedIOQueue.isEmpty()) {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException lvt_1_2_) {
                lvt_1_2_.printStackTrace();
            }
        }
    }

    public void queueIO(IThreadedFileIO p_queueIO_1_) {
        if (this.threadedIOQueue.contains(p_queueIO_1_)) {
            return;
        }
        ++this.writeQueuedCounter;
        this.threadedIOQueue.add(p_queueIO_1_);
    }

    public void waitForFinish() throws InterruptedException {
        this.isThreadWaiting = true;
        while (this.writeQueuedCounter != this.savedIOCounter) {
            Thread.sleep(10L);
        }
        this.isThreadWaiting = false;
    }
}

