/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataFixer;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldInfo {
    private String versionName;
    private int versionId;
    private boolean versionSnapshot;
    public static final EnumDifficulty DEFAULT_DIFFICULTY = EnumDifficulty.NORMAL;
    private long randomSeed;
    private WorldType terrainType = WorldType.DEFAULT;
    private String generatorOptions = "";
    private int spawnX;
    private int spawnY;
    private int spawnZ;
    private long totalTime;
    private long worldTime;
    private long lastTimePlayed;
    private long sizeOnDisk;
    private NBTTagCompound playerTag;
    private int dimension;
    private String levelName;
    private int saveVersion;
    private int cleanWeatherTime;
    private boolean raining;
    private int rainTime;
    private boolean thundering;
    private int thunderTime;
    private GameType theGameType;
    private boolean mapFeaturesEnabled;
    private boolean hardcore;
    private boolean allowCommands;
    private boolean initialized;
    private EnumDifficulty difficulty;
    private boolean difficultyLocked;
    private double borderCenterX;
    private double borderCenterZ;
    private double borderSize = 6.0E7;
    private long borderSizeLerpTime;
    private double borderSizeLerpTarget;
    private double borderSafeZone = 5.0;
    private double borderDamagePerBlock = 0.2;
    private int borderWarningDistance = 5;
    private int borderWarningTime = 15;
    private final Map<DimensionType, NBTTagCompound> dimensionData = Maps.newEnumMap(DimensionType.class);
    private GameRules theGameRules = new GameRules();
    private Map<String, NBTBase> additionalProperties;

    protected WorldInfo() {
    }

    public static void registerFixes(DataFixer p_registerFixes_0_) {
        p_registerFixes_0_.registerWalker(FixTypes.LEVEL, new IDataWalker(){

            @Override
            public NBTTagCompound process(IDataFixer p_process_1_, NBTTagCompound p_process_2_, int p_process_3_) {
                if (p_process_2_.hasKey("Player", 10)) {
                    p_process_2_.setTag("Player", p_process_1_.process(FixTypes.PLAYER, p_process_2_.getCompoundTag("Player"), p_process_3_));
                }
                return p_process_2_;
            }
        });
    }

    public WorldInfo(NBTTagCompound p_i2157_1_) {
        if (p_i2157_1_.hasKey("Version", 10)) {
            NBTTagCompound nbttagcompound = p_i2157_1_.getCompoundTag("Version");
            this.versionName = nbttagcompound.getString("Name");
            this.versionId = nbttagcompound.getInteger("Id");
            this.versionSnapshot = nbttagcompound.getBoolean("Snapshot");
        }
        this.randomSeed = p_i2157_1_.getLong("RandomSeed");
        if (p_i2157_1_.hasKey("generatorName", 8)) {
            String s1 = p_i2157_1_.getString("generatorName");
            this.terrainType = WorldType.parseWorldType(s1);
            if (this.terrainType == null) {
                this.terrainType = WorldType.DEFAULT;
            } else if (this.terrainType.isVersioned()) {
                int i = 0;
                if (p_i2157_1_.hasKey("generatorVersion", 99)) {
                    i = p_i2157_1_.getInteger("generatorVersion");
                }
                this.terrainType = this.terrainType.getWorldTypeForGeneratorVersion(i);
            }
            if (p_i2157_1_.hasKey("generatorOptions", 8)) {
                this.generatorOptions = p_i2157_1_.getString("generatorOptions");
            }
        }
        this.theGameType = GameType.getByID(p_i2157_1_.getInteger("GameType"));
        this.mapFeaturesEnabled = p_i2157_1_.hasKey("MapFeatures", 99) ? p_i2157_1_.getBoolean("MapFeatures") : true;
        this.spawnX = p_i2157_1_.getInteger("SpawnX");
        this.spawnY = p_i2157_1_.getInteger("SpawnY");
        this.spawnZ = p_i2157_1_.getInteger("SpawnZ");
        this.totalTime = p_i2157_1_.getLong("Time");
        this.worldTime = p_i2157_1_.hasKey("DayTime", 99) ? p_i2157_1_.getLong("DayTime") : this.totalTime;
        this.lastTimePlayed = p_i2157_1_.getLong("LastPlayed");
        this.sizeOnDisk = p_i2157_1_.getLong("SizeOnDisk");
        this.levelName = p_i2157_1_.getString("LevelName");
        this.saveVersion = p_i2157_1_.getInteger("version");
        this.cleanWeatherTime = p_i2157_1_.getInteger("clearWeatherTime");
        this.rainTime = p_i2157_1_.getInteger("rainTime");
        this.raining = p_i2157_1_.getBoolean("raining");
        this.thunderTime = p_i2157_1_.getInteger("thunderTime");
        this.thundering = p_i2157_1_.getBoolean("thundering");
        this.hardcore = p_i2157_1_.getBoolean("hardcore");
        this.initialized = p_i2157_1_.hasKey("initialized", 99) ? p_i2157_1_.getBoolean("initialized") : true;
        if (p_i2157_1_.hasKey("allowCommands", 99)) {
            this.allowCommands = p_i2157_1_.getBoolean("allowCommands");
        } else {
            boolean bl = this.allowCommands = this.theGameType == GameType.CREATIVE;
        }
        if (p_i2157_1_.hasKey("Player", 10)) {
            this.playerTag = p_i2157_1_.getCompoundTag("Player");
            this.dimension = this.playerTag.getInteger("Dimension");
        }
        if (p_i2157_1_.hasKey("GameRules", 10)) {
            this.theGameRules.readFromNBT(p_i2157_1_.getCompoundTag("GameRules"));
        }
        if (p_i2157_1_.hasKey("Difficulty", 99)) {
            this.difficulty = EnumDifficulty.getDifficultyEnum(p_i2157_1_.getByte("Difficulty"));
        }
        if (p_i2157_1_.hasKey("DifficultyLocked", 1)) {
            this.difficultyLocked = p_i2157_1_.getBoolean("DifficultyLocked");
        }
        if (p_i2157_1_.hasKey("BorderCenterX", 99)) {
            this.borderCenterX = p_i2157_1_.getDouble("BorderCenterX");
        }
        if (p_i2157_1_.hasKey("BorderCenterZ", 99)) {
            this.borderCenterZ = p_i2157_1_.getDouble("BorderCenterZ");
        }
        if (p_i2157_1_.hasKey("BorderSize", 99)) {
            this.borderSize = p_i2157_1_.getDouble("BorderSize");
        }
        if (p_i2157_1_.hasKey("BorderSizeLerpTime", 99)) {
            this.borderSizeLerpTime = p_i2157_1_.getLong("BorderSizeLerpTime");
        }
        if (p_i2157_1_.hasKey("BorderSizeLerpTarget", 99)) {
            this.borderSizeLerpTarget = p_i2157_1_.getDouble("BorderSizeLerpTarget");
        }
        if (p_i2157_1_.hasKey("BorderSafeZone", 99)) {
            this.borderSafeZone = p_i2157_1_.getDouble("BorderSafeZone");
        }
        if (p_i2157_1_.hasKey("BorderDamagePerBlock", 99)) {
            this.borderDamagePerBlock = p_i2157_1_.getDouble("BorderDamagePerBlock");
        }
        if (p_i2157_1_.hasKey("BorderWarningBlocks", 99)) {
            this.borderWarningDistance = p_i2157_1_.getInteger("BorderWarningBlocks");
        }
        if (p_i2157_1_.hasKey("BorderWarningTime", 99)) {
            this.borderWarningTime = p_i2157_1_.getInteger("BorderWarningTime");
        }
        if (p_i2157_1_.hasKey("DimensionData", 10)) {
            NBTTagCompound nbttagcompound1 = p_i2157_1_.getCompoundTag("DimensionData");
            for (String s : nbttagcompound1.getKeySet()) {
                this.dimensionData.put(DimensionType.getById(Integer.parseInt(s)), nbttagcompound1.getCompoundTag(s));
            }
        }
    }

    public WorldInfo(WorldSettings p_i2158_1_, String p_i2158_2_) {
        this.populateFromWorldSettings(p_i2158_1_);
        this.levelName = p_i2158_2_;
        this.difficulty = DEFAULT_DIFFICULTY;
        this.initialized = false;
    }

    public void populateFromWorldSettings(WorldSettings p_populateFromWorldSettings_1_) {
        this.randomSeed = p_populateFromWorldSettings_1_.getSeed();
        this.theGameType = p_populateFromWorldSettings_1_.getGameType();
        this.mapFeaturesEnabled = p_populateFromWorldSettings_1_.isMapFeaturesEnabled();
        this.hardcore = p_populateFromWorldSettings_1_.getHardcoreEnabled();
        this.terrainType = p_populateFromWorldSettings_1_.getTerrainType();
        this.generatorOptions = p_populateFromWorldSettings_1_.getGeneratorOptions();
        this.allowCommands = p_populateFromWorldSettings_1_.areCommandsAllowed();
    }

    public WorldInfo(WorldInfo p_i2159_1_) {
        this.randomSeed = p_i2159_1_.randomSeed;
        this.terrainType = p_i2159_1_.terrainType;
        this.generatorOptions = p_i2159_1_.generatorOptions;
        this.theGameType = p_i2159_1_.theGameType;
        this.mapFeaturesEnabled = p_i2159_1_.mapFeaturesEnabled;
        this.spawnX = p_i2159_1_.spawnX;
        this.spawnY = p_i2159_1_.spawnY;
        this.spawnZ = p_i2159_1_.spawnZ;
        this.totalTime = p_i2159_1_.totalTime;
        this.worldTime = p_i2159_1_.worldTime;
        this.lastTimePlayed = p_i2159_1_.lastTimePlayed;
        this.sizeOnDisk = p_i2159_1_.sizeOnDisk;
        this.playerTag = p_i2159_1_.playerTag;
        this.dimension = p_i2159_1_.dimension;
        this.levelName = p_i2159_1_.levelName;
        this.saveVersion = p_i2159_1_.saveVersion;
        this.rainTime = p_i2159_1_.rainTime;
        this.raining = p_i2159_1_.raining;
        this.thunderTime = p_i2159_1_.thunderTime;
        this.thundering = p_i2159_1_.thundering;
        this.hardcore = p_i2159_1_.hardcore;
        this.allowCommands = p_i2159_1_.allowCommands;
        this.initialized = p_i2159_1_.initialized;
        this.theGameRules = p_i2159_1_.theGameRules;
        this.difficulty = p_i2159_1_.difficulty;
        this.difficultyLocked = p_i2159_1_.difficultyLocked;
        this.borderCenterX = p_i2159_1_.borderCenterX;
        this.borderCenterZ = p_i2159_1_.borderCenterZ;
        this.borderSize = p_i2159_1_.borderSize;
        this.borderSizeLerpTime = p_i2159_1_.borderSizeLerpTime;
        this.borderSizeLerpTarget = p_i2159_1_.borderSizeLerpTarget;
        this.borderSafeZone = p_i2159_1_.borderSafeZone;
        this.borderDamagePerBlock = p_i2159_1_.borderDamagePerBlock;
        this.borderWarningTime = p_i2159_1_.borderWarningTime;
        this.borderWarningDistance = p_i2159_1_.borderWarningDistance;
    }

    public NBTTagCompound cloneNBTCompound(NBTTagCompound p_cloneNBTCompound_1_) {
        if (p_cloneNBTCompound_1_ == null) {
            p_cloneNBTCompound_1_ = this.playerTag;
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.updateTagCompound(nbttagcompound, p_cloneNBTCompound_1_);
        return nbttagcompound;
    }

    private void updateTagCompound(NBTTagCompound p_updateTagCompound_1_, NBTTagCompound p_updateTagCompound_2_) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.setString("Name", "1.11.2");
        nbttagcompound.setInteger("Id", 922);
        nbttagcompound.setBoolean("Snapshot", false);
        p_updateTagCompound_1_.setTag("Version", nbttagcompound);
        p_updateTagCompound_1_.setInteger("DataVersion", 922);
        FMLCommonHandler.instance().getDataFixer().writeVersionData(p_updateTagCompound_1_);
        p_updateTagCompound_1_.setLong("RandomSeed", this.randomSeed);
        p_updateTagCompound_1_.setString("generatorName", this.terrainType.getName());
        p_updateTagCompound_1_.setInteger("generatorVersion", this.terrainType.getGeneratorVersion());
        p_updateTagCompound_1_.setString("generatorOptions", this.generatorOptions);
        p_updateTagCompound_1_.setInteger("GameType", this.theGameType.getID());
        p_updateTagCompound_1_.setBoolean("MapFeatures", this.mapFeaturesEnabled);
        p_updateTagCompound_1_.setInteger("SpawnX", this.spawnX);
        p_updateTagCompound_1_.setInteger("SpawnY", this.spawnY);
        p_updateTagCompound_1_.setInteger("SpawnZ", this.spawnZ);
        p_updateTagCompound_1_.setLong("Time", this.totalTime);
        p_updateTagCompound_1_.setLong("DayTime", this.worldTime);
        p_updateTagCompound_1_.setLong("SizeOnDisk", this.sizeOnDisk);
        p_updateTagCompound_1_.setLong("LastPlayed", MinecraftServer.getCurrentTimeMillis());
        p_updateTagCompound_1_.setString("LevelName", this.levelName);
        p_updateTagCompound_1_.setInteger("version", this.saveVersion);
        p_updateTagCompound_1_.setInteger("clearWeatherTime", this.cleanWeatherTime);
        p_updateTagCompound_1_.setInteger("rainTime", this.rainTime);
        p_updateTagCompound_1_.setBoolean("raining", this.raining);
        p_updateTagCompound_1_.setInteger("thunderTime", this.thunderTime);
        p_updateTagCompound_1_.setBoolean("thundering", this.thundering);
        p_updateTagCompound_1_.setBoolean("hardcore", this.hardcore);
        p_updateTagCompound_1_.setBoolean("allowCommands", this.allowCommands);
        p_updateTagCompound_1_.setBoolean("initialized", this.initialized);
        p_updateTagCompound_1_.setDouble("BorderCenterX", this.borderCenterX);
        p_updateTagCompound_1_.setDouble("BorderCenterZ", this.borderCenterZ);
        p_updateTagCompound_1_.setDouble("BorderSize", this.borderSize);
        p_updateTagCompound_1_.setLong("BorderSizeLerpTime", this.borderSizeLerpTime);
        p_updateTagCompound_1_.setDouble("BorderSafeZone", this.borderSafeZone);
        p_updateTagCompound_1_.setDouble("BorderDamagePerBlock", this.borderDamagePerBlock);
        p_updateTagCompound_1_.setDouble("BorderSizeLerpTarget", this.borderSizeLerpTarget);
        p_updateTagCompound_1_.setDouble("BorderWarningBlocks", this.borderWarningDistance);
        p_updateTagCompound_1_.setDouble("BorderWarningTime", this.borderWarningTime);
        if (this.difficulty != null) {
            p_updateTagCompound_1_.setByte("Difficulty", (byte)this.difficulty.getDifficultyId());
        }
        p_updateTagCompound_1_.setBoolean("DifficultyLocked", this.difficultyLocked);
        p_updateTagCompound_1_.setTag("GameRules", this.theGameRules.writeToNBT());
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        for (Map.Entry<DimensionType, NBTTagCompound> entry : this.dimensionData.entrySet()) {
            nbttagcompound1.setTag(String.valueOf(entry.getKey().getId()), entry.getValue());
        }
        p_updateTagCompound_1_.setTag("DimensionData", nbttagcompound1);
        if (p_updateTagCompound_2_ != null) {
            p_updateTagCompound_1_.setTag("Player", p_updateTagCompound_2_);
        }
    }

    public long getSeed() {
        return this.randomSeed;
    }

    public int getSpawnX() {
        return this.spawnX;
    }

    public int getSpawnY() {
        return this.spawnY;
    }

    public int getSpawnZ() {
        return this.spawnZ;
    }

    public long getWorldTotalTime() {
        return this.totalTime;
    }

    public long getWorldTime() {
        return this.worldTime;
    }

    @SideOnly(value=Side.CLIENT)
    public long getSizeOnDisk() {
        return this.sizeOnDisk;
    }

    public NBTTagCompound getPlayerNBTTagCompound() {
        return this.playerTag;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSpawnX(int p_setSpawnX_1_) {
        this.spawnX = p_setSpawnX_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSpawnY(int p_setSpawnY_1_) {
        this.spawnY = p_setSpawnY_1_;
    }

    public void setWorldTotalTime(long p_setWorldTotalTime_1_) {
        this.totalTime = p_setWorldTotalTime_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSpawnZ(int p_setSpawnZ_1_) {
        this.spawnZ = p_setSpawnZ_1_;
    }

    public void setWorldTime(long p_setWorldTime_1_) {
        this.worldTime = p_setWorldTime_1_;
    }

    public void setSpawn(BlockPos p_setSpawn_1_) {
        this.spawnX = p_setSpawn_1_.getX();
        this.spawnY = p_setSpawn_1_.getY();
        this.spawnZ = p_setSpawn_1_.getZ();
    }

    public String getWorldName() {
        return this.levelName;
    }

    public void setWorldName(String p_setWorldName_1_) {
        this.levelName = p_setWorldName_1_;
    }

    public int getSaveVersion() {
        return this.saveVersion;
    }

    public void setSaveVersion(int p_setSaveVersion_1_) {
        this.saveVersion = p_setSaveVersion_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public long getLastTimePlayed() {
        return this.lastTimePlayed;
    }

    public int getCleanWeatherTime() {
        return this.cleanWeatherTime;
    }

    public void setCleanWeatherTime(int p_setCleanWeatherTime_1_) {
        this.cleanWeatherTime = p_setCleanWeatherTime_1_;
    }

    public boolean isThundering() {
        return this.thundering;
    }

    public void setThundering(boolean p_setThundering_1_) {
        this.thundering = p_setThundering_1_;
    }

    public int getThunderTime() {
        return this.thunderTime;
    }

    public void setThunderTime(int p_setThunderTime_1_) {
        this.thunderTime = p_setThunderTime_1_;
    }

    public boolean isRaining() {
        return this.raining;
    }

    public void setRaining(boolean p_setRaining_1_) {
        this.raining = p_setRaining_1_;
    }

    public int getRainTime() {
        return this.rainTime;
    }

    public void setRainTime(int p_setRainTime_1_) {
        this.rainTime = p_setRainTime_1_;
    }

    public GameType getGameType() {
        return this.theGameType;
    }

    public boolean isMapFeaturesEnabled() {
        return this.mapFeaturesEnabled;
    }

    public void setMapFeaturesEnabled(boolean p_setMapFeaturesEnabled_1_) {
        this.mapFeaturesEnabled = p_setMapFeaturesEnabled_1_;
    }

    public void setGameType(GameType p_setGameType_1_) {
        this.theGameType = p_setGameType_1_;
    }

    public boolean isHardcoreModeEnabled() {
        return this.hardcore;
    }

    public void setHardcore(boolean p_setHardcore_1_) {
        this.hardcore = p_setHardcore_1_;
    }

    public WorldType getTerrainType() {
        return this.terrainType;
    }

    public void setTerrainType(WorldType p_setTerrainType_1_) {
        this.terrainType = p_setTerrainType_1_;
    }

    public String getGeneratorOptions() {
        return this.generatorOptions == null ? "" : this.generatorOptions;
    }

    public boolean areCommandsAllowed() {
        return this.allowCommands;
    }

    public void setAllowCommands(boolean p_setAllowCommands_1_) {
        this.allowCommands = p_setAllowCommands_1_;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setServerInitialized(boolean p_setServerInitialized_1_) {
        this.initialized = p_setServerInitialized_1_;
    }

    public GameRules getGameRulesInstance() {
        return this.theGameRules;
    }

    public double getBorderCenterX() {
        return this.borderCenterX;
    }

    public double getBorderCenterZ() {
        return this.borderCenterZ;
    }

    public double getBorderSize() {
        return this.borderSize;
    }

    public void setBorderSize(double p_setBorderSize_1_) {
        this.borderSize = p_setBorderSize_1_;
    }

    public long getBorderLerpTime() {
        return this.borderSizeLerpTime;
    }

    public void setBorderLerpTime(long p_setBorderLerpTime_1_) {
        this.borderSizeLerpTime = p_setBorderLerpTime_1_;
    }

    public double getBorderLerpTarget() {
        return this.borderSizeLerpTarget;
    }

    public void setBorderLerpTarget(double p_setBorderLerpTarget_1_) {
        this.borderSizeLerpTarget = p_setBorderLerpTarget_1_;
    }

    public void getBorderCenterZ(double p_getBorderCenterZ_1_) {
        this.borderCenterZ = p_getBorderCenterZ_1_;
    }

    public void getBorderCenterX(double p_getBorderCenterX_1_) {
        this.borderCenterX = p_getBorderCenterX_1_;
    }

    public double getBorderSafeZone() {
        return this.borderSafeZone;
    }

    public void setBorderSafeZone(double p_setBorderSafeZone_1_) {
        this.borderSafeZone = p_setBorderSafeZone_1_;
    }

    public double getBorderDamagePerBlock() {
        return this.borderDamagePerBlock;
    }

    public void setBorderDamagePerBlock(double p_setBorderDamagePerBlock_1_) {
        this.borderDamagePerBlock = p_setBorderDamagePerBlock_1_;
    }

    public int getBorderWarningDistance() {
        return this.borderWarningDistance;
    }

    public int getBorderWarningTime() {
        return this.borderWarningTime;
    }

    public void setBorderWarningDistance(int p_setBorderWarningDistance_1_) {
        this.borderWarningDistance = p_setBorderWarningDistance_1_;
    }

    public void setBorderWarningTime(int p_setBorderWarningTime_1_) {
        this.borderWarningTime = p_setBorderWarningTime_1_;
    }

    public EnumDifficulty getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(EnumDifficulty p_setDifficulty_1_) {
        this.difficulty = p_setDifficulty_1_;
    }

    public boolean isDifficultyLocked() {
        return this.difficultyLocked;
    }

    public void setDifficultyLocked(boolean p_setDifficultyLocked_1_) {
        this.difficultyLocked = p_setDifficultyLocked_1_;
    }

    public void addToCrashReport(CrashReportCategory p_addToCrashReport_1_) {
        p_addToCrashReport_1_.setDetail("Level seed", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return String.valueOf(WorldInfo.this.getSeed());
            }
        });
        p_addToCrashReport_1_.setDetail("Level generator", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return String.format("ID %02d - %s, ver %d. Features enabled: %b", WorldInfo.this.terrainType.getWorldTypeID(), WorldInfo.this.terrainType.getName(), WorldInfo.this.terrainType.getGeneratorVersion(), WorldInfo.this.mapFeaturesEnabled);
            }
        });
        p_addToCrashReport_1_.setDetail("Level generator options", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return WorldInfo.this.generatorOptions;
            }
        });
        p_addToCrashReport_1_.setDetail("Level spawn location", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return CrashReportCategory.getCoordinateInfo(WorldInfo.this.spawnX, WorldInfo.this.spawnY, WorldInfo.this.spawnZ);
            }
        });
        p_addToCrashReport_1_.setDetail("Level time", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return String.format("%d game time, %d day time", WorldInfo.this.totalTime, WorldInfo.this.worldTime);
            }
        });
        p_addToCrashReport_1_.setDetail("Level dimension", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return String.valueOf(WorldInfo.this.dimension);
            }
        });
        p_addToCrashReport_1_.setDetail("Level storage version", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                String s = "Unknown?";
                try {
                    switch (WorldInfo.this.saveVersion) {
                        case 19132: {
                            s = "McRegion";
                            break;
                        }
                        case 19133: {
                            s = "Anvil";
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return String.format("0x%05X - %s", WorldInfo.this.saveVersion, s);
            }
        });
        p_addToCrashReport_1_.setDetail("Level weather", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return String.format("Rain time: %d (now: %b), thunder time: %d (now: %b)", WorldInfo.this.rainTime, WorldInfo.this.raining, WorldInfo.this.thunderTime, WorldInfo.this.thundering);
            }
        });
        p_addToCrashReport_1_.setDetail("Level game mode", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return String.format("Game mode: %s (ID %d). Hardcore: %b. Cheats: %b", WorldInfo.this.theGameType.getName(), WorldInfo.this.theGameType.getID(), WorldInfo.this.hardcore, WorldInfo.this.allowCommands);
            }
        });
    }

    public void setAdditionalProperties(Map<String, NBTBase> p_setAdditionalProperties_1_) {
        if (this.additionalProperties == null) {
            this.additionalProperties = p_setAdditionalProperties_1_;
        }
    }

    public NBTBase getAdditionalProperty(String p_getAdditionalProperty_1_) {
        return this.additionalProperties != null ? this.additionalProperties.get(p_getAdditionalProperty_1_) : null;
    }

    public NBTTagCompound getDimensionData(DimensionType p_getDimensionData_1_) {
        NBTTagCompound nbttagcompound = this.dimensionData.get((Object)p_getDimensionData_1_);
        return nbttagcompound == null ? new NBTTagCompound() : nbttagcompound;
    }

    public void setDimensionData(DimensionType p_setDimensionData_1_, NBTTagCompound p_setDimensionData_2_) {
        this.dimensionData.put(p_setDimensionData_1_, p_setDimensionData_2_);
    }

    @SideOnly(value=Side.CLIENT)
    public int getVersionId() {
        return this.versionId;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isVersionSnapshot() {
        return this.versionSnapshot;
    }

    @SideOnly(value=Side.CLIENT)
    public String getVersionName() {
        return this.versionName;
    }
}

