/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import net.minecraft.util.StringUtils;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.GameType;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class WorldSummary
implements Comparable<WorldSummary> {
    private final String fileName;
    private final String displayName;
    private final long lastTimePlayed;
    private final long sizeOnDisk;
    private final boolean requiresConversion;
    private final GameType theEnumGameType;
    private final boolean hardcore;
    private final boolean cheatsEnabled;
    private final String versionName;
    private final int versionId;
    private final boolean versionSnapshot;

    public WorldSummary(WorldInfo p_i46646_1_, String p_i46646_2_, String p_i46646_3_, long p_i46646_4_, boolean p_i46646_6_) {
        this.fileName = p_i46646_2_;
        this.displayName = p_i46646_3_;
        this.lastTimePlayed = p_i46646_1_.getLastTimePlayed();
        this.sizeOnDisk = p_i46646_4_;
        this.theEnumGameType = p_i46646_1_.getGameType();
        this.requiresConversion = p_i46646_6_;
        this.hardcore = p_i46646_1_.isHardcoreModeEnabled();
        this.cheatsEnabled = p_i46646_1_.areCommandsAllowed();
        this.versionName = p_i46646_1_.getVersionName();
        this.versionId = p_i46646_1_.getVersionId();
        this.versionSnapshot = p_i46646_1_.isVersionSnapshot();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public long getSizeOnDisk() {
        return this.sizeOnDisk;
    }

    public boolean requiresConversion() {
        return this.requiresConversion;
    }

    public long getLastTimePlayed() {
        return this.lastTimePlayed;
    }

    @Override
    public int compareTo(WorldSummary p_compareTo_1_) {
        if (this.lastTimePlayed < p_compareTo_1_.lastTimePlayed) {
            return 1;
        }
        if (this.lastTimePlayed > p_compareTo_1_.lastTimePlayed) {
            return -1;
        }
        return this.fileName.compareTo(p_compareTo_1_.fileName);
    }

    public GameType getEnumGameType() {
        return this.theEnumGameType;
    }

    public boolean isHardcoreModeEnabled() {
        return this.hardcore;
    }

    public boolean getCheatsEnabled() {
        return this.cheatsEnabled;
    }

    public String getVersionName() {
        if (StringUtils.isNullOrEmpty(this.versionName)) {
            return I18n.translateToLocal("selectWorld.versionUnknown");
        }
        return this.versionName;
    }

    public boolean markVersionInList() {
        return this.askToOpenWorld();
    }

    public boolean askToOpenWorld() {
        return this.versionId > 922;
    }

    @Override
    public /* synthetic */ int compareTo(Object p_compareTo_1_) {
        return this.compareTo((WorldSummary)p_compareTo_1_);
    }
}

